/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.accrual;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tcret.business.taxsource.TcwatSourceServiceHelper;

public class SzysAccrualDraftFormPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String TAXSOURCE = "taxsource";
    private static final String ZSZM = "zszm";
    private static final String SQLJQSL = "sqljqsl";
    private static final String CALSOURCE = "calsource";
    private static final String SYSE = "syse";
    private static final String YNSE = "ynse";
    private static final String JMSE = "jmse";
    private static final String JTYNSE = "jtynse";

    public void registerListener(EventObject e) {
        BasedataEdit taxsource = (BasedataEdit)this.getControl(TAXSOURCE);
        taxsource.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit zszm = (BasedataEdit)this.getControl(ZSZM);
        zszm.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if (TAXSOURCE.equals(name)) {
            long orgId = 0L;
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org != null) {
                orgId = org.getLong("id");
            }
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter.getListFilterParameter().setFilter(new QFilter("org", "=", (Object)orgId));
        } else if (ZSZM.equals(name)) {
            int row = evt.getRow();
            DynamicObject taxsource = (DynamicObject)this.getModel().getValue(TAXSOURCE, row);
            if (taxsource == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5148\u9009\u62e9\u7a0e\u6e90\u7f16\u53f7", (String)"SzysAccrualDraftFormPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            String sysbb = taxsource.getString("sysbb");
            if ("A".equals(sysbb)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7a0e\u6e90\u7f16\u53f7\u9002\u7528\u3010\u6c34\u8d44\u6e90\u7a0e\u7eb3\u7a0e\u7533\u62a5\u8868A\u3011\uff0c\u65e0\u9700\u9009\u62e9\u5f81\u6536\u5b50\u76ee", (String)"SzysAccrualDraftFormPlugin_1", (String)"taxc-tcret", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((Object)taxsource.getPkValue(), (String)taxsource.getDataEntityType().getName());
            DynamicObjectCollection entryentity1 = object.getDynamicObjectCollection("entryentity1");
            if (EmptyCheckUtils.isEmpty((Object)entryentity1)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7a0e\u6e90\u7f16\u53f7\u5f81\u6536\u5b50\u76ee\u548c\u7a0e\u7387\u914d\u7f6e\u4e3a\u7a7a", (String)"SzysAccrualDraftFormPlugin_2", (String)"taxc-tcret", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            List zszmIds = entryentity1.stream().map(d -> d.getLong("zszm.id")).collect(Collectors.toList());
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u5f81\u6536\u5b50\u76ee", (String)"SzysAccrualDraftFormPlugin_3", (String)"taxc-tcret", (Object[])new Object[0]));
            listShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", zszmIds));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        if (TAXSOURCE.equals(name)) {
            DynamicObject taxsource = (DynamicObject)changeData.getNewValue();
            BigDecimal ynse = BigDecimal.ZERO;
            if (taxsource != null && "A".equals(taxsource.getString("sysbb"))) {
                ynse = taxsource.getBigDecimal("sysl");
            }
            this.getModel().setValue(SYSE, (Object)ynse, rowIndex);
            this.getModel().setValue(ZSZM, null, rowIndex);
            this.getModel().setValue(SQLJQSL, (Object)BigDecimal.ZERO, rowIndex);
            this.getModel().setValue(CALSOURCE, (Object)BigDecimal.ZERO, rowIndex);
        } else if (ZSZM.equals(name)) {
            DynamicObject zszm = (DynamicObject)changeData.getNewValue();
            DynamicObject taxsource = (DynamicObject)this.getModel().getValue(TAXSOURCE, rowIndex);
            BigDecimal syse = this.calcSyse(taxsource, zszm);
            this.getModel().setValue(SYSE, (Object)syse, rowIndex);
            this.getModel().setValue(SQLJQSL, (Object)BigDecimal.ZERO, rowIndex);
            this.getModel().setValue(CALSOURCE, (Object)BigDecimal.ZERO, rowIndex);
        } else if (SQLJQSL.equals(name) || CALSOURCE.equals(name)) {
            DynamicObject taxsource = (DynamicObject)this.getModel().getValue(TAXSOURCE, rowIndex);
            if (taxsource != null) {
                BigDecimal sqljqsl = (BigDecimal)this.getModel().getValue(SQLJQSL, rowIndex);
                BigDecimal bqqsl = (BigDecimal)this.getModel().getValue(CALSOURCE, rowIndex);
                String sysbb = taxsource.getString("sysbb");
                BigDecimal ynse = BigDecimal.ZERO;
                if ("A".equals(sysbb)) {
                    ynse = TcwatSourceServiceHelper.calculateYnseForA(taxsource, sqljqsl, bqqsl);
                } else if ("B".equals(sysbb)) {
                    DynamicObject zszm = (DynamicObject)this.getModel().getValue(ZSZM, rowIndex);
                    DynamicObject zszmConfig = TcwatSourceServiceHelper.getZszmConfig(zszm, taxsource);
                    ynse = TcwatSourceServiceHelper.calculateYnseForB(zszmConfig, bqqsl);
                }
                this.getModel().setValue(YNSE, (Object)ynse, rowIndex);
            }
        } else if (YNSE.equals(name) || JMSE.equals(name)) {
            BigDecimal ynse = (BigDecimal)this.getModel().getValue(YNSE, rowIndex);
            BigDecimal jmse = (BigDecimal)this.getModel().getValue(JMSE, rowIndex);
            BigDecimal jtynse = BigDecimalUtil.subtractObject((Object)ynse, (Object)jmse);
            this.getModel().setValue(JTYNSE, (Object)BigDecimalUtil.max((Object)jtynse, (Object)BigDecimal.ZERO), rowIndex);
        } else if (JTYNSE.equals(name)) {
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            BigDecimal jtynsesum = BigDecimalUtil.sumDynamicObjectAmount((List)entryentity, (String)JTYNSE);
            this.getModel().setValue("jtynsesum", (Object)jtynsesum);
        }
    }

    private BigDecimal calcSyse(DynamicObject taxsource, DynamicObject zszm) {
        BigDecimal syse = BigDecimal.ZERO;
        if (taxsource != null) {
            String sysbb = taxsource.getString("sysbb");
            if ("A".equals(sysbb)) {
                syse = taxsource.getBigDecimal("sysl");
            } else if ("B".equals(sysbb)) {
                DynamicObject zszmConfig = TcwatSourceServiceHelper.getZszmConfig(zszm, taxsource);
                syse = zszmConfig != null ? zszmConfig.getBigDecimal("taxamount") : BigDecimal.ZERO;
            }
        }
        return syse;
    }
}

