/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.accrual;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.taxc.bdtaxr.common.util.DiscountHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.tcret.business.dto.YhsSjjtAdjust;
import kd.taxc.tcret.business.dto.YhsSjjtData;
import kd.taxc.tcret.common.utils.YhsAccrualUtils;

public class YhsAccrualDraftFormPlugin
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    private static final String COLOR_WHITE = "#ffffff";
    private static final String COLOR_BLUE = "#DCFAE4";
    private static final String JSJE = "jsje";
    private static final String HDBL = "hdbl";
    private static final String CALSOURCE = "calsource";
    private static final String TAXRATE = "taxrate";
    private static final String YNSE = "ynse";
    private static final String JMSE = "jmse";
    private static final String YJSE = "yjse";
    private static final String JTYNSE = "jtynse";

    public void registerListener(EventObject e) {
        EntryGrid control = (EntryGrid)this.getControl("entryentity");
        control.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if (JSJE.equals(name) || HDBL.equals(name)) {
            this.resetCalsource(rowIndex);
        } else if (CALSOURCE.equals(name) || TAXRATE.equals(name)) {
            this.resetYnse(rowIndex);
        } else if (YNSE.equals(name)) {
            this.resetJmse(rowIndex);
            this.resetJtynse(rowIndex);
        } else if (JMSE.equals(name) || YJSE.equals(name)) {
            this.resetJtynse(rowIndex);
        } else if (JTYNSE.equals(name)) {
            this.resetJtynsesum();
        } else if ("isxxwlqy".equals(name)) {
            int rowCount = this.getModel().getEntryRowCount("entryentity");
            for (int i = 0; i < rowCount; ++i) {
                this.resetJmse(i);
            }
        }
    }

    private void resetJmse(int rowIndex) {
        DynamicObject rowEntity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        BigDecimal ynse = rowEntity.getBigDecimal(YNSE);
        String deducationtype = rowEntity.getString("deductiontype");
        String isxxwlqy = (String)this.getModel().getValue("isxxwlqy");
        BigDecimal jmrate = DiscountHelper.calculateDiscountRate((String)deducationtype, (String)isxxwlqy);
        BigDecimal jmse = YhsAccrualUtils.calculateJmse(ynse, jmrate);
        this.getModel().setValue(JMSE, (Object)jmse, rowIndex);
    }

    private void resetJtynsesum() {
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        BigDecimal jtynsesum = BigDecimal.ZERO;
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            BigDecimal jtynse = (BigDecimal)this.getModel().getValue(JTYNSE, rowIndex);
            jtynsesum = BigDecimalUtil.addObject((Object)jtynsesum, (Object)jtynse);
        }
        this.getModel().setValue("jtynsesum", (Object)jtynsesum);
    }

    private void resetYnse(int rowIndex) {
        DynamicObject rowEntity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        BigDecimal calsource = rowEntity.getBigDecimal(CALSOURCE);
        BigDecimal taxrate = rowEntity.getBigDecimal(TAXRATE);
        BigDecimal ynse = YhsAccrualUtils.calculateYnse(calsource, taxrate);
        this.getModel().setValue(YNSE, (Object)ynse, rowIndex);
    }

    private void resetJtynse(int rowIndex) {
        DynamicObject rowEntity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        BigDecimal ynse = rowEntity.getBigDecimal(YNSE);
        BigDecimal jmse = rowEntity.getBigDecimal(JMSE);
        BigDecimal yjse = rowEntity.getBigDecimal(YJSE);
        BigDecimal jtynse = YhsAccrualUtils.calculateJtynse(ynse, jmse, yjse);
        this.getModel().setValue(JTYNSE, (Object)jtynse, rowIndex);
    }

    private void resetCalsource(int rowIndex) {
        DynamicObject rowObject = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        BigDecimal jsje = rowObject.getBigDecimal(JSJE);
        BigDecimal hdbl = rowObject.getBigDecimal(HDBL);
        BigDecimal calSource = YhsAccrualUtils.calculateCalSource(jsje, hdbl);
        this.getModel().setValue(CALSOURCE, (Object)calSource, rowIndex);
    }

    public void afterBindData(EventObject e) {
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            String details_tag = (String)this.getModel().getValue("details_tag", rowIndex);
            if (!this.isModify(details_tag)) continue;
            this.setBackColorForCell("entryentity", rowIndex, JSJE, COLOR_BLUE);
        }
    }

    private boolean isModify(String details_tag) {
        YhsSjjtData yhsSjjtData;
        List<YhsSjjtAdjust> adjusts;
        if (EmptyCheckUtils.isNotEmpty((Object)details_tag) && EmptyCheckUtils.isNotEmpty(adjusts = (yhsSjjtData = (YhsSjjtData)JsonUtil.fromJson((String)details_tag, YhsSjjtData.class)).getAdjusts())) {
            for (YhsSjjtAdjust adjust : adjusts) {
                if (adjust.getAdjustamount().compareTo(BigDecimal.ZERO) == 0) continue;
                return true;
            }
        }
        return false;
    }

    private void setBackColorForCell(String entryName, int rowIndex, String column, String color) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entryName);
        CellStyle cellStyle = new CellStyle();
        cellStyle.setRow(rowIndex);
        cellStyle.setFieldKey(column);
        cellStyle.setBackColor(color);
        entryGrid.setCellStyle(Collections.singletonList(cellStyle));
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if (JSJE.equals(fieldName)) {
            DynamicObject dynamicObject = this.getModel().getDataEntity(false);
            int rowIndex = evt.getRowIndex();
            DynamicObject entity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("rowIndex", rowIndex);
            customParams.put("data", entity.getString("details_tag"));
            customParams.put("orgid", dynamicObject.getDynamicObject("org").getString("id"));
            customParams.put("skssqq", DateUtils.format((Date)dynamicObject.getDate("skssqq")));
            customParams.put("skssqz", DateUtils.format((Date)dynamicObject.getDate("skssqz")));
            customParams.put("taxitem", entity.getString("taxitem"));
            DynamicObject subtaxitem = entity.getDynamicObject("subtaxitem");
            customParams.put("subtaxitem", subtaxitem != null ? subtaxitem.getString("id") : "0");
            DynamicObject accorg = entity.getDynamicObject("accorg");
            customParams.put("accorg", accorg != null ? accorg.getString("id") : "0");
            customParams.put("bizdimensiontype", entity.getString("bizdimensiontype.number"));
            customParams.put("bizdimensionname", entity.getString("bizdimensionname"));
            customParams.put("bizdimensionid", entity.getString("bizdimensionid"));
            customParams.put("deductiontype", entity.getString("deductiontype"));
            customParams.put("taxlimit", entity.getString("taxlimit"));
            customParams.put("cellvalue", entity.getString(JSJE));
            customParams.put("datasource", entity.getString("datasource"));
            OperationStatus status = OperationStatus.EDIT;
            String billstatus = dynamicObject.getString("billstatus");
            if (!"A".equals(billstatus)) {
                status = OperationStatus.VIEW;
            }
            PageShowCommon.showForm((OperationStatus)status, (ShowType)ShowType.Modal, (String)"tcret_sjjt_details_yhs", (IFormView)this.getView(), customParams, (IFormPlugin)this);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        String actionId = closedCallBackEvent.getActionId();
        if ("tcret_sjjt_details_yhs".equals(actionId) && (returnData = closedCallBackEvent.getReturnData()) != null) {
            Map custom = (Map)returnData;
            int rowIndex = Integer.parseInt(String.valueOf(custom.get("rowIndex")));
            this.getModel().setValue(JSJE, (Object)BigDecimalUtil.toBigDecimal(custom.get("adjustsumamount")), rowIndex);
            this.getModel().setValue("details_tag", custom.get("data"));
            if (this.isModify((String)custom.get("data"))) {
                this.setBackColorForCell("entryentity", rowIndex, JSJE, COLOR_BLUE);
            } else {
                this.setBackColorForCell("entryentity", rowIndex, JSJE, COLOR_WHITE);
            }
        }
    }
}

