/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.accrual.details;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcret.business.dto.YhsSjjtAdjust;
import kd.taxc.tcret.business.dto.YhsSjjtData;
import kd.taxc.tcret.business.dto.YhsSjjtDetail;
import kd.taxc.tcret.business.dto.YhsSjjtRecord;
import kd.taxc.tcret.formplugin.DetailDialogValidHelper;

public class YhsSjjtDetailsFormPlugin
extends AbstractFormPlugin
implements SelectRowsEventListener {
    private static final String RULEID = "ruleid";
    private static final String ENTRYENTITY_CARD = "entryentitycard";
    private static final String ENTRYENTITY_LIST = "entryentitylist";
    private static final HashMap<String, String> ruleTypeMap = new HashMap();
    private static final String TCRET_YHS_SJJT_DETAIL_FEILDS = "org,taxitem,subtaxitem,deductiontype,taxlimit,accountorg,bizdimensiontype,bizdimensionname,bizdimensionid,taxperiod,filtercondition,table,amountfield,datatype,datadirection,fetchamount,amount,bizname,skssqq,skssqz,type,ruleid,serialno,absolute,businessmap";

    public void initialize() {
        CardEntry entryentitycard = (CardEntry)this.getControl(ENTRYENTITY_CARD);
        entryentitycard.addSelectRowsListener((SelectRowsEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String data = (String)customParams.get("data");
        YhsSjjtData yhsSjjtData = null;
        if (EmptyCheckUtils.isNotEmpty((Object)data)) {
            try {
                yhsSjjtData = (YhsSjjtData)JsonUtil.fromJson((String)data, YhsSjjtData.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        List<YhsSjjtDetail> details = null;
        List<YhsSjjtAdjust> adjusts = null;
        List<YhsSjjtRecord> adjustRecords = null;
        if (yhsSjjtData != null) {
            details = yhsSjjtData.getDetails();
            adjusts = yhsSjjtData.getAdjusts();
            adjustRecords = yhsSjjtData.getRecords();
        }
        if (CollectionUtils.isEmpty(details)) {
            if (details == null) {
                details = new ArrayList<YhsSjjtDetail>(16);
            }
            Long accountorg = Long.parseLong(customParams.getOrDefault("accorg", "0"));
            String bizdimensiontype = (String)customParams.get("bizdimensiontype");
            String string = (String)customParams.get("bizdimensionname");
            String bizdimensionid = (String)customParams.get("bizdimensionid");
            Long orgid = Long.parseLong(String.valueOf(customParams.getOrDefault("orgid", "0")));
            String skssqq = customParams.getOrDefault("skssqq", "");
            String skssqz = customParams.getOrDefault("skssqz", "");
            String taxitem = customParams.getOrDefault("taxitem", "");
            Long subtaxitem = Long.parseLong(customParams.getOrDefault("subtaxitem", "0"));
            String deductiontype = (String)customParams.get("deductiontype");
            String taxlimit = (String)customParams.get("taxlimit");
            String datasource = customParams.getOrDefault("datasource", "");
            ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
            filters.add(new QFilter("org", "=", (Object)orgid));
            filters.add(new QFilter("skssqq", "=", (Object)DateUtils.stringToDate2((String)skssqq)));
            filters.add(new QFilter("skssqz", "=", (Object)DateUtils.stringToDate2((String)skssqz)));
            filters.add(new QFilter("subtaxitem", "=", (Object)subtaxitem));
            if (StringUtil.isNotBlank((CharSequence)taxitem)) {
                filters.add(new QFilter("taxitem", "=", (Object)taxitem));
            }
            if (StringUtil.isNotBlank((CharSequence)deductiontype)) {
                filters.add(new QFilter("deductiontype", "=", (Object)deductiontype));
            }
            if (StringUtil.isNotBlank((CharSequence)taxlimit)) {
                filters.add(new QFilter("taxlimit", "=", (Object)taxlimit));
            }
            if (StringUtil.isNotBlank((CharSequence)bizdimensiontype)) {
                filters.add(new QFilter("bizdimensiontype", "=", (Object)bizdimensiontype));
                filters.add(new QFilter("accountorg", "=", (Object)accountorg));
            } else {
                filters.add(new QFilter("bizdimensiontype", "is null", null).or(new QFilter("bizdimensiontype", "=", (Object)"")).or(new QFilter("bizdimensiontype", "=", (Object)" ")));
            }
            if (StringUtil.isNotBlank((CharSequence)string)) {
                filters.add(new QFilter("bizdimensionname", "=", (Object)string));
            }
            if (StringUtil.isNotBlank((CharSequence)bizdimensionid)) {
                filters.add(new QFilter("bizdimensionid", "=", (Object)bizdimensionid));
            }
            if (StringUtil.isNotBlank((CharSequence)datasource)) {
                filters.add(new QFilter("datasource", "=", (Object)datasource));
            } else {
                filters.add(new QFilter("datasource", "!=", (Object)"tcret_yhs_tax_source_info"));
            }
            DynamicObjectCollection detailObjs = QueryServiceHelper.query((String)"tcret_yhs_sjjt_detail", (String)TCRET_YHS_SJJT_DETAIL_FEILDS, (QFilter[])filters.toArray(new QFilter[filters.size()]));
            if (CollectionUtils.isNotEmpty((Collection)detailObjs)) {
                for (DynamicObject obj : detailObjs) {
                    YhsSjjtDetail detail = new YhsSjjtDetail();
                    detail.setOrg(obj.getLong("org"));
                    detail.setAccountorg(obj.getLong("accountorg"));
                    detail.setSkssqq(obj.getDate("skssqq"));
                    detail.setSkssqz(obj.getDate("skssqz"));
                    detail.setTaxitem(obj.getString("taxitem"));
                    detail.setSubtaxitem(obj.getLong("subtaxitem"));
                    detail.setAmount(obj.getBigDecimal("amount"));
                    detail.setAbsolute(obj.getString("absolute"));
                    detail.setTaxperiod(obj.getString("taxperiod"));
                    detail.setRuleid(obj.getString(RULEID));
                    detail.setTable(obj.getLong("table"));
                    detail.setType(obj.getString("type"));
                    detail.setSerialno(obj.getString("serialno"));
                    detail.setBizname(obj.getString("bizname"));
                    detail.setDatatype(obj.getString("datatype"));
                    detail.setFetchamount(obj.getBigDecimal("fetchamount"));
                    detail.setAmountfield(obj.getLong("amountfield"));
                    detail.setBizdimensionid(obj.getString("bizdimensionid"));
                    detail.setBizdimensionname(obj.getString("bizdimensionname"));
                    detail.setBizdimensiontype(obj.getString("bizdimensiontype"));
                    detail.setDatadirection(obj.getString("datadirection"));
                    detail.setFiltercondition(obj.getString("filtercondition"));
                    detail.setBusinessmap(obj.getString("businessmap"));
                    details.add(detail);
                }
            }
        }
        if (CollectionUtils.isEmpty(details)) {
            this.appendCard(adjusts, null, customParams);
            return;
        }
        this.doSetAdjusRecordtList(adjustRecords);
        Map<String, List<YhsSjjtDetail>> map = details.stream().collect(Collectors.groupingBy(YhsSjjtDetail::getRuleid));
        this.getModel().beginInit();
        for (Map.Entry entry : map.entrySet()) {
            int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY_CARD);
            YhsSjjtDetail detail = (YhsSjjtDetail)((List)entry.getValue()).get(0);
            String type = detail.getType();
            DynamicObject rule = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(detail.getRuleid()), (String)ruleTypeMap.get(type));
            this.getModel().setValue(RULEID, (Object)rule.getLong("id"), rowIndex);
            this.getModel().setValue("org", (Object)detail.getOrg(), rowIndex);
            this.getModel().setValue("titlename", (Object)rule.getString("name"), rowIndex);
            this.getModel().setValue("taxitem", (Object)rule.getDynamicObject("taxitem").getString("name"), rowIndex);
            BigDecimal amount = this.getAmount(detail.getRuleid(), (List)entry.getValue());
            this.getModel().setValue("amount", (Object)amount, rowIndex);
            BigDecimal adjustamount = this.getAdjustamount(rule.getString("id"), adjusts);
            this.getModel().setValue("adjustamount", (Object)adjustamount, rowIndex);
            this.getModel().setValue("totalamount", (Object)BigDecimalUtil.addObject((Object)amount, (Object)adjustamount), rowIndex);
            this.getModel().setValue("cardadjustexplain", (Object)this.getAdjustExplain(rule.getString("id"), adjusts), rowIndex);
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY_CARD);
        this.appendCard(adjusts, details, customParams);
        Map.Entry first = (Map.Entry)map.entrySet().stream().findFirst().get();
        this.clearEntry(ENTRYENTITY_LIST);
        this.setEntryentitylist((String)first.getKey(), details);
        this.getPageCache().put("yhsSjjtDetail", JsonUtil.toJson(details));
    }

    private void doSetAdjusRecordtList(List<YhsSjjtRecord> records) {
        if (EmptyCheckUtils.isNotEmpty(records)) {
            for (YhsSjjtRecord record : records) {
                int rowIndex = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("adjusttype", (Object)record.getAdjusttype(), rowIndex);
                this.getModel().setValue("title", (Object)record.getTitle(), rowIndex);
                this.getModel().setValue("orgname", (Object)record.getOrg(), rowIndex);
                this.getModel().setValue("preadjust", (Object)record.getPreadjust(), rowIndex);
                this.getModel().setValue("postadjust", (Object)record.getPostadjust(), rowIndex);
                this.getModel().setValue("adjustexplain", (Object)record.getAdjustexplain(), rowIndex);
                this.getModel().setValue("creator", (Object)record.getCreator(), rowIndex);
                this.getModel().setValue("createtime", (Object)record.getCreatetime(), rowIndex);
            }
        }
    }

    private Object calcAdjustsumamount() {
        DynamicObjectCollection entryentitycard = this.getModel().getEntryEntity(ENTRYENTITY_CARD);
        return entryentitycard.stream().map(s -> s.getBigDecimal("totalamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private void appendCard(List<YhsSjjtAdjust> adjustDetails, List<YhsSjjtDetail> detailDatas, Map<String, Object> customParams) {
        YhsSjjtAdjust dynamicObject = null;
        if (adjustDetails != null) {
            Optional<YhsSjjtAdjust> optional = adjustDetails.stream().filter(s -> "0".equals(s.getRuleid())).findFirst();
            dynamicObject = optional.orElse(null);
        }
        int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY_CARD);
        this.getModel().setValue("titlename", (Object)ResManager.loadKDString((String)"\u624b\u5de5\u5f55\u5165\u8c03\u6574\u91d1\u989d", (String)"YhsSjjtDetailsFormPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]), rowIndex);
        this.getModel().setValue("cardadjustexplain", (Object)(dynamicObject != null ? dynamicObject.getAdjustexplain() : ""), rowIndex);
        this.getModel().setValue("totalamount", (Object)(dynamicObject != null ? dynamicObject.getTotalamount() : BigDecimal.ZERO), rowIndex);
        this.getModel().setValue("adjustamount", (Object)(dynamicObject != null ? dynamicObject.getAdjustamount() : BigDecimal.ZERO), rowIndex);
        this.getModel().setValue(RULEID, (Object)0L, rowIndex);
        this.getModel().setValue("org", (Object)(dynamicObject != null ? dynamicObject.getOrg() : 0L), rowIndex);
        Object cellvalue = customParams.get("cellvalue");
        if (detailDatas == null) {
            if (dynamicObject == null) {
                this.getModel().setValue("amount", cellvalue, rowIndex);
                this.getModel().setValue("sumamount", cellvalue);
                this.getModel().setValue("adjustsumamount", cellvalue);
            } else {
                BigDecimal amount = dynamicObject.getAmount();
                BigDecimal adjustamount = dynamicObject.getAdjustamount();
                this.getModel().setValue("amount", (Object)amount, rowIndex);
                this.getModel().setValue("sumamount", (Object)amount);
                this.getModel().setValue("adjustsumamount", (Object)amount.add(adjustamount));
            }
        } else {
            this.getModel().setValue("amount", (Object)0, rowIndex);
            this.getModel().setValue("sumamount", (Object)this.calcSumAmount(detailDatas));
            this.getModel().setValue("adjustsumamount", this.calcAdjustsumamount());
        }
    }

    private BigDecimal getAdjustamount(String ruleid, List<YhsSjjtAdjust> adjustDetails) {
        Optional<YhsSjjtAdjust> optional;
        if (EmptyCheckUtils.isNotEmpty(adjustDetails) && (optional = adjustDetails.stream().filter(s -> StringUtil.equals((CharSequence)s.getRuleid(), (CharSequence)ruleid)).findFirst()).isPresent()) {
            return optional.get().getAdjustamount();
        }
        return BigDecimal.ZERO;
    }

    private String getAdjustExplain(String ruleid, List<YhsSjjtAdjust> adjustDetails) {
        if (EmptyCheckUtils.isNotEmpty(adjustDetails)) {
            Optional<YhsSjjtAdjust> optional = adjustDetails.stream().filter(s -> s.getRuleid().equals(ruleid)).findFirst();
            return optional.map(YhsSjjtAdjust::getAdjustexplain).orElse(null);
        }
        return null;
    }

    private BigDecimal calcSumAmount(List<YhsSjjtDetail> yhsSjjtDetails) {
        if (EmptyCheckUtils.isEmpty(yhsSjjtDetails)) {
            return BigDecimal.ZERO;
        }
        BigDecimal sum = yhsSjjtDetails.stream().map(YhsSjjtDetail::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        return sum.setScale(2, 4);
    }

    private BigDecimal getAmount(String ruleid, List<YhsSjjtDetail> details) {
        if (EmptyCheckUtils.isNotEmpty(details)) {
            BigDecimal sum = details.stream().filter(s -> StringUtil.equals((CharSequence)s.getRuleid(), (CharSequence)ruleid)).map(YhsSjjtDetail::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            return sum.setScale(2, 4);
        }
        return BigDecimal.ZERO;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        if ("adjustamount".equals(name) || "totalamount".equals(name) || "otheradjustamount".equals(name)) {
            BigDecimal amount;
            if ("adjustamount".equals(name)) {
                BigDecimal adjustamount = (BigDecimal)changeData.getNewValue();
                amount = (BigDecimal)this.getModel().getValue("amount", rowIndex);
                this.getModel().setValue("totalamount", (Object)adjustamount.add(amount), rowIndex);
            }
            if ("totalamount".equals(name)) {
                BigDecimal totalamount = (BigDecimal)changeData.getNewValue();
                amount = (BigDecimal)this.getModel().getValue("amount", rowIndex);
                this.getModel().setValue("adjustamount", (Object)totalamount.subtract(amount), rowIndex);
            }
            this.refreshAdjustSumAmount();
        }
    }

    private void refreshAdjustSumAmount() {
        DynamicObjectCollection entryentitycard = this.getModel().getEntryEntity(ENTRYENTITY_CARD);
        BigDecimal adjustsumamount = entryentitycard.stream().map(s -> s.getBigDecimal("totalamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.getModel().setValue("adjustsumamount", (Object)adjustsumamount);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing && "save".equals(((Donothing)args.getSource()).getOperateKey())) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String data = (String)customParams.get("data");
            YhsSjjtData yhsSjjtData = new YhsSjjtData();
            if (StringUtil.isNotBlank((CharSequence)data)) {
                yhsSjjtData = (YhsSjjtData)JsonUtil.fromJson((String)data, YhsSjjtData.class);
            }
            String orgid = (String)customParams.get("orgid");
            String accorg = (String)customParams.get("accorg");
            String subtaxitem = (String)customParams.get("subtaxitem");
            String bizdimensionid = (String)customParams.get("bizdimensionid");
            Date skssqq = DateUtils.stringToDate2((String)((String)customParams.get("skssqq")));
            Date skssqz = DateUtils.stringToDate2((String)((String)customParams.get("skssqz")));
            DynamicObjectCollection entryentitycard = this.getModel().getEntryEntity(ENTRYENTITY_CARD);
            if (EmptyCheckUtils.isNotEmpty((Object)entryentitycard)) {
                if (!DetailDialogValidHelper.validMustInput(this, ENTRYENTITY_CARD, "cardadjustexplain", "totalamount", "amount")) {
                    return;
                }
                BigDecimal adjustsumamount = (BigDecimal)this.getModel().getValue("adjustsumamount");
                if (BigDecimal.ZERO.compareTo(adjustsumamount) > 0) {
                    this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u7a0e\u91d1\u989d\u5408\u8ba1\u503c\u5b58\u5728\u8d1f\u6570", (String)"YhsSjjtDetailsFormPlugin_1", (String)"taxc-tcret", (Object[])new Object[0]));
                }
                this.addAdjustRecord(entryentitycard, yhsSjjtData);
                ArrayList<YhsSjjtAdjust> newAdjusts = new ArrayList<YhsSjjtAdjust>();
                for (DynamicObject dynamicObject : entryentitycard) {
                    YhsSjjtAdjust yhsSjjtAdjust = new YhsSjjtAdjust();
                    yhsSjjtAdjust.setRuleid(dynamicObject.getString(RULEID));
                    yhsSjjtAdjust.setTitlename(dynamicObject.getString("titlename"));
                    yhsSjjtAdjust.setTaxitem(dynamicObject.getString("taxitem"));
                    yhsSjjtAdjust.setAmount(dynamicObject.getBigDecimal("amount"));
                    yhsSjjtAdjust.setAdjustamount(dynamicObject.getBigDecimal("adjustamount"));
                    yhsSjjtAdjust.setTotalamount(dynamicObject.getBigDecimal("totalamount"));
                    yhsSjjtAdjust.setAdjustexplain(dynamicObject.getString("cardadjustexplain"));
                    yhsSjjtAdjust.setOrg(Long.valueOf(orgid));
                    yhsSjjtAdjust.setSkssqq(skssqq);
                    yhsSjjtAdjust.setSkssqz(skssqz);
                    yhsSjjtAdjust.setAccountorg(Long.valueOf(accorg));
                    yhsSjjtAdjust.setSubtaxitem(Long.valueOf(subtaxitem));
                    yhsSjjtAdjust.setBizdimensionid(bizdimensionid);
                    newAdjusts.add(yhsSjjtAdjust);
                }
                yhsSjjtData.setAdjusts(newAdjusts);
            }
            customParams.put("adjustsumamount", this.getModel().getValue("adjustsumamount").toString());
            customParams.put("data", JsonUtil.toJson((Object)yhsSjjtData));
            this.getView().returnDataToParent((Object)customParams);
            this.getView().close();
        }
    }

    private void addAdjustRecord(DynamicObjectCollection entryentitycard, YhsSjjtData yhsSjjtData) {
        String manualAdjust = ResManager.loadKDString((String)"\u624b\u5de5\u5f55\u5165\u8c03\u6574\u91d1\u989d", (String)"YhsSjjtDetailsFormPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]);
        List<YhsSjjtRecord> records = yhsSjjtData.getRecords();
        Map<Object, Object> amountMap = new HashMap();
        if (EmptyCheckUtils.isNotEmpty(records)) {
            amountMap = records.stream().collect(Collectors.toMap(d -> d.getTitle() + d.getRuleid(), YhsSjjtRecord::getPostadjust, (k, v) -> v));
        } else {
            records = new ArrayList<YhsSjjtRecord>();
            yhsSjjtData.setRecords(records);
        }
        for (DynamicObject d2 : entryentitycard) {
            BigDecimal currentAdjustAmount;
            String adjusttype = manualAdjust.equals(d2.getString("titlename")) ? "2" : "1";
            String key = d2.getString("titlename") + d2.getString(RULEID);
            BigDecimal preAdjustAmount = amountMap.getOrDefault(key, BigDecimal.ZERO);
            if (preAdjustAmount.compareTo(currentAdjustAmount = d2.getBigDecimal("adjustamount")) == 0) continue;
            YhsSjjtRecord record = new YhsSjjtRecord();
            record.setAdjusttype(adjusttype);
            record.setRuleid(d2.getLong(RULEID));
            record.setTitle(d2.getString("titlename"));
            record.setPreadjust(preAdjustAmount);
            record.setPostadjust(currentAdjustAmount);
            record.setAdjustexplain(d2.getString("cardadjustexplain"));
            record.setOrg(d2.getLong("org.id"));
            record.setCreator(RequestContext.get().getCurrUserId());
            record.setCreatetime(new Date());
            records.add(record);
        }
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        String data;
        CardEntry cardEntry = (CardEntry)evt.getSource();
        List rows = evt.getNewRows();
        DynamicObjectCollection entryentitycard = this.getModel().getEntryEntity(ENTRYENTITY_CARD);
        if (rows.isEmpty()) {
            return;
        }
        if (entryentitycard.size() - 1 == (Integer)rows.get(0)) {
            return;
        }
        this.clearEntry(ENTRYENTITY_LIST);
        Long ruleid = (Long)cardEntry.getModel().getValue(RULEID);
        if (ruleid != null && StringUtil.isNotBlank((CharSequence)(data = this.getPageCache().get("yhsSjjtDetail")))) {
            List details = JsonUtil.fromJsonList((String)data, YhsSjjtDetail.class);
            this.setEntryentitylist(ruleid.toString(), details);
        }
    }

    private void clearEntry(String ... entryNames) {
        for (String entry : entryNames) {
            this.getModel().deleteEntryData(entry);
        }
    }

    private void setEntryentitylist(String ruleid, List<YhsSjjtDetail> details) {
        if (CollectionUtils.isEmpty(details)) {
            return;
        }
        List currentRuleDetails = details.stream().filter(d -> d.getRuleid().equals(ruleid)).collect(Collectors.toList());
        this.getModel().beginInit();
        for (YhsSjjtDetail object : currentRuleDetails) {
            int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY_LIST);
            this.getModel().setValue("taxperiod", (Object)object.getTaxperiod(), rowIndex);
            this.getModel().setValue("bizname", (Object)object.getBizname(), rowIndex);
            this.getModel().setValue("table", (Object)object.getTable(), rowIndex);
            this.getModel().setValue("amountfield", (Object)object.getAmountfield(), rowIndex);
            this.getModel().setValue("datatype", (Object)object.getDatatype(), rowIndex);
            this.getModel().setValue("absolute", (Object)object.getAbsolute(), rowIndex);
            this.getModel().setValue("datadirection", (Object)object.getDatadirection(), rowIndex);
            this.getModel().setValue("fetchamount", (Object)object.getAmount(), rowIndex);
            this.getModel().setValue("filtercondition", (Object)object.getFiltercondition(), rowIndex);
            this.getModel().setValue("filtercondition_tag", (Object)object.getFiltercondition(), rowIndex);
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY_LIST);
    }

    public void afterBindData(EventObject e) {
        CardEntry entryentitycard = (CardEntry)this.getControl(ENTRYENTITY_CARD);
        entryentitycard.selectCard(Integer.valueOf(0));
        entryentitycard.selectRowsChanged(Collections.singletonList(0), null);
    }

    static {
        ruleTypeMap.put("1", "tcsd_rule_yshtpz");
        ruleTypeMap.put("2", "tcsd_rule_cqzysj");
        ruleTypeMap.put("3", "tcsd_rule_zjzb");
    }
}

