/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.accrual.handler;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tcret.common.enums.FcsTypeEnum;
import kd.taxc.tcret.formplugin.accrual.handler.AbstractFcsAccrualDraftCalHandler;

public class FcsHireAccrualCalHandler
extends AbstractFcsAccrualDraftCalHandler {
    private static final List<String> JZJMCODE_LIST = Lists.newArrayList((Object[])new String[]{"08011707", "08011708", "08011709", "08011710", "08129917"});

    @Override
    protected FcsTypeEnum getType() {
        return FcsTypeEnum.FCS_BY_HIRE;
    }

    @Override
    protected void setOtherValue(DynamicObject sourceObject, DynamicObject targetObject, Long orgId, String tabKey) {
        Date skssqq = targetObject.getDate("skssqq");
        Date skssqz = targetObject.getDate("skssqz");
        int monthDiff = DateUtils.getMonthDiff((Date)skssqz, (Date)skssqq);
        String fields = "leasecontractno,taxauthority,leaseetaxcode,leaseename,leasearea,contractstart,contractend";
        for (String field : fields.split(",")) {
            targetObject.set(field, sourceObject.get(field));
        }
        DynamicObjectCollection targetRententryentity = targetObject.getDynamicObjectCollection("rententryentity");
        DynamicObjectCollection sourcerententryentity = sourceObject.getDynamicObjectCollection("rententryentity");
        for (int i = 0; i < sourcerententryentity.size(); ++i) {
            Date enddate;
            DynamicObject source = (DynamicObject)sourcerententryentity.get(i);
            Date startdate = source.getDate("startdate");
            List<String> periodList = FcsHireAccrualCalHandler.getPeriodList(startdate, enddate = source.getDate("enddate"));
            long count = periodList.stream().filter(s -> {
                Date date = DateUtils.stringToDate((String)s, (String)"yyyy-MM");
                return !date.before(skssqq) && !date.after(skssqz);
            }).count();
            if (count <= 0L) continue;
            DynamicObject target = targetRententryentity.addNew();
            target.set("hirearea", source.get("hirearea"));
            target.set("rentincome", source.get("rentincome"));
            target.set("startdate", source.get("startdate"));
            target.set("enddate", source.get("enddate"));
            target.set("tenantry", source.get("tenantry"));
            target.set("hiretaxcode", source.get("hiretaxcode"));
        }
        DynamicObject fcsbasicinfo = sourceObject.getDynamicObject("fcsbasicinfo");
        if (fcsbasicinfo != null) {
            targetObject.set("number", fcsbasicinfo.get("number"));
            targetObject.set("name", fcsbasicinfo.get("name"));
            targetObject.set("fcsapanage", fcsbasicinfo.get("basedatafield"));
        }
        targetObject.set("taxlimit", sourceObject.get("fcsbyhirelimit"));
        targetObject.set("name", sourceObject.get("buildingname"));
        this.setJmAmount(sourceObject, targetObject, skssqq, skssqz, monthDiff);
    }

    @Override
    protected BigDecimal getCurrentPayable(BigDecimal taxRate, Date skssqq, Date skssqz, DynamicObject sourceObject, DynamicObject targetObject, DynamicObject entry, String tabKey) {
        BigDecimal rent = this.getCurrentRent(sourceObject, skssqq, skssqz);
        targetObject.set("currental", (Object)rent);
        return BigDecimalUtil.multiplyObject((Object)rent, (Object)taxRate, (int)2, (int)4);
    }

    private BigDecimal getCurrentRent(DynamicObject sourceObject, Date skssqq, Date skssqz) {
        DynamicObjectCollection rententryentity = sourceObject.getDynamicObjectCollection("rententryentity");
        BigDecimal result = BigDecimal.ZERO;
        for (DynamicObject rentDetail : rententryentity) {
            Date startDate = rentDetail.getDate("startdate");
            Date endDate = rentDetail.getDate("enddate");
            BigDecimal rentIncome = rentDetail.getBigDecimal("rentincome");
            BigDecimal unitPrice = this.doCalRentUnitPrice(startDate, endDate, rentIncome);
            int accrualMonth = this.doCalAccrualMonth(startDate, endDate, skssqq, skssqz);
            result = result.add(unitPrice.multiply(new BigDecimal(accrualMonth)));
        }
        return result.setScale(2, 4);
    }

    private BigDecimal doCalRentUnitPrice(Date startDate, Date endDate, BigDecimal rentIncome) {
        int monthDiff = DateUtils.getMonthDiff((Date)endDate, (Date)startDate) + 1;
        return rentIncome.divide(new BigDecimal(monthDiff), 2, 4);
    }

    private int doCalAccrualMonth(Date startRentDate, Date endRentDate, Date skssqq, Date skssqz) {
        return DateUtils.monthOfD1MinusD2((Date)DateUtils.getSmaller((Date)endRentDate, (Date)skssqz), (Date)DateUtils.getBigger((Date)startRentDate, (Date)skssqq)) < 0 ? 0 : DateUtils.getMonthDiff((Date)DateUtils.getSmaller((Date)endRentDate, (Date)skssqz), (Date)DateUtils.getBigger((Date)startRentDate, (Date)skssqq)) + 1;
    }

    public static List<String> getPeriodList(Date skssqq, Date skssqz) {
        ArrayList<String> list = new ArrayList<String>();
        if (DateUtils.formatMonth((Date)skssqq).equals(DateUtils.formatMonth((Date)skssqz))) {
            list.add(DateUtils.formatMonth((Date)skssqq));
        } else {
            while (skssqq.compareTo(skssqz) <= 0) {
                list.add(DateUtils.formatMonth((Date)skssqq));
                skssqq = DateUtils.addMonth((Date)skssqq, (int)1);
            }
        }
        return list;
    }

    private void setJmAmount(DynamicObject sourceObject, DynamicObject targetObject, Date skssqq, Date skssqz, int monthDiff) {
        BigDecimal totalJmamount = BigDecimal.ZERO;
        BigDecimal originalAmount = targetObject.getBigDecimal("currental");
        DynamicObjectCollection entryentity = targetObject.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection sourceEntity = sourceObject.getDynamicObjectCollection("entryentity");
        for (DynamicObject object : sourceEntity) {
            Date end;
            Date start = object.getDate("start");
            int minusMonths = FcsHireAccrualCalHandler.getMinusMonths(start, end = object.getDate("end"), skssqq, skssqz);
            if (minusMonths <= 0) continue;
            DynamicObject entry = entryentity.addNew();
            String registerule = object.getString("registerule");
            BigDecimal amount = object.getBigDecimal("entervalue");
            if ("1".equals(registerule) || "2".equals(registerule)) {
                BigDecimal registeretio = object.getBigDecimal("registeretio");
                amount = BigDecimalUtil.multiplyObject((Object)originalAmount, (Object)registeretio, (int)2, (int)4);
            }
            entry.set("amount", (Object)amount);
            DynamicObject taxdeduction = object.getDynamicObject("taxdeduction");
            entry.set("jmcode", (Object)taxdeduction);
            BigDecimal jmamount = BigDecimal.ZERO;
            String deductiontype = taxdeduction.getString("deductiontype");
            BigDecimal taxrate = targetObject.getBigDecimal("taxrate");
            if ("1".equals(deductiontype)) {
                jmamount = amount.multiply(taxrate).multiply(new BigDecimal(minusMonths)).divide(new BigDecimal(monthDiff + 1), 2, 4);
            } else if ("2".equals(deductiontype)) {
                jmamount = amount.multiply(object.getBigDecimal("ratio")).multiply(taxrate).multiply(new BigDecimal(minusMonths)).divide(new BigDecimal(monthDiff + 1), 2, 4);
            } else if ("6".equals(deductiontype)) {
                jmamount = BigDecimalUtil.multiplyObject((Object)object.getBigDecimal("monthlimit"), (Object)new BigDecimal(minusMonths), (int)2);
            }
            if (JZJMCODE_LIST.contains(taxdeduction.getString("number"))) {
                jmamount = amount.multiply(object.getBigDecimal("ratio")).multiply(new BigDecimal(minusMonths)).divide(new BigDecimal(monthDiff + 1), 2, 4);
            }
            entry.set("jmamount", (Object)jmamount);
            totalJmamount = BigDecimalUtil.addObject((Object)totalJmamount, (Object)jmamount);
            entry.set("start", object.get("start"));
            entry.set("end", object.get("end"));
            BigDecimal yjmamount = BigDecimalUtil.divideObject((Object)jmamount, (Object)minusMonths, (int)2);
            entry.set("yjmamount", (Object)yjmamount);
        }
        targetObject.set("currentjmamount", (Object)totalJmamount);
    }
}

