/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.accrual.handler;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tcret.common.enums.FcsTypeEnum;
import kd.taxc.tcret.formplugin.accrual.handler.AbstractFcsAccrualDraftCalHandler;

public class FctdsAccrualCalHandler
extends AbstractFcsAccrualDraftCalHandler {
    @Override
    protected FcsTypeEnum getType() {
        return FcsTypeEnum.TDS;
    }

    @Override
    protected void setOtherValue(DynamicObject sourceObject, DynamicObject targetObject, Long orgId, String tabKey) {
        Date skssqq = targetObject.getDate("skssqq");
        Date skssqz = targetObject.getDate("skssqz");
        String fields = "tdsapanage,taxpayertype,number,name,fixassertnumber,fixassertunitcode,parcelcode,landnature,landobtainway,landpurpose,taxauthority,detailaddr,obtaintime,price";
        for (String field : fields.split(",")) {
            targetObject.set(field, sourceObject.get(field));
        }
        targetObject.set("taxlimit", sourceObject.get("taxtimelimit"));
        this.setJmAmount(sourceObject, targetObject, skssqq, skssqz);
    }

    @Override
    protected BigDecimal getCurrentPayable(BigDecimal taxRate, Date startdate, Date enddate, DynamicObject sourceObject, DynamicObject targetObject, DynamicObject entry, String tabKey) {
        int monthLength = DateUtils.getMonthDiff((Date)enddate, (Date)startdate) + 1;
        BigDecimal landArea = sourceObject.getBigDecimal("landarea");
        BigDecimal taxStandard = sourceObject.getBigDecimal("taxstandard");
        String landlevel = sourceObject.getString("level");
        Date changeDate = sourceObject.getDate(FcsTypeEnum.TDS.getChangedateKey());
        String changeType = sourceObject.getString("changetype");
        if (entry != null) {
            landArea = entry.getBigDecimal("bglandarea");
            taxStandard = entry.getBigDecimal("bgtaxstandard");
            landlevel = entry.getString("bglevel");
        }
        if (changeDate == null || changeDate.compareTo(startdate) < 0 || changeDate.compareTo(enddate) > 0) {
            if (entry != null) {
                changeDate = entry.getDate("bgdate");
                changeType = entry.getString("bgtype");
            } else {
                changeDate = null;
                changeType = null;
            }
        }
        targetObject.set("occupylandarea", (Object)landArea);
        targetObject.set("taxstandard", (Object)taxStandard);
        targetObject.set("landlevel", (Object)landlevel);
        targetObject.set("changedate", (Object)changeDate);
        targetObject.set("changetype", (Object)changeType);
        return BigDecimalUtil.divideObject((Object)landArea.multiply(taxStandard).multiply(new BigDecimal(monthLength)), (Object)12, (int)2);
    }

    protected void setJmAmount(DynamicObject sourceObject, DynamicObject targetObject, Date skssqq, Date skssqz) {
        BigDecimal totalJmamount = BigDecimal.ZERO;
        BigDecimal originalAmount = targetObject.getBigDecimal("occupylandarea");
        DynamicObjectCollection entryentity = targetObject.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection sourceEntity = sourceObject.getDynamicObjectCollection("entryentity");
        for (DynamicObject object : sourceEntity) {
            Date end;
            Date start = object.getDate("start");
            int minusMonths = FctdsAccrualCalHandler.getMinusMonths(start, end = object.getDate("end"), skssqq, skssqz);
            if (minusMonths <= 0) continue;
            DynamicObject entry = entryentity.addNew();
            String registerule = object.getString("registerule");
            BigDecimal amount = object.getBigDecimal("entervalue");
            if ("1".equals(registerule) || "2".equals(registerule)) {
                BigDecimal registeretio = object.getBigDecimal("registeretio");
                amount = BigDecimalUtil.multiplyObject((Object)originalAmount, (Object)registeretio, (int)2, (int)4);
            }
            entry.set("amount", (Object)amount);
            DynamicObject taxdeduction = object.getDynamicObject("taxdeduction");
            entry.set("jmcode", (Object)taxdeduction);
            BigDecimal jmamount = BigDecimal.ZERO;
            String deductiontype = taxdeduction.getString("deductiontype");
            BigDecimal taxstandard = targetObject.getBigDecimal("taxstandard");
            if ("1".equals(deductiontype)) {
                jmamount = amount.multiply(taxstandard).multiply(new BigDecimal(minusMonths)).divide(new BigDecimal(12), 2, 4);
            } else if ("2".equals(deductiontype)) {
                jmamount = amount.multiply(object.getBigDecimal("ratio")).multiply(taxstandard).multiply(new BigDecimal(minusMonths)).divide(new BigDecimal(12), 2, 4);
            } else if ("6".equals(deductiontype)) {
                jmamount = BigDecimalUtil.multiplyObject((Object)object.getBigDecimal("monthlimit"), (Object)new BigDecimal(minusMonths), (int)2);
            }
            entry.set("jmamount", (Object)jmamount);
            totalJmamount = BigDecimalUtil.addObject((Object)totalJmamount, (Object)jmamount);
            entry.set("start", object.get("start"));
            entry.set("end", object.get("end"));
            BigDecimal yjmamount = BigDecimalUtil.divideObject((Object)jmamount, (Object)minusMonths, (int)2);
            entry.set("yjmamount", (Object)yjmamount);
        }
        targetObject.set("currentjmamount", (Object)totalJmamount);
    }
}

