/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.apphome;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class TcretAppHomePlugin
extends AbstractFormPlugin {
    private static Map<Integer, String> monthMap = new HashMap<Integer, String>();

    public void afterCreateNewData(EventObject e) {
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)true);
        this.getPageCache().put("orgList", SerializationUtils.toJsonString((Object)col));
        Object object = this.getModel().getValue("org");
        Long orgid = null;
        if (object == null) {
            orgid = OrgCheckUtil.setDefaultOrg((IFormView)this.getView(), (Long)RequestContext.get().getOrgId(), (DynamicObjectCollection)col);
            if (null == orgid) {
                return;
            }
            if (OrgCheckUtil.check((IFormView)this.getView(), (String)String.valueOf(orgid), (String)"tcret", null)) {
                orgid = null;
            }
        } else {
            orgid = ((DynamicObject)object).getLong("id");
        }
        this.getModel().setValue("org", (Object)orgid);
        this.refreshCache();
    }

    private void refreshCache() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org == null) {
            this.getPageCache().remove("org");
            return;
        }
        this.getPageCache().put("org", org.getString("id"));
        if (this.getPageCache().get("period_" + org.getPkValue()) != null) {
            return;
        }
        TaxResult taxResult = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)org.getLong("id"));
        if (!taxResult.isSuccess() || EmptyCheckUtils.isEmpty((Object)taxResult.getData()) || ((DynamicObject)taxResult.getData()).getLong("registeraddress") == 0L) {
            return;
        }
        DynamicObject registerAddress = this.getAdmindivision(((DynamicObject)taxResult.getData()).getLong("registeraddress"));
        long level = registerAddress.getLong("basedatafield");
        long provinceid = 0L;
        long cityid = -1L;
        if (level == 1L) {
            provinceid = registerAddress.getLong("id");
        } else if (level == 2L) {
            cityid = registerAddress.getLong("id");
            provinceid = registerAddress.getLong("parent");
        } else if (level == 3L) {
            cityid = registerAddress.getLong("parent");
            DynamicObject city = this.getAdmindivision(cityid);
            provinceid = city.getLong("parent");
        }
        QFilter provinceFilter = new QFilter("entryentity.provinces", "=", (Object)provinceid);
        QFilter cityFilter = new QFilter("entryentity.city", "=", (Object)cityid);
        QFilter taxtypeFilter = new QFilter("entryentity.taxtype", "=", (Object)"1");
        QFilter methodsFilter = new QFilter("entryentity.methods", "=", (Object)"2");
        Date now = new Date();
        int year = now.getYear() + 1900;
        int month = now.getMonth() + 1;
        QFilter yearFilter = new QFilter("year", "=", (Object)String.valueOf(year));
        DynamicObject dynamicObjects = QueryServiceHelper.queryOne((String)"tpo_tax_calendar", (String)("id, entryentity." + monthMap.get(month) + " as date"), (QFilter[])new QFilter[]{provinceFilter, cityFilter, taxtypeFilter, methodsFilter, yearFilter});
        if (dynamicObjects == null) {
            dynamicObjects = QueryServiceHelper.queryOne((String)"tpo_tax_calendar", (String)("id, entryentity." + monthMap.get(month) + " as date"), (QFilter[])new QFilter[]{provinceFilter, taxtypeFilter, methodsFilter, yearFilter});
        }
        if (dynamicObjects != null) {
            String datestr = dynamicObjects.getString("date");
            Date date = DateUtils.stringToDate((String)String.format(ResManager.loadKDString((String)"%1$s\u5e74%2$s", (String)"TcretAppHomePlugin_0", (String)"taxc-tcret", (Object[])new Object[0]), year, datestr), (String)DateUtils.YYYYMMDD_CHINESE);
            String period = now.after(date) ? DateUtils.formatMonth((Date)now) : DateUtils.getLastMonthFirstDateStr((String)"yyyy-MM");
            this.getPageCache().put("period_" + org.getPkValue(), period);
        }
    }

    private DynamicObject getAdmindivision(Long id) {
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        return QueryServiceHelper.queryOne((String)"bd_admindivision", (String)"id, parent, basedatafield", (QFilter[])new QFilter[]{idFilter});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("org".equals(e.getProperty().getName())) {
            String orgId = Optional.ofNullable((DynamicObject)this.getModel().getValue("org")).map(s -> s.getString("id")).orElse(null);
            if (orgId == null) {
                return;
            }
            boolean check = OrgCheckUtil.withoutLicenseCheck((IFormView)this.getView(), (String)orgId, (String)"tcret", (String)"fcscztdsys");
            if (!check) {
                this.refreshCache();
                this.refreshView();
            }
        }
    }

    private void refreshView() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap dataMap = new HashMap();
        proxy.invokeControlMethod("gridcontainerap", "trigger", new Object[]{dataMap});
    }

    public void customEvent(CustomEventArgs e) {
        if ("refreshFromGridContainer".equals(e.getKey())) {
            this.refreshView();
        }
    }

    static {
        monthMap.put(1, "january");
        monthMap.put(2, "february");
        monthMap.put(3, "march");
        monthMap.put(4, "april");
        monthMap.put(5, "may");
        monthMap.put(6, "june");
        monthMap.put(7, "july");
        monthMap.put(8, "august");
        monthMap.put(9, "september");
        monthMap.put(10, "october");
        monthMap.put(11, "november");
        monthMap.put(12, "december");
    }
}

