/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.compare;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.taxc.bdtaxr.common.constant.AccrualConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.provision.ProvisionSharePlanDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.license.plugin.common.AbstractLicenseCheckFormPlugin;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.tcret.business.compare.CompareCalcService;
import kd.taxc.tcret.business.compare.CompareCalcServiceFactory;
import kd.taxc.tcret.business.compare.CompareServiceHelper;
import kd.taxc.tcret.common.constant.TcretAccrualConstant;
import kd.taxc.tcret.common.enums.CompareListEnum;
import kd.taxc.tcret.common.utils.CompareUtils;

public class CompareDraftFormPlugin
extends AbstractLicenseCheckFormPlugin
implements TcretAccrualConstant,
BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(CompareDraftFormPlugin.class);
    private List<String> paramKeys = Arrays.asList("org", "frequency", "skssqq", "skssqz");

    private void doCalcCompareDetails() {
        DynamicObject compareDraftObj = this.getModel().getDataEntity(true);
        DynamicObjectCollection detailList = compareDraftObj.getDynamicObjectCollection("entryentity");
        detailList.clear();
        long start = System.currentTimeMillis();
        CompareCalcService service = CompareCalcServiceFactory.getService(this.getCompareDraftType());
        service.doCalcCompareDetails(compareDraftObj);
        long end = System.currentTimeMillis();
        logger.info("\u8ba1\u7b97\u6bd4\u5bf9\u5e95\u7a3f\u660e\u7ec6\u6210\u529f\uff0c\u8017\u65f6\uff1a" + (end - start));
        this.getView().updateView();
    }

    public void registerListener(EventObject e) {
        BasedataEdit base = (BasedataEdit)this.getView().getControl("org");
        base.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "org": {
                this.doTaxOrgChanged(e);
                break;
            }
            case "frequency": {
                String newfrequency = (String)e.getChangeSet()[0].getNewValue();
                this.doSetTaxPeriod(newfrequency, true);
                break;
            }
            case "skssqq": 
            case "skssqz": {
                Map skssqzMap;
                Date newValue = (Date)e.getChangeSet()[0].getNewValue();
                String frequency = (String)this.getModel().getValue("frequency");
                if (newValue != null && frequency != null && EmptyCheckUtils.isNotEmpty((Object)(skssqzMap = DateUtils.getPeriodByTaxLimit((Date)newValue, (String)frequency)))) {
                    this.getModel().setValue("skssqq", skssqzMap.get("startDate"));
                    this.getModel().setValue("skssqz", skssqzMap.get("endDate"));
                }
                this.doAccrualDateChanged(frequency);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        for (String paramKey : this.paramKeys) {
            if (params.get(paramKey) == null) continue;
            this.getModel().setValue(paramKey, params.get(paramKey));
        }
        this.doSetBaseField();
        this.loadData();
    }

    public void afterBindData(EventObject e) {
        this.setBtnStatus(this.getModel().getDataEntity(), this.getCompareDraftType());
        if (this.getView().getFormShowParameter().getCustomParams().get("isFormViewFlow") != null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tbmain"});
        }
        this.setDimensionField();
    }

    private void setDimensionField() {
        DynamicObject taxorg = (DynamicObject)this.getModel().getValue("org");
        if (taxorg != null) {
            TaxResult taxResult = ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryIdAndDateRange(Collections.singletonList(taxorg.getLong("id")), (Long)((DynamicObject)this.getModel().getValue("taxtype")).getLong("id"), (Long)AccrualConstant.TAXSYSTEM_CHINA, (Date)this.getModel().getDataEntity().getDate("skssqq"), (Date)this.getModel().getDataEntity().getDate("skssqz"));
            if (EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
                DynamicObject entry = (DynamicObject)((DynamicObjectCollection)taxResult.getData()).get(0);
                boolean isdimprovision = entry.getBoolean("ruleentity.rule.isdimprovision");
                String provisiondimension = entry.getString("ruleentity.rule.provisiondimension");
                if (isdimprovision && provisiondimension.contains("businessdimension")) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"bizdimensiontype", "bizdimensionname"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"bizdimensiontype", "bizdimensionname"});
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bizdimensiontype", "bizdimensionname", "bizdimensionid"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bizdimensiontype", "bizdimensionname", "bizdimensionid"});
        }
    }

    private void doSetBaseField() {
        if (this.getModel().getValue("org") == null) {
            HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
            this.doSetTaxOrg(hasPermOrgs);
        }
        this.doSetDefaultValue();
        this.doSetAccrualItem();
    }

    private void doSetDefaultValue() {
        this.getModel().setValue("taxsystem", (Object)AccrualConstant.TAXSYSTEM_CHINA);
        this.getModel().setValue("taxareagroup", (Object)AccrualConstant.TAXAREAGROUP_CHINA);
        this.getModel().setValue("accountsettype", (Object)"");
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if ("org".equals(beforeF7SelectEvent.getProperty().getName())) {
            HasPermOrgResult permOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
            if (EmptyCheckUtils.isNotEmpty((Object)permOrgResult) && !permOrgResult.hasAllOrgPerm()) {
                List orgList = permOrgResult.getHasPermOrgs();
                List customQFilters = beforeF7SelectEvent.getCustomQFilters();
                customQFilters.add(new QFilter("id", "in", (Object)orgList));
            }
            OrgUtils.addFilterByConditionBeforeF7Select((Object)beforeF7SelectEvent, (IFormView)this.getView(), null, null, null);
        }
    }

    private void doSetTaxOrg(HasPermOrgResult hasPermOrgs) {
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)true);
        Long orgid = OrgCheckUtil.setDefaultOrg((IFormView)this.getView(), (Long)RequestContext.get().getOrgId(), (DynamicObjectCollection)col);
        if (orgid != null) {
            int permission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)orgid, (String)"tcret", (String)((String)this.getView().getFormShowParameter().getCustomParams().get("formId")), (String)"47156aff000000ac");
            if (permission == 1) {
                this.getModel().setValue("org", (Object)orgid);
            } else {
                hasPermOrgs.getHasPermOrgs().remove(orgid);
                this.doSetTaxOrg(hasPermOrgs);
            }
        }
    }

    private void doSetAccrualItem() {
        if (this.getModel().getValue("org") == null) {
            return;
        }
        String frequency = (String)this.getModel().getValue("frequency");
        this.doSetTaxPeriod(frequency, false);
    }

    private void doSetTaxPeriod(String frequency, boolean reSetSkssqqz) {
        DynamicObject taxOrg = (DynamicObject)this.getModel().getValue("org");
        if (taxOrg == null) {
            return;
        }
        Object skssqq = this.getModel().getValue("skssqq");
        Object skssqz = this.getModel().getValue("skssqz");
        if (!reSetSkssqqz && skssqq != null && skssqz != null) {
            return;
        }
        Date now = new Date();
        Map skssqzMap = DateUtils.getPrePeriodByTaxLimit((Date)now, (String)frequency);
        if (EmptyCheckUtils.isNotEmpty((Object)skssqzMap)) {
            this.getModel().setValue("skssqq", skssqzMap.get("startDate"));
            this.getModel().setValue("skssqz", skssqzMap.get("endDate"));
        }
    }

    private void loadData() {
        DynamicObject taxOrg = (DynamicObject)this.getModel().getValue("org");
        Date skssqq = (Date)this.getModel().getValue("skssqq");
        Date skssqz = (Date)this.getModel().getValue("skssqz");
        if (taxOrg == null || skssqq == null || skssqz == null) {
            this.getModel().deleteEntryData("entryentity");
            return;
        }
        Long orgId = taxOrg.getLong("id");
        String category = CompareListEnum.getTaxCategoryByDraftType(this.getCompareDraftType());
        boolean isNotPass = OrgCheckUtil.withoutLicenseCheck((IFormView)this.getView(), (String)String.valueOf(orgId), (String)"tcret", (String)category);
        if (isNotPass) {
            return;
        }
        boolean hasNoDraftLicense = OrgCheckUtil.draftLicenseCheck((IFormView)this.getView(), (String)"", (String)"tcdrs", (String)"");
        if (hasNoDraftLicense) {
            return;
        }
        DynamicObject compareDraftObject = CompareServiceHelper.queryCompareDraft(taxOrg.getLong("id"), this.getCompareDraftType(), skssqq, skssqz);
        this.setBtnStatus(compareDraftObject, this.getCompareDraftType());
        if (compareDraftObject != null) {
            Long pkId = compareDraftObject.getLong("id");
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("org", compareDraftObject.getDynamicObject("org").get("id"));
            customParams.put("skssqq", skssqq);
            customParams.put("skssqz", skssqz);
            customParams.put("drafttype", this.getCompareDraftType());
            PageShowCommon.showBill((ShowType)ShowType.InCurrentForm, (String)this.getEntityName(), (Object)pkId, (IFormView)this.getView(), customParams, (OperationStatus)OperationStatus.EDIT);
        } else {
            this.doCalcCompareDetails();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        DynamicObject taxorg = (DynamicObject)this.getModel().getValue("org");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String draftType = this.getCompareDraftType();
        switch (operateKey) {
            case "recal": {
                Long orgId = taxorg.getLong("id");
                String category = CompareListEnum.getTaxCategoryByDraftType(draftType);
                boolean isNotPass = OrgCheckUtil.withoutLicenseCheck((IFormView)this.getView(), (String)String.valueOf(orgId), (String)"tcret", (String)category);
                if (isNotPass) {
                    return;
                }
                boolean hasNoDraftLicense = OrgCheckUtil.draftLicenseCheck((IFormView)this.getView(), (String)"", (String)"tcdrs", (String)"");
                if (hasNoDraftLicense) {
                    return;
                }
                String frequency = (String)this.getModel().getValue("frequency");
                if (!this.checkPeriod(frequency).booleanValue()) break;
                this.doCalcCompareDetails();
                break;
            }
            case "checkjtd": {
                CompareUtils.openProvistonBillPage(this.getView(), dataEntity);
                break;
            }
            case "viewjt": {
                CompareUtils.openAccrualListPage(this.getView(), dataEntity);
                break;
            }
            case "viewsbb": {
                CompareUtils.openTcretDeclareListPage(this.getView(), dataEntity);
                break;
            }
            case "viewjnd": {
                CompareUtils.openPayRecordListPage(this.getView(), dataEntity);
            }
        }
        this.setBtnStatus(this.getModel().getDataEntity(), draftType);
    }

    private void doAccrualDateChanged(String frequency) {
        Boolean result;
        this.getModel().deleteEntryData("entryentity");
        DynamicObject taxOrg = (DynamicObject)this.getModel().getValue("org");
        if (taxOrg != null && (result = this.checkPeriod(frequency)).booleanValue()) {
            this.showBill();
        }
    }

    private void showBill() {
        DynamicObject taxOrg = (DynamicObject)this.getModel().getValue("org");
        Date skssqq = (Date)this.getModel().getValue("skssqq");
        Date skssqz = (Date)this.getModel().getValue("skssqz");
        if (taxOrg == null || skssqq == null || skssqz == null) {
            return;
        }
        DynamicObject compareDraftObject = CompareServiceHelper.queryCompareDraft(taxOrg.getLong("id"), this.getCompareDraftType(), skssqq, skssqz);
        Long pkId = null;
        OperationStatus operationStatus = OperationStatus.ADDNEW;
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        if (compareDraftObject != null) {
            pkId = compareDraftObject.getLong("id");
            operationStatus = OperationStatus.EDIT;
        }
        customParams.put("org", taxOrg.getLong("id"));
        customParams.put("frequency", this.getModel().getValue("frequency"));
        customParams.put("skssqq", skssqq);
        customParams.put("skssqz", skssqz);
        customParams.put("drafttype", this.getCompareDraftType());
        PageShowCommon.showBill((ShowType)ShowType.InCurrentForm, (String)this.getEntityName(), (Object)pkId, (IFormView)this.getView(), customParams, (OperationStatus)operationStatus);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Save || args.getSource() instanceof Submit) {
            DynamicObject org;
            for (int i = 0; i < this.getModel().getEntryEntity("entryentity").size(); ++i) {
                this.getModel().setValue("updaco", (Object)"1", i);
            }
            if (CollectionUtils.isEmpty((Collection)this.getModel().getEntryEntity("entryentity"))) {
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u6bd4\u5bf9\u660e\u7ec6\u201d\u4e0d\u80fd\u4e3a\u7a7a", (String)"CompareDraftFormPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]));
            }
            if ((org = (DynamicObject)this.getModel().getValue("org")) != null && !TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).isSuccess()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"CompareDraftFormPlugin_1", (String)"taxc-tcret", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    private void doTaxOrgChanged(PropertyChangedArgs e) {
        this.doSetAccrualItem();
        this.showBill();
    }

    protected String getEntityName() {
        return this.getView().getEntityId();
    }

    protected String getCompareDraftType() {
        return (String)this.getModel().getValue("drafttype");
    }

    protected Boolean checkPeriod(String frequency) {
        Date startDate = (Date)this.getModel().getValue("skssqq");
        Date endDate = (Date)this.getModel().getValue("skssqz");
        return DateUtils.validDateRange((String)frequency, (Date)startDate, (Date)endDate);
    }

    private void setBtnStatus(DynamicObject dynamicObject, String draftType) {
        if (dynamicObject != null) {
            String billstatus = dynamicObject.getString("billstatus");
            if ("A".equals(billstatus)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"newjtd"});
            } else if ("B".equals(billstatus)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"newjtd"});
            } else if ("C".equals(billstatus)) {
                if (dynamicObject.getString("generatebusinessdoc").equals("false")) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"newjtd"});
                    this.getView().setEnable(Boolean.TRUE, new String[]{"newjtd", "bar_unaudit"});
                    this.getView().setEnable(Boolean.FALSE, new String[]{"checkjtd", "deletejtd"});
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"newjtd"});
                    this.getView().setEnable(Boolean.TRUE, new String[]{"checkjtd", "deletejtd"});
                    this.getView().setEnable(Boolean.FALSE, new String[]{"newjtd"});
                }
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"newjtd"});
        }
    }
}

