/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.compare;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.listop.ExportList_expt;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.form.operate.ViewFlowchart;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcret.common.constant.TcretAccrualConstant;
import kd.taxc.tcret.common.enums.CompareListEnum;
import kd.taxc.tcret.common.utils.CompareUtils;
import org.apache.commons.lang3.ObjectUtils;

public class TcretCompareDraftListPlugin
extends AbstractListPlugin
implements TcretAccrualConstant {
    private static List<String> onlyOneSelectedRowOperations = Arrays.asList("checkjtd", "viewjt", "viewsbb", "viewjnd");

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        ListSelectedRowCollection selectedRows = args.getListSelectedData();
        if (args.getSource() instanceof Donothing && onlyOneSelectedRowOperations.contains(((Donothing)args.getSource()).getOperateKey()) && ObjectUtils.isNotEmpty((Object)selectedRows) && selectedRows.size() > 1) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e", (String)"TcretCompareDraftListPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]));
            return;
        }
        if (args.getSource() instanceof ExportList_expt || args.getSource() instanceof ViewFlowchart) {
            BillList billlistap = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows1 = billlistap.getSelectedRows();
            if (selectedRows1.size() != 1) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e", (String)"TcretCompareDraftListPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]));
                return;
            }
            Object primaryKeyValue = selectedRows1.get(0).getPrimaryKeyValue();
            DynamicObject object = QueryServiceHelper.queryOne((String)"tcret_compare_list", (String)"drafttype", (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKeyValue)});
            if (object != null) {
                ((AbstractOperate)args.getSource()).setEntityId(CompareListEnum.getEntityNameByDraftType(object.getString("drafttype")));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        BillList billlist = (BillList)this.getControl("billlistap");
        String operateKey = evt.getOperateKey();
        if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"newjtd") || StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"deletejtd")) {
            billlist.refresh();
        } else if (EmptyCheckUtils.isNotEmpty((Object)CompareListEnum.getEntityNameByDraftType(operateKey))) {
            String entityName = CompareListEnum.getEntityNameByDraftType(operateKey);
            PageShowCommon.showBill((ShowType)ShowType.MainNewTabPage, (String)entityName, null, (IFormView)this.getView(), null, (OperationStatus)OperationStatus.ADDNEW);
        } else if ("checkjtd".equals(operateKey)) {
            this.invokeCompareUtils(evt, "openProvistonBillPage");
        } else if ("viewjt".equals(operateKey)) {
            this.invokeCompareUtils(evt, "openAccrualListPage");
        } else if ("viewsbb".equals(operateKey)) {
            this.invokeCompareUtils(evt, "openTcretDeclareListPage");
        } else if ("viewjnd".equals(operateKey)) {
            this.invokeCompareUtils(evt, "openPayRecordListPage");
        }
    }

    private void invokeCompareUtils(AfterDoOperationEventArgs evt, String methodName) {
        String entityId = ((Donothing)evt.getSource()).getEntityId();
        List ids = evt.getOperationResult().getSuccessPkIds();
        if (ObjectUtils.isNotEmpty((Object)ids)) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle(ids.get(0), (String)entityId);
            Method method = ReflectionUtils.findMethod(CompareUtils.class, (String)methodName, (Class[])new Class[]{IFormView.class, DynamicObject.class});
            try {
                method.invoke(null, this.getView(), dynamicObject);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        DynamicObject current = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRowInfo.getPrimaryKeyValue(), (String)"tcret_compare_list");
        String accrualDraftType = current.getString("drafttype");
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("drafttype", accrualDraftType);
        String formId = CompareListEnum.getEntityNameByDraftType(accrualDraftType);
        PageShowCommon.showBill((ShowType)ShowType.MainNewTabPage, (String)formId, (Object)current.get("id"), (IFormView)this.getView(), customParams, (OperationStatus)OperationStatus.EDIT);
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        if ("skssqq".equals(columnDesc.getKey())) {
            String skssqq = DateUtils.format((Date)data.getDate("skssqq"), (String)DateUtils.YYYYMMDD_CHINESE);
            String skssqz = DateUtils.format((Date)data.getDate("skssqz"), (String)DateUtils.YYYYMMDD_CHINESE);
            e.setFormatValue((Object)(skssqq + "-" + skssqz));
        }
    }

    public void setFilter(SetFilterEvent e) {
        e.getQFilters().add(new QFilter("drafttype", "in", Arrays.asList("yhs_bd", "fcs_bd", "cztdsys_bd")));
    }
}

