/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.draft;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.taxc.bdtaxr.business.serviceImpl.mutex.MutexServiceImpl;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bos.orgrelation.OrgRelationDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.license.plugin.common.AbstractLicenseCheckFormPlugin;
import kd.taxc.bdtaxr.common.plugin.ProvisionDimension;
import kd.taxc.bdtaxr.common.taxdeclare.draft.org.OrgChangeRecordUtil;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.TaxBaseDataUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcret.business.declare.engine.impl.AbstractEngine;
import kd.taxc.tcret.business.declare.engine.impl.CcsEngineServiceImpl;
import kd.taxc.tcret.business.declare.provider.ServiceProvider;
import kd.taxc.tcret.business.draft.DraftCalculateServiceFactory;
import kd.taxc.tcret.business.draft.DraftServiceHelpler;
import kd.taxc.tcret.common.constant.TcretDraftConstant;
import kd.taxc.tcret.common.enums.CcsTypeEnum;
import kd.taxc.tcret.common.enums.FcsTypeEnum;
import kd.taxc.tcret.common.utils.TcretSystemParamUtil;

public abstract class AbstractDraftPlugin
extends AbstractLicenseCheckFormPlugin
implements TcretDraftConstant,
ProvisionDimension,
BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(AbstractDraftPlugin.class);
    private List<String> paramKeys = Arrays.asList("org", "accountorg", "taxoffice", "collectiondate", "isxxwlqy", "sourcetype");
    private static final Set<String> GTGSH = new LinkedHashSet<String>(Arrays.asList("410", "411", "412", "413"));
    private static final Map<String, Long> itemMap = new HashMap<String, Long>();

    public void afterCreateNewData(EventObject e) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        this.setTaxOrg();
        for (String paramKey : this.paramKeys) {
            if (params.get(paramKey) == null) continue;
            this.getModel().setValue(paramKey, params.get(paramKey));
        }
        DynamicObject taxOrg = (DynamicObject)this.getModel().getValue("org");
        if (taxOrg == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"FcsDraftPlugin_1", (String)"taxc-tcret", (Object[])new Object[0]));
            return;
        }
        if (this.checkTaxOrgEnable(taxOrg.getLong("id"))) {
            this.getModel().setValue("org", null);
            return;
        }
        if (this.checkPlan(this.getBaseTaxCategory(), taxOrg)) {
            return;
        }
        if (params.get("accountorg") == null) {
            this.setBaseField();
        }
        this.setXxwlqy();
        this.loadData();
    }

    private boolean checkTaxOrgEnable(long orgid) {
        return OrgCheckUtil.orgEnable((IFormView)this.getView(), (Long)orgid, (boolean)true);
    }

    private void setXxwlqy() {
        DynamicObject taxOrg = (DynamicObject)this.getModel().getValue("org");
        DynamicObject accountorg = (DynamicObject)this.getModel().getValue("accountorg");
        DynamicObject taxoffice = (DynamicObject)this.getModel().getValue("taxoffice");
        if (!"tcret_ccs_taxdraft".equals(this.getEntityName())) {
            DynamicObjectCollection items = this.getItems(taxOrg.getLong("id"), accountorg.getLong("id"), taxoffice.getLong("id"), (Date)this.getModel().getValue("collectiondate"));
            this.refreshXxwlqy((List<DynamicObject>)items);
        }
    }

    private void setTaxOrg() {
        Object selectOrgId = this.getView().getFormShowParameter().getCustomParams().get("SELECT_ORG_ID");
        if (Objects.nonNull(selectOrgId)) {
            this.getModel().setValue("org", selectOrgId);
        } else {
            long orgId = RequestContext.get().getOrgId();
            TaxResult taxcMainByOrgIdAndIsTaxpayer = TaxcMainDataServiceHelper.isTaxcMainByOrgIdAndIsTaxpayer((Long)orgId);
            if (taxcMainByOrgIdAndIsTaxpayer.isSuccess() && ((Boolean)taxcMainByOrgIdAndIsTaxpayer.getData()).booleanValue()) {
                this.getModel().setValue("org", (Object)orgId);
            }
        }
    }

    public void afterBindData(EventObject e) {
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"org"});
    }

    public void registerListener(EventObject e) {
        BasedataEdit taxorgEdit = (BasedataEdit)this.getView().getControl("org");
        BasedataEdit accountorgEdit = (BasedataEdit)this.getView().getControl("accountorg");
        taxorgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        accountorgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"recalc", "save"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if ("org".equals(name) && newValue != null) {
            if (this.checkTaxOrgEnable(((DynamicObject)newValue).getLong("id"))) {
                this.getModel().setValue("org", null);
                return;
            }
            if (this.checkPlan(this.getBaseTaxCategory(), (DynamicObject)newValue)) {
                return;
            }
            this.setBaseField();
            this.showBillForm();
        }
        if ("accountorg".equals(name) || "taxoffice".equals(name) || "collectiondate".equals(name) || "sourcetype".equals(name)) {
            this.showBillForm();
        }
        if ("isxxwlqy".equals(name)) {
            this.getView().invokeOperation("recalc");
        }
        super.propertyChanged(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Object org;
        String name = evt.getProperty().getName();
        if ("accountorg".equals(name)) {
            org = this.getModel().getValue("org");
            if (Objects.isNull(org)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"FcsDraftPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            long taxOrgId = ((DynamicObject)org).getLong("id");
            List ids = (List)OrgRelationDataServiceHelper.getAccountingOrgIdByTaxcOrgId((Long)taxOrgId).getData();
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            QFilter accountOrgFilter = new QFilter("id", "in", (Object)ids);
            evt.setCustomQFilters(Arrays.asList(enableFilter, accountOrgFilter));
        }
        if ("taxoffice".equals(name) && Objects.isNull(org = this.getModel().getValue("org"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"FcsDraftPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection entryentity;
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (("save".equals(operateKey) || "submit".equals(operateKey)) && (entryentity = this.getModel().getEntryEntity("entryentity")).size() <= 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8ba1\u7a0e\u5e95\u7a3f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FcsDraftPlugin_6", (String)"taxc-tcret", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String idstr;
        String operateKey = args.getOperateKey();
        if ("recalc".equals(operateKey) && args.getOperationResult().isSuccess()) {
            Date collectionDate;
            DynamicObject taxoffice;
            DynamicObject accountOrg;
            DynamicObject taxOrg = (DynamicObject)this.getModel().getValue("org");
            if (this.checkMustField(taxOrg, accountOrg = (DynamicObject)this.getModel().getValue("accountorg"), taxoffice = (DynamicObject)this.getModel().getValue("taxoffice"), collectionDate = (Date)this.getModel().getValue("collectiondate"))) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"accountorg"});
                return;
            }
            if (this.checkPlan(this.getBaseTaxCategory(), taxOrg)) {
                return;
            }
            DynamicObjectCollection entryentity = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
            entryentity.clear();
            this.calcDraftData(taxOrg, taxoffice.getLong("id"), collectionDate);
            this.getView().updateView();
        }
        if ("save".equals(operateKey) && args.getOperationResult().isSuccess() && StringUtil.isNotBlank((CharSequence)(idstr = this.getPageCache().get("sourceids")))) {
            Object id = this.getModel().getValue("id");
            List sourceDetailList = (List)SerializationUtils.deSerializeFromBase64((String)idstr);
            DynamicObjectCollection entryentity = (DynamicObjectCollection)this.getModel().getValue("entryentity");
            Map<Long, DynamicObject> sourcedetailidMap = entryentity.stream().collect(Collectors.toMap(k -> k.getLong("sourcedetailid"), v -> v, (k1, k2) -> k1));
            sourceDetailList.forEach(e -> {
                e.set("draftid", id);
                DynamicObject object = (DynamicObject)sourcedetailidMap.get(e.getLong("id"));
                if (object != null) {
                    e.set("ybtse", (Object)object.getBigDecimal("ybtse"));
                    e.set("paidtaxes", (Object)object.getBigDecimal("paidtaxes"));
                }
            });
            SaveServiceHelper.save((DynamicObject[])sourceDetailList.toArray(new DynamicObject[0]));
        }
    }

    private void showBillForm() {
        Date collectionDate;
        DynamicObject taxoffice;
        DynamicObject accountOrg;
        DynamicObject taxOrg = (DynamicObject)this.getModel().getValue("org");
        if (this.checkMustField(taxOrg, accountOrg = (DynamicObject)this.getModel().getValue("accountorg"), taxoffice = (DynamicObject)this.getModel().getValue("taxoffice"), collectionDate = (Date)this.getModel().getValue("collectiondate"))) {
            return;
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        String sourceType = "";
        if ("tcret_ccs_taxdraft".equals(this.getEntityName())) {
            sourceType = this.getModel().getDataEntity().getString("sourcetype");
            customParams.put("sourcetype", sourceType);
        }
        Long orgId = taxOrg.getLong("id");
        Long accountOrgId = accountOrg.getLong("id");
        Long taxofficeId = taxoffice.getLong("id");
        DynamicObject draftObject = DraftServiceHelpler.queryDraft(this.getEntityName(), orgId, accountOrgId, taxofficeId, collectionDate, sourceType);
        customParams.put("org", orgId);
        customParams.put("accountorg", accountOrgId);
        customParams.put("taxoffice", taxofficeId);
        customParams.put("collectiondate", collectionDate);
        if (!"tcret_ccs_taxdraft".equals(this.getEntityName())) {
            customParams.put("isxxwlqy", this.getModel().getValue("isxxwlqy"));
        }
        if (draftObject != null) {
            Long pkId = draftObject.getLong("id");
            PageShowCommon.showBill((ShowType)ShowType.InCurrentForm, (String)this.getEntityName(), (Object)pkId, (IFormView)this.getView(), customParams, (OperationStatus)OperationStatus.EDIT);
        } else {
            this.releaseMutex();
            PageShowCommon.showBill((ShowType)ShowType.InCurrentForm, (String)this.getEntityName(), null, (IFormView)this.getView(), customParams, (OperationStatus)OperationStatus.ADDNEW);
        }
    }

    private boolean checkPlan(Long category, DynamicObject taxOrg) {
        Date collectionDate = (Date)this.getModel().getValue("collectiondate");
        if (!DraftServiceHelpler.check(this.getView(), taxOrg, category, collectionDate)) {
            this.getModel().beginInit();
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"accountorg"});
            this.getModel().setValue("accountorg", null);
            this.getModel().setValue("taxoffice", null);
            this.getModel().endInit();
            this.getView().updateView();
            return true;
        }
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"accountorg"});
        return false;
    }

    private void setBaseField() {
        DynamicObject taxOrg = (DynamicObject)this.getModel().getValue("org");
        long taxOrgId = taxOrg.getLong("id");
        Map orgRelationAccountToTax = OrgRelationDataServiceHelper.getOrgRelationTaxToAccount((Long)taxOrgId, (boolean)true);
        List orglist = (List)orgRelationAccountToTax.get("data");
        if (!CollectionUtils.isEmpty((Collection)orglist)) {
            Optional<HashMap> first = orglist.stream().filter(o -> (Boolean)o.get("isDefault")).findFirst();
            if (first.isPresent()) {
                HashMap orgObj = first.get();
                this.getModel().setValue("accountorg", orgObj.get("orgId"));
            } else {
                this.getModel().setValue("accountorg", ((HashMap)orglist.get(0)).get("orgId"));
            }
        } else {
            List list = OrgUnitServiceHelper.filterOrgDuty(Collections.singletonList(taxOrgId), (String)"10");
            if (ObjectUtils.isEmpty((Object)list)) {
                return;
            }
            this.getModel().setValue("accountorg", (Object)taxOrgId);
        }
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)taxOrgId);
        if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
            this.getModel().setValue("taxoffice", (Object)((DynamicObject)result.getData()).getLong("taxoffice.id"));
        }
        this.getModel().setDataChanged(false);
    }

    private void loadData() {
        Date collectionDate;
        DynamicObject taxoffice;
        DynamicObject accountOrg;
        DynamicObject taxOrg = (DynamicObject)this.getModel().getValue("org");
        if (this.checkMustField(taxOrg, accountOrg = (DynamicObject)this.getModel().getValue("accountorg"), taxoffice = (DynamicObject)this.getModel().getValue("taxoffice"), collectionDate = (Date)this.getModel().getValue("collectiondate"))) {
            this.getModel().deleteEntryData("entryentity");
            return;
        }
        String sourceType = "";
        if ("tcret_ccs_taxdraft".equals(this.getEntityName())) {
            sourceType = this.getModel().getDataEntity().getString("sourcetype");
        }
        Long orgId = taxOrg.getLong("id");
        Long accountOrgId = accountOrg.getLong("id");
        Long taxofficeId = taxoffice.getLong("id");
        DynamicObject draftObject = DraftServiceHelpler.queryDraft(this.getEntityName(), orgId, accountOrgId, taxofficeId, collectionDate, sourceType);
        if (draftObject != null) {
            Long pkId = draftObject.getLong("id");
            HashMap<String, Object> customParams = new HashMap<String, Object>(8);
            customParams.put("org", taxOrg);
            customParams.put("accountorg", accountOrg);
            customParams.put("taxoffice", taxoffice);
            customParams.put("collectiondate", collectionDate);
            if (!"tcret_ccs_taxdraft".equals(this.getEntityName())) {
                customParams.put("isxxwlqy", this.getModel().getValue("isxxwlqy"));
            }
            PageShowCommon.showBill((ShowType)ShowType.InCurrentForm, (String)this.getEntityName(), (Object)pkId, (IFormView)this.getView(), customParams, (OperationStatus)OperationStatus.EDIT);
        } else {
            this.calcDraftData(taxOrg, taxofficeId, collectionDate);
        }
    }

    private boolean checkMustField(DynamicObject taxOrg, DynamicObject accountOrg, DynamicObject taxoffice, Date collectionDate) {
        if (taxOrg == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"FcsDraftPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]));
            return true;
        }
        if (accountOrg == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FcsDraftPlugin_3", (String)"taxc-tcret", (Object[])new Object[0]));
            return true;
        }
        if (taxoffice == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7a0e\u52a1\u673a\u5173\u3002", (String)"FcsDraftPlugin_4", (String)"taxc-tcret", (Object[])new Object[0]));
            return true;
        }
        if (collectionDate == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u91c7\u96c6\u65f6\u95f4\u3002", (String)"FcsDraftPlugin_5", (String)"taxc-tcret", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void calcDraftData(DynamicObject taxOrg, Long taxofficeId, Date collectionDate) {
        DynamicObject draftObj = this.getModel().getDataEntity(true);
        DynamicObjectCollection detailList = draftObj.getDynamicObjectCollection("entryentity");
        detailList.clear();
        long start = System.currentTimeMillis();
        this.calcDraftDetails(draftObj, taxOrg, taxofficeId, collectionDate);
        long end = System.currentTimeMillis();
        logger.info("\u8ba1\u7b97\u8ba1\u63d0\u5e95\u7a3f\u660e\u7ec6\u6210\u529f\uff0c\u8017\u65f6\uff1a" + (end - start));
    }

    public void calcDraftDetails(DynamicObject draftObj, DynamicObject taxorg, Long taxofficeId, Date collectionDate) {
    }

    void calcDraftDetails(DynamicObject draftObj, DynamicObject taxorg, Long taxofficeId, Date collectionDate, String taxtype, String selectField) {
        long orgid = taxorg.getLong("id");
        DynamicObject accountOrg = (DynamicObject)this.getModel().getValue("accountorg");
        DynamicObjectCollection items = this.getItems(orgid, accountOrg.getLong("id"), taxofficeId, collectionDate);
        List<DynamicObject> enableItems = this.filterEnableData(taxtype, items);
        if (CollectionUtils.isEmpty(enableItems)) {
            return;
        }
        String isxxwlqy = "";
        if (!taxtype.startsWith("ccs")) {
            isxxwlqy = (String)this.getModel().getValue("isxxwlqy");
        }
        Long accountOrgId = draftObj.getDynamicObject("accountorg").getLong("id");
        List<DynamicObject> sourceDetailList = DraftServiceHelpler.getDataByRunEngine(enableItems, this.getEntityName(), orgid, taxofficeId, collectionDate, isxxwlqy, accountOrgId);
        this.getPageCache().put("sourceids", SerializationUtils.serializeToBase64(sourceDetailList));
        DynamicObjectCollection detailList = draftObj.getDynamicObjectCollection("entryentity");
        this.setValue(detailList, sourceDetailList, selectField);
    }

    private List<DynamicObject> filterEnableData(String taxtype, DynamicObjectCollection items) {
        String planstartdate = this.getPageCache().get("planstartdate");
        String planenddate = this.getPageCache().get("planenddate");
        ArrayList<DynamicObject> priceItems = new ArrayList<DynamicObject>(8);
        if (StringUtil.isBlank((CharSequence)planstartdate)) {
            return priceItems;
        }
        for (DynamicObject item : items) {
            Date enddate;
            Date skssqq = item.getDate("skssqq");
            Date skssqz = item.getDate("skssqz");
            Date startdate = DateUtils.stringToDate2((String)planstartdate);
            if (skssqq.compareTo(startdate) < 0 || StringUtil.isNotBlank((CharSequence)planenddate) && (skssqq.compareTo(enddate = DateUtils.stringToDate2((String)planenddate)) > 0 || skssqz.compareTo(enddate) > 0) || !taxtype.equals(item.getString("taxtype"))) continue;
            priceItems.add(item);
        }
        return priceItems;
    }

    protected void setValue(DynamicObjectCollection detailList, List<DynamicObject> sourceDetailList, String selectField) {
        Map<String, List<DynamicObject>> isxgm = sourceDetailList.stream().filter(e -> e.getBoolean("isxgm")).collect(Collectors.groupingBy(e -> e.getString("org") + e.getString("number") + DateUtils.format((Date)e.getDate("skssqq")) + DateUtils.format((Date)e.getDate("skssqz"))));
        DynamicObject currency = DraftServiceHelpler.getCurrency();
        for (DynamicObject dynamicObject : sourceDetailList) {
            if (dynamicObject.getBoolean("isxgm")) continue;
            DynamicObject detail = detailList.addNew();
            List<DynamicObject> dynamicObjectList = isxgm.get(dynamicObject.getString("org") + dynamicObject.getString("number") + DateUtils.format((Date)dynamicObject.getDate("skssqq")) + DateUtils.format((Date)dynamicObject.getDate("skssqz")));
            if (!CollectionUtils.isEmpty(dynamicObjectList)) {
                BigDecimal sumCurrentjmamount = dynamicObjectList.stream().map(d -> d.getBigDecimal("currentjmamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                dynamicObject.set("currentjmamount", (Object)dynamicObject.getBigDecimal("currentjmamount").add(sumCurrentjmamount));
                detail.set("xgmsourcedetailid", (Object)dynamicObjectList.get(0).getLong("id"));
            }
            for (String field : selectField.split(",")) {
                detail.set(field, dynamicObject.get(field));
            }
            detail.set("sourcedetailid", (Object)dynamicObject.getLong("id"));
            detail.set("currency", (Object)currency);
            detail.set("paidtaxes", (Object)BigDecimal.ZERO);
            detail.set("ybtse", (Object)detail.getBigDecimal("currentpayable").subtract(detail.getBigDecimal("currentjmamount")));
        }
    }

    private DynamicObjectCollection getItems(Long orgid, Long accountOrgId, Long taxofficeId, Date collectionDate) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("orgid", String.valueOf(orgid));
        customParams.put("accountorgid", accountOrgId);
        customParams.put("taxoffice", String.valueOf(taxofficeId));
        customParams.put("declaremonth", DateUtils.format((Date)collectionDate));
        ServiceProvider serviceProvider = DraftCalculateServiceFactory.getProviderServiceMap(this.getEntityName());
        return serviceProvider.createDeclareItemListService().queryList(customParams);
    }

    private List<DynamicObject> getDataByRunEngine(List<DynamicObject> items, Long orgid, Long taxofficeId, Date collectionDate, String taxtype) {
        AbstractEngine abstractEngine = DraftCalculateServiceFactory.getService(this.getEntityName());
        CcsEngineServiceImpl ccsEngineServiceImpl = new CcsEngineServiceImpl();
        ArrayList<DynamicObject> detailList = new ArrayList<DynamicObject>(8);
        DynamicObject taxorg = (DynamicObject)TaxcOrgDataServiceHelper.queryTaxcOrgByOrgId((Long)orgid).getData();
        Boolean changeEffectCurrentMonth = TcretSystemParamUtil.getChangeEffectCurrentMonth(orgid);
        for (DynamicObject item : items) {
            Date skssqq = item.getDate("skssqq");
            Date skssqz = item.getDate("skssqz");
            String itemTaxtype = item.getString("taxtype");
            String reliefPolicyType = TaxBaseDataUtils.getReliefPolicyType((Long)orgid, (Date)skssqq, (Date)skssqz, (boolean)true);
            EngineModel model = new EngineModel(taxorg.getString("id"), DateUtils.format((Date)skssqq), DateUtils.format((Date)skssqz));
            String taxlimit = item.getString("taxlimit");
            model.addCustom("taxlimit", (Object)taxlimit);
            model.addCustom("declaremonth", (Object)collectionDate);
            model.addCustom("taxoffice", (Object)String.valueOf(taxofficeId));
            model.addCustom("sbbid", (Object)0L);
            model.addCustom("changeeffectcurrentmonth", (Object)changeEffectCurrentMonth);
            DynamicObject[] sourceObjects = itemTaxtype.startsWith("ccs") ? ccsEngineServiceImpl.queryData(model, CcsTypeEnum.getByTaxType(itemTaxtype)) : abstractEngine.queryData(model, FcsTypeEnum.getByTaxType(taxtype));
            ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> originalList = new ArrayList<DynamicObject>();
            for (DynamicObject sourceObject : sourceObjects) {
                List<DynamicObject> dynamicObjectList;
                List<DynamicObject> list = dynamicObjectList = itemTaxtype.startsWith("ccs") ? Collections.singletonList(ccsEngineServiceImpl.initialObj(sourceObject, CcsTypeEnum.getByTaxType(itemTaxtype), model)) : abstractEngine.initialObj(taxorg, sourceObject, FcsTypeEnum.getByTaxType(taxtype), model);
                if (null == dynamicObjectList) continue;
                if (!taxtype.startsWith("ccs")) {
                    dynamicObjectList.forEach(d -> d.set("sourceid", (Object)sourceObject));
                }
                dynamicObjects.addAll(dynamicObjectList);
                originalList.addAll(dynamicObjectList);
            }
            if (!itemTaxtype.startsWith("ccs")) {
                if ("1".equals(this.getModel().getValue("isxxwlqy"))) {
                    model.addCustom("reliefPolicy", (Object)"xxwlqy");
                } else if (("0".equals(this.getModel().getValue("isxxwlqy")) || "".equals(this.getModel().getValue("isxxwlqy"))) && "xxwlqy".equals(reliefPolicyType)) {
                    model.addCustom("reliefPolicy", (Object)"");
                } else {
                    model.addCustom("reliefPolicy", (Object)reliefPolicyType);
                }
                abstractEngine.addXgm(model, dynamicObjects, FcsTypeEnum.getByTaxType(taxtype), itemMap);
                Map<String, List<DynamicObject>> isxgm = dynamicObjects.stream().filter(e -> e.getBoolean("isxgm")).collect(Collectors.groupingBy(e -> e.getString("org") + e.getString("number") + DateUtils.format((Date)e.getDate("skssqq")) + DateUtils.format((Date)e.getDate("skssqz"))));
                for (DynamicObject object : originalList) {
                    List<DynamicObject> dynamicObjectList = isxgm.get(object.getString("org") + object.getString("number") + DateUtils.format((Date)object.getDate("skssqq")) + DateUtils.format((Date)object.getDate("skssqz")));
                    if (CollectionUtils.isEmpty(dynamicObjectList)) continue;
                    BigDecimal sumCurrentjmamount = dynamicObjectList.stream().map(d -> d.getBigDecimal("currentjmamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    object.set("currentjmamount", (Object)object.getBigDecimal("currentjmamount").add(sumCurrentjmamount));
                }
            }
            detailList.addAll(originalList);
        }
        return detailList;
    }

    private void releaseMutex() {
        MutexServiceImpl.releaseMutexLocks((String)String.valueOf(this.getModel().getValue("id")), (String)"modify", (Long)RequestContext.get().getCurrUserId());
    }

    protected String getEntityName() {
        return this.getView().getEntityId();
    }

    private void refreshXxwlqy(List<DynamicObject> declareQueryCollection) {
        if (declareQueryCollection.size() > 0) {
            int registerYear;
            DynamicObject taxOrg = (DynamicObject)this.getModel().getValue("org");
            String orgId = taxOrg.getString("id");
            DynamicObject taxMainInfo = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.valueOf(orgId)).getData();
            if (null == taxMainInfo) {
                this.getModel().setValue("isxxwlqy", (Object)"0");
                this.getView().setEnable(Boolean.FALSE, new String[]{"isxxwlqy"});
                return;
            }
            int year = DateUtils.getYearOfDate((Date)((Date)this.getModel().getValue("collectiondate")));
            if (year <= (registerYear = DateUtils.getYearOfDate((Date)taxMainInfo.getDate("registertime")))) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"isxxwlqy"});
                String result = TaxBaseDataUtils.checkXxwlqyByTaxMainInfo((DynamicObject)taxMainInfo);
                if ("1".equals(result)) {
                    this.getModel().setValue("isxxwlqy", (Object)"1");
                } else {
                    this.getModel().setValue("isxxwlqy", (Object)"0");
                }
                return;
            }
            HashMap<String, Date> xxwlqyDate = DraftServiceHelpler.getXxwlqyDate(declareQueryCollection, taxMainInfo, (DynamicObject)this.getModel().getValue("org"));
            if (!xxwlqyDate.isEmpty()) {
                Date skssqq = xxwlqyDate.get("skssqq");
                Date skssqz = xxwlqyDate.get("skssqz");
                this.getView().setEnable(Boolean.TRUE, new String[]{"isxxwlqy"});
                DynamicObject dynamicObject = OrgChangeRecordUtil.loadChangeRecord((String)orgId, (Date)skssqq, (Date)skssqz);
                String xxwlqy = TaxBaseDataUtils.queryQysdsXxwlqy((Long)Long.valueOf(orgId), (Date)skssqq, (Date)skssqz, (DynamicObject)dynamicObject, (DynamicObject)taxMainInfo);
                if ("1".equals(xxwlqy)) {
                    this.getModel().setValue("isxxwlqy", (Object)"1");
                } else if ("0".equals(xxwlqy)) {
                    this.getModel().setValue("isxxwlqy", (Object)"0");
                } else {
                    this.getModel().setValue("isxxwlqy", null);
                }
            } else {
                this.getModel().setValue("isxxwlqy", (Object)"0");
                this.getView().setEnable(Boolean.FALSE, new String[]{"isxxwlqy"});
            }
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"isxxwlqy"});
        }
    }

    private HashMap<String, Date> getXxwlqyDate(List<DynamicObject> declareQueryCollection, DynamicObject taxMainInfo) {
        Date start = declareQueryCollection.get(0).getDate("skssqq");
        Date end = declareQueryCollection.get(0).getDate("skssqz");
        for (DynamicObject dynamicObject : declareQueryCollection) {
            if (dynamicObject.getDate("skssqq").before(start)) {
                start = dynamicObject.getDate("skssqq");
            }
            if (!dynamicObject.getDate("skssqz").after(end)) continue;
            end = dynamicObject.getDate("skssqz");
        }
        DynamicObject taxOrg = (DynamicObject)this.getModel().getValue("org");
        String orgId = taxOrg.getString("id");
        DynamicObject dynamicObject = OrgChangeRecordUtil.loadChangeRecord((String)orgId, (Date)start, (Date)end);
        if (dynamicObject != null) {
            String registertype;
            String taxpayertype = dynamicObject.getString("taxpayertype");
            if (taxMainInfo == null) {
                taxMainInfo = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.valueOf(orgId)).getData();
            }
            String string = registertype = taxMainInfo != null ? taxMainInfo.getString("registertype.number") : "";
            if ("ybnsr".equals(taxpayertype) && !GTGSH.contains(registertype)) {
                HashMap<String, Date> map = new HashMap<String, Date>();
                map.put("skssqq", start);
                map.put("skssqz", end);
                return map;
            }
        }
        return new HashMap<String, Date>();
    }

    static {
        itemMap.put("xgmnsr", 789806550519688192L);
        itemMap.put("gtgsh", 1381170168142543875L);
        itemMap.put("xxwlqy", 1381170168142542852L);
    }
}

