/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.draft;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.tcret.formplugin.draft.AbstractDraftPlugin;

public class FcsDraftPlugin
extends AbstractDraftPlugin
implements HyperLinkClickListener {
    public Long getBaseTaxCategory() {
        return 7L;
    }

    @Override
    public void calcDraftDetails(DynamicObject draftObj, DynamicObject taxorg, Long taxofficeId, Date collectionDate) {
        super.calcDraftDetails(draftObj, taxorg, taxofficeId, collectionDate, "fcscj", "sourceid,skssqq,skssqz,assertvalue,rentalvalue,taxratio,taxbasis,taxrate,currentpayable,currentjmamount");
    }

    @Override
    public void registerListener(EventObject e) {
        EntryGrid reportlist = (EntryGrid)this.getView().getControl("entryentity");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
        super.registerListener(e);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        int rowIndex = evt.getRowIndex();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("id", this.getModel().getValue("sourcedetailid", rowIndex));
        param.put("sbbid", 0L);
        param.put("draft", "true");
        param.put("number", ((DynamicObject)this.getModel().getValue("sourceid", rowIndex)).getString("number"));
        param.put("assertvalue", this.getModel().getValue("assertvalue", rowIndex));
        param.put("currentjmamount", this.getModel().getValue("currentjmamount", rowIndex));
        param.put("xgmid", this.getModel().getValue("xgmsourcedetailid", rowIndex));
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if ("sourceid".equals(fieldName)) {
            PageShowCommon.showForm((OperationStatus)formShowParameter.getStatus(), (ShowType)ShowType.Modal, (String)"tcret_fcs_price_syinfo", (IFormView)this.getView(), param, (IFormPlugin)this);
        } else if ("assertvalue".equals(fieldName)) {
            PageShowCommon.showForm((OperationStatus)formShowParameter.getStatus(), (ShowType)ShowType.Modal, (String)"tcret_fcs_price_jsinfo", (IFormView)this.getView(), param, (IFormPlugin)this);
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        this.deleteSourceDetail();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("accountorg".equals(name) || "taxoffice".equals(name) || "collectiondate".equals(name) || "org".equals(name) || "isxxwlqy".equals(name)) {
            this.deleteSourceDetail();
        }
        super.propertyChanged(e);
    }

    private void deleteSourceDetail() {
        Long id = (Long)this.getModel().getValue("id");
        if (id == null || id.equals(0L)) {
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            List sourcedetailid = entryentity.stream().map(e -> e.getLong("sourcedetailid")).collect(Collectors.toList());
            List xgmsourcedetailid = entryentity.stream().map(e -> e.getLong("xgmsourcedetailid")).collect(Collectors.toList());
            sourcedetailid.addAll(xgmsourcedetailid);
            DeleteServiceHelper.delete((String)"tcret_pbt_fcs_price_sum_tp", (QFilter[])new QFilter[]{new QFilter("id", "in", sourcedetailid)});
        }
    }
}

