/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.pbtdeclare;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.EntityMappingUtils;

public class AccountSelectFormPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static final String TABAP = "tabap";
    private static final Map<String, String> tabToPageMap = new HashMap<String, String>(8){
        {
            this.put("yhs", "tcret_pbt_taxdata_yhs");
            this.put("hbs", "tcret_pbt_hbs_list");
            this.put("fcscj", "tcret_pbt_fcs_price_list");
            this.put("fcscz", "tcret_pbt_fcs_hire_list");
            this.put("cztdsys", "tcret_pbt_tds_list");
            this.put("ccs", "tcret_pbt_ccs_list");
            this.put("qs", "tcret_pbt_qs_list");
            this.put("tdzzs", "tcret_pbt_tdzzs_list");
            this.put("zys", "tcret_pbt_zys_list");
        }
    };

    public void registerListener(EventObject e) {
        this.addTabSelectListener(this, TABAP);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"yhs", "hbs", "fcscj", "fcscz", "cztdsys", "ccs", "qs", "tdzzs", "zys"});
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Boolean visible = (Boolean)customParams.get("btn_visible");
        this.getView().setVisible(visible, new String[]{"operatepanel"});
        String entityid = customParams.getOrDefault("entityid", "");
        Long sbbid = Long.parseLong(String.valueOf(customParams.get("sbbid")));
        if ("bdtaxr_history_sbb".equals(entityid)) {
            sbbid = (Long)customParams.get("maindataid");
            customParams.put("sbbid", sbbid);
        }
        OperationStatus status = formShowParameter.getStatus();
        String entityName = EntityMappingUtils.getEntityName((OperationStatus)status, (String)"tcret_declare_main");
        DynamicObjectCollection taxstatusACollection = QueryServiceHelper.query((String)entityName, (String)"billstatus, entryentity.taxtype as taxtype, entryentity.taxlimit as taxlimit", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)sbbid)});
        List<String> taxtypelist = taxstatusACollection.stream().map(t -> {
            if (t.getString("taxtype").startsWith("yhs")) {
                return "yhs";
            }
            if (t.getString("taxtype").startsWith("hbs")) {
                return "hbs";
            }
            if (t.getString("taxtype").startsWith("ccs")) {
                return "ccs";
            }
            if (t.getString("taxtype").startsWith("qs")) {
                return "qs";
            }
            if (t.getString("taxtype").startsWith("tdzzs")) {
                return "tdzzs";
            }
            if (t.getString("taxtype").startsWith("zys")) {
                return "zys";
            }
            return t.getString("taxtype");
        }).collect(Collectors.toList());
        taxtypelist.forEach(t -> this.getView().setVisible(Boolean.TRUE, new String[]{t}));
        Tab tab = (Tab)this.getControl(TABAP);
        if (null != tab && taxtypelist.size() > 0) {
            tab.activeTab((String)taxtypelist.get(0));
            this.showFormInnerTabPage(status, tabToPageMap.get(taxtypelist.get(0)), (String)taxtypelist.get(0));
        }
    }

    private void showFormInnerTabPage(OperationStatus status, String pageName, String tbName) {
        this.getView().getParentView().getPageCache().put("tabname", tbName);
        String flag = "loadtb-" + tbName;
        String id = this.getPageCache().get(flag);
        if (id == null) {
            FormShowParameter parameter = new FormShowParameter();
            String pageId = parameter.getPageId();
            parameter.setFormId(pageName);
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey(tbName);
            FormShowParameter upStepParameter = this.getView().getFormShowParameter();
            Map customParams = upStepParameter.getCustomParams();
            String entityid = customParams.getOrDefault("entityid", "");
            if ("bdtaxr_history_sbb".equals(entityid)) {
                customParams.put("sbbid", customParams.get("maindataid"));
            }
            parameter.setCustomParams(customParams);
            parameter.setStatus(status);
            this.getView().showForm(parameter);
            this.getPageCache().put(flag, pageId);
        } else {
            this.getView().getView(id).invokeOperation("refresh");
            this.getView().sendFormAction(this.getView().getView(id));
        }
    }

    public void addTabSelectListener(TabSelectListener form, String ... tabName) {
        for (int i = 0; i < tabName.length; ++i) {
            Tab tab = (Tab)this.getControl(tabName[i]);
            if (tab == null) continue;
            tab.addTabSelectListener(form);
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        this.showFormInnerTabPage(status, tabToPageMap.get(evt.getTabKey()), evt.getTabKey());
    }
}

