/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.pbtdeclare;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.AfterBindDataListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.list.events.ListRowSelectAllEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcret.business.declare.DeclareItemServiceHelper;
import kd.taxc.tcret.common.utils.PbtDeclareUtil;
import org.apache.commons.collections.CollectionUtils;

public class DependingItemsPlugin
extends AbstractFormPlugin
implements SelectRowsEventListener,
CreateListDataProviderListener {
    public void preOpenForm(PreOpenFormEventArgs e) {
        Map customParams = e.getFormShowParameter().getCustomParams();
        String taxoffice = (String)customParams.get("taxoffice");
        if (null == taxoffice || "0".equals(taxoffice)) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u673a\u5173\u3002", (String)"DependingItemsPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void initialize() {
        BillList billlistap = (BillList)this.getControl("billlistap");
        billlistap.addSelectRowsListener((SelectRowsEventListener)this);
        billlistap.addCreateListDataProviderListener((CreateListDataProviderListener)this);
        billlistap.addAfterBindDataListener(this.selectBillListRows(billlistap));
        billlistap.addListRowSelectAllListeners(this.selectAllRows());
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String taxoffice = (String)customParams.get("taxoffice");
        String orgid = (String)customParams.get("orgid");
        String declaremonth = (String)customParams.get("declaremonth");
        String sbbid = (String)customParams.get("sbbid");
        JSONArray entryentity = (JSONArray)customParams.get("entryentity");
        DynamicObjectCollection declareQueryCollection = PbtDeclareUtil.queryAllRecord(OperationStatus.VIEW, orgid, declaremonth, taxoffice);
        DynamicObjectCollection resultCollection = DeclareItemServiceHelper.queryList(customParams);
        IDataModel model = this.getModel();
        model.beginInit();
        for (DynamicObject object : resultCollection) {
            boolean remove = false;
            for (DynamicObject t : declareQueryCollection) {
                if (!object.getString("taxtype").equals(t.getString("taxtype")) || !DateUtils.format((Date)object.getDate("skssqq")).equals(DateUtils.format((Date)t.getDate("skssqq"))) || !DateUtils.format((Date)object.getDate("skssqz")).equals(DateUtils.format((Date)t.getDate("skssqz"))) || t.getString("sbbid").equals(sbbid) && "A".equals(t.getString("billstatus"))) continue;
                remove = true;
                break;
            }
            if (remove) continue;
            int row = model.createNewEntryRow("entryentity");
            model.setValue("taxtype", (Object)object.getString("taxtype"), row);
            model.setValue("skssqq", (Object)object.getDate("skssqq"), row);
            model.setValue("skssqz", (Object)object.getDate("skssqz"), row);
            model.setValue("status", (Object)object.getString("taxstatus"), row);
            model.setValue("taxlimit", (Object)object.getString("taxlimit"), row);
            if (null == entryentity) continue;
            model.setValue("checkbox", this.setCheckBox(entryentity, object), row);
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private Object setCheckBox(JSONArray entryentity, DynamicObject object) {
        for (int i = 0; i < entryentity.size(); ++i) {
            JSONObject jsonObject = entryentity.getJSONObject(i);
            String skssqq = DateUtils.format((Date)DateUtils.stringToDate((String)jsonObject.getString("skssqq")));
            String skssqz = DateUtils.format((Date)DateUtils.stringToDate((String)jsonObject.getString("skssqz")));
            if (!jsonObject.getString("taxtype").equals(object.getString("taxtype")) || !skssqq.equals(DateUtils.format((Date)object.getDate("skssqq"))) || !skssqz.equals(DateUtils.format((Date)object.getDate("skssqz")))) continue;
            return "1";
        }
        return "0";
    }

    public void click(EventObject evt) {
        if ("btnok".equals(((Button)evt.getSource()).getKey())) {
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            if (CollectionUtils.isEmpty((Collection)entryentity)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5f85\u7533\u62a5\u9879\u76ee\u53ef\u9009\u62e9\u3002", (String)"DependingItemsPlugin_1", (String)"taxc-tcret", (Object[])new Object[0]));
                return;
            }
            entryentity.removeIf(dynamicObject -> !dynamicObject.getBoolean("checkbox"));
            if (CollectionUtils.isEmpty((Collection)entryentity)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f85\u7533\u62a5\u9879\u76ee\u3002", (String)"DependingItemsPlugin_2", (String)"taxc-tcret", (Object[])new Object[0]));
                return;
            }
            this.getView().returnDataToParent((Object)entryentity);
            this.getView().close();
        }
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        List newRows = evt.getNewRows();
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        this.getModel().beginInit();
        for (int row = 0; row < rowCount; ++row) {
            this.getModel().setValue("checkbox", (Object)(newRows.contains(row) ? "1" : "0"), row);
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                return DependingItemsPlugin.this.getModel().getEntryEntity("entryentity");
            }
        });
    }

    private Consumer<ListRowSelectAllEvent> selectAllRows() {
        return listRowSelectAllEvent -> {
            BillList billlist = (BillList)listRowSelectAllEvent.getSource();
            IDataModel model = billlist.getModel();
            int rowCount = model.getEntryRowCount("entryentity");
            for (int i = 0; i < rowCount; ++i) {
                model.setValue("checkbox", (Object)"1");
            }
        };
    }

    private AfterBindDataListener selectBillListRows(BillList billlistap) {
        return afterBindDataEvent -> {
            ArrayList<Integer> rows = new ArrayList<Integer>();
            DynamicObjectCollection collection = this.getModel().getEntryEntity("entryentity");
            int row = 0;
            for (DynamicObject object : collection) {
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                JSONArray entryentity = (JSONArray)customParams.get("entryentity");
                Object isChecked = this.setCheckBox(entryentity, object);
                if ("1".equals(isChecked)) {
                    rows.add(row);
                }
                ++row;
            }
            int[] integers = new int[rows.size()];
            int i = 0;
            for (Integer r : rows) {
                integers[i++] = r;
            }
            billlistap.selectRows(integers);
        };
    }
}

