/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.pbtdeclare;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.serviceImpl.mutex.MutexServiceImpl;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.formula.biz.FormulaService;
import kd.taxc.bdtaxr.common.helper.SourceOperateHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.mq.datasynchronize.DataSynchronizeMQSender;
import kd.taxc.bdtaxr.common.mq.datasynchronize.SynchronizeParam;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.taxdeclare.DeclarePageType;
import kd.taxc.bdtaxr.common.taxdeclare.TaxStepsConstant;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.EntityMappingUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcret.business.declare.DeclareItemServiceHelper;
import kd.taxc.tcret.business.declare.TcretDeclareMainHelper;
import kd.taxc.tcret.business.draft.DraftDateService;
import kd.taxc.tcret.business.draft.DraftWriteBackService;
import kd.taxc.tcret.common.utils.PbtDeclareUtil;

public class PbtDeclareHomePlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(PbtDeclareHomePlugin.class);
    protected static final String FOCUS_PAGE = "focuspage";
    private static final String STEP_1 = "step1";
    private static final String STEP_2 = "step2";
    private static final String STEP_3 = "step3";
    private static final String TOOL_BAR = "toolbarap";
    protected static String TOOL_BAR_DECLARE = "toolbarapdeclare";
    private static final String DECLARE_MONTH = "declaremonth";
    private static final String DECLARE_NUMBER = "declarenumber";
    private static final String CHANGE_TYPE_PROPERTY = "propertyChanged";
    private static final String CHANGE_TYPE_CLICK = "click";
    private static final String NEED_REFRESH = "need_refresh";
    private static final String ISXXWLQY = "isxxwlqy";
    private static final String DETAIL_DECLARE = "detaildeclare";
    private static final String BTN_YES = "Yes";
    protected static final String ORGID_KEY = "orgid";
    protected static final String TAXOFFICE = "taxoffice";
    private static final String PAGE_1 = "1";
    private static final String ID = "id";
    protected static final String RECALC_KEY = "recalc";
    protected static final String READ_ONLY = "readonly";
    protected static final String CONTENT_TAB = "tabcontent";
    protected static final String YWJSFA_ENBALE = "1";
    private Map<String, DeclarePageType> declarePageMap = new HashMap<String, DeclarePageType>();
    private Map<String, List<String>> btnMap = new HashMap<String, List<String>>(){
        {
            this.put("1-VIEW", Arrays.asList("bar_edit", "bar_selectsbb", "bar_close"));
            this.put("1-EDIT", Arrays.asList("bar_reset", "bar_cancel", "bar_close"));
            this.put("2-VIEW", Arrays.asList("bar_edit", "bar_selectsbb", "bar_viewsource", "bar_submit", "bar_audit", "bar_unaudit", "bar_refresh", "bar_close"));
            this.put("2-EDIT", Arrays.asList("bar_save", "bar_reset", "bar_viewsource", "bar_cancel", "bar_close"));
        }
    };

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{STEP_1, STEP_2, STEP_3});
        this.addItemClickListeners(new String[]{TOOL_BAR, TOOL_BAR_DECLARE});
    }

    public void initialize() {
        this.declarePageMap = TaxStepsConstant.getPbt();
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get("sbbid") != null) {
            this.getPageCache().put("sbbid", String.valueOf(customParams.get("sbbid")));
            this.loadFromHyperLinkClick(customParams);
        } else {
            this.loadFromMenuClick(customParams);
        }
    }

    private void loadFromHyperLinkClick(Map<String, Object> customParams) {
        Object sbbid = customParams.get("sbbid");
        if (sbbid instanceof String) {
            sbbid = Long.parseLong(String.valueOf(sbbid));
        }
        DynamicObject nsrxx = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"org, billno,taxauthority, declaredate", (QFilter[])new QFilter[]{new QFilter(ID, "=", sbbid)});
        String billno = nsrxx.getString("billno");
        this.getModel().setValue(DECLARE_NUMBER, (Object)billno);
        this.getPageCache().put(DECLARE_NUMBER, billno);
        String orgid = nsrxx.getString("org");
        this.getModel().setValue(ORGID_KEY, (Object)orgid);
        this.getPageCache().put(ORGID_KEY, orgid);
        customParams.put(ORGID_KEY, orgid);
        boolean zeroDeclare = SystemParamUtil.getZeroDeclareParameter((String)"tcret", (String)"zerodeclare", (long)Long.parseLong(orgid));
        boolean hasLicense = false;
        if (zeroDeclare) {
            if (OrgCheckUtil.zeroDeclareCheck((IFormView)this.getView(), (String)orgid, (String)"tcret", null)) {
                PbtDeclareUtil.lightenForStatus(this.declarePageMap, "1", "0", this.getView(), this.getPageCache());
                PbtDeclareUtil.setBtnVisible(this.getView(), this.btnMap, "1", OperationStatus.VIEW);
                return;
            }
            hasLicense = LicenseCheckServiceHelper.check((Object)orgid, null, (String)"tcret");
        } else if (OrgCheckUtil.check((IFormView)this.getView(), (String)orgid, (String)"tcret", null)) {
            PbtDeclareUtil.lightenForStatus(this.declarePageMap, "1", "0", this.getView(), this.getPageCache());
            PbtDeclareUtil.setBtnVisible(this.getView(), this.btnMap, "1", OperationStatus.VIEW);
            return;
        }
        this.getPageCache().put("zerodeclare", zeroDeclare ? "true" : "false");
        this.getPageCache().put("haslicense", hasLicense ? "false" : "true");
        String taxOfficeId = nsrxx.getString("taxauthority");
        this.getModel().setValue(TAXOFFICE, (Object)taxOfficeId);
        this.getPageCache().put(TAXOFFICE, taxOfficeId);
        customParams.put(TAXOFFICE, taxOfficeId);
        Date declaremonth = nsrxx.getDate("declaredate");
        this.getModel().setValue(DECLARE_MONTH, (Object)declaremonth);
        this.getPageCache().put(DECLARE_MONTH, DateUtils.format((Date)declaremonth, (String)"yyyy-MM-dd"));
        customParams.put(DECLARE_MONTH, this.getPageCache().get(DECLARE_MONTH));
        this.showInnerTbPage("1", orgid);
    }

    private void loadFromMenuClick(Map<String, Object> customParams) {
        String orgid;
        String declaredate = (String)customParams.get(DECLARE_MONTH);
        if (declaredate != null) {
            PbtDeclareUtil.initDeclareMonth(DateUtils.stringToDate((String)declaredate), this.getModel(), this.getPageCache());
        } else {
            PbtDeclareUtil.initDeclareMonth(new Date(), this.getModel(), this.getPageCache());
            customParams.put(DECLARE_MONTH, this.getPageCache().get(DECLARE_MONTH));
        }
        String string = orgid = null != customParams.get(ORGID_KEY) ? String.valueOf(customParams.get(ORGID_KEY)) : PbtDeclareUtil.getOrgId(this.getView());
        if (null == orgid) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599\u8fdb\u884c\u914d\u7f6e\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PbtDeclareHomePlugin_14", (String)"taxc-tcret", (Object[])new Object[0]));
            return;
        }
        boolean zeroDeclare = SystemParamUtil.getZeroDeclareParameter((String)"tcret", (String)"zerodeclare", (long)Long.parseLong(orgid));
        boolean hasLicense = false;
        if (zeroDeclare) {
            if (OrgCheckUtil.zeroDeclareCheck((IFormView)this.getView(), (String)orgid, (String)"tcret", null)) {
                PbtDeclareUtil.lightenForStatus(this.declarePageMap, "1", "0", this.getView(), this.getPageCache());
                PbtDeclareUtil.setBtnVisible(this.getView(), this.btnMap, "1", OperationStatus.VIEW);
                return;
            }
            hasLicense = LicenseCheckServiceHelper.check((Object)orgid, null, (String)"tcret");
        } else if (OrgCheckUtil.check((IFormView)this.getView(), (String)orgid, (String)"tcret", null)) {
            PbtDeclareUtil.lightenForStatus(this.declarePageMap, "1", "0", this.getView(), this.getPageCache());
            PbtDeclareUtil.setBtnVisible(this.getView(), this.btnMap, "1", OperationStatus.VIEW);
            return;
        }
        this.getPageCache().put("zerodeclare", zeroDeclare ? "true" : "false");
        customParams.put("zerodeclare", zeroDeclare ? "true" : "false");
        this.getPageCache().put("haslicense", hasLicense ? "false" : "true");
        customParams.put("haslicense", hasLicense ? "false" : "true");
        this.getModel().setValue(ORGID_KEY, (Object)orgid);
        this.getPageCache().put(ORGID_KEY, orgid);
        customParams.put(ORGID_KEY, orgid);
        String taxOfficeId = customParams.get(TAXOFFICE) != null ? (String)customParams.get(TAXOFFICE) : PbtDeclareUtil.queryTaxOffice(orgid);
        this.getModel().setValue(TAXOFFICE, (Object)taxOfficeId);
        this.getPageCache().put(TAXOFFICE, taxOfficeId);
        customParams.put(TAXOFFICE, taxOfficeId);
        String declaremonth = this.getPageCache().get(DECLARE_MONTH);
        String taxoffice = this.getPageCache().get(TAXOFFICE);
        List<Long> sbbIds = TcretDeclareMainHelper.queryYhsSbbIds(orgid, taxoffice, declaremonth);
        String generatefrom = (String)customParams.get("generatefrom");
        if (EmptyCheckUtils.isNotEmpty((Object)generatefrom) && EmptyCheckUtils.isEmpty(sbbIds)) {
            DynamicObjectCollection resultCollection = DeclareItemServiceHelper.queryList(customParams);
            List<DynamicObject> yhsItems = resultCollection.stream().filter(d -> "yhsaq".equals(d.getString("taxtype")) || "yhsac".equals(d.getString("taxtype"))).collect(Collectors.toList());
            DynamicObject dynamicObject = PbtDeclareUtil.createTcretDeclareMain(declaremonth, taxoffice, yhsItems, this.getPageCache().get(ORGID_KEY), "1");
            String sbbid = dynamicObject.getString("sbbid");
            this.getPageCache().put("sbbid", sbbid);
            this.getPageCache().put("status", "1");
            this.getModel().setValue(DECLARE_NUMBER, (Object)dynamicObject.getString("billno"));
            this.getPageCache().put(DECLARE_NUMBER, dynamicObject.getString("billno"));
            this.getPageCache().put("OperationStatus", OperationStatus.EDIT.name());
            this.showInnerTbPage("1", this.getPageCache().get(ORGID_KEY));
        } else {
            this.showInnerTbPage("1", orgid);
            this.selectSbb(CHANGE_TYPE_CLICK);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if (null == changeData) {
            return;
        }
        Object newValue = changeData.getNewValue();
        this.getPageCache().put("status", "1");
        switch (name) {
            case "orgid": {
                DynamicObject newOrg = (DynamicObject)changeData.getNewValue();
                if (null == newOrg) {
                    this.getPageCache().put(ORGID_KEY, null);
                    return;
                }
                String neworgid = newOrg.getString(ID);
                String appid = this.getView().getFormShowParameter().getAppId();
                boolean zeroDeclare = SystemParamUtil.getZeroDeclareParameter((String)"tcret", (String)"zerodeclare", (long)Long.parseLong(neworgid));
                boolean hasLicense = false;
                if (zeroDeclare) {
                    if (OrgCheckUtil.zeroDeclareCheck((IFormView)this.getView(), (String)neworgid, (String)"tcret", null)) {
                        if (null == this.getPageCache().get(ORGID_KEY)) {
                            return;
                        }
                        this.getModel().setValue(ORGID_KEY, (Object)this.getPageCache().get(ORGID_KEY));
                        return;
                    }
                    if (!neworgid.equals(this.getPageCache().get(ORGID_KEY))) {
                        this.getPageCache().put("selectSbb", "true");
                    }
                    this.getPageCache().put(ORGID_KEY, neworgid);
                    hasLicense = LicenseCheckServiceHelper.check((Object)neworgid, null, (String)"tcret");
                } else {
                    if (OrgCheckUtil.check((IFormView)this.getView(), (String)neworgid, (String)appid, null)) {
                        if (null == this.getPageCache().get(ORGID_KEY)) {
                            return;
                        }
                        this.getModel().setValue(ORGID_KEY, (Object)this.getPageCache().get(ORGID_KEY));
                        return;
                    }
                    if (!neworgid.equals(this.getPageCache().get(ORGID_KEY))) {
                        this.getPageCache().put("selectSbb", "true");
                    }
                    this.getPageCache().put(ORGID_KEY, neworgid);
                }
                this.getPageCache().put("zerodeclare", zeroDeclare ? "true" : "false");
                this.getPageCache().put("haslicense", hasLicense ? "false" : "true");
                String newTaxOffice = PbtDeclareUtil.queryTaxOffice(neworgid);
                String oldTaxOffice = this.getPageCache().get(TAXOFFICE);
                if (newTaxOffice.equals(oldTaxOffice) && this.getPageCache().get("selectSbb") != null) {
                    this.getPageCache().remove("selectSbb");
                    this.selectSbb(CHANGE_TYPE_PROPERTY);
                    break;
                }
                this.getModel().setValue(TAXOFFICE, (Object)newTaxOffice);
                break;
            }
            case "declaremonth": {
                if (null == newValue) {
                    PbtDeclareUtil.initDeclareMonth(new Date(), this.getModel(), this.getPageCache());
                    break;
                }
                if (DateUtils.format((Date)((Date)this.getModel().getValue(DECLARE_MONTH)), (String)"yyyy-MM-dd").compareTo("2021-06-01") < 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d22\u4ea7\u548c\u884c\u4e3a\u7a0e\u7eb3\u7a0e\u7533\u62a5\u4ece2021\u5e746\u67081\u65e5\u5f00\u59cb\u6267\u884c\u3002", (String)"PbtDeclareHomePlugin_13", (String)"taxc-tcret", (Object[])new Object[0]));
                    this.getModel().setValue(DECLARE_MONTH, (Object)this.getPageCache().get(DECLARE_MONTH));
                    break;
                }
                this.getPageCache().put(DECLARE_MONTH, DateUtils.format((Date)((Date)this.getModel().getValue(DECLARE_MONTH)), (String)"yyyy-MM-dd"));
                customParams.put(DECLARE_MONTH, this.getPageCache().get(DECLARE_MONTH));
                this.selectSbb(CHANGE_TYPE_PROPERTY);
                break;
            }
            case "taxoffice": {
                if (null == newValue) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u673a\u5173\u3002", (String)"PbtDeclareHomePlugin_9", (String)"taxc-tcret", (Object[])new Object[0]));
                    this.getPageCache().put(TAXOFFICE, null);
                    break;
                }
                DynamicObject taxoffice = (DynamicObject)this.getModel().getValue(TAXOFFICE);
                this.getPageCache().put(TAXOFFICE, taxoffice.getString(ID));
                customParams.put(TAXOFFICE, taxoffice.getString(ID));
                this.selectSbb(CHANGE_TYPE_PROPERTY);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        DynamicObject org;
        if (this.isInvalidInput()) {
            return;
        }
        String key = evt.getItemKey();
        if (!"bar_selectsbb".equals(key) && StringUtil.isBlank((CharSequence)this.getPageCache().get("sbbid"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7533\u62a5\u8868\u3002", (String)"PbtDeclareHomePlugin_15", (String)"taxc-tcret", (Object[])new Object[0]));
            return;
        }
        if ((Objects.equals("next", key) || Objects.equals("bar_save", key)) && (org = (DynamicObject)this.getModel().getValue(ORGID_KEY)) != null && !TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong(ID)).isSuccess()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"PbtDeclareHomePlugin_30", (String)"taxc-tcret", (Object[])new Object[0]));
            return;
        }
        switch (key) {
            case "next": 
            case "forward": {
                this.lastOrNextStep(key);
                break;
            }
            case "bar_refresh": {
                this.showInnerTbPage(this.getPageCache().get(FOCUS_PAGE), this.getPageCache().get(ORGID_KEY));
                break;
            }
            case "bar_reset": {
                this.recale();
                break;
            }
            case "bar_cancel": {
                boolean dataChanged;
                String focuspage = this.getPageCache().get(FOCUS_PAGE);
                IFormView childPage = this.getView().getView(this.getPageCache().get("declarepageid"));
                if ("1".equals(focuspage)) {
                    dataChanged = childPage.getModel().getDataChanged();
                } else {
                    IPageCache childPageCache = childPage.getPageCache();
                    Map updateMap = (Map)TreeUtils.getCache((IPageCache)childPageCache, (String)"updata_cellid", Map.class);
                    boolean bl = dataChanged = updateMap != null && updateMap.size() > 0;
                }
                if (dataChanged) {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("bar_cancel", (IFormPlugin)this);
                    HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
                    btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"PbtDeclareHomePlugin_16", (String)"taxc-tcret", (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u9000\u51fa\u7f16\u8f91", (String)"PbtDeclareHomePlugin_17", (String)"taxc-tcret", (Object[])new Object[0]));
                    MessageBoxOptions options = MessageBoxOptions.OKCancel;
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"PbtDeclareHomePlugin_18", (String)"taxc-tcret", (Object[])new Object[0]), "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
                    break;
                }
                this.getPageCache().put("OperationStatus", OperationStatus.VIEW.name());
                FormulaService.cancel((IPageCache)this.getPageCache());
                long sbbid = Long.parseLong(this.getPageCache().get("sbbid"));
                boolean exists = QueryServiceHelper.exists((String)"tcret_declare_main", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)sbbid)});
                this.showInnerTbPage(exists ? focuspage : "1", this.getPageCache().get(ORGID_KEY));
                break;
            }
            case "bar_selectsbb": {
                this.selectSbb(CHANGE_TYPE_CLICK);
                break;
            }
            case "bar_viewsource": {
                this.viewSource();
            }
        }
    }

    private void print() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        FormShowParameter showParameter = new FormShowParameter();
        params.put("templateId", TemplateUtils.getTemplateIdByType((String)"ccxws"));
        params.put("sbbid", this.getPageCache().get("sbbid"));
        showParameter.setFormId("bdtaxr_declare_print");
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParams(params);
        this.getView().showForm(showParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (this.isInvalidInput()) {
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key;
        switch (key = afterDoOperationEventArgs.getOperateKey()) {
            case "edit": {
                String operateName = ResManager.loadKDString((String)"\u7f16\u8f91", (String)"PbtDeclareHomePlugin_33", (String)"taxc-tcret", (Object[])new Object[0]);
                String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u7533\u62a5\u8868,\u7f16\u8f91\u6210\u529f", (String)"PbtDeclareHomePlugin_29", (String)"taxc-tcret", (Object[])new Object[0]), this.getModel().getValue(DECLARE_NUMBER));
                OperatorDialogUtils.operateDialog((String)"ccxws", (String)"tcret_pbt_declare_home", (String)operateName, (String)operateDescription);
                if (StringUtil.isBlank((CharSequence)this.getPageCache().get("sbbid"))) {
                    return;
                }
                SourceOperateHelper.saveSourceTemporaryEntity((String)"ccxws", (String)this.getPageCache().get("sbbid"));
                this.getPageCache().put("OperationStatus", OperationStatus.EDIT.name());
                this.showInnerTbPage(this.getPageCache().get(FOCUS_PAGE), this.getPageCache().get(ORGID_KEY));
                break;
            }
            case "save": {
                LocaleString saveMsg = new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u4e2d\uff0c\u8bf7\u7a0d\u7b49\uff083S\uff09", (String)"PbtDeclareHomePlugin_3", (String)"taxc-tcret", (Object[])new Object[0]));
                this.getView().showLoading(saveMsg, 3000);
                this.save();
                break;
            }
            case "submit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": {
                this.submit(key);
                break;
            }
            case "print": {
                this.print();
            }
        }
    }

    private void viewSource() {
        String taxlimit = this.getPageCache().get("taxlimit");
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put(ORGID_KEY, this.getPageCache().get(ORGID_KEY));
        customParams.put("taxauthority", this.getPageCache().get(TAXOFFICE));
        String statusStr = this.getPageCache().get("OperationStatus");
        OperationStatus operationStatus = statusStr == null ? OperationStatus.VIEW : OperationStatus.valueOf((String)statusStr);
        String sbbid = this.getPageCache().get("sbbid");
        customParams.put("sbbid", EmptyCheckUtils.isEmpty((Object)sbbid) ? 0L : Long.parseLong(sbbid));
        customParams.put("btn_visible", true);
        customParams.put("ywjsfa", this.getPageCache().get("ywjsfa"));
        customParams.put("draft", this.getPageCache().get("draft"));
        if ("single".equals(taxlimit)) {
            customParams.put(DECLARE_MONTH, this.getModel().getValue(DECLARE_MONTH));
        }
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960px");
        styleCss.setHeight("580px");
        PageShowCommon.showForm((OperationStatus)operationStatus, (ShowType)ShowType.Modal, (StyleCss)styleCss, (String)"tcret_pbt_taxdata_tab", (IFormView)this.getView(), customParams, (IFormPlugin)this);
    }

    private void selectSbb(String changetype) {
        if (this.isInvalidInput()) {
            return;
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        IPageCache pageCache = this.getPageCache();
        String declaremonth = pageCache.get(DECLARE_MONTH);
        String orgid = pageCache.get(ORGID_KEY);
        String taxoffice = pageCache.get(TAXOFFICE);
        List<Long> sbbids = TcretDeclareMainHelper.querySbbIds(orgid, taxoffice, declaremonth);
        customParams.put("sbbids", sbbids);
        customParams.put("changetype", changetype);
        PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tcret_pbt_selectsbb", (IFormView)this.getView(), customParams, (IFormPlugin)this);
    }

    public void click(EventObject evt) {
        String status;
        String key = ((Control)evt.getSource()).getKey();
        String orgId = this.getPageCache().get(ORGID_KEY);
        String string = status = null == this.getPageCache().get("status") ? "0" : this.getPageCache().get("status");
        if (this.isInvalidInput()) {
            return;
        }
        if (key.startsWith("step")) {
            String focuspage;
            String step = key.replace("step", "");
            if (step.equals(focuspage = this.getPageCache().get(FOCUS_PAGE))) {
                return;
            }
            if (Integer.parseInt(status) >= Integer.parseInt(step)) {
                this.showInnerTbPage(step, orgId);
            }
        }
    }

    private void lastOrNextStep(String step) {
        String newFocusPage;
        if (this.isInvalidInput()) {
            return;
        }
        String focusPage = this.getPageCache().get(FOCUS_PAGE);
        String orgId = this.getPageCache().get(ORGID_KEY);
        String taxOffice = this.getPageCache().get(TAXOFFICE);
        String sbbId = this.getPageCache().get("sbbid");
        String isxxwlqy = "";
        String declaremonth = this.getPageCache().get(DECLARE_MONTH);
        if ("next".equals(step)) {
            IDataModel model;
            if (focusPage.equals("1")) {
                model = this.getView().getView(this.getPageCache().get("declarepageid")).getModel();
                isxxwlqy = (String)model.getValue(ISXXWLQY);
                this.getPageCache().put(ISXXWLQY, isxxwlqy);
                this.getPageCache().put(DETAIL_DECLARE, (String)model.getValue(DETAIL_DECLARE));
                if (!PbtDeclareUtil.verifyRegistertime(orgId, declaremonth)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u786e\u8ba4\u7533\u62a5\u7684\u6240\u5c5e\u7a0e\u671f\u4e0d\u5f97\u65e9\u4e8e\u4f01\u4e1a\u767b\u8bb0\u65f6\u95f4\u3002", (String)"PbtDeclareHomePlugin_24", (String)"taxc-tcret", (Object[])new Object[0]));
                    return;
                }
            }
            newFocusPage = String.valueOf(Integer.parseInt(focusPage) + 1);
            model = this.getView().getView(this.getPageCache().get("declarepageid")).getModel();
            DynamicObjectCollection declareItemCollection = model.getEntryEntity("entryentity");
            if (0 == declareItemCollection.size()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672c\u671f\u65e0\u7533\u62a5\u4e8b\u9879\u3002", (String)"PbtDeclareHomePlugin_0", (String)"taxc-tcret", (Object[])new Object[0]));
                return;
            }
            List<String> taxTypeList = DraftDateService.getTaxTypesByDeclareItemCollection(declareItemCollection);
            List<String> draftTaxTypeList = DraftDateService.getDraftTaxTypes(taxTypeList);
            this.getPageCache().put("draftTaxTypeList", SerializationUtils.toJsonString(draftTaxTypeList));
            List<String> noYwjsfaList = DraftDateService.getNoYwjsfaList(Long.parseLong(orgId), (List<DynamicObject>)declareItemCollection);
            String status = this.getPageCache().get("OperationStatus");
            if (StringUtil.isBlank((CharSequence)status)) {
                status = OperationStatus.VIEW.name();
            }
            String ywjsfa = "";
            if (!CollectionUtils.isEmpty(noYwjsfaList) && noYwjsfaList.size() != taxTypeList.size() && OperationStatus.EDIT.name().equals(status)) {
                this.showErrorMsg(noYwjsfaList, declareItemCollection);
                return;
            }
            if (CollectionUtils.isEmpty(noYwjsfaList) && OperationStatus.EDIT.name().equals(status)) {
                BaseResult baseResult = DraftDateService.checkDraftSourceInfo(Long.parseLong(orgId), isxxwlqy, DateUtils.stringToDate2((String)declaremonth), Long.parseLong(taxOffice), (List<DynamicObject>)declareItemCollection);
                if (!((Boolean)baseResult.getData()).booleanValue()) {
                    this.getView().showErrorNotification(baseResult.getMessage());
                    return;
                }
                ywjsfa = "1";
            }
            this.getPageCache().put("ywjsfa", ywjsfa);
            if (!this.checkBeforeNextStep(orgId, newFocusPage, declareItemCollection, isxxwlqy)) {
                return;
            }
            this.runEngine(focusPage, orgId);
        } else {
            newFocusPage = String.valueOf(Integer.parseInt(focusPage) - 1);
        }
        this.showInnerTbPage(newFocusPage, orgId);
    }

    private void showErrorMsg(List<String> noYwjsfaList, DynamicObjectCollection declareItemCollection) {
        ArrayList<String> noYwjsfaNameList = new ArrayList<String>(noYwjsfaList.size());
        if (!CollectionUtils.isEmpty(noYwjsfaList)) {
            for (String noYwjsfa : noYwjsfaList) {
                for (DynamicObject obj : declareItemCollection) {
                    if (!noYwjsfa.equals(obj.get("taxtype"))) continue;
                    noYwjsfaNameList.add(((ComboProp)obj.getDynamicObjectType().getProperty("taxtype")).getItemByName(noYwjsfa));
                }
            }
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u9009\u62e9\u7533\u62a5\u9879\u76ee%s\u5bf9\u5e94\u7684\u4e1a\u52a1\u8ba1\u7a0e\u65b9\u6848\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u7533\u62a5\u9879\u76ee\u3002", (String)"PbtDeclareHomePlugin_36", (String)"taxc-tcret", (Object[])new Object[0]), Joiner.on((String)"\u3001").join(noYwjsfaNameList)));
        }
    }

    private void setYwjsfaDraftCache(String ywjsfa, Map<String, DynamicObject[]> draftDynamicObjectMap) {
        this.getPageCache().put("ywjsfa", ywjsfa);
        if ("1".equals(ywjsfa)) {
            HashMap<String, String> draftMap = new HashMap<String, String>(16);
            for (Map.Entry<String, DynamicObject[]> entry : draftDynamicObjectMap.entrySet()) {
                DynamicObject[] values = entry.getValue();
                ArrayList<String> ids = new ArrayList<String>(16);
                if (values != null && values.length > 0) {
                    for (DynamicObject obj : values) {
                        ids.add(obj.getString(ID));
                    }
                }
                draftMap.put(entry.getKey(), Joiner.on((String)",").join(ids));
            }
            this.getPageCache().put("draft", SerializationUtils.toJsonString(draftMap));
        }
    }

    private void runEngine(String focusPage, String orgId) {
        String status = this.getPageCache().get("OperationStatus");
        OperationStatus operationStatus = OperationStatus.valueOf((String)(StringUtil.isNotBlank((CharSequence)status) ? status : "VIEW"));
        if (operationStatus == OperationStatus.EDIT) {
            Map<String, Object> customParams = this.createCustomParams(focusPage, orgId);
            customParams.put(DECLARE_NUMBER, this.getPageCache().get(DECLARE_NUMBER));
            String pageid = this.getPageCache().get("declarepageid");
            IDataModel model = this.getView().getView(pageid).getModel();
            String ywjsfa = this.getPageCache().get("ywjsfa");
            if ("1".equals(ywjsfa)) {
                Map<String, List<Long>> draftIdMap = PbtDeclareUtil.runDraftEngine((List<DynamicObject>)model.getEntryEntity("entryentity"), customParams);
                this.getPageCache().put("draft", SerializationUtils.toJsonString(draftIdMap));
            } else {
                PbtDeclareUtil.runEngine((List<DynamicObject>)model.getEntryEntity("entryentity"), customParams);
            }
        }
    }

    private boolean isInvalidInput() {
        String focusPage = this.getPageCache().get(FOCUS_PAGE);
        String orgId = this.getPageCache().get(ORGID_KEY);
        if (focusPage == null || orgId == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"PbtDeclareHomePlugin_4", (String)"taxc-tcret", (Object[])new Object[0]));
            return true;
        }
        String taxoffice = this.getPageCache().get(TAXOFFICE);
        if ("0".equals(taxoffice) || null == taxoffice) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u673a\u5173\u3002", (String)"PbtDeclareHomePlugin_9", (String)"taxc-tcret", (Object[])new Object[0]));
            return true;
        }
        String declareMonth = this.getPageCache().get(DECLARE_MONTH);
        if (null == declareMonth) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7533\u62a5\u65e5\u671f\u3002", (String)"PbtDeclareHomePlugin_10", (String)"taxc-tcret", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void recale() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(RECALC_KEY, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"PbtDeclareHomePlugin_5", (String)"taxc-tcret", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"PbtDeclareHomePlugin_6", (String)"taxc-tcret", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u91cd\u65b0\u8ba1\u7b97\u5c06\u5bfc\u81f4\u539f\u6709\u7eb3\u7a0e\u7533\u62a5\u6570\u636e\u88ab\u6e05\u7a7a\u4e14\u91cd\u65b0\u8ba1\u7b97\uff0c\u662f\u5426\u8981\u6267\u884c\u6b64\u64cd\u4f5c\uff1f", (String)"PbtDeclareHomePlugin_7", (String)"taxc-tcret", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        Long sbbid;
        EngineModel deleteModel;
        String orgId;
        String callBackId = e.getCallBackId();
        if ("bar_cancel".equals(callBackId) && e.getResult() == MessageBoxResult.Yes) {
            this.getPageCache().put("OperationStatus", OperationStatus.VIEW.name());
            FormulaService.cancel((IPageCache)this.getPageCache());
            orgId = this.getPageCache().get(ORGID_KEY);
            deleteModel = new EngineModel(orgId, null, null);
            sbbid = Long.parseLong(this.getPageCache().get("sbbid"));
            deleteModel.addCustom("sbbid", (Object)sbbid);
            deleteModel.addCustom("OperationStatus", (Object)OperationStatus.EDIT);
            SourceOperateHelper.deleteSourceTpEntity((String)"ccxws", (Long)sbbid);
            this.showInnerTbPage(this.getPageCache().get(FOCUS_PAGE), this.getPageCache().get(ORGID_KEY));
        }
        if (RECALC_KEY.equals(callBackId) && e.getResult() == MessageBoxResult.Yes) {
            orgId = this.getPageCache().get(ORGID_KEY);
            if (orgId == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"PbtDeclareHomePlugin_4", (String)"taxc-tcret", (Object[])new Object[0]));
                return;
            }
            deleteModel = new EngineModel(orgId, null, null);
            sbbid = Long.parseLong(this.getPageCache().get("sbbid"));
            deleteModel.addCustom("sbbid", (Object)sbbid);
            deleteModel.addCustom("OperationStatus", (Object)OperationStatus.EDIT);
            SourceOperateHelper.deleteSourceTpEntity((String)"ccxws", (Long)sbbid, (String)"tcret_declare_main_tp");
            DynamicObject tcretMain = QueryServiceHelper.queryOne((String)"tcret_declare_main_tp", (String)ID, (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)sbbid)});
            if (tcretMain != null) {
                DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)tcretMain.getLong(ID), (String)"tcret_declare_main_tp");
                object.set("status", (Object)"1");
                object.set("entryentity", null);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
            }
            this.getPageCache().put("OperationStatus", OperationStatus.EDIT.name());
            this.showInnerTbPage("1", orgId);
        }
        if (ISXXWLQY.equals(callBackId) && BTN_YES.equals(e.getResultValue())) {
            orgId = this.getPageCache().get(ORGID_KEY);
            String focusPage = this.getPageCache().get(FOCUS_PAGE);
            String newFocusPage = String.valueOf(Integer.parseInt(focusPage) + 1);
            this.runEngine(focusPage, orgId);
            this.showInnerTbPage(newFocusPage, orgId);
        }
    }

    private boolean checkBeforeNextStep(String orgId, String newFocusPage, DynamicObjectCollection declareItemCollection, String isxxwlqy) {
        Object operationStatus;
        if (null == isxxwlqy || isxxwlqy.isEmpty()) {
            String status = this.getPageCache().get("OperationStatus");
            if (StringUtil.isBlank((CharSequence)status)) {
                status = OperationStatus.VIEW.name();
            }
            if (OperationStatus.EDIT.equals(operationStatus = OperationStatus.valueOf((String)status))) {
                this.showConfirmTips();
                return false;
            }
        }
        Long sbbid = Long.valueOf(null == this.getPageCache().get("sbbid") ? "0" : this.getPageCache().get("sbbid"));
        operationStatus = this.getPageCache().get("OperationStatus");
        String entityName = EntityMappingUtils.getEntityName((OperationStatus)(operationStatus == null ? OperationStatus.VIEW : OperationStatus.valueOf((String)operationStatus)), (String)"tcret_declare_main");
        DynamicObject declareMain = QueryServiceHelper.queryOne((String)entityName, (String)"status", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)sbbid)});
        if (Integer.parseInt(newFocusPage) > declareMain.getInt("status")) {
            HashMap<String, Object> custom = new HashMap<String, Object>();
            custom.put("status", newFocusPage);
            PbtDeclareUtil.updateDeclareMain(sbbid, declareItemCollection, orgId, custom);
        }
        return true;
    }

    private void showConfirmTips() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(ISXXWLQY, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"PbtDeclareHomePlugin_5", (String)"taxc-tcret", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"PbtDeclareHomePlugin_6", (String)"taxc-tcret", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String title = ResManager.loadKDString((String)"\u662f\u5426\u8981\u7ee7\u7eed\u4e0b\u4e00\u6b65\uff1f", (String)"PbtDeclareHomePlugin_28", (String)"taxc-tcret", (Object[])new Object[0]);
        String msg = ResManager.loadKDString((String)"\u3010\u5c0f\u578b\u5fae\u5229\u4f01\u4e1a\u3011\u4e0d\u52fe\u9009\u5219\u4e0d\u80fd\u4eab\u53d7\u516d\u7a0e\u4e24\u8d39\u4f18\u60e0\u653f\u7b56", (String)"PbtDeclareHomePlugin_27", (String)"taxc-tcret", (Object[])new Object[0]);
        this.getView().showConfirm(title, msg, options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    public boolean showInnerTbPage(String focuspage, String orgId) {
        String status = this.getPageCache().get("OperationStatus");
        if (StringUtil.isBlank((CharSequence)status)) {
            status = OperationStatus.VIEW.name();
        }
        OperationStatus operationStatus = OperationStatus.valueOf((String)status);
        FormShowParameter param = PbtDeclareUtil.createShowParameter(this.declarePageMap, focuspage, operationStatus);
        Map<String, Object> customParams = this.createCustomParams(focuspage, orgId);
        boolean readonly = PbtDeclareUtil.isSubmitOrAudit(this.getPageCache(), this.getView());
        customParams.put(READ_ONLY, readonly);
        customParams.put("declarepageid", param.getPageId());
        String sbbid = this.getPageCache().get("sbbid");
        if ("1".equals(focuspage)) {
            this.getPageCache().put(NEED_REFRESH, "true");
        } else if ("2".equals(focuspage)) {
            this.getPageCache().put(NEED_REFRESH, Boolean.toString("EDIT".equals(operationStatus.name())));
            DeclareRequestModel requestModel = new DeclareRequestModel();
            requestModel.setId(Long.valueOf(Long.parseLong(null == sbbid ? "0" : sbbid)));
            requestModel.setOrgId(Long.valueOf(Long.parseLong(orgId)));
            requestModel.setBillNo(this.getPageCache().get(DECLARE_NUMBER));
            requestModel.setTemplateType("ccxws");
            Map<String, String> map = this.getSkssq(operationStatus);
            if (map.size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u88ab\u5220\u9664", (String)"PbtDeclareHomePlugin_22", (String)"taxc-tcret", (Object[])new Object[0]));
                return false;
            }
            requestModel.setSkssqq(map.get("skssqq"));
            requestModel.setSkssqz(map.get("skssqz"));
            requestModel.setOperation(operationStatus == OperationStatus.VIEW ? "read" : "edit");
            String forwardPage = this.getPageCache().get(FOCUS_PAGE);
            requestModel.setRefresh(Boolean.valueOf(status.equals(OperationStatus.EDIT.name()) && "1".equals(forwardPage)));
            requestModel.addBusinessValue(DECLARE_MONTH, this.getPageCache().get(DECLARE_MONTH));
            requestModel.addBusinessValue("sbbid", sbbid);
            requestModel.addBusinessValue(ISXXWLQY, this.getPageCache().get(ISXXWLQY));
            requestModel.addBusinessValue(DETAIL_DECLARE, this.getPageCache().get(DETAIL_DECLARE));
            HashMap<String, String> extendParams = new HashMap<String, String>();
            extendParams.put("taxauthority", this.getPageCache().get(TAXOFFICE));
            extendParams.put("declaredate", this.getPageCache().get(DECLARE_MONTH));
            requestModel.setExtendParams(extendParams);
            customParams.put("declareRequestData", SerializationUtils.toJsonString((Object)requestModel));
            this.getPageCache().put("taxlimit", DateUtils.getTaxLimit((Date)DateUtils.stringToDate((String)map.get("skssqq")), (Date)DateUtils.stringToDate((String)map.get("skssqz"))));
        }
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey(CONTENT_TAB);
        String pageid = param.getPageId();
        this.getPageCache().put("declarepageid", pageid);
        String entityName = EntityMappingUtils.getEntityName((OperationStatus)operationStatus, (String)"tcret_declare_main");
        DynamicObject tcretMain = QueryServiceHelper.queryOne((String)entityName, (String)ID, (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)Long.valueOf(null == sbbid ? "0" : sbbid))});
        DynamicObject declareMain = null;
        if (tcretMain != null) {
            declareMain = QueryServiceHelper.queryOne((String)entityName, (String)"status", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)tcretMain.getLong(ID))});
        }
        PbtDeclareUtil.lightenForStatus(this.declarePageMap, focuspage, null == declareMain ? focuspage : declareMain.getString("status"), this.getView(), this.getPageCache());
        PbtDeclareUtil.setBtnVisible(this.getView(), this.btnMap, focuspage, operationStatus);
        if (((Boolean)customParams.get(READ_ONLY)).booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_edit"});
        }
        this.getView().showForm(param);
        return true;
    }

    private Map<String, Object> createCustomParams(String focuspage, String orgId) {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put(ORGID_KEY, orgId);
        customParams.put(TAXOFFICE, this.getPageCache().get(TAXOFFICE));
        customParams.put(ISXXWLQY, this.getPageCache().get(ISXXWLQY));
        customParams.put(DETAIL_DECLARE, this.getPageCache().get(DETAIL_DECLARE));
        customParams.put(DECLARE_MONTH, this.getPageCache().get(DECLARE_MONTH));
        customParams.put("rootPageId", this.getView().getPageId());
        customParams.put("totalsteps", this.declarePageMap.size());
        customParams.put(FOCUS_PAGE, focuspage);
        customParams.put("sbbid", this.getPageCache().get("sbbid"));
        return customParams;
    }

    private Map<String, String> getSkssq(OperationStatus operationStatus) {
        QFilter filter = new QFilter("sbbid", "=", (Object)Long.parseLong(this.getPageCache().get("sbbid")));
        DynamicObjectCollection declareQueryCollection = QueryServiceHelper.query((String)EntityMappingUtils.getEntityName((OperationStatus)operationStatus, (String)"tcret_declare_main"), (String)"id, entryentity.taxtype as taxtype, entryentity.skssqq as skssqq, entryentity.skssqz as skssqz, entryentity.taxlimit as taxlimit, entryentity.taxstatus as taxstatus,billstatus, status", (QFilter[])new QFilter[]{filter});
        return PbtDeclareUtil.getSkssqzMap((List<DynamicObject>)declareQueryCollection);
    }

    public void save() {
        block30: {
            Throwable throwable;
            TXHandle h;
            DeclareRequestModel declareRequestModel;
            DynamicObject nsrxx;
            String sbbid;
            block26: {
                block27: {
                    block28: {
                        Map<String, String> map;
                        Method saveClick;
                        Object taxDeclarePlugin;
                        IPageCache childPageCache;
                        block23: {
                            block24: {
                                block25: {
                                    sbbid = this.getPageCache().get("sbbid");
                                    if (!EmptyCheckUtils.isNotEmpty((Object)sbbid)) break block30;
                                    nsrxx = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"billno,billstatus", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)Long.parseLong(sbbid))});
                                    if (nsrxx != null && !"A".equals(nsrxx.getString("billstatus"))) {
                                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7533\u62a5\u8868\u5df2\u63d0\u4ea4\u6216\u8005\u5df2\u5ba1\u6838", (String)"PbtDeclareHomePlugin_23", (String)"taxc-tcret", (Object[])new Object[0]));
                                        return;
                                    }
                                    String pageid = this.getPageCache().get("declarepageid");
                                    IFormView childView = this.getView().getView(pageid);
                                    FormViewPluginProxy pluginProxy = (FormViewPluginProxy)childView.getService(FormViewPluginProxy.class);
                                    childPageCache = (IPageCache)childView.getService(IPageCache.class);
                                    List pluginList = pluginProxy.getPlugIns();
                                    taxDeclarePlugin = null;
                                    for (IFormPlugin plugin : pluginList) {
                                        String name = plugin.getPluginName();
                                        if (!name.endsWith("TaxDeclarePlugin")) continue;
                                        taxDeclarePlugin = plugin;
                                        break;
                                    }
                                    if (taxDeclarePlugin == null) break block30;
                                    Class<?> pluginClass = taxDeclarePlugin.getClass();
                                    declareRequestModel = new DeclareRequestModel();
                                    h = TX.requiresNew();
                                    throwable = null;
                                    saveClick = pluginClass.getMethod("saveClick", IPageCache.class, DeclareRequestModel.class);
                                    String orgId = this.getPageCache().get(ORGID_KEY);
                                    declareRequestModel.setId(Long.valueOf(Long.parseLong(sbbid)));
                                    declareRequestModel.setOrgId(Long.valueOf(Long.parseLong(orgId)));
                                    declareRequestModel.setTemplateType("ccxws");
                                    declareRequestModel.setRefresh(Boolean.valueOf(Boolean.TRUE.toString().equals(this.getPageCache().get(NEED_REFRESH))));
                                    declareRequestModel.setOperation("edit");
                                    map = this.getSkssq(OperationStatus.EDIT);
                                    if (map.size() != 0) break block23;
                                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u88ab\u5220\u9664", (String)"PbtDeclareHomePlugin_22", (String)"taxc-tcret", (Object[])new Object[0]));
                                    if (h == null) break block24;
                                    if (throwable == null) break block25;
                                    try {
                                        h.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    break block24;
                                }
                                h.close();
                            }
                            return;
                        }
                        declareRequestModel.setSkssqq(map.get("skssqq"));
                        declareRequestModel.setSkssqz(map.get("skssqz"));
                        BaseResult resultMap = (BaseResult)saveClick.invoke(taxDeclarePlugin, childPageCache, declareRequestModel);
                        if (500 != resultMap.getCode()) break block26;
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25,\u539f\u56e0\uff1a%s", (String)"PbtDeclareHomePlugin_34", (String)"taxc-tcret", (Object[])new Object[0]), resultMap.getMessage()));
                        if (h == null) break block27;
                        if (throwable == null) break block28;
                        try {
                            h.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        break block27;
                    }
                    h.close();
                }
                return;
            }
            try {
                try {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"PbtDeclareHomePlugin_21", (String)"taxc-tcret", (Object[])new Object[0]));
                    this.getPageCache().remove(NEED_REFRESH);
                    nsrxx = nsrxx != null ? nsrxx : QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"billno,billstatus", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)Long.parseLong(sbbid))});
                    this.writeBack(this.getPageCache().get("draft"), Long.parseLong(sbbid), nsrxx == null ? "" : nsrxx.getString("billno"), "editing", "A");
                }
                catch (Exception e) {
                    LOGGER.error("save error:", (Throwable)e);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"PbtDeclareHomePlugin_8", (String)"taxc-tcret", (Object[])new Object[0]));
                    h.markRollback();
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            catch (Throwable throwable5) {
                throw throwable5;
            }
            finally {
                if (h != null) {
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                    } else {
                        h.close();
                    }
                }
            }
            DataSynchronizeMQSender.sendMessage((SynchronizeParam)new SynchronizeParam(declareRequestModel.getId(), "ccxws", declareRequestModel.getOrgId()));
            if (this.getPageCache().get(ORGID_KEY) != null) {
                this.getPageCache().put("OperationStatus", OperationStatus.VIEW.name());
                this.showInnerTbPage(this.getPageCache().get(FOCUS_PAGE), this.getPageCache().get(ORGID_KEY));
            }
        }
    }

    private void writeBack(String draftMapStr, Long declareReportId, String declarenumber, String declarestatus, String declarebillstatus) {
        Map draftMap = null;
        if (StringUtil.isNotBlank((CharSequence)draftMapStr)) {
            draftMap = (Map)SerializationUtils.fromJsonString((String)draftMapStr, Map.class);
        }
        if (draftMap == null) {
            return;
        }
        DraftWriteBackService.writeBackDeclareReportInfo(draftMap, declareReportId, declarenumber, declarestatus, declarebillstatus);
    }

    private void submit(String operationKey) {
        DynamicObject declare = YbnsrService.queryYbnsr((String)this.getPageCache().get("sbbid"));
        if (declare != null) {
            String sbbid = declare.getString(ID);
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)operationKey, (String)"tcret_query_report", (Object[])new Long[]{Long.parseLong(sbbid)});
            if (operationResult.isSuccess()) {
                this.getView().setVisible(Boolean.valueOf("unsubmit".equals(operationKey) || "unaudit".equals(operationKey)), new String[]{"bar_edit"});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"PbtDeclareHomePlugin_35", (String)"taxc-tcret", (Object[])new Object[0]));
            } else {
                this.getView().showOperationResult(operationResult);
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u672a\u751f\u6210\u6216\u5df2\u88ab\u5220\u9664, \u8bf7\u91cd\u65b0\u751f\u6210\u3002", (String)"PbtDeclareHomePlugin_31", (String)"taxc-tcret", (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("tcret_pbt_selectsbb".equals(e.getActionId())) {
            Map returnData = (Map)e.getReturnData();
            Object key = returnData.get("key");
            if (key == null) {
                Object changetype = returnData.get("changetype");
                if (CHANGE_TYPE_PROPERTY.equals(changetype)) {
                    this.getPageCache().remove("sbbid");
                    this.showInnerTbPage("1", this.getPageCache().get(ORGID_KEY));
                }
            } else if ("newsbb".equals(key)) {
                String declaremonth = this.getPageCache().get(DECLARE_MONTH);
                String taxoffice = this.getPageCache().get(TAXOFFICE);
                DynamicObject dynamicObject = PbtDeclareUtil.createTcretDeclareMain(declaremonth, taxoffice, (List<DynamicObject>)new DynamicObjectCollection(), this.getPageCache().get(ORGID_KEY), "1");
                String sbbid = dynamicObject.getString("sbbid");
                this.getPageCache().put("sbbid", sbbid);
                this.getPageCache().put("status", "1");
                this.getModel().setValue(DECLARE_NUMBER, (Object)dynamicObject.getString("billno"));
                this.getPageCache().put(DECLARE_NUMBER, dynamicObject.getString("billno"));
                this.getPageCache().put("OperationStatus", OperationStatus.EDIT.name());
                this.showInnerTbPage("1", this.getPageCache().get(ORGID_KEY));
            } else if ("btnok".equals(key)) {
                ListSelectedRow listSelectedRow = (ListSelectedRow)returnData.get("data");
                DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)listSelectedRow.getPrimaryKeyValue(), (String)"tcret_declare_main");
                String sbbid = object.getString("sbbid");
                String billno = object.getString("billno");
                this.getModel().setValue(DECLARE_NUMBER, (Object)billno);
                this.getPageCache().put(DECLARE_NUMBER, billno);
                this.getPageCache().put("sbbid", sbbid);
                this.getPageCache().put("OperationStatus", OperationStatus.VIEW.name());
                this.showInnerTbPage("1", this.getPageCache().get(ORGID_KEY));
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        String entityname = this.getModel().getDataEntityType().getName();
        String entity = "tcvat_nsrxx";
        String sbbid = this.getPageCache().get("sbbid");
        HashMap<String, String> customparam = new HashMap<String, String>();
        if ("bar_edit".equals(key)) {
            if (StringUtils.isNotBlank((CharSequence)entity)) {
                try {
                    DynamicObject dynamicObject;
                    MutexServiceImpl mutexService = new MutexServiceImpl();
                    customparam.put("dataObjId", sbbid);
                    customparam.put("entityKey", entity);
                    customparam.put("operationKey", "edit");
                    customparam.put("groupId", "declare_edit");
                    mutexService.setMutexLockInfo(customparam);
                    boolean isSuccessLock = mutexService.setMutexLock();
                    LOGGER.info("DynamicEntity:{},Entity:{} lock : {}", new Object[]{entityname, entity, isSuccessLock});
                    if (!isSuccessLock && (dynamicObject = MutexServiceImpl.getMutexData((QFilter)new QFilter("objectid", "=", (Object)sbbid))) != null) {
                        String user = dynamicObject.getString("user.name");
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"PbtDeclareHomePlugin_32", (String)"taxc-tcret", (Object[])new Object[0]), user));
                        evt.setCancel(true);
                        return;
                    }
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                }
            }
        } else if (Sets.newHashSet((Object[])new String[]{"bar_submit", "bar_unsubmit", "bar_audit", "bar_unaudit"}).contains(key)) {
            DynamicObject dynamicObject = MutexServiceImpl.getMutexData((QFilter)new QFilter("objectid", "=", (Object)sbbid));
            if (dynamicObject != null && !dynamicObject.get("user.id").equals(RequestContext.get().getCurrUserId())) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"PbtDeclareHomePlugin_32", (String)"taxc-tcret", (Object[])new Object[0]), dynamicObject.get("user.name")));
                evt.setCancel(true);
            }
        } else if ("bar_save".equals(key) || "bar_cancel".equals(key)) {
            MutexServiceImpl.releaseMutexLock((String)sbbid, (String)"edit", (Long)RequestContext.get().getCurrUserId());
        }
    }

    public void pageRelease(EventObject e) {
        String sbbid = this.getPageCache().get("sbbid");
        if (StringUtils.isNotBlank((CharSequence)sbbid)) {
            MutexServiceImpl.releaseMutexLock((String)sbbid, (String)"edit", (Long)RequestContext.get().getCurrUserId());
        }
    }
}

