/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.rule;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class LvatRulePlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String TDZZS_CLEARING_UNIT = "tdm_tdzzs_clearing_unit";
    private static final String PREPAYMENTINFO = "prepaymentinfo";
    private static final String ORG = "org";
    private static final String YJXM = "yjxm";
    private static final String BUILDINGTYPE = "buildingtype";
    private static final String SUBBUILDINGTYPE = "subbuildingtype";
    private static final String INCOMETYPE = "incometype";

    public void initialize() {
        BasedataEdit org = (BasedataEdit)this.getControl(ORG);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit yjxm = (BasedataEdit)this.getControl(YJXM);
        yjxm.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit buildingtype = (BasedataEdit)this.getControl(BUILDINGTYPE);
        buildingtype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit subbuildingtype = (BasedataEdit)this.getControl(SUBBUILDINGTYPE);
        subbuildingtype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit incometype = (BasedataEdit)this.getControl(INCOMETYPE);
        incometype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String number = (String)this.getModel().getValue("number");
        String ruletype = (String)this.getView().getFormShowParameter().getCustomParam("ruletype");
        if (StringUtils.isNotEmpty((CharSequence)ruletype) && StringUtils.isEmpty((CharSequence)number)) {
            this.getModel().setValue("ruletype", (Object)ruletype);
            String billno = DeclareServiceHelper.generateSBBNo((String)"tcret_lvat_rule");
            this.getModel().setValue("number", (Object)billno);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if (YJXM.equals(name)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            evt.addCustomQFilter(new QFilter(ORG, "=", (Object)(org != null ? org.getLong("id") : 0L)));
            evt.addCustomQFilter(new QFilter("phase.number", "=", (Object)"LVAT-sblx-01"));
        } else if (BUILDINGTYPE.equals(name)) {
            DynamicObject yjxm = (DynamicObject)this.getModel().getValue(YJXM);
            List<Object> buildingTypeIds = new ArrayList();
            if (yjxm != null) {
                DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)yjxm.getPkValue(), (String)TDZZS_CLEARING_UNIT);
                DynamicObjectCollection prepaymentinfo = object.getDynamicObjectCollection(PREPAYMENTINFO);
                buildingTypeIds = prepaymentinfo.stream().map(p -> p.getDynamicObject(BUILDINGTYPE).getLong("id")).collect(Collectors.toList());
            }
            evt.addCustomQFilter(new QFilter("id", "in", buildingTypeIds));
            evt.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u623f\u4ea7\u7c7b\u578b", (String)"LvatRulePlugin_0", (String)"taxc-tcret", (Object[])new Object[0]));
        } else if (SUBBUILDINGTYPE.equals(name)) {
            DynamicObject buildingtype = (DynamicObject)this.getModel().getValue(BUILDINGTYPE);
            List<Object> subBuildingTypeIds = new ArrayList();
            if (buildingtype != null) {
                DynamicObject yjxm = (DynamicObject)this.getModel().getValue(YJXM);
                DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)yjxm.getPkValue(), (String)TDZZS_CLEARING_UNIT);
                DynamicObjectCollection prepaymentinfo = object.getDynamicObjectCollection(PREPAYMENTINFO);
                subBuildingTypeIds = prepaymentinfo.stream().filter(p -> p.getDynamicObject(BUILDINGTYPE).getLong("id") == buildingtype.getLong("id")).filter(p -> p.getDynamicObject(SUBBUILDINGTYPE) != null).map(p -> p.getDynamicObject(SUBBUILDINGTYPE).getLong("id")).collect(Collectors.toList());
            }
            evt.addCustomQFilter(new QFilter("id", "in", subBuildingTypeIds));
            evt.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u623f\u4ea7\u7c7b\u578b\u5b50\u76ee", (String)"LvatRulePlugin_1", (String)"taxc-tcret", (Object[])new Object[0]));
        } else if (INCOMETYPE.equals(name)) {
            evt.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u7533\u62a5\u6536\u5165\u7c7b\u578b", (String)"LvatRulePlugin_2", (String)"taxc-tcret", (Object[])new Object[0]));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (ORG.equals(name)) {
            this.getModel().setValue(YJXM, null);
        } else if (YJXM.equals(name)) {
            this.getModel().setValue(BUILDINGTYPE, null);
        } else if (BUILDINGTYPE.equals(name)) {
            this.getModel().setValue(SUBBUILDINGTYPE, null);
        }
    }
}

