/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.tcret.business.rule.TdzzsSharingPlanServiceHelper;

public class LvatRuleQueryPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
HyperLinkClickListener {
    private static final String SHOWDISABLE = "showdisable";
    private static final String ORG = "org";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"toolbarap"});
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        BillList billlist = (BillList)this.getView().getControl("billlistap");
        billlist.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue(ORG, (Object)PermissionUtils.getDefaultOrgId());
        DynamicObject org = (DynamicObject)this.getView().getModel().getValue(ORG);
        this.createTree(org, false);
    }

    private void createTree(DynamicObject org, boolean showdisable) {
        List<TreeNode> nodeList = this.getNodeList(org, showdisable);
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        IPageCache cache = this.getPageCache();
        if (nodeList.size() > 0) {
            treeView.deleteAllNodes();
            TreeUtils.build((TreeView)treeView, nodeList, (IPageCache)cache, (boolean)false);
            TreeUtils.expand((TreeView)treeView, (IPageCache)cache, (int)1);
            treeView.focusNode(nodeList.get(0));
            this.refreshRules("0", "");
            this.getPageCache().put("currentnode", nodeList.get(0).getId());
        }
    }

    private void createTreeCache(DynamicObject org, boolean showdisable, String currentnode) {
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        List<TreeNode> nodeList = this.getNodeList(org, showdisable);
        TreeNode foucsnode = new TreeNode();
        for (TreeNode node : nodeList) {
            if (!node.getId().equals(currentnode)) continue;
            foucsnode = node;
        }
        IPageCache cache = this.getPageCache();
        TreeUtils.build((TreeView)treeView, nodeList, (IPageCache)cache, (boolean)false);
        TreeUtils.expand((TreeView)treeView, (IPageCache)cache, (int)1);
        treeView.focusNode(foucsnode);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        BillList billlist = (BillList)this.getView().getControl("billlistap");
        ListSelectedRow row = billlist.getCurrentSelectedRowInfo();
        DynamicObject rule = TdzzsSharingPlanServiceHelper.queryRuleById(row.getPrimaryKeyValue());
        if (rule != null) {
            BaseShowParameter param = this.setParms(rule.getString("ruletype"));
            param.setPkId(row.getPrimaryKeyValue());
            this.getView().showForm((FormShowParameter)param);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"treeviewap")) {
            String id = (String)evt.getNodeId();
            String parentid = (String)evt.getParentNodeId();
            this.getPageCache().put("currentnode", id);
            this.getPageCache().put("currentparentnode", parentid);
            this.refreshRules(id, parentid);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Boolean showdisable = (Boolean)this.getModel().getValue(SHOWDISABLE);
        String name = e.getProperty().getName();
        if (ORG.equals(name) || SHOWDISABLE.equals(name)) {
            DynamicObject org = (DynamicObject)this.getView().getModel().getValue(ORG);
            String currentnode = this.getPageCache().get("currentnode");
            String currentparentnode = this.getPageCache().get("currentparentnode");
            this.createTree(org, showdisable);
            this.getView().updateView();
            this.refreshRules(currentnode, currentparentnode);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperateKey().equals("refresh")) {
            Boolean showdisable = (Boolean)this.getModel().getValue(SHOWDISABLE);
            DynamicObject org = (DynamicObject)this.getView().getModel().getValue(ORG);
            String currentnode = this.getPageCache().get("currentnode");
            String currentparentnode = this.getPageCache().get("currentparentnode");
            this.createTreeCache(org, showdisable, currentnode);
            this.refreshRules(currentnode, currentparentnode);
        }
    }

    private void refreshRules(String nodeid, String parentnodeid) {
        Boolean showdisable = (Boolean)this.getModel().getValue(SHOWDISABLE);
        if ("0".equals(nodeid)) {
            this.loadyjAllCard(showdisable);
        } else {
            this.loadCard(nodeid, parentnodeid, showdisable);
        }
    }

    private void loadyjAllCard(boolean showdisable) {
        DynamicObject org = (DynamicObject)this.getView().getModel().getValue(ORG);
        BillList list = (BillList)this.getView().getControl("billlistap");
        FilterParameter filterParameter = new FilterParameter();
        List qFilters = filterParameter.getQFilters();
        QFilter pfilter1 = new QFilter(ORG, "=", (Object)(org == null ? 0L : org.getLong("id")));
        QFilter pfilter2 = new QFilter("status", "=", (Object)"C");
        QFilter pfilter3 = new QFilter("phase.number", "=", (Object)"LVAT-sblx-01");
        DynamicObject[] units = BusinessDataServiceHelper.load((String)"tdm_tdzzs_clearing_unit", (String)"id,taxproject.name,prepaymentinfo", (QFilter[])new QFilter[]{pfilter1, pfilter2, pfilter3});
        List unitids = Arrays.stream(units).map(p -> p.getLong("id")).collect(Collectors.toList());
        QFilter qFilter1 = new QFilter("yjxm", "in", unitids);
        List allFxlxzmids = new ArrayList();
        String allChildlist = this.getPageCache().get("unitschildlist");
        if (allChildlist != null) {
            allFxlxzmids = SerializationUtils.fromJsonStringToList((String)allChildlist, Long.class);
        }
        QFilter orgFilter = new QFilter("orgentity.orgid", "=", (Object)(org == null ? 0L : org.getLong("id")));
        QFilter prepayFilter = new QFilter("prepayentity.prepayid", "in", unitids);
        QFilter fclxzmFilter = new QFilter("fclxzmentity.fclxzmid", "in", allFxlxzmids);
        DynamicObjectCollection sharingRules = QueryServiceHelper.query((String)"tcret_tdzzs_share", (String)"ruleentity.ruleid as ruleid", (QFilter[])new QFilter[]{orgFilter, prepayFilter, fclxzmFilter});
        List ruleids = sharingRules.stream().map(a -> a.getLong("ruleid")).collect(Collectors.toList());
        QFilter qFilter2 = new QFilter("id", "in", ruleids);
        QFilter qFilter3 = new QFilter("enable", "in", (Object)"1");
        qFilters.add(qFilter1.or(qFilter2));
        if (!showdisable) {
            qFilters.add(qFilter3);
        }
        list.setQueryFilterParameter(filterParameter);
        list.clearSelection();
        this.getView().updateView("billlistap");
    }

    private void loadCard(String nodeid, String parentnodeid, boolean showdisable) {
        DynamicObject org = (DynamicObject)this.getView().getModel().getValue(ORG);
        BillList list = (BillList)this.getView().getControl("billlistap");
        FilterParameter filterParameter = new FilterParameter();
        List qFilters = filterParameter.getQFilters();
        if (org != null) {
            if ("0".equals(parentnodeid)) {
                Set<Object> fxlxzmids = new HashSet();
                String schildlist = this.getPageCache().get(nodeid);
                if (schildlist != null) {
                    Map childlist = (Map)SerializationUtils.fromJsonString((String)schildlist, Map.class);
                    fxlxzmids = childlist.keySet().stream().map(a -> Long.valueOf(a)).collect(Collectors.toSet());
                }
                QFilter qFilter1 = new QFilter("orgentity.orgid", "=", org.get("id"));
                QFilter qFilter2 = new QFilter("prepayentity.prepayid", "=", (Object)Long.valueOf(nodeid));
                QFilter qFilter3 = new QFilter("fclxzmentity.fclxzmid", "in", fxlxzmids);
                DynamicObjectCollection sharingRules = QueryServiceHelper.query((String)"tcret_tdzzs_share", (String)"ruleentity.ruleid as ruleid", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3});
                List ruleids = sharingRules.stream().map(a -> a.getLong("ruleid")).collect(Collectors.toList());
                QFilter qFilter4 = new QFilter(ORG, "=", org.get("id"));
                QFilter qFilter5 = new QFilter("ruletype", "=", (Object)"private");
                QFilter qFilter6 = new QFilter("enable", "in", (Object)"1");
                QFilter qFilter7 = new QFilter("id", "in", ruleids);
                QFilter qFilter8 = new QFilter("yjxm", "=", (Object)Long.valueOf(nodeid));
                qFilters.add(qFilter4.and(qFilter5).and(qFilter8).or(qFilter7));
                if (!showdisable) {
                    qFilters.add(qFilter6);
                }
            } else if (StringUtils.isNotBlank((CharSequence)parentnodeid)) {
                QFilter qFilter1 = new QFilter("orgentity.orgid", "=", org.get("id"));
                QFilter qFilter2 = new QFilter("prepayentity.prepayid", "=", (Object)Long.valueOf(parentnodeid));
                QFilter qFilter3 = new QFilter("fclxzmentity.fclxzmid", "=", (Object)Long.valueOf(nodeid));
                DynamicObjectCollection sharingRules = QueryServiceHelper.query((String)"tcret_tdzzs_share", (String)"ruleentity.ruleid as ruleid", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3});
                List ruleids = sharingRules.stream().map(a -> a.getLong("ruleid")).collect(Collectors.toList());
                QFilter qFilter4 = new QFilter(ORG, "=", (Object)(org == null ? 0L : org.getLong("id")));
                QFilter qFilter5 = new QFilter("ruletype", "=", (Object)"private");
                QFilter qFilter6 = new QFilter("enable", "in", (Object)"1");
                QFilter qFilter7 = new QFilter("id", "in", ruleids);
                QFilter qFilter8 = new QFilter("yjxm", "=", (Object)Long.valueOf(parentnodeid));
                QFilter qFilter9 = new QFilter("subbuildingtype", "=", (Object)Long.valueOf(nodeid));
                qFilters.add(qFilter4.and(qFilter5).and(qFilter8).and(qFilter9).or(qFilter7));
                if (!showdisable) {
                    qFilters.add(qFilter6);
                }
            }
            list.setQueryFilterParameter(filterParameter);
            list.clearSelection();
            this.getView().updateView("billlistap");
        }
    }

    private static DynamicObjectCollection getrules(Long fclxzmid, DynamicObject org, boolean showdisable, Long prepayid) {
        DynamicObjectCollection rules = new DynamicObjectCollection();
        ArrayList<Long> ruleids = new ArrayList<Long>();
        if (null != org) {
            QFilter qFilter1 = new QFilter("orgentity.orgid", "=", org.get("id"));
            QFilter qFilter2 = new QFilter("prepayentity.prepayid", "=", (Object)prepayid);
            QFilter qFilter3 = new QFilter("fclxzmentity.fclxzmid", "=", (Object)fclxzmid);
            DynamicObjectCollection sharingRules = QueryServiceHelper.query((String)"tcret_tdzzs_share", (String)"id,ruleentity.ruleid as ruleid", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3});
            for (DynamicObject sharingRule : sharingRules) {
                Long ruleid = sharingRule.getLong("ruleid");
                ruleids.add(ruleid);
            }
            QFilter qFilter4 = new QFilter(ORG, "=", org.get("id"));
            QFilter qFilter5 = new QFilter("ruletype", "=", (Object)"private");
            QFilter qFilter6 = new QFilter("enable", "=", (Object)"1");
            QFilter qFilter7 = new QFilter("id", "in", ruleids);
            QFilter qFilter8 = new QFilter("yjxm", "=", (Object)prepayid);
            QFilter qFilter9 = new QFilter("subbuildingtype", "=", (Object)fclxzmid);
            if (showdisable) {
                QFilter[] allfilter = new QFilter[]{qFilter4.and(qFilter5).and(qFilter8).and(qFilter9).or(qFilter7)};
                DynamicObjectCollection rule = QueryServiceHelper.query((String)"tcret_lvat_rule", (String)"id,enable,ruletype,name,modifytime", (QFilter[])allfilter);
                rules.addAll((Collection)rule);
            } else {
                QFilter[] enalbefilter = new QFilter[]{qFilter4.and(qFilter5).and(qFilter6).and(qFilter8).and(qFilter9).or(qFilter7.and(qFilter6))};
                DynamicObjectCollection rule = QueryServiceHelper.query((String)"tcret_lvat_rule", (String)"id,enable,ruletype,name,modifytime", (QFilter[])enalbefilter);
                rules.addAll((Collection)rule);
            }
        }
        return rules;
    }

    public List<TreeNode> getNodeList(DynamicObject org, boolean showdisable) {
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
        DynamicObjectCollection collection = new DynamicObjectCollection();
        HashMap typemap = new HashMap();
        int sumroot = 0;
        TreeNode root = new TreeNode();
        root.setId("0");
        QFilter pfilter1 = new QFilter(ORG, "=", org == null ? Long.valueOf(0L) : org.get("id"));
        QFilter pfilter2 = new QFilter("status", "=", (Object)"C");
        QFilter pfilter3 = new QFilter("phase.number", "=", (Object)"LVAT-sblx-01");
        DynamicObject[] units = TdzzsSharingPlanServiceHelper.queryUnits(new QFilter[]{pfilter1, pfilter2, pfilter3});
        ArrayList unitslist = new ArrayList();
        for (DynamicObject unit : units) {
            String unitId = unit.getString("id");
            DynamicObjectCollection prepaymentinfo = unit.getDynamicObjectCollection("prepaymentinfo");
            List subBuildingTypeId = prepaymentinfo.stream().filter(p -> p.getDynamicObject("subbuildingtype") != null).map(p -> p.getDynamicObject("subbuildingtype").getLong("id")).collect(Collectors.toList());
            Map<String, Object> idMap = prepaymentinfo.stream().filter(p -> p.getDynamicObject("subbuildingtype") != null).collect(Collectors.toMap(a -> a.getDynamicObject("subbuildingtype").getString("id"), b -> b.getDynamicObject("subbuildingtype").getString("name"), (m, n) -> m));
            unitslist.addAll(subBuildingTypeId);
            String unitchildlist = SerializationUtils.toJsonString(idMap);
            this.getPageCache().put(unitId, unitchildlist);
        }
        String unitschildlist = SerializationUtils.toJsonString(unitslist);
        this.getPageCache().put("unitschildlist", unitschildlist);
        collection.addAll(Arrays.asList(units));
        for (DynamicObject entry : collection) {
            int sumchild = 0;
            String Id = entry.getString("id");
            String name = entry.getString("taxproject.name");
            String parentid = "0";
            TreeNode leftRoot = new TreeNode();
            leftRoot.setParentid(parentid);
            leftRoot.setId(Id);
            String schildlist = this.getPageCache().get(Id);
            if (schildlist == null) continue;
            Map childlist = (Map)SerializationUtils.fromJsonString((String)schildlist, Map.class);
            for (Map.Entry child : childlist.entrySet()) {
                TreeNode childRoot = new TreeNode();
                int childnum = LvatRuleQueryPlugin.getrules(Long.valueOf((String)child.getKey()), org, showdisable, entry.getLong("id")).size();
                sumchild += childnum;
                childRoot.setParentid(Id);
                childRoot.setId((String)child.getKey());
                childRoot.setText(child.getValue() + "(" + childnum + ")");
                nodeList.add(childRoot);
            }
            String num = String.valueOf(sumchild);
            leftRoot.setText(name + "(" + num + ")");
            nodeList.add(leftRoot);
            sumroot += sumchild;
        }
        root.setText(String.format(ResManager.loadKDString((String)"\u9884\u7f34\u9879\u76ee(%s)", (String)"LvatRuleQueryPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]), sumroot));
        nodeList.add(root);
        String map = SerializationUtils.toJsonString(typemap);
        this.getPageCache().put("typemap", map);
        return nodeList;
    }

    private BaseShowParameter setParms(String ruletype) {
        BaseShowParameter param = new BaseShowParameter();
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("ruletype", ruletype);
        param.setFormId("private".equals(ruletype) ? "tcret_lvat_rule" : "tcret_lvat_rule_inf");
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        return param;
    }
}

