/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.rule;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.tree.SearchUtil;

public class RentRuleConfigsPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TabSelectListener {
    public static final String RULETYPE = "ruletype";
    public static final String PRIVATE = "private";
    private static String TREE_ORG = "treeviewap";
    private static final String ENTITY_FCCZZJ = "tcret_rule_fcczzj";
    private static final String CURRENT_NODE = "CURRENT_NODE";
    private static final String CURRENT_TEMP_NODE = "CURRENT_TEMP_NODE";
    private static final String CURRENT_TAB = "CURRENT_TAB";
    private static final String RULE_TYPE_FCCZZJ = "fcczzj";
    private Set<String> fcczzjKeys = new HashSet<String>(Arrays.asList("fcczzjruleadd", "fcczzjruleup", "fcczzjruledown", "fcczzjrulelabel", "cardflexpanelap1", "cardflexpanelap2", "cardflexpanelap3", "cardflexpanelap4", "cardflexpanelap5", "cardflexpanelap6", "cardflexpanelap7", "fcczzj_image", "labelap_modifydate", "labelap_jzjt", "labelap_taxrate", "labelap_enable", "labelap_disable"));

    public void initialize() {
        TreeView tree = (TreeView)this.getView().getControl(TREE_ORG);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void registerListener(EventObject e) {
        Search sl = (Search)this.getControl("entitysearchap");
        sl.addEnterListener(this::orgSearchListener);
        this.addClickListeners(this.fcczzjKeys.toArray(new String[0]));
        this.addItemClickListeners(new String[]{"toolbarap"});
        Tab tabap = (Tab)this.getControl("tabap");
        tabap.addTabSelectListener((TabSelectListener)this);
    }

    private void orgSearchListener(SearchEnterEvent event) {
        IPageCache pageCache = this.getPageCache();
        String treeCache = pageCache.get(TREE_ORG);
        if (treeCache == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"RentRuleConfigsPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]));
            return;
        }
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)treeCache, TreeNode.class);
        List nodes = SearchUtil.getList((String)event.getText(), (TreeNode)root);
        if (!nodes.isEmpty()) {
            TreeView treeView = (TreeView)this.getView().getControl(TREE_ORG);
            TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)((TreeNode)nodes.get(0)).getId());
            return;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"RentRuleConfigsPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]));
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("refresh".equals(itemKey)) {
            this.refreshData();
        }
    }

    private void refreshData() {
        TreeView treeView = (TreeView)this.getView().getControl(TREE_ORG);
        treeView.deleteAllNodes();
        IFormView view = this.getView();
        IPageCache cache = this.getPageCache();
        OrgUtils.buildOrgTree((IFormView)view, (TreeView)treeView, (IPageCache)cache);
        this.checkNode(treeView, cache);
    }

    public void afterCreateNewData(EventObject e) {
        TreeView treeView = (TreeView)this.getView().getControl(TREE_ORG);
        IFormView view = this.getView();
        IPageCache cache = this.getPageCache();
        this.getPageCache().put(CURRENT_TAB, "fcczzjruletab");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getPageCache().put(RULETYPE, (String)customParams.get(RULETYPE));
        OrgUtils.buildOrgTree((IFormView)view, (TreeView)treeView, (IPageCache)cache);
        this.checkNode(treeView, cache);
    }

    private void loadfcczzjrule(String ruleType) {
        this.getModel().deleteEntryData("fcczzjentity");
        QFilter org = new QFilter("org", "=", (Object)Long.parseLong(this.getPageCache().get(CURRENT_NODE) == null ? "0" : this.getPageCache().get(CURRENT_NODE)));
        QFilter ruleTypeFilter = new QFilter(RULETYPE, "=", (Object)ruleType);
        DynamicObjectCollection rules = QueryServiceHelper.query((String)ENTITY_FCCZZJ, (String)"id,org.name as org,org.status as status,ruletype,enable,name,modifytime,leasecontractno.number", (QFilter[])new QFilter[]{org, ruleTypeFilter}, (String)"ruletype desc");
        for (DynamicObject rule : rules) {
            int row = this.getModel().createNewEntryRow("fcczzjentity");
            this.getModel().setValue("fcczzjid", rule.get("id"), row);
            this.getModel().setValue("fcczzjrulename", (Object)rule.getString("name"), row);
            this.getModel().setValue("fcczzjmodifydate", rule.get("modifytime"), row);
            this.getModel().setValue("fcczzjenable", rule.get("enable"), row);
            this.getModel().setValue("taxname", rule.get("leasecontractno.number"), row);
            String ruletype = rule.getString(RULETYPE);
            this.getModel().setValue("fcczzjruletype", (Object)ruletype, row);
            this.setBackgroundAndImage(row, RULE_TYPE_FCCZZJ, ruletype);
        }
    }

    private void setBackgroundAndImage(int row, String type, String ruletype) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>(16);
        HashMap<String, HashMap<String, String>> pmap = new HashMap<String, HashMap<String, String>>(16);
        if (PRIVATE.equals(ruletype)) {
            propertiesMap.put("bc", "#FFF2E9");
            propertiesMap.put("src", "/icons/pc/label/swy_zy_86_86.png");
        } else {
            propertiesMap.put("bc", "#E7F0FF");
            propertiesMap.put("src", "/icons/pc/label/swy_fp_86_86.png");
        }
        pmap.put(type + "_flex", propertiesMap);
        pmap.put(type + "_image", propertiesMap);
        ClientViewProxy client = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        client.invokeControlMethod(type + "entity", "setCustomProperties", new Object[]{row, pmap});
    }

    private void checkNode(TreeView treeView, IPageCache cache) {
        String status;
        Object orgid = cache.get(CURRENT_NODE);
        if (orgid == null || StringUtils.isEmpty((CharSequence)String.valueOf(orgid))) {
            orgid = this.getView().getFormShowParameter().getCustomParam("orgid");
        }
        if (orgid != null) {
            TreeUtils.checkNode((IPageCache)cache, (TreeView)treeView, (String)String.valueOf(orgid));
            return;
        }
        if (cache.get(CURRENT_NODE) != null && "2".equals(status = OrgUtils.getOrgStatusById((String)cache.get(CURRENT_NODE)))) {
            TreeUtils.checkNode((IPageCache)cache, (TreeView)treeView, (String)cache.get(CURRENT_NODE));
            return;
        }
        DynamicObject org = null;
        try {
            org = (DynamicObject)this.getView().getParentView().getModel().getValue("org");
        }
        catch (Exception ee) {
            org = null;
        }
        if (org != null && "1".equals(org.getString("enable"))) {
            TreeUtils.checkNode((IPageCache)cache, (TreeView)treeView, (String)org.getString("id"));
        } else {
            TreeUtils.checkFirstNode((IPageCache)cache, (TreeView)treeView);
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (this.fcczzjKeys.contains(key)) {
            Object pkid;
            EntryGrid fcczzjentity = (EntryGrid)this.getControl("fcczzjentity");
            int[] selectRows = fcczzjentity.getSelectRows();
            Object object = pkid = selectRows.length > 0 ? this.getModel().getValue("fcczzjid", selectRows[0]) : null;
            if (key.contains("fccz")) {
                pkid = null;
            }
            this.openRuleForm(ENTITY_FCCZZJ, pkid, RULE_TYPE_FCCZZJ);
        }
        if ("searchbefore".equals(key) || "searchnext".equals(key)) {
            String[] btns = new String[]{"searchbefore", "searchnext"};
            SearchUtil.getLeftOrRight((IPageCache)this.getPageCache(), (IFormView)this.getView(), (String)key, (TreeView)((TreeView)this.getControl(TREE_ORG)), (String[])btns, (String)TREE_ORG);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        TreeView treeView = (TreeView)this.getView().getControl(TREE_ORG);
        IPageCache cache = this.getPageCache();
        this.checkNode(treeView, cache);
    }

    private void openRuleForm(String formId, Object pkid, String ruletype) {
        String orgId = this.getPageCache().get(CURRENT_NODE);
        if (StringUtils.isEmpty((CharSequence)orgId)) {
            if (StringUtils.isEmpty((CharSequence)this.getPageCache().get(CURRENT_TEMP_NODE))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u5de6\u8fb9\u7ec4\u7ec7\u6811\u4e0a\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"RentRuleConfigsPlugin_1", (String)"taxc-tcret", (Object[])new Object[0]));
                return;
            }
            String nodeId = this.getPageCache().get(CURRENT_TEMP_NODE);
            boolean check = OrgCheckUtil.check((IFormView)this.getView(), (String)nodeId, (String)"tcret", (String)"fcscztdsys", (String)"fcscztdsys");
            if (check) {
                return;
            }
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId(formId);
        if (pkid == null) {
            showParameter.setBillStatus(BillOperationStatus.ADDNEW);
        } else {
            showParameter.setBillStatus(BillOperationStatus.EDIT);
            showParameter.setPkId(pkid);
        }
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("orgid", orgId);
        customParams.put(RULETYPE, this.getPageCache().get(RULETYPE));
        showParameter.setCustomParams(customParams);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, formId);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        IPageCache pageCache = this.getPageCache();
        String current = this.getPageCache().get(CURRENT_NODE);
        TreeView treeView = (TreeView)this.getControl(TREE_ORG);
        boolean check = OrgCheckUtil.withoutLicenseCheck((IFormView)this.getView(), (String)nodeId, (String)"tcret", (String)"fcscztdsys");
        if (check) {
            TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)current);
            pageCache.put(CURRENT_TEMP_NODE, nodeId);
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)nodeId) && !TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)Long.parseLong(nodeId)).isSuccess()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u53ef\u9009\u3002", (String)"RentRuleConfigsPlugin_2", (String)"taxc-tcret", (Object[])new Object[0]));
            TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)current);
            pageCache.put(CURRENT_TEMP_NODE, nodeId);
            return;
        }
        pageCache.remove(CURRENT_TEMP_NODE);
        pageCache.put(CURRENT_NODE, nodeId);
        String tab = pageCache.get(CURRENT_TAB);
        if (null != tab && "fcczzjruletab".equals(tab)) {
            this.loadfcczzjrule(this.getPageCache().get(RULETYPE));
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        this.getPageCache().put(CURRENT_TAB, tabKey);
        if ("fcczzjruletab".equals(tabKey)) {
            this.loadfcczzjrule(this.getPageCache().get(RULETYPE));
        }
    }
}

