/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.operate.formop.Refresh;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ShareSchemePlugin
extends AbstractBillPlugIn
implements SelectRowsEventListener,
TabSelectListener {
    private static final String TABAP = "tabap";
    private static final String CURRENT_TAB = "current_tab";
    private static final String ORG = "org";
    private static final String ITEM_CLOSE = "bar_close";
    private static final String systemType = "taxc-tcret";
    private static final String SEPARATOR = System.getProperty("line.separator");
    private static final String PLANENTITY = "planentity";
    private static final String RULEENTITY = "ruleentity";
    private static final String ORGENTITY = "orgentity";
    private static final String LEASEENTITY = "leaseentity";

    public void initialize() {
        CardEntry planentity = (CardEntry)this.getControl(PLANENTITY);
        planentity.addSelectRowsListener((SelectRowsEventListener)this);
        Tab tab = (Tab)this.getView().getControl(TABAP);
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"flex_addorg", "vector_addorg", "label_addorg", "label_moreorg", "labelcreate", "flex_addlease", "vector_addlease", "label_addlease", "label_morelease"});
        this.addItemClickListeners(new String[]{"advcontoolbarap1"});
        Toolbar toolbarMain = (Toolbar)this.getControl("tbmain");
        toolbarMain.addItemClickListener((ItemClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue(ORG, this.getOrgid(customParams));
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (org == null) {
            Long orgid = PermissionUtils.getDefaultOrgId();
            this.getModel().setValue(ORG, (Object)orgid);
        }
        if ((org = (DynamicObject)this.getModel().getValue(ORG)) != null && !customParams.containsKey("initialized")) {
            String orgId = org.getString("id");
            HashMap<String, Object> custom = new HashMap<String, Object>();
            custom.put("orgid", orgId);
            custom.put("initialized", Boolean.TRUE);
            QFilter filter = new QFilter(ORG, "=", (Object)Long.parseLong(orgId));
            DynamicObject plan = QueryServiceHelper.queryOne((String)"tcret_edit_sharingscheme", (String)"id", (QFilter[])new QFilter[]{filter});
            if (plan != null) {
                this.showBill(plan.getLong("id"), custom);
            } else {
                this.showBill(null, custom);
            }
        }
    }

    public Object getOrgid(Map<String, Object> customParams) {
        Object orgId = customParams.get("orgid");
        if (orgId != null) {
            return orgId;
        }
        return "";
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            if (org != null && !TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).isSuccess()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"ShareSchemePlugin_0", (String)systemType, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection planentity = this.getModel().getEntryEntity(PLANENTITY);
            HashSet<String> planMap = new HashSet<String>(planentity.size());
            for (int row = 0; row < planentity.size(); ++row) {
                String errMsg;
                this.getModel().setEntryCurrentRowIndex(PLANENTITY, row);
                int orgCount = this.getModel().getEntryRowCount(ORGENTITY);
                int leaseCount = this.getModel().getEntryRowCount(LEASEENTITY);
                String planName = ((DynamicObject)planentity.get(row)).getString("name");
                if (planMap.contains(planName)) {
                    errMsg = String.format(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\uff08%s\uff09\u91cd\u590d\uff0c\u8bf7\u8bbe\u7f6e\u4e0d\u540c\u7684\u65b9\u6848\u540d\u79f0\u3002", (String)"ShareSchemePlugin_1", (String)systemType, (Object[])new Object[0]), planName);
                    this.getView().showErrorNotification(errMsg);
                    args.setCancel(true);
                    return;
                }
                planMap.add(planName);
                if (orgCount == 0) {
                    errMsg = String.format(ResManager.loadKDString((String)"\u65b9\u6848\uff08%s\uff09\u914d\u7f6e\u6709\u8bef\uff0c\u88ab\u5171\u4eab\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u88ab\u5171\u4eab\u7ec4\u7ec7\u3002", (String)"ShareSchemePlugin_2", (String)systemType, (Object[])new Object[0]), planName);
                    this.getView().showErrorNotification(errMsg);
                    args.setCancel(true);
                    return;
                }
                if (leaseCount == 0) {
                    errMsg = String.format(ResManager.loadKDString((String)"\u65b9\u6848\uff08%s\uff09\u914d\u7f6e\u6709\u8bef\uff0c\u9002\u7528\u79df\u8d41\u9879\u76ee\u4e3a\u7a7a\uff0c\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u9002\u7528\u79df\u8d41\u9879\u76ee\u3002", (String)"ShareSchemePlugin_3", (String)systemType, (Object[])new Object[0]), planName);
                    this.getView().showErrorNotification(errMsg);
                    args.setCancel(true);
                    return;
                }
                DynamicObjectCollection ruleentity = this.getModel().getEntryEntity(RULEENTITY);
                if (ruleentity.size() != 0) continue;
                String errMsg2 = String.format(ResManager.loadKDString((String)"\u65b9\u6848\uff08%s\uff09\u914d\u7f6e\u6709\u8bef\uff0c\u5171\u4eab\u89c4\u5219\u4e3a\u7a7a\uff0c\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u5171\u4eab\u89c4\u5219\u3002", (String)"ShareSchemePlugin_4", (String)systemType, (Object[])new Object[0]), planName);
                this.getView().showErrorNotification(errMsg2);
                args.setCancel(true);
                return;
            }
            EntryGrid planentitys = (EntryGrid)this.getControl(PLANENTITY);
            int[] selectRows = planentitys.getSelectRows();
            if (selectRows.length > 0) {
                int planIndex = selectRows[0];
                this.getModel().setEntryCurrentRowIndex(PLANENTITY, planIndex);
            }
        } else if (args.getSource() instanceof Refresh) {
            this.getPageCache().put("refresh", "true");
        } else if (args.getSource() instanceof DeleteEntry) {
            String msg;
            HashMap<Integer, String> btnNameMaps;
            ConfirmCallBackListener confirmCallBacks;
            EntryGrid entrye;
            DeleteEntry deleteEntry = (DeleteEntry)args.getSource();
            if ("deleteorg".equals(deleteEntry.getOperateKey())) {
                args.setCancel(true);
                entrye = (EntryGrid)this.getControl(ORGENTITY);
                entrye.getSelectRows();
                String orgName = this.getModel().getEntryRowEntity(ORGENTITY, entrye.getSelectRows()[0]).getString("orgid.name");
                confirmCallBacks = new ConfirmCallBackListener("orgDeleteConform", (IFormPlugin)this);
                btnNameMaps = new HashMap<Integer, String>();
                btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"ShareSchemePlugin_5", (String)systemType, (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"ShareSchemePlugin_6", (String)systemType, (Object[])new Object[0]));
                msg = String.format(ResManager.loadKDString((String)"\u662f\u5426\u5c06\u201c%1$s\u201d\u53ca\u5176\u5bf9\u5e94\u7684\u79df\u8d41\u9879\u76ee\u4ece\u201c%2$s\u201d\u89c4\u5219\u4e2d\u5254\u9664\uff1f", (String)"ShareSchemePlugin_7", (String)systemType, (Object[])new Object[0]), orgName, this.getModel().getValue("planname"));
                this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
            }
            if ("deletelease".equals(deleteEntry.getOperateKey())) {
                args.setCancel(true);
                entrye = (EntryGrid)this.getControl(LEASEENTITY);
                entrye.getSelectRows();
                String leaseNo = this.getModel().getEntryRowEntity(LEASEENTITY, entrye.getSelectRows()[0]).getString("leaseid.number");
                confirmCallBacks = new ConfirmCallBackListener("leaseDeleteConform", (IFormPlugin)this);
                btnNameMaps = new HashMap();
                btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"ShareSchemePlugin_5", (String)systemType, (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"ShareSchemePlugin_6", (String)systemType, (Object[])new Object[0]));
                msg = String.format(ResManager.loadKDString((String)"\u662f\u5426\u5c06\u201c%1$s\u201d\u4ece\u201c%2$s\u201d\u89c4\u5219\u4e2d\u5254\u9664\uff1f", (String)"ShareSchemePlugin_8", (String)systemType, (Object[])new Object[0]), leaseNo, this.getModel().getValue("planname"));
                this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperateKey().equals("editrule")) {
            if (this.checkPlanNotSelected()) {
                return;
            }
            HashMap<String, Object> custom = new HashMap<String, Object>();
            custom.put(ORG, this.getModel().getValue(ORG));
            custom.put(RULEENTITY, this.getModel().getEntryEntity(RULEENTITY));
            Tab tabap = (Tab)this.getControl(TABAP);
            custom.put(CURRENT_TAB, tabap.getCurrentTab());
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tcret_select_rule", (IFormView)this.getView(), custom, (IFormPlugin)this);
        } else if (args.getSource() instanceof DeleteEntry) {
            DeleteEntry deleteEntry = (DeleteEntry)args.getSource();
            if ("deleteplan".equals(deleteEntry.getOperateKey())) {
                DynamicObject dynamicObject = this.getModel().getDataEntity(true);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            }
        } else if (args.getOperateKey().equals("refresh") && "true".equals(this.getPageCache().get("refresh"))) {
            this.getPageCache().put("refresh", "false");
        }
        this.setVisible();
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        List newRows = evt.getNewRows();
        if (newRows != null && newRows.size() > 0) {
            Integer startRowIndex = (Integer)newRows.get(0);
            this.resetPlanName(startRowIndex);
            Tab tab = (Tab)this.getControl(TABAP);
            tab.selectTab(tab.getCurrentTab());
        }
        this.updateAddLableName();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (ORG.equals(e.getProperty().getName())) {
            this.getModel().setDataChanged(false);
            HashMap<String, Object> custom = new HashMap<String, Object>();
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            if (org != null) {
                String orgid = org.getString("id");
                custom.put("orgid", orgid);
                QFilter filter = new QFilter(ORG, "=", (Object)Long.parseLong(orgid));
                DynamicObject plan = QueryServiceHelper.queryOne((String)"tcret_edit_sharingscheme", (String)"id", (QFilter[])new QFilter[]{filter});
                if (plan != null) {
                    this.showBill(plan.getLong("id"), custom);
                } else {
                    this.showBill(null, custom);
                }
            }
        } else if ("planname".equals(e.getProperty().getName())) {
            CardEntry planentity = (CardEntry)this.getControl(PLANENTITY);
            int[] selectRows = planentity.getSelectRows();
            if (selectRows.length > 0 && !"true".equals(this.getPageCache().get("refresh"))) {
                this.getModel().setValue("name", e.getChangeSet()[0].getNewValue(), selectRows[0]);
            }
            this.updateAddLableName();
        } else if ("orgid".equals(e.getProperty().getName())) {
            this.updateAddLableName();
        }
    }

    private void showBill(Object pkId, Map<String, Object> customParams) {
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        billShowParameter.getCustomParams().putAll(customParams);
        if (pkId != null) {
            billShowParameter.setPkId(pkId);
            this.getModel().setValue("id", pkId);
            billShowParameter.setBillStatus(BillOperationStatus.EDIT);
            billShowParameter.setStatus(OperationStatus.EDIT);
        } else {
            billShowParameter.setBillStatus(BillOperationStatus.ADDNEW);
            billShowParameter.setStatus(OperationStatus.ADDNEW);
        }
        this.getView().invokeOperation("refresh");
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        if (e.getEntryProp().getName().equals(PLANENTITY)) {
            CardEntry planentity = (CardEntry)this.getControl(PLANENTITY);
            RowDataEntity[] rowDataEntities = e.getRowDataEntities();
            if (rowDataEntities != null && rowDataEntities.length > 0) {
                int rowIndex = rowDataEntities[0].getRowIndex();
                planentity.selectCard(Integer.valueOf(rowIndex));
                planentity.selectRowsChanged(Collections.singletonList(rowIndex), null);
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        if (e.getEntryProp().getName().equals(PLANENTITY)) {
            this.resetPlanName(e.getRowIndexs()[0] - 1);
            this.refreshRuleList("fcczzj");
            this.updateAddLableName();
        }
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Vector && "vector_addorg".equals(((Vector)source).getKey()) || source instanceof Label && "label_addorg".equals(((Label)source).getKey()) || source instanceof Label && "label_moreorg".equals(((Label)source).getKey()) || source instanceof Container && "flex_addorg".equals(((Container)source).getKey())) {
            if (this.checkPlanNotSelected()) {
                return;
            }
            this.showOrgSelect();
        } else if (source instanceof Label && "labelcreate".equals(((Label)source).getKey())) {
            Button button = (Button)this.getControl("button_addplan");
            button.click();
        } else if (source instanceof Vector && "vector_addlease".equals(((Vector)source).getKey()) || source instanceof Label && "label_addlease".equals(((Label)source).getKey()) || source instanceof Label && "label_morelease".equals(((Label)source).getKey()) || source instanceof Container && "flex_addlease".equals(((Container)source).getKey())) {
            if (this.checkPlanNotSelected()) {
                return;
            }
            this.showLeaseSelect();
        }
    }

    private void showLeaseSelect() {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"tdm_house_rental_info", (boolean)true, (int)2);
        parameter.setCaption(ResManager.loadKDString((String)"\u623f\u4ea7\u51fa\u79df\u4fe1\u606f", (String)"ShareSchemePlugin_9", (String)systemType, (Object[])new Object[0]));
        Optional<DynamicObject> optional = this.getModel().getEntryEntity(PLANENTITY).stream().filter(s -> this.isCurrentSelect(s.getInt("seq") - 1)).findFirst();
        ListSelectedRowCollection listSelectedRowCollection = new ListSelectedRowCollection();
        if (optional.isPresent()) {
            DynamicObject planentity = optional.get();
            DynamicObjectCollection leaseEntity = planentity.getDynamicObjectCollection(LEASEENTITY);
            for (DynamicObject entity : leaseEntity) {
                ListSelectedRow row = new ListSelectedRow();
                DynamicObject lease = entity.getDynamicObject("leaseid");
                row.setName(lease.getString("name"));
                row.setNumber(lease.getString("number"));
                row.setPrimaryKeyValue(lease.get("id"));
                listSelectedRowCollection.add((Object)row);
            }
        }
        parameter.setListSelectedRowCollection(listSelectedRowCollection);
        DynamicObjectCollection orgEntitys = this.getModel().getEntryEntity(ORGENTITY);
        if (orgEntitys.size() <= 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u88ab\u5171\u4eab\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"ShareSchemePlugin_10", (String)systemType, (Object[])new Object[0]));
            return;
        }
        List orgids = orgEntitys.stream().map(e -> e.getDynamicObject("orgid").getLong("id")).collect(Collectors.toList());
        List filters = parameter.getListFilterParameter().getQFilters();
        filters.add(new QFilter(ORG, "in", orgids));
        filters.add(new QFilter("enable", "in", (Object)"1"));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectLease"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        ListSelectedRowCollection leases;
        if ("selectorg".equals(evt.getActionId())) {
            ListSelectedRowCollection orgs = (ListSelectedRowCollection)evt.getReturnData();
            if (orgs != null) {
                EntryGrid planentity = (EntryGrid)this.getControl(PLANENTITY);
                int[] selectRows = planentity.getSelectRows();
                int planIndex = selectRows[0];
                this.getModel().setEntryCurrentRowIndex(PLANENTITY, planIndex);
                this.getModel().beginInit();
                this.getModel().deleteEntryData(ORGENTITY);
                for (ListSelectedRow selectedRow : orgs) {
                    int index = this.getModel().createNewEntryRow(ORGENTITY);
                    this.getModel().setValue("orgid", selectedRow.getPrimaryKeyValue(), index, planIndex);
                }
                this.getModel().endInit();
                this.getView().updateView(ORGENTITY);
            }
        } else if ("tcret_select_rule".equals(evt.getActionId())) {
            EntryGrid planentity;
            int[] rows;
            Map idmap = (Map)evt.getReturnData();
            if (idmap != null && (rows = (planentity = (EntryGrid)this.getControl(PLANENTITY)).getSelectRows()) != null && rows.length > 0) {
                int planindex = rows[0];
                this.getModel().beginInit();
                this.getModel().deleteEntryData(RULEENTITY);
                for (Map.Entry entry : idmap.entrySet()) {
                    Object[] value;
                    String type = (String)entry.getKey();
                    for (Object id : value = (Object[])entry.getValue()) {
                        int ruleindex = this.getModel().createNewEntryRow(RULEENTITY);
                        this.getModel().setValue("type", (Object)type, ruleindex, planindex);
                        this.getModel().setValue("ruleid", id, ruleindex, planindex);
                    }
                }
                this.getModel().endInit();
                this.getView().updateView(RULEENTITY);
                this.refreshRuleList("fcczzj");
            }
        } else if ("selectLease".equals(evt.getActionId()) && (leases = (ListSelectedRowCollection)evt.getReturnData()) != null) {
            EntryGrid planentity = (EntryGrid)this.getControl(PLANENTITY);
            int[] selectRows = planentity.getSelectRows();
            int planIndex = selectRows[0];
            this.getModel().setEntryCurrentRowIndex(PLANENTITY, planIndex);
            this.getModel().beginInit();
            this.getModel().deleteEntryData(LEASEENTITY);
            for (ListSelectedRow selectedRow : leases) {
                int index = this.getModel().createNewEntryRow(LEASEENTITY);
                this.getModel().setValue("leaseid", selectedRow.getPrimaryKeyValue(), index, planIndex);
            }
            this.getModel().endInit();
            this.getView().updateView(LEASEENTITY);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        EntryGrid entrye;
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((String)"orgDeleteConform", (String)callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                entrye = (EntryGrid)this.getControl(ORGENTITY);
                int[] selectRows = entrye.getSelectRows();
                long deleteOrgid = this.getModel().getEntryRowEntity(ORGENTITY, selectRows[0]).getDynamicObject("orgid").getLong("id");
                DynamicObjectCollection leaseentity = this.getModel().getEntryEntity(LEASEENTITY);
                int[] rows = leaseentity.stream().filter(e -> e.getDynamicObject("leaseid").getLong("org.id") == deleteOrgid).map(e -> e.getInt("seq")).mapToInt(i -> i - 1).toArray();
                this.getModel().deleteEntryRows(LEASEENTITY, rows);
                this.getModel().deleteEntryRows(ORGENTITY, selectRows);
                this.updateAddLableName();
            } else if (MessageBoxResult.Cancel.equals((Object)messageBoxClosedEvent.getResult())) {
                return;
            }
        }
        if ("leaseDeleteConform".equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                entrye = (EntryGrid)this.getControl(LEASEENTITY);
                this.getModel().deleteEntryRows(LEASEENTITY, entrye.getSelectRows());
                this.updateAddLableName();
            } else if (MessageBoxResult.Cancel.equals((Object)messageBoxClosedEvent.getResult())) {
                return;
            }
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)callBackId, (CharSequence)ITEM_CLOSE) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getView().close();
        }
    }

    private void showOrgSelect() {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"bos_org", (boolean)true, (int)2);
        parameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u88ab\u5171\u4eab\u7ec4\u7ec7", (String)"ShareSchemePlugin_11", (String)systemType, (Object[])new Object[0]));
        Optional<DynamicObject> optional = this.getModel().getEntryEntity(PLANENTITY).stream().filter(s -> this.isCurrentSelect(s.getInt("seq") - 1)).findFirst();
        ListSelectedRowCollection listSelectedRowCollection = new ListSelectedRowCollection();
        if (optional.isPresent()) {
            DynamicObject planentity = optional.get();
            DynamicObjectCollection orgEntity = planentity.getDynamicObjectCollection(ORGENTITY);
            for (DynamicObject entity : orgEntity) {
                ListSelectedRow row = new ListSelectedRow();
                DynamicObject org = entity.getDynamicObject("orgid");
                row.setName(org.getString("name"));
                row.setNumber(org.getString("number"));
                row.setPrimaryKeyValue(org.get("id"));
                listSelectedRowCollection.add((Object)row);
            }
        }
        parameter.setListSelectedRowCollection(listSelectedRowCollection);
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (org == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"ShareSchemePlugin_12", (String)systemType, (Object[])new Object[0]));
            return;
        }
        List filters = parameter.getListFilterParameter().getQFilters();
        ArrayList<Long> orgList = new ArrayList<Long>();
        orgList.add(org.getLong("id"));
        List subOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)OrgUtils.getLocalDefaultViewId(), orgList, (boolean)true);
        filters.add(new QFilter("id", "in", (Object)subOrgIds.toArray()));
        filters.add(new QFilter("id", "in", TaxcMainDataServiceHelper.queryTaxcMainOrgIds().getData()));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectorg"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    private boolean isCurrentSelect(int row) {
        EntryGrid planentity = (EntryGrid)this.getControl(PLANENTITY);
        int[] rows = planentity.getSelectRows();
        return Arrays.stream(rows).allMatch(s -> s == row);
    }

    private boolean checkPlanNotSelected() {
        EntryGrid planentity = (EntryGrid)this.getControl(PLANENTITY);
        int[] selectedRows = planentity.getSelectRows();
        if (selectedRows == null || selectedRows.length == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5171\u4eab\u65b9\u6848\u88ab\u9009\u4e2d\uff0c\u8bf7\u5148\u6dfb\u52a0\u5171\u4eab\u65b9\u6848\u3002", (String)"ShareSchemePlugin_13", (String)systemType, (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void beforeBindData(EventObject e) {
        this.resetPlanName(0);
        DynamicObjectCollection entity = this.getModel().getEntryEntity(RULEENTITY);
        this.setFilter(entity, "fcczzj");
    }

    public void afterBindData(EventObject e) {
        CardEntry planentity = (CardEntry)this.getControl(PLANENTITY);
        planentity.selectCard(Integer.valueOf(0));
        planentity.selectRowsChanged(Collections.singletonList(0), null);
        this.updateAddLableName();
        this.setVisible();
    }

    private void updateAddLableName() {
        DynamicObjectCollection orgEntity = this.getModel().getEntryEntity(ORGENTITY);
        if (null == orgEntity || orgEntity.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"label_moreorg"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"label_addorg"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"label_moreorg"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"label_addorg"});
        }
        DynamicObjectCollection leaseEntity = this.getModel().getEntryEntity(LEASEENTITY);
        if (null == leaseEntity || leaseEntity.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"label_morelease"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"label_addlease"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"label_morelease"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"label_addlease"});
        }
    }

    private void setVisible() {
        int row = this.getModel().getEntryRowCount(PLANENTITY);
        if (row > 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexnodata", "planflex"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexdata", PLANENTITY});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexnodata", "planflex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexdata", PLANENTITY});
        }
    }

    private void resetPlanName(Integer startRowIndex) {
        DynamicObject[] planentities;
        if (-1 == startRowIndex) {
            startRowIndex = 0;
        }
        if ((planentities = this.getModel().getEntryEntity(PLANENTITY, startRowIndex.intValue(), startRowIndex + 1)) != null && planentities.length > 0) {
            this.getModel().setValue("planname", (Object)planentities[0].getString("name"));
        } else {
            this.getModel().setValue("planname", (Object)"");
        }
    }

    private void setFilter(DynamicObjectCollection entity, String type) {
        BillList list = (BillList)this.getControl(type + "list");
        ListFilterParameter filterParameter = new ListFilterParameter();
        ArrayList<Long> ids = new ArrayList<Long>();
        if (entity != null) {
            for (DynamicObject object : entity) {
                if (!type.equals(object.getString("type"))) continue;
                ids.add(object.getLong("ruleid"));
            }
        }
        QFilter idsFilter = new QFilter("id", "in", ids);
        filterParameter.setFilter(idsFilter);
        list.setFilterParameter((FilterParameter)filterParameter);
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        EntryGrid planentity = (EntryGrid)this.getControl(PLANENTITY);
        int[] rows = planentity.getSelectRows();
        if (rows == null || rows.length == 0) {
            return;
        }
        if (tabKey.equals("fcczzjruletab")) {
            this.refreshRuleList("fcczzj");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String resultMsg;
        if (StringUtil.equalsIgnoreCase((CharSequence)evt.getItemKey(), (CharSequence)ITEM_CLOSE) && StringUtil.isNotBlank((CharSequence)(resultMsg = this.checkChangeData()))) {
            evt.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(ITEM_CLOSE, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"ShareSchemePlugin_14", (String)systemType, (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"ShareSchemePlugin_15", (String)systemType, (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.YesNo;
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"ShareSchemePlugin_16", (String)systemType, (Object[])new Object[0]);
            this.getView().showConfirm(msg, resultMsg, options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
        }
    }

    private String checkChangeData() {
        DynamicObjectCollection planCollection = this.getModel().getEntryEntity(PLANENTITY);
        if (planCollection.isEmpty()) {
            return "";
        }
        StringBuilder msg = new StringBuilder();
        for (DynamicObject newPlan : planCollection) {
            String name;
            StringBuilder words = new StringBuilder();
            String newName = newPlan.getString("name");
            DynamicObject oldPlan = BusinessDataServiceHelper.loadSingle((String)"tcret_sharingscheme", (String)"id,name,autoshar,creator,createtime,ruleentity,ruleentity.ruleid,ruleentity.id,orgentity,orgentity.orgid,orgentity.id,leaseentity,leaseentity.id,leaseentity.leaseid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)newPlan.getLong("id"))});
            if (ObjectUtils.isEmpty((Object)oldPlan)) {
                String name2 = String.format(ResManager.loadKDString((String)"\u5171\u4eab\u65b9\u6848\uff08%s\uff09\u4e3a\u65b0\u589e\u65b9\u6848\u8fd8\u672a\u4fdd\u5b58\uff01", (String)"ShareSchemePlugin_17", (String)systemType, (Object[])new Object[0]), newName);
                if (StringUtil.isBlank((CharSequence)msg)) {
                    msg.append(name2);
                    continue;
                }
                msg.append(SEPARATOR).append(name2);
                continue;
            }
            List ruleEntityList = oldPlan.getDynamicObjectCollection(RULEENTITY).stream().map(o -> o.getString("ruleid")).collect(Collectors.toList());
            List orgEntityList = oldPlan.getDynamicObjectCollection(ORGENTITY).stream().map(o -> o.getString("orgid_id")).collect(Collectors.toList());
            List leaseEntityList = oldPlan.getDynamicObjectCollection(LEASEENTITY).stream().map(o -> o.getString("leaseid")).collect(Collectors.toList());
            String oldName = oldPlan.getString("name");
            ArrayList ruleList = new ArrayList();
            ArrayList orgList = new ArrayList();
            ArrayList leaseList = new ArrayList();
            DynamicObjectCollection ruleCol = newPlan.getDynamicObjectCollection(RULEENTITY);
            ruleCol.stream().forEach(ruleRow -> ruleList.add(ruleRow.getString("ruleid")));
            DynamicObjectCollection orgCol = newPlan.getDynamicObjectCollection(ORGENTITY);
            orgCol.stream().forEach(orgRow -> orgList.add(orgRow.getDynamicObject("orgid").getString("id")));
            DynamicObjectCollection leaseCol = newPlan.getDynamicObjectCollection(LEASEENTITY);
            leaseCol.stream().forEach(leaseRow -> leaseList.add(leaseRow.getDynamicObject("leaseid").getString("id")));
            if (!newName.equals(oldName)) {
                name = ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0", (String)"ShareSchemePlugin_18", (String)systemType, (Object[])new Object[0]);
                words.append(name).append(",");
            }
            if (!CollectionUtils.isEqualCollection(orgList, orgEntityList)) {
                name = ResManager.loadKDString((String)"\u88ab\u5171\u4eab\u8303\u56f4", (String)"ShareSchemePlugin_19", (String)systemType, (Object[])new Object[0]);
                words.append(name).append(",");
            }
            if (!CollectionUtils.isEqualCollection(leaseList, leaseEntityList)) {
                name = ResManager.loadKDString((String)"\u9002\u7528\u79df\u8d41\u9879\u76ee", (String)"ShareSchemePlugin_20", (String)systemType, (Object[])new Object[0]);
                words.append(name).append(",");
            }
            if (!CollectionUtils.isEqualCollection(ruleList, ruleEntityList)) {
                name = ResManager.loadKDString((String)"\u5171\u4eab\u89c4\u5219\u5361\u7247", (String)"ShareSchemePlugin_21", (String)systemType, (Object[])new Object[0]);
                words.append(name).append(",");
            }
            name = String.format(ResManager.loadKDString((String)"\u5171\u4eab\u65b9\u6848\uff08%s\uff09\u53d8\u66f4\u5b57\u6bb5\uff1a", (String)"ShareSchemePlugin_22", (String)systemType, (Object[])new Object[0]), newName);
            if (!StringUtil.isNotBlank((CharSequence)words)) continue;
            words.deleteCharAt(words.lastIndexOf(","));
            if (StringUtil.isBlank((CharSequence)msg)) {
                msg.append(name).append((CharSequence)words);
                continue;
            }
            msg.append(SEPARATOR).append(name).append((CharSequence)words);
        }
        return msg.toString();
    }

    private void refreshRuleList(String type) {
        BillList list = (BillList)this.getControl(type + "list");
        ListFilterParameter filterParameter = new ListFilterParameter();
        ArrayList<Long> ids = new ArrayList<Long>();
        DynamicObjectCollection entity = this.getModel().getEntryEntity(RULEENTITY);
        if (entity != null) {
            for (DynamicObject object : entity) {
                if (!type.equals(object.getString("type"))) continue;
                ids.add(object.getLong("ruleid"));
            }
        }
        QFilter idsFilter = new QFilter("id", "in", ids);
        filterParameter.setFilter(idsFilter);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        filterParameter.setFilter(enableFilter);
        list.setFilterParameter((FilterParameter)filterParameter);
        list.refreshData();
    }
}

