/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.taxsource;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.license.plugin.common.AbstractLicenseCheckBillPlugin;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.tcret.business.taxsource.YhsTaxSourceServiceHelper;

public class GenerateSbbDialogPlugin
extends AbstractLicenseCheckBillPlugin {
    private static final String ORG = "org";
    private static final String TAXOFFICE = "taxoffice";
    private static final String DECLAREDATE = "declaredate";
    private static final String FIELDS = "taxitem,subtaxitem,skssqq,skssqz,declaretype,taxation,verifybasis,ynse,deductioncode";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        TaxResult taxResult = TaxcCombineDataServiceHelper.queryTaxcMainOrgIdByIsTaxpayerWithPerm((Long)RequestContext.get().getCurrUserId());
        List orgIds = (List)taxResult.getData();
        if (EmptyCheckUtils.isEmpty((Object)orgIds)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599\u8fdb\u884c\u914d\u7f6e\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"GenerateSbbDialogPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]));
            return;
        }
        Long orgId = RequestContext.get().getOrgId();
        if (!orgIds.contains(orgId)) {
            orgId = (Long)orgIds.get(0);
        }
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgId);
        this.getModel().setValue(ORG, (Object)orgId);
        if (result.getData() != null) {
            DynamicObject taxoffice = ((DynamicObject)result.getData()).getDynamicObject(TAXOFFICE);
            this.getModel().setValue(TAXOFFICE, (Object)taxoffice);
            this.refreshEntryEntity();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (ORG.equals(name)) {
            boolean notAuthorize;
            long orgId;
            DynamicObject org = (DynamicObject)e.getChangeSet()[0].getNewValue();
            long l = orgId = org != null ? org.getLong("id") : 0L;
            if (org != null && (notAuthorize = LicenseCheckServiceHelper.check((Object)orgId, (IFormView)this.getView(), (String)"tcret"))) {
                this.getModel().setValue(ORG, null);
                this.getModel().setValue(TAXOFFICE, null);
                return;
            }
            DynamicObject taxMain = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgId).getData();
            if (taxMain != null) {
                this.getModel().setValue(TAXOFFICE, taxMain.get(TAXOFFICE));
            } else {
                this.getModel().setValue(TAXOFFICE, null);
            }
            this.refreshEntryEntity();
        } else if (TAXOFFICE.equals(name) || DECLAREDATE.equals(name)) {
            this.refreshEntryEntity();
        }
    }

    private void refreshEntryEntity() {
        DynamicObject entity = this.getModel().getDataEntity();
        long orgId = entity.getLong("org_id");
        long taxofficeId = entity.getLong("taxoffice_id");
        Date declaredate = entity.getDate(DECLAREDATE);
        List<DynamicObject> dynamicObjects = YhsTaxSourceServiceHelper.queryYhsTaxSource(orgId, taxofficeId, declaredate);
        this.getModel().deleteEntryData("entryentity");
        this.getModel().beginInit();
        for (DynamicObject dynamicObject : dynamicObjects) {
            int row = this.getModel().createNewEntryRow("entryentity");
            for (String field : FIELDS.split(",")) {
                this.getModel().setValue(field, dynamicObject.get(field), row);
            }
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    public void click(EventObject evt) {
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        if (rowCount == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5370\u82b1\u7a0e\u7a0e\u6e90\u4e2d\u53ef\u4f9b\u7533\u62a5\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u751f\u6210\u7533\u62a5\u8868\u3002", (String)"GenerateSbbDialogPlugin_1", (String)"taxc-tcret", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> custom = new HashMap<String, Object>();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        custom.put("orgid", dataEntity.getString("org_id"));
        custom.put(TAXOFFICE, dataEntity.getString("taxoffice_id"));
        custom.put("declaremonth", dataEntity.getDate(DECLAREDATE));
        this.getView().returnDataToParent(custom);
        this.getView().close();
        String operateName = ResManager.loadKDString((String)"\u786e\u5b9a", (String)"GenerateSbbDialogPlugin_2", (String)"taxc-tcret", (Object[])new Object[0]);
        String operateDescription = ResManager.loadKDString((String)"\u751f\u6210\u7533\u62a5\u8868\u6210\u529f", (String)"GenerateSbbDialogPlugin_3", (String)"taxc-tcret", (Object[])new Object[0]);
        OperatorDialogUtils.operateDialog((String)"ccxws", (String)"tcret_yhs_tax_source_info", (String)operateName, (String)operateDescription);
    }
}

