/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.taxsource;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.FieldTip;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class TaxSourceTZDetailFormPlugin
extends AbstractFormPlugin
implements SelectRowsEventListener {
    private static final String ORG = "org";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String ACCOUNTORG = "accountorg";
    private static final String BIZDIMENSIONID = "bizdimensionid";
    private static final String RULEID = "ruleid";
    private static final String ENTRYENTITY_CARD = "entryentitycard";
    private static final String ENTRYENTITY_LIST = "entryentitylist";
    private static final String TCRET_YSH_TAX_SOURCE_DE = "tcret_ysh_tax_source_de";
    private static final String SERIALNO = "serialno";
    private static final String TCRET_SYCJ_ADJUST_DETAIL = "tcret_sycj_adjust_detail";
    private static final HashMap<String, String> ruleTypeMap = new HashMap();
    private static final String TCRET_YHS_TAX_ACCOUNT = "tcret_yhs_tax_account";

    public void initialize() {
        CardEntry entryentitycard = (CardEntry)this.getControl(ENTRYENTITY_CARD);
        entryentitycard.addSelectRowsListener((SelectRowsEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (!PermissionUtils.hasSpecificPerm((IFormView)this.getView().getParentView(), (String)"4715a0df000000ac")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"btnok"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"btnok"});
        }
        Object btclose = customParams.get("btclose");
        if (Objects.nonNull(btclose) && ((Boolean)btclose).booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btncancel", "btnok"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btclose"});
        }
        String serialno = (String)customParams.get(SERIALNO);
        DynamicObject[] adjustDetails = this.getAdjustData(customParams);
        DynamicObject[] genericObjects = this.loadDetailData(customParams);
        if (genericObjects.length == 0) {
            this.appendCard(serialno, adjustDetails, null);
            return;
        }
        Map<String, List<DynamicObject>> map = Arrays.stream(genericObjects).sorted(Comparator.comparing(d -> d.getLong("id"))).collect(Collectors.groupingBy(s -> s.getString(RULEID)));
        this.getModel().beginInit();
        for (Map.Entry<String, List<DynamicObject>> entry : map.entrySet()) {
            int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY_CARD);
            DynamicObject detail = entry.getValue().get(0);
            String ruleEntity = ruleTypeMap.get(detail.getString("type"));
            DynamicObject rule = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(detail.getString(RULEID)), (String)ruleEntity);
            this.getModel().setValue(RULEID, detail.get(RULEID), rowIndex);
            this.getModel().setValue("titlename", (Object)rule.getString("name"), rowIndex);
            this.getModel().setValue("taxitem", (Object)rule.getDynamicObject("taxitem").getString("name"), rowIndex);
            this.getModel().setValue(SERIALNO, (Object)serialno, rowIndex);
            this.getModel().setValue("amount", (Object)this.getAmount(detail.getString(RULEID), entry.getValue()), rowIndex);
            this.getModel().setValue("adjustamount", (Object)this.getAdjustamount(detail.getString(RULEID), serialno, adjustDetails), rowIndex);
            this.getModel().setValue("totalamount", (Object)this.getTotalamount(detail, serialno, adjustDetails, entry.getValue()), rowIndex);
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY_CARD);
        this.appendCard(serialno, adjustDetails, genericObjects);
        Map.Entry first = (Map.Entry)map.entrySet().stream().findFirst().get();
        this.clearEntry(ENTRYENTITY_LIST);
        this.setEntryentitylist((String)first.getKey());
    }

    private DynamicObject[] getAdjustData(Map<String, Object> customParams) {
        String selectPrope = "serialno,ruleid,adjustamount,totalamount";
        Object orgid = customParams.get(ORG);
        QFilter orgFilter = new QFilter(ORG, "=", (Object)Long.parseLong((String)orgid));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        QFilter startFilter = new QFilter(SKSSQQ, "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter endFilter = new QFilter(SKSSQZ, "=", (Object)skssqz);
        String serialno = (String)customParams.get(SERIALNO);
        QFilter serialnoFilter = new QFilter(SERIALNO, "=", (Object)serialno);
        QFilter[] filters = new QFilter[]{orgFilter, startFilter, endFilter, serialnoFilter};
        return BusinessDataServiceHelper.load((String)TCRET_SYCJ_ADJUST_DETAIL, (String)selectPrope, (QFilter[])filters);
    }

    private DynamicObject[] loadDetailData(Map<String, Object> customParams) {
        String selectProperties = "type,ruleid,serialno,skssqq,table,amountfield,datatype,datadirection,amount,fetchamount,filtercondition";
        List<QFilter> qFilters = this.buildQFilters(customParams);
        return BusinessDataServiceHelper.load((String)TCRET_YSH_TAX_SOURCE_DE, (String)selectProperties, (QFilter[])qFilters.toArray(new QFilter[0]));
    }

    private List<QFilter> buildQFilters(Map<String, Object> customParams) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        Object orgid = customParams.get(ORG);
        QFilter orgFilter = new QFilter(ORG, "=", (Object)Long.parseLong((String)orgid));
        qFilters.add(orgFilter);
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        QFilter startFilter = new QFilter(SKSSQQ, "=", (Object)skssqq);
        qFilters.add(startFilter);
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter endFilter = new QFilter(SKSSQZ, "=", (Object)skssqz);
        qFilters.add(endFilter);
        String serialno = (String)customParams.get(SERIALNO);
        QFilter serialnoFilter = new QFilter(SERIALNO, "=", (Object)serialno);
        qFilters.add(serialnoFilter);
        String accoutorg = (String)customParams.get(ACCOUNTORG);
        if (EmptyCheckUtils.isNotEmpty((Object)accoutorg)) {
            QFilter accountorgFilter = new QFilter(ACCOUNTORG, "=", (Object)Long.parseLong(accoutorg));
            qFilters.add(accountorgFilter);
        }
        String bizdimensionid = (String)customParams.get(BIZDIMENSIONID);
        QFilter bizdimensionidFilter = new QFilter(BIZDIMENSIONID, "=", (Object)bizdimensionid);
        qFilters.add(bizdimensionidFilter);
        return qFilters;
    }

    private Object calcAdjustsumamount() {
        DynamicObjectCollection entryentitycard = this.getModel().getEntryEntity(ENTRYENTITY_CARD);
        BigDecimal totalamount = entryentitycard.stream().map(s -> s.getBigDecimal("totalamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return totalamount;
    }

    private void appendCard(String serialno, DynamicObject[] adjustDetails, DynamicObject[] genericObjects) {
        Optional<DynamicObject> optional = Arrays.stream(adjustDetails).filter(s -> StringUtil.equals((CharSequence)s.getString(RULEID), (CharSequence)"") && s.getString(SERIALNO).equals(serialno)).findFirst();
        DynamicObject dynamicObject = optional.isPresent() ? optional.get() : null;
        int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY_CARD);
        this.getModel().setValue("titlename", (Object)ResManager.loadKDString((String)"\u624b\u5de5\u5f55\u5165\u8c03\u6574\u91d1\u989d", (String)"TaxSourceTZDetailFormPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]), rowIndex);
        this.getModel().setValue(SERIALNO, (Object)serialno, rowIndex);
        this.getModel().setValue("amount", (Object)BigDecimal.ZERO, rowIndex);
        this.getModel().setValue("totalamount", (Object)(dynamicObject != null ? dynamicObject.getBigDecimal("totalamount") : BigDecimal.ZERO), rowIndex);
        this.getModel().setValue("adjustamount", (Object)(dynamicObject != null ? dynamicObject.getBigDecimal("adjustamount") : BigDecimal.ZERO), rowIndex);
        this.getModel().setValue("sumamount", (Object)this.calcSumAmount(genericObjects));
        this.getModel().setValue("adjustsumamount", this.calcAdjustsumamount());
    }

    private BigDecimal getTotalamount(DynamicObject detail, String serialno, DynamicObject[] adjustDetails, List<DynamicObject> genericObjects) {
        String ruleid = detail.getString(RULEID);
        Optional<DynamicObject> optional = Arrays.stream(adjustDetails).filter(s -> StringUtil.equals((CharSequence)s.getString(RULEID), (CharSequence)ruleid) && s.getString(SERIALNO).equals(serialno)).findFirst();
        BigDecimal result = optional.isPresent() ? optional.get().getBigDecimal("totalamount") : this.getAmount(ruleid, genericObjects);
        return result;
    }

    private BigDecimal getAdjustamount(String ruleid, String serialno, DynamicObject[] adjustDetails) {
        Optional<DynamicObject> optional = Arrays.stream(adjustDetails).filter(s -> StringUtil.equals((CharSequence)s.getString(RULEID), (CharSequence)ruleid) && s.getString(SERIALNO).equals(serialno)).findFirst();
        if (optional.isPresent()) {
            return optional.get().getBigDecimal("adjustamount");
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal calcSumAmount(DynamicObject[] genericObjects) {
        if (genericObjects == null || genericObjects.length == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal sum = Arrays.stream(genericObjects).map(s -> s.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return sum.setScale(2, 4);
    }

    private BigDecimal getAmount(String ruleid, List<DynamicObject> genericObjects) {
        BigDecimal sum = genericObjects.stream().filter(s -> StringUtil.equals((CharSequence)s.getString(RULEID), (CharSequence)ruleid)).map(s -> s.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return sum.setScale(2, 4);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Boolean mustPositiveInteger;
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        if ("adjustamount".equals(name) || "totalamount".equals(name) || "otheradjustamount".equals(name)) {
            BigDecimal amount;
            if ("adjustamount".equals(name)) {
                BigDecimal adjustamount = (BigDecimal)changeData.getNewValue();
                amount = (BigDecimal)this.getModel().getValue("amount", rowIndex);
                this.getModel().setValue("totalamount", (Object)adjustamount.add(amount), rowIndex);
            }
            if ("totalamount".equals(name)) {
                BigDecimal totalamount = (BigDecimal)changeData.getNewValue();
                amount = (BigDecimal)this.getModel().getValue("amount", rowIndex);
                this.getModel().setValue("adjustamount", (Object)totalamount.subtract(amount), rowIndex);
            }
            this.refreshAdjustSumAmount();
        } else if ("adjustsumamount".equals(name) && (mustPositiveInteger = (Boolean)this.getView().getFormShowParameter().getCustomParam("mustPositiveInt")) != null && mustPositiveInteger.booleanValue()) {
            String notPositiveIntMsg = (String)this.getView().getFormShowParameter().getCustomParam("notPositiveIntMsg");
            BigDecimal newValue = (BigDecimal)changeData.getNewValue();
            if (newValue.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) != 0) {
                FieldTip tip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, "adjustamount", notPositiveIntMsg);
                this.getView().showFieldTip(tip);
                this.getView().showTipNotification(notPositiveIntMsg);
            } else if (newValue.compareTo(BigDecimal.ZERO) < 0) {
                FieldTip tip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, "adjustamount", notPositiveIntMsg);
                this.getView().showFieldTip(tip);
                this.getView().showTipNotification(notPositiveIntMsg);
            } else {
                FieldTip tip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, "adjustamount", "");
                tip.setSuccess(true);
                this.getView().showFieldTip(tip);
            }
        }
    }

    private void refreshAdjustSumAmount() {
        DynamicObjectCollection entryentitycard = this.getModel().getEntryEntity(ENTRYENTITY_CARD);
        BigDecimal adjustsumamount = entryentitycard.stream().map(s -> s.getBigDecimal("totalamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.getModel().setValue("adjustsumamount", (Object)adjustsumamount);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing && "save".equals(((Donothing)args.getSource()).getOperateKey())) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Object orgid = customParams.get(ORG);
            Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
            Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
            DynamicObjectCollection entryentitycard = this.getModel().getEntryEntity(ENTRYENTITY_CARD);
            ArrayList<DynamicObject> datas = new ArrayList<DynamicObject>();
            if (!CollectionUtils.isEmpty((Collection)entryentitycard)) {
                String serialno = ((DynamicObject)entryentitycard.get(0)).getString(SERIALNO);
                BigDecimal adjustsumamount = (BigDecimal)this.getModel().getValue("adjustsumamount");
                if (BigDecimal.ZERO.compareTo(adjustsumamount) > 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8ba1\u7a0e\u91d1\u989d\u4e0d\u53ef\u4e3a\u8d1f\u6570\uff0c\u8bf7\u4fee\u6539\u3002", (String)"TaxSourceTZDetailFormPlugin_1", (String)"taxc-tcret", (Object[])new Object[0]));
                    return;
                }
                BigDecimal sumamount = (BigDecimal)this.getModel().getValue("sumamount");
                BigDecimal adjustamount = (BigDecimal)this.getModel().getValue("adjustamount");
                if (adjustsumamount.compareTo(sumamount) != 0 || !adjustamount.equals(new BigDecimal("0.00"))) {
                    this.deleteDetail((String)orgid, skssqq, skssqz, serialno);
                    for (DynamicObject dynamicObject : entryentitycard) {
                        DynamicObject object = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TCRET_SYCJ_ADJUST_DETAIL));
                        object.set(RULEID, (Object)dynamicObject.getString(RULEID));
                        object.set(SERIALNO, (Object)dynamicObject.getString(SERIALNO));
                        object.set("titlename", (Object)dynamicObject.getString("titlename"));
                        object.set("taxitem", (Object)dynamicObject.getString("taxitem"));
                        object.set("amount", (Object)dynamicObject.getBigDecimal("amount"));
                        object.set("adjustamount", (Object)dynamicObject.getBigDecimal("adjustamount"));
                        object.set("totalamount", (Object)dynamicObject.getBigDecimal("totalamount"));
                        object.set(ORG, orgid);
                        object.set(SKSSQQ, (Object)skssqq);
                        object.set(SKSSQZ, (Object)skssqz);
                        datas.add(object);
                    }
                    this.updateSummary(adjustsumamount, customParams.get("billid"));
                }
            }
            SaveServiceHelper.save((DynamicObject[])datas.toArray(new DynamicObject[0]));
            this.getView().close();
        }
    }

    private void updateSummary(BigDecimal adjustsumamount, Object billid) {
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)billid, (String)TCRET_YHS_TAX_ACCOUNT);
        if (object != null) {
            object.set("calctaxamount", (Object)adjustsumamount.setScale(2, 4));
            object.set("vouchernum", (Object)(adjustsumamount.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
        }
    }

    private void deleteDetail(String orgid, Object skssqq, Object skssqz, String serialno) {
        DeleteServiceHelper.delete((String)TCRET_SYCJ_ADJUST_DETAIL, (QFilter[])new QFilter[]{new QFilter(SKSSQQ, "=", skssqq).and(new QFilter(SKSSQZ, "=", skssqz)).and(new QFilter(ORG, "=", (Object)Long.valueOf(orgid))).and(new QFilter(SERIALNO, "=", (Object)serialno))});
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        CardEntry cardEntry = (CardEntry)evt.getSource();
        List rows = evt.getNewRows();
        DynamicObjectCollection entryentitycard = this.getModel().getEntryEntity(ENTRYENTITY_CARD);
        if (rows.isEmpty()) {
            return;
        }
        if (entryentitycard.size() - 1 == (Integer)rows.get(0)) {
            return;
        }
        this.clearEntry(ENTRYENTITY_LIST);
        String ruleid = (String)cardEntry.getModel().getValue(RULEID);
        if (ruleid != null) {
            this.setEntryentitylist(ruleid);
        }
    }

    private void clearEntry(String ... entryNames) {
        for (String entry : entryNames) {
            this.getModel().deleteEntryData(entry);
        }
    }

    private void setEntryentitylist(String ruleid) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        QFilter ruleFilter = new QFilter(RULEID, "=", (Object)ruleid);
        List<QFilter> qFilters = this.buildQFilters(customParams);
        qFilters.add(ruleFilter);
        String selectProperties = "skssqq,absolute,bizname,table,datatype,amountfield,datadirection,fetchamount,amount,filtercondition,ruleid,serialno,taxperiod";
        DynamicObjectCollection collection = QueryServiceHelper.query((String)TCRET_YSH_TAX_SOURCE_DE, (String)selectProperties, (QFilter[])qFilters.toArray(new QFilter[0]));
        this.getModel().beginInit();
        for (DynamicObject object : collection) {
            int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY_LIST);
            this.getModel().setValue("taxperiod", object.get("taxperiod"), rowIndex);
            this.getModel().setValue("bizname", object.get("bizname"), rowIndex);
            this.getModel().setValue("table", object.get("table"), rowIndex);
            this.getModel().setValue("amountfield", object.get("amountfield"), rowIndex);
            this.getModel().setValue("datatype", (Object)object.getString("datatype"), rowIndex);
            this.getModel().setValue("absolute", object.get("absolute"), rowIndex);
            this.getModel().setValue("datadirection", object.get("datadirection"), rowIndex);
            this.getModel().setValue("fetchamount", object.get("amount"), rowIndex);
            this.getModel().setValue("filtercondition", object.get("filtercondition"), rowIndex);
            this.getModel().setValue("filtercondition_tag", object.get("filtercondition"), rowIndex);
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY_LIST);
    }

    public void afterBindData(EventObject e) {
        CardEntry entryentitycard = (CardEntry)this.getControl(ENTRYENTITY_CARD);
        entryentitycard.selectCard(Integer.valueOf(0));
        entryentitycard.selectRowsChanged(Collections.singletonList(0), null);
    }

    static {
        ruleTypeMap.put("1", "tcsd_rule_yshtpz");
        ruleTypeMap.put("2", "tcsd_rule_cqzysj");
        ruleTypeMap.put("3", "tcsd_rule_zjzb");
    }
}

