/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.taxsource;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.AccrualConstant;
import kd.taxc.bdtaxr.common.constant.BaseTaxCategory;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.orgmapping.TaxcOrgMappingDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.provision.ProvisionSharePlanDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.license.plugin.common.AbstractLicenseCheckFormPlugin;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcret.business.taxsource.BeforeF7FilterHelper;
import kd.taxc.tcret.business.taxsource.YhsAccountServiceHelper;
import kd.taxc.tcret.common.utils.DateCheckUtils;
import kd.taxc.tcret.common.utils.YhsUtils;

public class YhsTaxAccountSavePlugin
extends AbstractLicenseCheckFormPlugin
implements BeforeF7SelectListener {
    private static final String TCRET_YHS_TAX_ACCOUNT = "tcret_yhs_tax_account";
    private static final String BTNOK = "btnok";
    private static final String ORG = "org";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String TAXOFFICE = "taxoffice";
    private static final String TAXITEM = "taxitem";
    private static final String DECLARETYPE = "declaretype";
    private static final String ENTRYENTITY = "entryentity";
    private static final String PAYTYPE = "paytype";
    private static final String DEDUCTIONCODE = "deductioncode";
    private static final String SUB_TAX_ITEM = "subtaxitem";
    private static final String QTZP = "013";
    private static final String JZZP = "012";
    private List<String> fieldList = Arrays.asList("accountorg", "bizdimensiontype", "bizdimensionname", "bizdimensionid", "taxitem", "subtaxitem", "voucherno", "vouchernum", "voucherdate", "calctaxamount", "taxation", "verifyrate", "taxrate", "deductioncode", "remark", "paytype", "taxlimit");

    public void initialize() {
        this.addClickListeners(new String[]{BTNOK});
        this.addClickListeners(new String[]{"btncancel"});
        this.addClickListeners(new String[]{"advconap", "advcontoolbarap"});
        Toolbar mbar = (Toolbar)this.getView().getControl("advcontoolbarap");
        mbar.addItemClickListener((ItemClickListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl(ORG);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit accountorg = (BasedataEdit)this.getControl("accountorg");
        accountorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxitem = (BasedataEdit)this.getControl(TAXITEM);
        taxitem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TextEdit bizdimensionname = (TextEdit)this.getControl("bizdimensionname");
        bizdimensionname.addClickListener((ClickListener)this);
        BasedataEdit subTaxItem = (BasedataEdit)this.getControl(SUB_TAX_ITEM);
        subTaxItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit deductioncode = (BasedataEdit)this.getControl(DEDUCTIONCODE);
        deductioncode.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object orgidObj = customParams.get(ORG);
        Object value = this.getModel().getValue(ORG);
        if (orgidObj != null || value != null) {
            long orgid;
            if (value == null) {
                orgid = Long.parseLong(String.valueOf(orgidObj));
                this.getModel().setValue(ORG, (Object)orgid);
            } else {
                orgid = ((DynamicObject)this.getModel().getValue(ORG)).getLong("id");
            }
            boolean zeroDeclare = SystemParamUtil.getZeroDeclareParameter((String)"tcret", (String)"zerodeclare", (long)orgid);
            if (zeroDeclare) {
                String orgname = OrgUtils.getOrgNameById((String)String.valueOf(orgidObj));
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u7ec4\u7ec7\u7684\u5370\u82b1\u7a0e\u4e3a\u96f6\u7533\u62a5\uff0c\u4e0d\u80fd\u751f\u6210\u53f0\u8d26", (String)"YhsTaxAccountSavePlugin_0", (String)"taxc-tcret", (Object[])new Object[0]), orgname));
                this.getModel().setValue(ORG, null);
                return;
            }
            TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgid);
            if (result.getData() != null) {
                this.getModel().setValue(TAXOFFICE, (Object)((DynamicObject)result.getData()).getLong("taxoffice.id"));
            }
            if (YhsAccountServiceHelper.verifyTaxoffice(this.getModel().getValue(ORG), this.getModel().getValue(TAXOFFICE))) {
                this.getPageCache().put(PAYTYPE, "bdjn");
            } else {
                this.getPageCache().put(PAYTYPE, "ydjn");
            }
            String declaretype = (String)this.getModel().getValue(DECLARETYPE);
            DateEdit skssqq = (DateEdit)this.getControl(SKSSQQ);
            DateEdit skssqz = (DateEdit)this.getControl(SKSSQZ);
            FieldProp skssqqProperty = (FieldProp)this.getModel().getProperty(SKSSQQ);
            FieldProp skssqzProperty = (FieldProp)this.getModel().getProperty(SKSSQZ);
            DateEdit voucherdate = (DateEdit)this.getControl("voucherdate");
            DateProp voucherdateProperty = (DateProp)this.getModel().getProperty("voucherdate");
            if (StringUtil.equals((CharSequence)"acsb", (CharSequence)declaretype)) {
                skssqq.setMustInput(false);
                skssqz.setMustInput(false);
                skssqqProperty.setMustInput(false);
                skssqzProperty.setMustInput(false);
                voucherdate.setMustInput(true);
                voucherdateProperty.setMustInput(true);
                this.getView().setVisible(Boolean.FALSE, new String[]{SKSSQQ, SKSSQZ});
            } else {
                skssqq.setMustInput(true);
                skssqz.setMustInput(true);
                skssqqProperty.setMustInput(true);
                skssqzProperty.setMustInput(true);
                voucherdate.setMustInput(false);
                voucherdateProperty.setMustInput(false);
                this.getView().setVisible(Boolean.TRUE, new String[]{SKSSQQ, SKSSQZ});
                Date addMonth = DateUtils.addMonth((Date)new Date(), (int)-3);
                Date firstDateOfSeason = DateUtils.getFirstDateOfSeason((Date)addMonth);
                Date lastDateOfSeason = DateUtils.trunc((Date)DateUtils.getLastDateOfSeason((Date)addMonth));
                this.getModel().setValue(SKSSQQ, (Object)firstDateOfSeason);
                this.getModel().setValue(SKSSQZ, (Object)lastDateOfSeason);
            }
        }
        this.refreshDimensionFieldsVisible();
        this.getModel().setDataChanged(true);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(true);
    }

    private void refreshDimensionFieldsVisible() {
        DynamicObject taxorg = (DynamicObject)this.getModel().getValue(ORG);
        if (taxorg != null) {
            Date startdate = this.getModel().getDataEntity().getDate(SKSSQQ);
            Date enddate = this.getModel().getDataEntity().getDate(SKSSQZ);
            if ("acsb".equals(this.getModel().getDataEntity().getString(DECLARETYPE))) {
                startdate = new Date();
                enddate = new Date();
            }
            BasedataEdit accountorg = (BasedataEdit)this.getControl("accountorg");
            FieldProp property = (FieldProp)this.getModel().getProperty("bizdimensionname");
            BasedataEdit bizdimensiontype = (BasedataEdit)this.getControl("bizdimensiontype");
            TextEdit bizdimensionname = (TextEdit)this.getControl("bizdimensionname");
            TaxResult taxResult = ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryIdAndDateRange(Collections.singletonList(taxorg.getLong("id")), (Long)BaseTaxCategory.YHS, (Long)AccrualConstant.TAXSYSTEM_CHINA, (Date)startdate, (Date)enddate);
            if (EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
                DynamicObject entry = (DynamicObject)((DynamicObjectCollection)taxResult.getData()).get(0);
                long provisionId = entry.getLong("ruleentity.rule");
                DynamicObject provision = BusinessDataServiceHelper.loadSingleFromCache((Object)provisionId, (String)"itp_proviston_plan");
                String provisiondimension = provision.getString("provisiondimension");
                if (provision.getBoolean("isdimprovision") && provisiondimension.contains("accountorg")) {
                    accountorg.setMustInput(true);
                    property.setMustInput(true);
                    this.getView().setVisible(Boolean.TRUE, new String[]{"accountorg"});
                } else {
                    accountorg.setMustInput(false);
                    property.setMustInput(false);
                    this.getView().setVisible(Boolean.FALSE, new String[]{"accountorg"});
                }
                if (provision.getBoolean("isdimprovision") && provisiondimension.contains("businessdimension")) {
                    DynamicObjectCollection businessdimensions = provision.getDynamicObjectCollection("businessdimension");
                    if (EmptyCheckUtils.isNotEmpty((Object)businessdimensions)) {
                        DynamicObject basedata = ((DynamicObject)businessdimensions.get(0)).getDynamicObject("fbasedataid");
                        this.getPageCache().put("bizdimensiontype", basedata.getString("mapobject.id"));
                        this.getModel().setValue("bizdimensiontype", (Object)basedata.getString("mapobject.id"), 0);
                    }
                    bizdimensiontype.setMustInput(true);
                    bizdimensionname.setMustInput(true);
                    property.setMustInput(true);
                    this.getView().setVisible(Boolean.TRUE, new String[]{"bizdimensiontype", "bizdimensionname"});
                } else {
                    bizdimensiontype.setMustInput(false);
                    bizdimensionname.setMustInput(false);
                    property.setMustInput(false);
                    this.getView().setVisible(Boolean.FALSE, new String[]{"bizdimensiontype", "bizdimensionname"});
                }
            } else {
                accountorg.setMustInput(false);
                property.setMustInput(false);
                bizdimensiontype.setMustInput(false);
                bizdimensionname.setMustInput(false);
                this.getView().setVisible(Boolean.FALSE, new String[]{"accountorg", "bizdimensiontype", "bizdimensionname", "bizdimensionid"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"accountorg", "bizdimensiontype", "bizdimensionname", "bizdimensionid"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        IDataModel model = this.getModel();
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        String declaretype = (String)model.getValue(DECLARETYPE);
        if (DECLARETYPE.equals(name)) {
            model.deleteEntryData(ENTRYENTITY);
            model.createNewEntryRow(ENTRYENTITY);
            DateEdit voucherdate = (DateEdit)this.getControl("voucherdate");
            DateProp voucherdateProperty = (DateProp)this.getModel().getProperty("voucherdate");
            DateEdit skssqq = (DateEdit)this.getControl(SKSSQQ);
            DateEdit skssqz = (DateEdit)this.getControl(SKSSQZ);
            DateProp skssqqProperty = (DateProp)this.getModel().getProperty(SKSSQQ);
            DateProp skssqzProperty = (DateProp)this.getModel().getProperty(SKSSQZ);
            if (StringUtil.equals((CharSequence)"acsb", (CharSequence)declaretype)) {
                voucherdate.setMustInput(true);
                voucherdateProperty.setMustInput(true);
                skssqq.setMustInput(false);
                skssqz.setMustInput(false);
                skssqqProperty.setMustInput(false);
                skssqzProperty.setMustInput(false);
                this.getView().setVisible(Boolean.FALSE, new String[]{SKSSQQ, SKSSQZ});
            } else {
                voucherdate.setMustInput(false);
                voucherdateProperty.setMustInput(false);
                skssqq.setMustInput(true);
                skssqz.setMustInput(true);
                skssqqProperty.setMustInput(false);
                skssqzProperty.setMustInput(false);
                this.getView().setVisible(Boolean.TRUE, new String[]{SKSSQQ, SKSSQZ});
                Date addMonth = DateUtils.addMonth((Date)new Date(), (int)-3);
                Date firstDateOfSeason = DateUtils.getFirstDateOfSeason((Date)addMonth);
                Date lastDateOfSeason = DateUtils.trunc((Date)DateUtils.getLastDateOfSeason((Date)addMonth));
                this.getModel().setValue(SKSSQQ, (Object)firstDateOfSeason);
                this.getModel().setValue(SKSSQZ, (Object)lastDateOfSeason);
            }
            this.refreshDimensionFieldsVisible();
        }
        if (TAXITEM.equals(name) && org != null) {
            DynamicObject newValue;
            DynamicObject taxItem = (DynamicObject)changeData.getNewValue();
            int rowIndex = changeData.getRowIndex();
            if (EmptyCheckUtils.isNotEmpty((Object)changeData.getOldValue())) {
                this.getModel().setValue("voucherno", null, rowIndex);
                this.getModel().setValue("voucherdate", null, rowIndex);
                this.getModel().setValue("calctaxamount", (Object)BigDecimal.ZERO, rowIndex);
                this.getModel().setValue("taxation", null, rowIndex);
                this.getModel().setValue("verifyrate", (Object)BigDecimal.ZERO, rowIndex);
                this.getModel().setValue(DEDUCTIONCODE, null, rowIndex);
            }
            if ((newValue = (DynamicObject)changeData.getNewValue()) != null) {
                DynamicObject subtaxitem = (DynamicObject)this.getModel().getValue(SUB_TAX_ITEM);
                String number = newValue.getString("number");
                if (subtaxitem != null && !StringUtils.equals((CharSequence)subtaxitem.getString("parent.number"), (CharSequence)number)) {
                    this.getModel().setValue(SUB_TAX_ITEM, null, rowIndex);
                }
            } else {
                this.getModel().setValue(SUB_TAX_ITEM, null, rowIndex);
            }
            if (taxItem != null) {
                String number = taxItem.getString("number");
                this.setValue(model, taxItem, org, rowIndex);
                if (StringUtil.equals((CharSequence)JZZP, (CharSequence)number)) {
                    this.setDeductioncode("09129906", rowIndex);
                } else if (StringUtil.equals((CharSequence)QTZP, (CharSequence)number)) {
                    this.setDeductioncode("09129907", rowIndex);
                }
            }
        }
        if (ORG.equals(name)) {
            if (changeData.getNewValue() == null) {
                model.setValue(ORG, changeData.getOldValue());
            } else {
                model.deleteEntryData(ENTRYENTITY);
                Object newValue = changeData.getNewValue();
                this.getView().getFormShowParameter().setCustomParam(ORG, (Object)((DynamicObject)newValue).getLong("id"));
                this.getView().invokeOperation("refresh");
            }
        }
        if (SKSSQQ.equals(name) || SKSSQZ.equals(name)) {
            Date skssqq = (Date)this.getModel().getValue(SKSSQQ);
            Date skssqz = (Date)this.getModel().getValue(SKSSQZ);
            if (SKSSQQ.equals(name) && skssqq != null && !skssqq.equals(DateUtils.getFirstDateOfMonth((Date)skssqq))) {
                this.getModel().setValue(SKSSQQ, (Object)DateUtils.getFirstDateOfMonth((Date)skssqq));
                return;
            }
            if (SKSSQZ.equals(name) && skssqz != null && !skssqz.equals(DateUtils.getLastDateOfMonth2((Date)skssqz))) {
                this.getModel().setValue(SKSSQZ, (Object)DateUtils.getLastDateOfMonth2((Date)skssqz));
                return;
            }
            if (!DateCheckUtils.checkDate(skssqq, skssqz, this.getView())) {
                return;
            }
            this.refreshDimensionFieldsVisible();
        }
        if ("calctaxamount".equals(name) && StringUtil.equals((CharSequence)"acsb", (CharSequence)declaretype) && BigDecimal.ZERO.compareTo((BigDecimal)changeData.getNewValue()) >= 0) {
            String msg = ResManager.loadKDString((String)"\u6309\u6b21\u7533\u62a5\u65f6\uff0c\u8ba1\u7a0e\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0\uff0c\u8bf7\u4fee\u6539", (String)"YhsTaxAccountSavePlugin_1", (String)"taxc-tcret", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
        }
    }

    private void setDeductioncode(String deductioncode, int rowIndex) {
        QFilter qFilter = new QFilter("taxcategory.number", "=", (Object)"008").and("number", "=", (Object)deductioncode);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tpo_taxdeduction", (String)"id,number", (QFilter[])qFilter.toArray());
        if (dynamicObject != null) {
            this.getModel().setValue(DEDUCTIONCODE, (Object)dynamicObject.getLong("id"), rowIndex);
        }
    }

    private void setValue(IDataModel model, DynamicObject taxItem, DynamicObject org, int rowIndex) {
        String declaretype = (String)model.getValue(DECLARETYPE);
        if (StringUtil.equals((CharSequence)"acsb", (CharSequence)declaretype)) {
            model.setValue("taxation", (Object)"aqhz", rowIndex);
            model.setValue("verifyrate", (Object)BigDecimal.ZERO, rowIndex);
        } else {
            DynamicObject object = YhsUtils.getTaxItem(org, taxItem.getString("number"));
            if (object != null) {
                model.setValue("taxation", (Object)(object.getBoolean("isverify") ? "hdzs" : "aqhz"), rowIndex);
                model.setValue("verifyrate", (Object)object.getBigDecimal("hdrate"), rowIndex);
            }
        }
        this.getModel().setValue(PAYTYPE, (Object)this.getPageCache().get(PAYTYPE), rowIndex);
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof TextEdit && "bizdimensionname".equals(((TextEdit)source).getKey())) {
            Map map;
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
            String declaretype = (String)this.getModel().getValue(DECLARETYPE);
            DynamicObject bizdimensiontype = (DynamicObject)this.getModel().getValue("bizdimensiontype", rowIndex);
            if (bizdimensiontype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u7ef4\u5ea6\u4e3a\u7a7a", (String)"YhsTaxAccountSavePlugin_2", (String)"taxc-tcret", (Object[])new Object[0]));
                return;
            }
            DynamicObject taxorg = (DynamicObject)this.getModel().getValue(ORG);
            Date skssqq = (Date)this.getModel().getValue(SKSSQQ);
            Date skssqz = (Date)this.getModel().getValue(SKSSQZ);
            if (!(StringUtil.equals((CharSequence)"acsb", (CharSequence)declaretype) || taxorg != null && skssqq != null && skssqz != null)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u57fa\u672c\u4fe1\u606f", (String)"YhsTaxAccountSavePlugin_3", (String)"taxc-tcret", (Object[])new Object[0]));
                return;
            }
            if (StringUtil.equals((CharSequence)"acsb", (CharSequence)declaretype)) {
                skssqq = skssqz = new Date();
            }
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)bizdimensiontype.getString("id"), (boolean)false);
            Map allFields = EntityMetadataCache.getDataEntityType((String)bizdimensiontype.getString("id")).getAllFields();
            if (allFields.get("enable") != null) {
                listShowParameter.getListFilterParameter().setFilter(new QFilter("enable", "=", (Object)"1"));
            }
            if (allFields.get("status") != null) {
                listShowParameter.getListFilterParameter().setFilter(new QFilter("status", "=", (Object)"C"));
            }
            if (EmptyCheckUtils.isNotEmpty((Object)(map = (Map)TaxcOrgMappingDataServiceHelper.getOrgMappingByOrgIdAndCategoryId((Long)taxorg.getLong("id"), (Long)BaseTaxCategory.YHS, (Date)skssqq, (Date)skssqz).getData())) && EmptyCheckUtils.isNotEmpty(map.get(bizdimensiontype.getString("id")))) {
                List businessid = ((List)map.get(bizdimensiontype.getString("id"))).stream().map(e -> e.get("businessid")).collect(Collectors.toList());
                listShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", businessid));
            } else {
                listShowParameter.getListFilterParameter().setFilter(QFilter.of((String)"1!=1", (Object[])new Object[0]));
            }
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bizdimensionname"));
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey = evt.getOperateKey();
        if (BTNOK.equals(operateKey) && evt.getOperationResult().isSuccess()) {
            this.saveData();
            this.getView().returnDataToParent((Object)true);
            this.getView().close();
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        IDataModel model = this.getModel();
        String bizdimensiontype = this.getPageCache().get("bizdimensiontype");
        Arrays.stream(e.getRowDataEntities()).map(RowDataEntity::getRowIndex).forEach(b -> model.setValue("bizdimensiontype", (Object)bizdimensiontype, b.intValue()));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection returnData;
        String actionId = closedCallBackEvent.getActionId();
        if ("bizdimensionname".equals(actionId) && EmptyCheckUtils.isNotEmpty((Object)(returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()))) {
            this.getModel().setValue("bizdimensionname", (Object)returnData.get(0).getName());
            this.getModel().setValue("bizdimensionid", returnData.get(0).getPrimaryKeyValue());
        }
    }

    private void saveData() {
        IDataModel model = this.getModel();
        ArrayList<DynamicObject> saveDatas = new ArrayList<DynamicObject>();
        Object org = model.getValue(ORG);
        Object skssqq = model.getValue(SKSSQQ);
        Object skssqz = model.getValue(SKSSQZ);
        Object taxoffice = model.getValue(TAXOFFICE);
        Object declaretype = model.getValue(DECLARETYPE);
        DynamicObjectCollection entryentity = model.getEntryEntity(ENTRYENTITY);
        for (DynamicObject object : entryentity) {
            DynamicObject account = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TCRET_YHS_TAX_ACCOUNT));
            account.set(ORG, org);
            if ("acsb".equals(declaretype)) {
                skssqq = object.get("voucherdate");
                skssqz = object.get("voucherdate");
            }
            account.set(SKSSQQ, skssqq);
            account.set(SKSSQZ, skssqz);
            account.set(TAXOFFICE, taxoffice);
            account.set(DECLARETYPE, declaretype);
            for (String filed : this.fieldList) {
                account.set(filed, object.get(filed));
            }
            String billno = CodeRuleServiceHelper.getNumber((String)TCRET_YHS_TAX_ACCOUNT, (DynamicObject)account, null);
            account.set("billno", (Object)billno);
            account.set("billstatus", (Object)"A");
            account.set("createtime", (Object)new Date());
            account.set("creator", (Object)RequestContext.get().getCurrUserId());
            account.set("datasource", (Object)"useradd");
            saveDatas.add(account);
        }
        if (saveDatas.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])saveDatas.toArray(new DynamicObject[0]));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        BeforeF7FilterHelper.beforeF7(evt, this.getView());
    }
}

