/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.taxsource;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.license.plugin.zerodeclare.AbstractLicenseCheckBillPlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcret.business.taxsource.YhsAccountServiceHelper;
import kd.taxc.tcret.business.taxsource.YhsTaxSourceServiceHelper;
import kd.taxc.tcret.common.utils.YhsUtils;

public class YhsTaxSourceFromAccFormPlugin
extends AbstractLicenseCheckBillPlugin
implements BeforeF7SelectListener {
    private static final String BTNOK = "btnok";
    private static final String FLEXPANELAP_2 = "flexpanelap2";
    private static final String ORG = "org";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String COLLECTDATE = "collectdate";
    private static final String ENTRYENTITY = "entryentity";
    private static final String YHS_TAX_ACCOUNT = "tcret_yhs_tax_account";
    private static final String YHS_TAX_SOURCE_INFO = "tcret_yhs_tax_source_info";
    private static final String STRING = "-";
    private static final String GANG = "NO";
    private static final String NEW_ACCOUNT = "newaccount";

    public void initialize() {
        this.addClickListeners(new String[]{BTNOK});
        this.addClickListeners(new String[]{NEW_ACCOUNT});
        BasedataEdit org = (BasedataEdit)this.getControl(ORG);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANELAP_2});
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String isreverse = (String)customParams.get("isreverse");
        Long org = null;
        if (StringUtil.isNotBlank((CharSequence)isreverse)) {
            Map reverseCustomParams = (Map)SerializationUtils.fromJsonString((String)isreverse, Map.class);
            org = Long.valueOf((String)reverseCustomParams.get("orgid"));
        } else {
            Long l = org = StringUtil.isNotBlank((CharSequence)((String)customParams.get(ORG))) ? Long.valueOf((String)customParams.get(ORG)) : null;
        }
        if (org != null) {
            this.getModel().setValue(ORG, (Object)org);
            this.refreshGatherList();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        ListFilterParameter listFilterParameter = formShowParameter.getListFilterParameter();
        if (ORG.equals(name)) {
            TaxResult listTaxResult = TaxcCombineDataServiceHelper.queryTaxcOrgIdsWithPerm((Long)RequestContext.get().getCurrUserId());
            listFilterParameter.setFilter(new QFilter("id", "in", listTaxResult.getData()));
        }
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Button) {
            Date collectdate;
            DynamicObject org;
            if (((Button)source).getKey().equals(BTNOK)) {
                org = (DynamicObject)this.getModel().getValue(ORG);
                if (org != null && !TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).isSuccess()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"YhsTaxSourceFromAccFormPlugin_5", (String)"taxc-tcret", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
                long count = entryEntity.stream().filter(a -> a.getBoolean("getconfirm")).count();
                if (count > 0L) {
                    this.gatherTaxSource();
                }
                this.getPageCache().put("okflag", "true");
                collectdate = (Date)this.getModel().getValue(COLLECTDATE);
                HashMap<String, Object> returnData = new HashMap<String, Object>();
                returnData.put(ORG, org != null ? org.getString("id") : "");
                returnData.put(COLLECTDATE, collectdate);
                returnData.put("okflag", "true");
                this.getView().returnDataToParent(returnData);
                this.getView().close();
                String operateName = ResManager.loadKDString((String)"\u786e\u5b9a", (String)"YhsTaxSourceFromAccFormPlugin_6", (String)"taxc-tcret", (Object[])new Object[0]);
                String operateDescription = ResManager.loadKDString((String)"\u5370\u82b1\u7a0e\u7a0e\u6e90\u4fe1\u606f\u53f0\u8d26\u91c7\u96c6\u6210\u529f", (String)"YhsTaxSourceFromAccFormPlugin_7", (String)"taxc-tcret", (Object[])new Object[0]);
                OperatorDialogUtils.operateDialog((String)"ccxws", (String)YHS_TAX_SOURCE_INFO, (String)operateName, (String)operateDescription);
            }
            if (((Button)source).getKey().equals(NEW_ACCOUNT)) {
                Map skssqzMap;
                org = (DynamicObject)this.getModel().getValue(ORG);
                if (org == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (String)"YhsTaxSourceFromAccFormPlugin_2", (String)"taxc-tcret", (Object[])new Object[0]));
                    return;
                }
                StringBuilder message = new StringBuilder();
                StringBuilder theIds = new StringBuilder();
                String declaretype = (String)this.getModel().getValue("declaretype");
                collectdate = (Date)this.getModel().getValue(COLLECTDATE);
                if (collectdate == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u91c7\u96c6\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"YhsTaxSourceFromAccFormPlugin_4", (String)"taxc-tcret", (Object[])new Object[0]));
                    return;
                }
                Map taxLimitSkssqzMap = DateUtils.getTaxLimitSkssqzMap((Date)collectdate);
                for (Map.Entry entry : taxLimitSkssqzMap.entrySet()) {
                    skssqzMap = (Map)entry.getValue();
                    this.yhsTaxAccountExitsValidate(theIds, message, org, (Date)skssqzMap.get(SKSSQQ), (Date)skssqzMap.get(SKSSQZ), declaretype);
                }
                if (message.length() > 0) {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("new_account_confirm", (IFormPlugin)this);
                    String msg1 = ResManager.loadKDString((String)"%1$s\u5728%2$s\u5df2\u5b58\u5728\u5370\u82b1\u7a0e\u53f0\u8d26\u6570\u636e\uff0c\u91cd\u65b0\u751f\u6210\u53f0\u8d26\u4f1a\u5c06\u539f\u6709\u53f0\u8d26\u6570\u636e\u8986\u76d6\uff0c\u662f\u5426\u8981\u6267\u884c\u6b64\u64cd\u4f5c\uff1f", (String)"YhsTaxSourceFromAccFormPlugin_1", (String)"taxc-tcret", (Object[])new Object[0]);
                    String msg = String.format(msg1, org.getString("name"), message.substring(0, message.length() - 1));
                    this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks, new HashMap(), theIds.substring(0, theIds.length() - 1));
                } else {
                    for (Map.Entry entry : taxLimitSkssqzMap.entrySet()) {
                        skssqzMap = (Map)entry.getValue();
                        YhsAccountServiceHelper.createAccount(org.getLong("id"), (Date)skssqzMap.get(SKSSQQ), (Date)skssqzMap.get(SKSSQZ));
                    }
                }
                this.refreshGatherList();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if ("new_account_confirm".equals(e.getCallBackId()) && e.getResult() == MessageBoxResult.Yes) {
            String ids = e.getCustomVaule();
            DeleteServiceHelper.delete((String)YHS_TAX_ACCOUNT, (QFilter[])new QFilter[]{new QFilter("id", "in", Arrays.stream(ids.split(",")).map(Long::parseLong).collect(Collectors.toList()))});
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            Date collectdate = (Date)this.getModel().getValue(COLLECTDATE);
            Map taxLimitSkssqzMap = DateUtils.getTaxLimitSkssqzMap((Date)collectdate);
            for (Map.Entry entry : taxLimitSkssqzMap.entrySet()) {
                Map skssqzMap = (Map)entry.getValue();
                YhsAccountServiceHelper.createAccount(org.getLong("id"), (Date)skssqzMap.get(SKSSQQ), (Date)skssqzMap.get(SKSSQZ));
            }
            this.refreshGatherList();
        }
    }

    private void yhsTaxAccountExitsValidate(StringBuilder theIds, StringBuilder message, DynamicObject org, Date skssqq, Date skssqz, String declaretype) {
        String msg2 = ResManager.loadKDString((String)"%1$s\u81f3%2$s", (String)"YhsTaxSourceFromAccFormPlugin_3", (String)"taxc-tcret", (Object[])new Object[0]);
        DynamicObjectCollection exists = YhsAccountServiceHelper.queryYhsTaxAccountIds(org.getLong("id"), skssqq, skssqz, declaretype);
        if (!CollectionUtils.isEmpty((Collection)exists)) {
            String ids = exists.stream().map(s -> s.getString("id")).collect(Collectors.joining(","));
            theIds.append(ids).append(",");
            String msg = String.format(msg2, DateUtils.format((Date)skssqq), DateUtils.format((Date)skssqz));
            message.append(msg).append(",");
        }
    }

    private void gatherTaxSource() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        Date collectdate = (Date)this.getModel().getValue(COLLECTDATE);
        if (org == null || collectdate == null) {
            return;
        }
        Map taxLimitSkssqzMap = DateUtils.getTaxLimitSkssqzMap((Date)collectdate);
        this.addInSequenceDate(taxLimitSkssqzMap, collectdate);
        HashSet<String> messages = new HashSet<String>();
        try (TXHandle h = TX.requiresNew();){
            try {
                for (Map.Entry entry : taxLimitSkssqzMap.entrySet()) {
                    Map skssqzMap = (Map)entry.getValue();
                    YhsTaxSourceServiceHelper.gatherTaxSource(org.getLong("id"), (Date)skssqzMap.get(SKSSQQ), (Date)skssqzMap.get(SKSSQZ), (List<DynamicObject>)entryEntity, true, messages, (String)entry.getKey());
                }
            }
            catch (Throwable t) {
                h.markRollback();
                throw new RuntimeException(t);
            }
        }
        if (messages.size() > 0) {
            this.getView().getParentView().showTipNotification(StringUtil.join(messages, (String)""));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (ORG.equals(name) || COLLECTDATE.equals(name)) {
            this.refreshGatherList();
        }
    }

    private void refreshGatherList() {
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (org == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (String)"YhsTaxSourceFromAccFormPlugin_2", (String)"taxc-tcret", (Object[])new Object[0]));
            return;
        }
        Date collectdate = (Date)this.getModel().getValue(COLLECTDATE);
        if (collectdate == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u91c7\u96c6\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"YhsTaxSourceFromAccFormPlugin_4", (String)"taxc-tcret", (Object[])new Object[0]));
            return;
        }
        this.getModel().deleteEntryData(ENTRYENTITY);
        Map taxLimitSkssqzMap = DateUtils.getTaxLimitSkssqzMap((Date)collectdate);
        this.addInSequenceDate(taxLimitSkssqzMap, collectdate);
        for (Map.Entry entry : taxLimitSkssqzMap.entrySet()) {
            Map skssqzMap = (Map)entry.getValue();
            this.refreshList(org, (Date)skssqzMap.get(SKSSQQ), (Date)skssqzMap.get(SKSSQZ), (String)entry.getKey());
        }
    }

    private void addInSequenceDate(Map<String, Map<String, Date>> taxLimitSkssqzMap, Date collectdate) {
        HashMap<String, Date> dateMap = new HashMap<String, Date>();
        Date skssqz = DateUtils.getLastDateOfMonth1((Date)DateUtils.addMonth((Date)collectdate, (int)-1));
        dateMap.put(SKSSQQ, skssqz);
        dateMap.put(SKSSQZ, skssqz);
        taxLimitSkssqzMap.put("count", dateMap);
    }

    private void refreshList(DynamicObject org, Date skssqq, Date skssqz, String key) {
        QFilter qFilter2;
        Function<DynamicObject, String> function;
        QFilter qFilter1;
        QFilter qFilter = new QFilter(ORG, "=", org.get("id"));
        if ("count".equals(key)) {
            qFilter1 = new QFilter(SKSSQZ, ">=", (Object)DateUtils.getFirstDateOfMonth((Date)skssqz)).and(SKSSQZ, "<=", (Object)skssqz);
            qFilter1.and("declaretype", "=", (Object)"acsb");
            function = a -> a.getLong("taxitem.id") + STRING + a.getLong("subtaxitem.id") + STRING + a.getString("taxation") + STRING + a.getLong("deductioncode.id") + STRING + a.getLong("taxoffice.id") + STRING + a.getString("paytype") + STRING + a.getString("declaretype") + STRING + a.getString(SKSSQZ);
        } else {
            qFilter1 = new QFilter(SKSSQQ, "=", (Object)skssqq).and(SKSSQZ, "=", (Object)skssqz);
            qFilter1.and("declaretype", "=", (Object)"aqsb");
            function = a -> a.getLong("taxitem.id") + STRING + a.getLong("subtaxitem.id") + STRING + a.getString("taxation") + STRING + a.getLong("deductioncode.id") + STRING + a.getLong("taxoffice.id") + STRING + a.getString("paytype") + STRING + a.getString("declaretype");
        }
        DynamicObject[] accounts = BusinessDataServiceHelper.load((String)YHS_TAX_ACCOUNT, (String)MetadataUtil.getAllFieldToQuery((String)YHS_TAX_ACCOUNT), (QFilter[])new QFilter[]{qFilter, qFilter1});
        Map<String, List<DynamicObject>> accountGroup = Arrays.stream(accounts).collect(Collectors.groupingBy(function));
        if ("count".equals(key)) {
            qFilter2 = new QFilter(SKSSQZ, ">=", (Object)DateUtils.getFirstDateOfMonth((Date)skssqz)).and(SKSSQZ, "<=", (Object)skssqz);
            qFilter2.and("declaretype", "=", (Object)"acsb");
        } else {
            qFilter2 = new QFilter(SKSSQQ, "=", (Object)skssqq).or(SKSSQQ, "=", (Object)skssqz).and(SKSSQZ, "=", (Object)skssqz);
            qFilter2.and("declaretype", "=", (Object)"aqsb");
        }
        DynamicObject[] sy = BusinessDataServiceHelper.load((String)YHS_TAX_SOURCE_INFO, (String)MetadataUtil.getAllFieldToQuery((String)YHS_TAX_SOURCE_INFO), (QFilter[])new QFilter[]{qFilter, qFilter2});
        Map<String, List<DynamicObject>> syGroup = Arrays.stream(sy).collect(Collectors.groupingBy(function));
        Map<String, String> sbbBillStatusMap = YhsUtils.getSbbBillStatus((Long)org.get("id"), skssqq, skssqz, key, sy);
        this.updateFormEntity(accountGroup, syGroup, sbbBillStatusMap, function);
    }

    private void updateFormEntity(Map<String, List<DynamicObject>> accountGroup, Map<String, List<DynamicObject>> syGroup, Map<String, String> sbbBillStatusMap, Function<DynamicObject, String> function) {
        this.getModel().beginInit();
        this.getView().setVisible(Boolean.TRUE, new String[]{FLEXPANELAP_2});
        for (Map.Entry<String, List<DynamicObject>> entry : accountGroup.entrySet()) {
            String getresult;
            String sbbBillStatus;
            DynamicObject object = entry.getValue().get(0);
            int index = this.getModel().createNewEntryRow(ENTRYENTITY);
            this.getModel().setValue("taxitem", object.get("taxitem"), index);
            this.getModel().setValue("subtaxitem", object.get("subtaxitem"), index);
            this.getModel().setValue("declaretype", object.get("declaretype"), index);
            String taxperiod = DateUtils.format((Date)object.getDate(SKSSQQ), (String)DateUtils.YYYYMMDD_CHINESE) + STRING + DateUtils.format((Date)object.getDate(SKSSQZ), (String)DateUtils.YYYYMMDD_CHINESE);
            if ("acsb".equals(object.get("declaretype"))) {
                taxperiod = DateUtils.format((Date)object.getDate(SKSSQZ), (String)DateUtils.YYYYMMDD_CHINESE) + STRING + DateUtils.format((Date)object.getDate(SKSSQZ), (String)DateUtils.YYYYMMDD_CHINESE);
            }
            this.getModel().setValue("taxperiod", (Object)taxperiod, index);
            this.getModel().setValue("taxation", object.get("taxation"), index);
            this.getModel().setValue("deductioncode", object.get("deductioncode"), index);
            this.getModel().setValue("taxoffice", object.get("taxoffice"), index);
            this.getModel().setValue("paytype", object.get("paytype"), index);
            String key = function.apply(object);
            List<DynamicObject> syList = syGroup.get(key);
            boolean isSyExist = EmptyCheckUtils.isNotEmpty(syList);
            if (isSyExist) {
                this.getModel().setValue("existed", (Object)"1", index);
                this.getModel().setValue("datasource", syList.get(0).get("datasource"), index);
            } else {
                this.getModel().setValue("existed", (Object)"0", index);
                this.getModel().setValue("datasource", (Object)GANG, index);
            }
            String mapKey = object.getString("taxitem.name") + "_" + DateUtils.format((Date)object.getDate(SKSSQQ)) + "_" + DateUtils.format((Date)object.getDate(SKSSQZ));
            if ("acsb".equals(object.get("declaretype"))) {
                mapKey = object.getString("taxitem.name") + "_" + DateUtils.format((Date)object.getDate(SKSSQZ)) + "_" + DateUtils.format((Date)object.getDate(SKSSQZ));
            }
            if (StringUtil.isEmpty((CharSequence)(sbbBillStatus = sbbBillStatusMap.get(mapKey)))) {
                sbbBillStatus = GANG;
            }
            this.getModel().setValue("sbbbillstatus", (Object)sbbBillStatus, index);
            if (Objects.equals("C", sbbBillStatus) || Objects.equals("B", sbbBillStatus)) {
                getresult = "2";
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"getconfirm"});
                this.getModel().setValue("getconfirm", (Object)Boolean.FALSE, index);
            } else {
                getresult = isSyExist ? "3" : "1";
            }
            this.getModel().setValue("getresult", (Object)getresult, index);
        }
        this.getModel().endInit();
        this.getView().updateView();
    }
}

