/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.taxsource;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.TaxBaseDataUtils;
import kd.taxc.bdtaxr.common.util.UUID;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcret.business.taxsource.YhsAccountServiceHelper;
import kd.taxc.tcret.common.utils.RuleUtils;

public class YhsTaxSourceGatherFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String BTNOK = "btnok";
    private static final String ORG = "org";
    private static final String DATE = "date";
    private static final String AQSB = "aqsb";
    private static final String ORGID = "orgid";
    private static final String EFFECTIVEDATE = "effectivedate";
    private static final String EXPIRYDATE = "expirydate";
    private static final String ENTRYENTITY = "entryentity";
    private static final String TAX_SOURCE_YHSSM = "tcret_tax_source_yhssm";
    private static final String GATHERNUMBER = "gathernumber";
    private static final List<String> periodList = new ArrayList<String>(8);
    private static final String TCRET_YHS_TAX_ACCOUNT = "tcret_yhs_tax_account";
    private static final String TCSD_RULE_CONFIGS = "tcsd_rule_configs";
    private static final String TCSD_CONTRACT_VOUCHER = "tcsd_rule_yshtpz";
    private static final String TCSD_TRANSFER_DOCUMENTS = "tcsd_rule_cqzysj";
    private static final String TCSD_MONEY_ACCOUNT_BOOK = "tcsd_rule_zjzb";
    public static final String YSHTPZ = "yshtpz";
    public static final String CQZYSJ = "cqzysj";
    public static final String ZJZB = "zjzb";
    private static final String YHS_TZ_CHECK_RULE = "tcret_yhs_tz_check_rule";
    private static final String HDZS = "hdzs";
    private static final String AQHZ = "aqhz";
    private static final Set<String> NOCONTAINLIST;

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        ListFilterParameter listFilterParameter = formShowParameter.getListFilterParameter();
        formShowParameter.setMultiSelect(false);
        if (beforeF7SelectEvent.getProperty().getName().equals(ORG)) {
            TaxResult listTaxResult = TaxcCombineDataServiceHelper.queryTaxcOrgIdsWithPerm((Long)RequestContext.get().getCurrUserId());
            listFilterParameter.setFilter(new QFilter("id", "in", listTaxResult.getData()));
        }
    }

    public void initialize() {
        BasedataEdit amountfield = (BasedataEdit)this.getControl(ORG);
        amountfield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{BTNOK});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String org = (String)customParams.get(ORG);
        this.getModel().setValue(DATE, (Object)new Date());
        if (StringUtil.isNotEmpty((CharSequence)org)) {
            boolean zeroDeclare = SystemParamUtil.getZeroDeclareParameter((String)"tcret", (String)"zerodeclare", (long)Long.parseLong(org));
            if (zeroDeclare) {
                String orgname = OrgUtils.getOrgNameById((String)org);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u7ec4\u7ec7\u7684\u5370\u82b1\u7a0e\u4e3a\u96f6\u7533\u62a5\uff0c\u4e0d\u80fd\u751f\u6210\u53f0\u8d26", (String)"YhsTaxSourceGatherFormPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]), orgname));
                return;
            }
            this.getModel().setValue(ORG, (Object)new Long[]{Long.valueOf(org)});
            this.getGatherList();
        }
    }

    public void beforeBindData(EventObject e) {
        String orgid;
        boolean isOrgAuth;
        DynamicObjectCollection org = (DynamicObjectCollection)this.getModel().getValue(ORG);
        if (EmptyCheckUtils.isNotEmpty((Object)org) && (isOrgAuth = LicenseCheckServiceHelper.check((Object)(orgid = ((DynamicObject)org.get(0)).getString("fbasedataid_id")), (IFormView)this.getView(), (String)"tcret"))) {
            this.getModel().setValue(ORG, (Object)new Long[0]);
        }
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Button && ((Button)source).getKey().equals(BTNOK)) {
            String orgid;
            DynamicObjectCollection org = (DynamicObjectCollection)this.getModel().getValue(ORG);
            if (EmptyCheckUtils.isNotEmpty((Object)org) && StringUtils.isNotEmpty((CharSequence)(orgid = ((DynamicObject)org.get(0)).getString("fbasedataid_id"))) && !TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)Long.parseLong(orgid)).isSuccess()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"YhsTaxSourceGatherFormPlugin_1", (String)"taxc-tcret", (Object[])new Object[0]));
                return;
            }
            String getFlag = this.getPageCache().get(GATHERNUMBER);
            if (StringUtil.isNotEmpty((CharSequence)getFlag)) {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
                boolean checkRule = this.checkRule(entryEntity);
                if (!checkRule) {
                    return;
                }
                String gathernumber = this.getPageCache().get(GATHERNUMBER);
                YhsAccountServiceHelper.createAccount(entryEntity, gathernumber);
            }
            this.getPageCache().put("okflag", "true");
            Date date = (Date)this.getModel().getValue(DATE);
            HashMap<String, Object> returnData = new HashMap<String, Object>();
            ArrayList orgIds = org != null ? org.stream().map(a -> a.getString("fbasedataid_id")).collect(Collectors.toList()) : new ArrayList();
            returnData.put(ORG, orgIds);
            returnData.put(DATE, date);
            returnData.put("okflag", "true");
            this.getView().returnDataToParent(returnData);
            this.getView().close();
            String operateName = ResManager.loadKDString((String)"\u786e\u8ba4", (String)"YhsTaxSourceGatherFormPlugin_2", (String)"taxc-tcret", (Object[])new Object[0]);
            String operateDescription = ResManager.loadKDString((String)"\u5370\u82b1\u7a0e\u53f0\u8d26\u81ea\u52a8\u53d6\u6570\u6210\u529f", (String)"YhsTaxSourceGatherFormPlugin_3", (String)"taxc-tcret", (Object[])new Object[0]);
            OperatorDialogUtils.operateDialog((String)"ccxws", (String)TCRET_YHS_TAX_ACCOUNT, (String)operateName, (String)operateDescription);
        }
    }

    private boolean checkRule(DynamicObjectCollection entryEntity) {
        DynamicObjectCollection org = (DynamicObjectCollection)this.getModel().getValue(ORG);
        if (EmptyCheckUtils.isNotEmpty((Object)org)) {
            String orgid = ((DynamicObject)org.get(0)).getString("fbasedataid_id");
            Map<String, DynamicObject> taxItemList = this.collectRuleList(orgid);
            if (taxItemList == null) {
                return false;
            }
            List noRuleItems = entryEntity.stream().filter(object -> object.getString("paytype").equals("bdjn")).filter(object -> {
                if (object.getBoolean("getconfirm")) {
                    if (NOCONTAINLIST.contains(object.getString("taxitem.number"))) {
                        return false;
                    }
                    String taxation = object.getBigDecimal("verifyrate") != null && object.getBigDecimal("verifyrate").compareTo(BigDecimal.ZERO) > 0 ? HDZS : AQHZ;
                    String key = object.getString("taxitem.id") + "_" + taxation;
                    return taxItemList.get(key) == null;
                }
                return false;
            }).collect(Collectors.toList());
            if (noRuleItems.size() > 0) {
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId(YHS_TZ_CHECK_RULE);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "checkNoRuleCard"));
                HashMap<String, Object> customParams = new HashMap<String, Object>();
                customParams.put("noRuleItems", noRuleItems);
                customParams.put(ORGID, orgid);
                parameter.setCustomParams(customParams);
                this.getView().showForm(parameter);
            } else {
                return true;
            }
        }
        return false;
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map map = (Map)event.getReturnData();
        if ("checkNoRuleCard".equals(event.getActionId()) && map != null && !map.isEmpty()) {
            if (Objects.equals(map.get("flag"), "goconfig")) {
                HashMap<String, String> customParams = new HashMap<String, String>();
                DynamicObjectCollection org = (DynamicObjectCollection)this.getModel().getValue(ORG);
                if (EmptyCheckUtils.isNotEmpty((Object)org)) {
                    String orgid = ((DynamicObject)org.get(0)).getString("fbasedataid_id");
                    customParams.put(ORGID, orgid);
                }
                customParams.put("ruletype", "private");
                PageShowCommon.showForm((ShowType)ShowType.MainNewTabPage, (String)TCSD_RULE_CONFIGS, (IFormView)this.getView().getParentView(), customParams, (IFormPlugin)this);
            } else if (Objects.equals(map.get("flag"), "directaccess")) {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
                String gathernumber = this.getPageCache().get(GATHERNUMBER);
                YhsAccountServiceHelper.createAccount(entryEntity, gathernumber);
                this.getPageCache().put("okflag", "true");
            }
            this.getView().close();
        }
    }

    public Map<String, DynamicObject> collectRuleList(String orgId) {
        DynamicObjectCollection voucherPrivates = RuleUtils.getRuleList(orgId, "private", TCSD_CONTRACT_VOUCHER, "nssb");
        DynamicObjectCollection transferPrivates = RuleUtils.getRuleList(orgId, "private", TCSD_TRANSFER_DOCUMENTS, "nssb");
        DynamicObjectCollection bookPrivates = RuleUtils.getRuleList(orgId, "private", TCSD_MONEY_ACCOUNT_BOOK, "nssb");
        voucherPrivates.addAll((Collection)RuleUtils.getPublicRules(orgId, YSHTPZ, "nssb"));
        transferPrivates.addAll((Collection)RuleUtils.getPublicRules(orgId, CQZYSJ, "nssb"));
        bookPrivates.addAll((Collection)RuleUtils.getPublicRules(orgId, ZJZB, "nssb"));
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
        boolean anyMatch = transferPrivates.stream().filter(s -> "02001".equals(s.getString("tnumber"))).anyMatch(s -> "0".equals(s.getString("subtaxitem")));
        if (anyMatch) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ea7\u6743\u8f6c\u79fb\u4e66\u636e\u53d6\u6570\u89c4\u5219\u7684\u5b50\u76ee\u4e3a\u7a7a\uff0c\u8bf7\u5148\u914d\u7f6e\u3002", (String)"YhsTaxSourceGatherFormPlugin_4", (String)"taxc-tcret", (Object[])new Object[0]));
            return null;
        }
        voucherPrivates.stream().forEach(s -> map.computeIfAbsent(s.getString("taxitem") + "_" + s.getString("taxation"), k -> s));
        transferPrivates.stream().forEach(s -> map.computeIfAbsent(s.getString("taxitem") + "_" + s.getString("taxation"), k -> s));
        bookPrivates.stream().forEach(s -> map.computeIfAbsent(s.getString("taxitem") + "_" + s.getString("taxation"), k -> s));
        return map;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String gathernumber = this.getPageCache().get(GATHERNUMBER);
        String okflag = this.getPageCache().get("okflag");
        if (StringUtil.isNotEmpty((CharSequence)gathernumber) && StringUtil.isEmpty((CharSequence)okflag)) {
            DeleteServiceHelper.delete((String)TAX_SOURCE_YHSSM, (QFilter[])new QFilter(GATHERNUMBER, "=", (Object)gathernumber).toArray());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if (ORG.equals(name)) {
            MulBasedataDynamicObjectCollection newValue = (MulBasedataDynamicObjectCollection)changeData.getNewValue();
            MulBasedataDynamicObjectCollection oldValue = (MulBasedataDynamicObjectCollection)changeData.getOldValue();
            if (newValue.size() > 0) {
                Long oldOrgid = null;
                if (oldValue.size() > 0) {
                    oldOrgid = Optional.of(oldValue).map(s -> ((DynamicObject)s.get(0)).getDynamicObject("fbasedataid").getLong("id")).orElse(null);
                }
                Long orgid = Optional.ofNullable(newValue).map(s -> ((DynamicObject)s.get(0)).getDynamicObject("fbasedataid").getLong("id")).orElse(0L);
                String orgname = Optional.ofNullable(newValue).map(s -> ((DynamicObject)s.get(0)).getDynamicObject("fbasedataid").getString("name")).orElse("");
                boolean zeroDeclare = SystemParamUtil.getZeroDeclareParameter((String)"tcret", (String)"zerodeclare", (long)orgid);
                if (zeroDeclare) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u7ec4\u7ec7\u7684\u5370\u82b1\u7a0e\u4e3a\u96f6\u7533\u62a5\uff0c\u4e0d\u80fd\u751f\u6210\u53f0\u8d26", (String)"YhsTaxSourceGatherFormPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]), orgname));
                    if (oldOrgid == null) {
                        this.getModel().setValue(ORG, (Object)new Long[0]);
                    } else {
                        this.getModel().setValue(ORG, (Object)new Long[]{oldOrgid});
                    }
                    return;
                }
                boolean isOrgAuth = LicenseCheckServiceHelper.check((Object)orgid, (IFormView)this.getView(), (String)"tcret");
                if (isOrgAuth) {
                    if (oldOrgid == null) {
                        this.getModel().setValue(ORG, (Object)new Long[0]);
                    } else {
                        this.getModel().setValue(ORG, (Object)new Long[]{oldOrgid});
                    }
                    return;
                }
            }
            this.getGatherList();
        } else if (DATE.equals(name) || AQSB.equals(name)) {
            this.getGatherList();
        } else if ("getconfirm".equals(name)) {
            Object taxlimit = changeData.getDataEntity().get("taxlimit");
            Object taxorg = changeData.getDataEntity().get("taxorg.id");
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
            entryEntity.forEach(a -> {
                if (Objects.equals(taxlimit, a.get("taxlimit")) && Objects.equals(taxorg, a.get("taxorg.id"))) {
                    a.set("getconfirm", changeData.getNewValue());
                }
            });
            this.getView().updateView(ENTRYENTITY);
        }
    }

    private void getGatherList() {
        Object org = this.getModel().getValue(ORG);
        Object date = this.getModel().getValue(DATE);
        if (org == null || date == null) {
            return;
        }
        DynamicObjectCollection orgs = (DynamicObjectCollection)org;
        List<Long> ids = orgs.stream().map(a -> a.getLong("fbasedataid_id")).collect(Collectors.toList());
        Date month = DateUtils.addMonth((Date)((Date)date), (int)-1);
        HashMap<String, Map<String, String>> extendMap = new HashMap<String, Map<String, String>>();
        List<DynamicObject> fitTaxItem = this.findFitTaxItem(month, ids);
        List<DynamicObject> fitCollectTaxItem = YhsAccountServiceHelper.findFitCollectTaxItem(fitTaxItem, ids, null, null, extendMap);
        this.updateFormEntity(fitCollectTaxItem, extendMap);
        String gathernumber = this.getPageCache().get(GATHERNUMBER);
        if (StringUtil.isEmpty((CharSequence)gathernumber)) {
            gathernumber = UUID.randomUUID();
            this.getPageCache().put(GATHERNUMBER, gathernumber);
        }
        this.saveFitTaxItems(fitCollectTaxItem, gathernumber, extendMap);
    }

    private void saveFitTaxItems(List<DynamicObject> fitTaxItem, String gathernumber, Map<String, Map<String, String>> extendMap) {
        DeleteServiceHelper.delete((String)TAX_SOURCE_YHSSM, (QFilter[])new QFilter(GATHERNUMBER, "=", (Object)gathernumber).toArray());
        ArrayList<DynamicObject> arrayList = new ArrayList<DynamicObject>(fitTaxItem.size());
        Date now = new Date();
        for (DynamicObject object : fitTaxItem) {
            DynamicObject taxItem = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TAX_SOURCE_YHSSM));
            taxItem.set("taxitem", object.get("taxrate.id"));
            taxItem.set("declaretype", object.get("declaretype"));
            taxItem.set("taxlimit", object.get("period"));
            taxItem.set("isverify", object.get("isverify"));
            taxItem.set("hdrate", object.get("hdrate"));
            taxItem.set(EFFECTIVEDATE, object.get(EFFECTIVEDATE));
            taxItem.set(EXPIRYDATE, object.get(EXPIRYDATE));
            taxItem.set(GATHERNUMBER, (Object)gathernumber);
            taxItem.set("createtime", (Object)now);
            DynamicObject taxMain = (DynamicObject)object.getParent();
            taxItem.set(ORG, taxMain.get("taxorg.id"));
            taxItem.set("taxoffice", (Object)extendMap.get(object.getString("id")).get("taxoffice"));
            taxItem.set("paytype", (Object)extendMap.get(object.getString("id")).get("paytype"));
            arrayList.add(taxItem);
        }
        SaveServiceHelper.save((DynamicObject[])arrayList.toArray(new DynamicObject[arrayList.size()]));
    }

    private void updateFormEntity(List<DynamicObject> fitTaxItem, Map<String, Map<String, String>> extendMap) {
        this.getModel().deleteEntryData(ENTRYENTITY);
        List collect1 = fitTaxItem.stream().sorted(Comparator.comparing(a -> ((DynamicObject)a.getParent()).getString("taxorg.id")).thenComparing(b -> periodList.indexOf(b.getString("period")))).collect(Collectors.toList());
        this.getModel().beginInit();
        for (int i = 0; i < collect1.size(); ++i) {
            DynamicObject object = (DynamicObject)collect1.get(i);
            int index = this.getModel().createNewEntryRow(ENTRYENTITY);
            DynamicObject taxMain = (DynamicObject)object.getParent();
            this.getModel().setValue("taxorg", taxMain.get("taxorg.id"), index);
            this.getModel().setValue("declaretype", object.get("declaretype"), index);
            this.getModel().setValue("taxlimit", object.get("period"), index);
            this.getModel().setValue("skssqq", object.get(EFFECTIVEDATE), index);
            this.getModel().setValue("skssqz", object.get(EXPIRYDATE), index);
            this.getModel().setValue("taxitem", object.get("taxrate.id"), index);
            this.getModel().setValue("verifyrate", object.get("hdrate"), index);
            this.getModel().setValue("taxation", (Object)(object.getBoolean("isverify") ? HDZS : AQHZ), index);
            this.getModel().setValue("taxoffice", (Object)extendMap.get(object.getString("id")).get("taxoffice"), index);
            this.getModel().setValue("paytype", (Object)extendMap.get(object.getString("id")).get("paytype"), index);
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        Iterator iterator = entryEntity.iterator();
        while (iterator.hasNext()) {
            DynamicObject object;
            boolean isCreated = this.isCreated((object = (DynamicObject)iterator.next()).getLong("taxorg.id"), object.getDate("skssqq"), object.getDate("skssqz"), object.get("taxitem.id"), object.get("verifyrate"), object.getLong("taxoffice.id"), object.getString("paytype"));
            object.set("iscreated", (Object)(isCreated ? "yes" : "no"));
            object.set("getconfirm", (Object)(!isCreated ? 1 : 0));
        }
        this.getView().updateView();
    }

    private boolean isCreated(long org, Date start, Date end, Object taxitem, Object verifyrate, Long taxoffice, String paytype) {
        QFilter qFilter = new QFilter("skssqq", "=", (Object)start).and("skssqz", "=", (Object)end).and("taxitem", "=", taxitem).and("verifyrate", "=", verifyrate).and("datasource", "in", (Object)Lists.newArrayList((Object[])new String[]{"system", "prepay"})).and(ORG, "=", (Object)org).and("taxoffice", "=", (Object)taxoffice).and("paytype", "=", (Object)paytype);
        return QueryServiceHelper.exists((String)TCRET_YHS_TAX_ACCOUNT, (QFilter[])qFilter.toArray());
    }

    private List<DynamicObject> findFitTaxItem(Date jzsq, List<Long> orgs) {
        List enableOrgList = TaxBaseDataUtils.filterEnableOrgsByTaxType(orgs, (String)"yhs");
        TaxResult listTaxResult = TaxcMainDataServiceHelper.queryTaxcMainYhsByOrgId((List)enableOrgList);
        ArrayList collection = new ArrayList();
        if (listTaxResult.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)listTaxResult.getData())) {
            for (DynamicObject dynamicObject : (List)listTaxResult.getData()) {
                collection.addAll(dynamicObject.getDynamicObjectCollection("yhsentity"));
            }
        }
        List orgTaxItems = collection.stream().filter(a -> {
            if (NOCONTAINLIST.contains(a.getString("taxrate.number"))) {
                return false;
            }
            if (jzsq != null) {
                Date startDate = DateUtils.getFirstDateOfMonth((Date)jzsq);
                Date endDate = DateUtils.getLastDateOfMonth2((Date)jzsq);
                Date effectivedate = a.getDate(EFFECTIVEDATE);
                Date expirydate = a.getDate(EXPIRYDATE);
                if (effectivedate == null || expirydate == null) {
                    return false;
                }
                return effectivedate.compareTo(startDate) <= 0 && expirydate.compareTo(endDate) >= 0;
            }
            return false;
        }).collect(Collectors.toList());
        for (DynamicObject a2 : orgTaxItems) {
            if (jzsq == null) continue;
            String taxLimit = a2.getString("period");
            Date start = a2.getDate(EFFECTIVEDATE);
            Date end = a2.getDate(EXPIRYDATE);
            switch (taxLimit) {
                case "month": {
                    start = DateUtils.getFirstDateOfMonth((Date)jzsq);
                    end = DateUtils.getLastDateOfMonth((Date)jzsq);
                    break;
                }
                case "season": {
                    start = DateUtils.getFirstDateOfSeason((Date)jzsq);
                    end = DateUtils.getLastDateOfSeason((Date)jzsq);
                    break;
                }
                case "halfyear": {
                    start = DateUtils.getFirstDateOfHalfYear((Date)jzsq);
                    end = DateUtils.getLastDateOfHalfYear((Date)jzsq);
                    break;
                }
                case "year": {
                    start = DateUtils.getFirstDateOfYear((Date)jzsq);
                    end = DateUtils.getLastDateOfYear((Date)jzsq);
                }
            }
            a2.set(EFFECTIVEDATE, (Object)DateUtils.trunc((Date)start));
            a2.set(EXPIRYDATE, (Object)DateUtils.trunc((Date)end));
        }
        List<DynamicObject> collect = orgTaxItems.stream().filter(a -> {
            String monthOfend = DateUtils.getMonthOfDate((Date)a.getDate(EXPIRYDATE)) + "";
            String month = DateUtils.getMonthOfDate((Date)jzsq) + "";
            return Objects.equals(month, monthOfend);
        }).collect(Collectors.toList());
        return collect;
    }

    static {
        periodList.add("month");
        periodList.add("season");
        periodList.add("halfyear");
        periodList.add("year");
        periodList.add("single");
        NOCONTAINLIST = new LinkedHashSet<String>();
        NOCONTAINLIST.add("013");
        NOCONTAINLIST.add("014");
    }
}

