/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.taxsource;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcret.business.taxsource.BeforeF7FilterHelper;
import kd.taxc.tcret.business.taxsource.YhsAccountServiceHelper;
import kd.taxc.tcret.common.utils.YhsUtils;

public class YhsTaxSourceInfoEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String ORG = "org";
    private static final String TAXITEM = "taxitem";
    private static final String SUB_TAX_ITEM = "subtaxitem";
    private static final String DEDUCTIONCODE = "deductioncode";

    public void initialize() {
        BasedataEdit taxitem = (BasedataEdit)this.getControl(TAXITEM);
        taxitem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit subTaxItem = (BasedataEdit)this.getControl(SUB_TAX_ITEM);
        subTaxItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit deductioncode = (BasedataEdit)this.getControl(DEDUCTIONCODE);
        deductioncode.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (org != null) {
            boolean zeroDeclare = SystemParamUtil.getZeroDeclareParameter((String)"tcret", (String)"zerodeclare", (long)org.getLong("id"));
            if (zeroDeclare) {
                String orgname = OrgUtils.getOrgNameById((String)org.getString("id"));
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u7ec4\u7ec7\u7684\u5370\u82b1\u7a0e\u4e3a\u96f6\u7533\u62a5\uff0c\u4e0d\u80fd\u751f\u6210\u53f0\u8d26", (String)"YhsTaxSourceInfoEdit_0", (String)"taxc-tcret", (Object[])new Object[0]), orgname));
                this.getModel().setValue(ORG, null);
                return;
            }
            TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)org.getLong("id"));
            if (result.getData() != null) {
                this.getModel().setValue("taxoffice", (Object)((DynamicObject)result.getData()).getLong("taxoffice.id"));
            }
            if (YhsAccountServiceHelper.verifyTaxoffice(this.getModel().getValue(ORG), this.getModel().getValue("taxoffice"))) {
                this.getModel().setValue("paytype", (Object)"bdjn");
            } else {
                this.getModel().setValue("paytype", (Object)"ydjn");
            }
        }
    }

    public void afterBindData(EventObject e) {
        boolean zeroDeclare;
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (org != null && (zeroDeclare = SystemParamUtil.getZeroDeclareParameter((String)"tcret", (String)"zerodeclare", (long)org.getLong("id")))) {
            this.setEnable();
        }
    }

    private void setEnable() {
        this.getView().setEnable(Boolean.FALSE, new String[]{TAXITEM, SUB_TAX_ITEM, "voucherno", "vouchername", "vouchernum", "voucherdate", DEDUCTIONCODE, "yjse", "calctaxamount"});
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        BeforeF7FilterHelper.beforeF7(evt, this.getView());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        IDataModel model = this.getModel();
        if (TAXITEM.equals(name) || "verifybasis".equals(name)) {
            String declaretype = (String)model.getValue("declaretype");
            DynamicObject taxItem = (DynamicObject)model.getValue(TAXITEM);
            DynamicObject org = (DynamicObject)model.getValue(ORG);
            if (TAXITEM.equals(name) && EmptyCheckUtils.isNotEmpty((Object)changeData.getOldValue())) {
                DynamicObject object;
                model.setValue(SUB_TAX_ITEM, null);
                model.setValue("voucherno", null);
                model.setValue("vouchername", null);
                model.setValue("vouchernum", null);
                model.setValue("voucherdate", null);
                model.setValue("calctaxamount", (Object)BigDecimal.ZERO);
                model.setValue(DEDUCTIONCODE, null);
                model.setValue("yjse", null);
                if ("acsb".equals(declaretype)) {
                    model.setValue("taxation", (Object)"aqhz");
                    model.setValue("verifyrate", (Object)BigDecimal.ZERO);
                }
                if (taxItem != null && (object = YhsUtils.getTaxItem(org, taxItem.getString("number"))) != null) {
                    model.setValue("taxation", (Object)(object.getBoolean("isverify") ? "hdzs" : "aqhz"));
                    model.setValue("verifyrate", (Object)object.getBigDecimal("hdrate"));
                }
            }
            if (taxItem != null) {
                BigDecimal verifybasis = (BigDecimal)model.getValue("verifybasis");
                String taxrate = taxItem.getString("taxrate");
                if (StringUtil.isNotEmpty((CharSequence)taxrate)) {
                    String replace = taxrate.replace("\u2030", "");
                    BigDecimal bigDecimal = new BigDecimal(replace);
                    if (taxrate.contains("\u2030")) {
                        bigDecimal = bigDecimal.divide(BigDecimal.valueOf(1000L));
                    }
                    BigDecimal multiply = BigDecimalUtil.multiplyObject((Object)bigDecimal, (Object)(verifybasis == null ? BigDecimal.ZERO : verifybasis), (int)2);
                    model.setValue("ynse", (Object)multiply);
                }
            }
        } else if ("declaretype".equals(name)) {
            String declaretype = (String)model.getValue("declaretype");
            if (StringUtil.equals((CharSequence)"acsb", (CharSequence)declaretype)) {
                Object voucherdate = this.getModel().getValue("voucherdate");
                if (voucherdate != null) {
                    model.setValue("skssqz", voucherdate);
                    model.setValue("skssqq", voucherdate);
                } else {
                    model.setValue("skssqz", (Object)new Date());
                    model.setValue("skssqq", (Object)new Date());
                }
            }
        } else if ("ynse".equals(name) || DEDUCTIONCODE.equals(name)) {
            DynamicObject deductioncode = (DynamicObject)model.getValue(DEDUCTIONCODE);
            BigDecimal ynse = (BigDecimal)model.getValue("ynse");
            if (deductioncode != null) {
                String deductiontype;
                switch (deductiontype = deductioncode.getString("deductiontype")) {
                    case "1": {
                        model.setValue("deducttax", (Object)ynse);
                        break;
                    }
                    case "2": {
                        model.setValue("deducttax", (Object)ynse.divide(BigDecimal.valueOf(2L)).setScale(2, 4));
                    }
                }
            } else {
                model.setValue("deducttax", (Object)BigDecimal.ZERO);
            }
        }
    }
}

