/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.taxsource;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.report.CellStyle;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcret.business.taxsource.YhsTaxSourceServiceHelper;

public class YhsTaxSourceInfoListPlugin
extends AbstractListPlugin {
    private static final String TAXSOURCEGET = "taxsourceget";
    private static final String GENERATESBB = "generatesbb";
    private static final String TBLNEW = "tblnew";
    private static final String TCRET_YHS_SY_TZCJ = "tcret_yhs_sy_tzcj";
    private static final String TCRET_YHS_SY_TZCJMX = "tcret_yhs_sy_tzcjmx";
    private static final String YHS_TAX_SOURCE_INFO = "tcret_yhs_tax_source_info";
    private static final String TCRET_YHSSYCJ_ADD_HAND = "tcret_yhssycj_add_hand";
    private static final String TCRET_GENERATE_SBB = "tcret_generate_sbb";
    private static final List<String> refreshList = Lists.newArrayList((Object[])new String[]{"tcret_yhs_sy_tzcjmx", "tcret_yhs_sy_tzcj", "tcret_yhssycj_add_hand"});

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object org = customParams.get("orgid");
        boolean isReverse = this.isReverse(customParams);
        this.getPageCache().put("isreverse", isReverse ? SerializationUtils.toJsonString((Object)customParams) : null);
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumnList) {
            if (org != null && filterColumn.getFieldName().equals("org.id") && filterColumn instanceof CommonFilterColumn) {
                filterColumn.setDefaultValue(org.toString());
                this.getPageCache().put("verifyOrg", (String)org);
                continue;
            }
            if (!isReverse) continue;
            String taxType = (String)customParams.get("taxType");
            if (taxType.equals("yhsaq")) {
                if (filterColumn.getFieldName().equals("skssqq")) {
                    filterColumn.setDefaultValues(new Object[]{customParams.get("skssqq"), customParams.get("skssqz")});
                }
                if (filterColumn.getFieldName().equals("taxlimit")) {
                    filterColumn.setDefaultValue(DateUtils.getTaxLimit((Date)DateUtils.stringToDate((String)((String)customParams.get("skssqq"))), (Date)DateUtils.stringToDate((String)((String)customParams.get("skssqz")))));
                }
                if (!filterColumn.getFieldName().equals("declaretype")) continue;
                filterColumn.setDefaultValue("aqsb");
                continue;
            }
            if (!filterColumn.getFieldName().equals("declaretype")) continue;
            filterColumn.setDefaultValue("acsb");
        }
    }

    public void setFilter(SetFilterEvent e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List qFilters = e.getQFilters();
        if (this.isReverse(customParams) && "yhsac".equals(customParams.get("taxType"))) {
            String sbbid = String.valueOf(customParams.get("sbbid"));
            qFilters.add(new QFilter("sbbid", "in", (Object)Lists.newArrayList((Object[])new Long[]{Long.parseLong(sbbid), 0L})));
            qFilters.add(new QFilter("skssqz", "<=", (Object)DateUtils.getDayLast((Date)DateUtils.stringToDate((String)((String)customParams.get("skssqz"))))));
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        List qFilters = args.getFilterParameter().getQFilters();
        if (!CollectionUtils.isEmpty((Collection)qFilters)) {
            Optional<QFilter> optional = qFilters.stream().filter(s -> s.getProperty().equals("declaretype")).findFirst();
            optional.ifPresent(qFilter -> this.getPageCache().put("declaretype", qFilter.getValue().toString()));
        } else {
            this.getPageCache().put("declaretype", "");
        }
    }

    public void afterBindData(EventObject e) {
        ArrayList<CellStyle> cslist = new ArrayList<CellStyle>();
        BillList bl = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection collection = bl.getCurrentListAllRowCollection();
        List<Long> idList = collection.stream().map(a -> (Long)a.getPrimaryKeyValue()).collect(Collectors.toList());
        Map<Long, Integer> idMap = collection.stream().collect(Collectors.toMap(a -> (Long)a.getPrimaryKeyValue(), b -> b.getRowKey(), (m, n) -> m));
        DynamicObjectCollection taxSourceCollection = YhsTaxSourceServiceHelper.getTaxSource(idList);
        List gathernumberList = taxSourceCollection.stream().map(a -> a.getString("gathernumber")).collect(Collectors.toCollection(ArrayList::new));
        List<Long> orgList = taxSourceCollection.stream().map(a -> a.getLong("org")).collect(Collectors.toList());
        DynamicObjectCollection accountFbCollection = YhsTaxSourceServiceHelper.getAccountFb(orgList, gathernumberList);
        Map<String, List<DynamicObject>> map = accountFbCollection.stream().collect(Collectors.groupingBy(o -> o.getLong("org") + o.getString("taxsourceno")));
        List<Long> orignalidList = accountFbCollection.stream().map(a -> a.getLong("orignalid")).collect(Collectors.toList());
        DynamicObjectCollection accountCollection = YhsTaxSourceServiceHelper.getAccount(orignalidList);
        List<String> serialnoList = accountCollection.stream().map(a -> a.getString("serialno")).collect(Collectors.toList());
        DynamicObjectCollection adjustDetailCollection = YhsTaxSourceServiceHelper.getAdjustDetail(serialnoList);
        DynamicObjectCollection adjustDetailBySyxxCollection = YhsTaxSourceServiceHelper.getAdjustDetailBySyxxId(idList);
        for (DynamicObject object : taxSourceCollection) {
            if (map.get(object.getLong("org") + object.getString("gathernumber")) == null) continue;
            List orignalids = map.get(object.getLong("org") + object.getString("gathernumber")).stream().map(a -> a.getLong("orignalid")).collect(Collectors.toList());
            List serialnos = accountCollection.stream().filter(a -> orignalids.contains(a.getLong("id"))).map(a -> a.getString("serialno")).collect(Collectors.toList());
            List dynamicObjects = adjustDetailCollection.stream().filter(a -> serialnos.contains(a.getString("serialno"))).collect(Collectors.toList());
            List dynamicObjectsBySyxx = adjustDetailBySyxxCollection.stream().filter(a -> object.get("id").toString().equals(a.getString("ruleid"))).collect(Collectors.toList());
            if (dynamicObjects.size() <= 0 && dynamicObjectsBySyxx.size() <= 0) continue;
            CellStyle cs = new CellStyle();
            cs.setFieldKey("calctaxamount");
            cs.setBackColor("#DCFAE4");
            cs.setRow(idMap.get(object.getLong("id")).intValue());
            cslist.add(cs);
        }
        bl.setCellStyle(cslist);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String itemKey = afterDoOperationEventArgs.getOperateKey();
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("org", this.getPageCache().get("verifyOrg"));
        customParams.put("isreverse", this.getPageCache().get("isreverse"));
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParams().get("billFormId");
        if (TAXSOURCEGET.equals(itemKey)) {
            String operateName = ResManager.loadKDString((String)"\u53f0\u8d26\u91c7\u96c6", (String)"YhsTaxSourceInfoListPlugin_1", (String)"taxc-tcret", (Object[])new Object[0]);
            String operateDescription = ResManager.loadKDString((String)"\u5370\u82b1\u7a0e\u7a0e\u6e90\u4fe1\u606f\u53f0\u8d26\u91c7\u96c6\u9875\u9762\u6253\u5f00\u6210\u529f", (String)"YhsTaxSourceInfoListPlugin_2", (String)"taxc-tcret", (Object[])new Object[0]);
            OperatorDialogUtils.operateDialog((String)"ccxws", (String)billFormId, (String)operateName, (String)operateDescription);
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)TCRET_YHS_SY_TZCJ, (IFormView)this.getView(), customParams, (IFormPlugin)this);
        } else if (TBLNEW.equals(itemKey)) {
            String operateName = ResManager.loadKDString((String)"\u624b\u5de5\u65b0\u589e", (String)"YhsTaxSourceInfoListPlugin_3", (String)"taxc-tcret", (Object[])new Object[0]);
            String operateDescription = ResManager.loadKDString((String)"\u65b0\u589e\u5370\u82b1\u7a0e\u7a0e\u6e90\u9875\u9762\u6253\u5f00\u6210\u529f", (String)"YhsTaxSourceInfoListPlugin_4", (String)"taxc-tcret", (Object[])new Object[0]);
            OperatorDialogUtils.operateDialog((String)"ccxws", (String)billFormId, (String)operateName, (String)operateDescription);
            customParams.put("customCaption", ResManager.loadKDString((String)"\u65b0\u589e\u5370\u82b1\u7a0e\u7a0e\u6e90", (String)"YhsTaxSourceInfoListPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]));
            customParams.put("entity", YHS_TAX_SOURCE_INFO);
            customParams.put("declaretype", this.getPageCache().get("declaretype"));
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)TCRET_YHSSYCJ_ADD_HAND, (IFormView)this.getView(), customParams, (IFormPlugin)this);
        } else if (GENERATESBB.equals(itemKey)) {
            String operateName = ResManager.loadKDString((String)"\u751f\u6210\u7533\u62a5\u8868", (String)"YhsTaxSourceInfoListPlugin_5", (String)"taxc-tcret", (Object[])new Object[0]);
            String operateDescription = ResManager.loadKDString((String)"\u751f\u6210\u7533\u62a5\u8868\u9875\u9762\u6253\u5f00\u6210\u529f", (String)"YhsTaxSourceInfoListPlugin_6", (String)"taxc-tcret", (Object[])new Object[0]);
            OperatorDialogUtils.operateDialog((String)"ccxws", (String)billFormId, (String)operateName, (String)operateDescription);
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)TCRET_GENERATE_SBB, (IFormView)this.getView(), customParams, (IFormPlugin)this);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map custom;
        String actionId = e.getActionId();
        if (refreshList.contains(actionId)) {
            BillList list = (BillList)this.getControl("billlistap");
            list.refresh();
        } else if (TCRET_GENERATE_SBB.equals(actionId) && (custom = (Map)e.getReturnData()) != null) {
            custom.put("generatefrom", "yhs");
            PageShowCommon.showForm((ShowType)ShowType.MainNewTabPage, (String)"tcret_pbt_declare_home", (IFormView)this.getView(), (Map)custom, (IFormPlugin)this);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillList list = (BillList)this.getControl("billlistap");
        ListSelectedRow rowInfo = list.getCurrentSelectedRowInfo();
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)rowInfo.getPrimaryKeyValue(), (String)YHS_TAX_SOURCE_INFO);
        if (object != null) {
            String datasource = object.getString("datasource");
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("billid", rowInfo.getPrimaryKeyValue());
            if (StringUtil.equals((CharSequence)"fromacc", (CharSequence)datasource)) {
                args.setCancel(true);
                customParams.put("org", String.valueOf(object.get("org.id")));
                customParams.put("skssqq", DateUtils.format((Date)object.getDate("skssqq")));
                customParams.put("skssqz", DateUtils.format((Date)object.getDate("skssqz")));
                customParams.put("originalamount", object.getBigDecimal("calctaxamount"));
                customParams.put("serialno", object.getString("gathernumber"));
                customParams.put("sbbbillstatus", object.getString("sbbid.billstatus"));
                PageShowCommon.showForm((ShowType)ShowType.Modal, (String)TCRET_YHS_SY_TZCJMX, (IFormView)this.getView(), customParams, (IFormPlugin)this);
            }
        }
    }

    private boolean isReverse(Map<String, Object> customParams) {
        String org = (String)customParams.get("orgid");
        String taxType = (String)customParams.get("taxType");
        return StringUtil.isNotBlank((CharSequence)org) && StringUtil.isNotBlank((CharSequence)taxType);
    }
}

