/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.taxsource.hbs;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.tree.TreeFilterParameter;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.util.tree.TreeUtils;
import kd.taxc.tcret.common.utils.DateCheckUtils;
import kd.taxc.tcret.formplugin.taxsource.hbs.ExtendAbstractBillPlugin;
import kd.taxc.tcret.formplugin.taxsource.hbs.OrgCheckServiceHelper;
import kd.taxc.tcret.formplugin.taxsource.hbs.PollutionBaseDataConstant;
import kd.taxc.tcret.formplugin.taxsource.hbs.PollutionBaseDataUtils;

public class PollutionBaseDataBillPlugin
extends ExtendAbstractBillPlugin
implements BeforeF7SelectListener,
PollutionBaseDataConstant {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        pops.forEach(s -> {
            BasedataEdit type = (BasedataEdit)this.getControl((String)s);
            type.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        });
    }

    public void afterCreateNewData(EventObject e) {
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)Boolean.TRUE);
        Object object = this.getModel().getValue("org");
        Long orgid = null;
        if (object != null) {
            orgid = this.isTaxAccount(((DynamicObject)object).getLong("id")) ? Long.valueOf(((DynamicObject)object).getLong("id")) : OrgCheckServiceHelper.setDefaultOrg(this.getView(), RequestContext.get().getOrgId(), col);
        }
        this.getModel().setValue("org", orgid);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long id = dataEntity.getLong("id");
        if (id == 0L) {
            this.getModel().setValue("scjyszx", (Object)this.getScjyszx(orgid));
            this.getModel().setValue("pfksszgswjg", (Object)this.getPfksszgswjg(orgid));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        switch (name) {
            case "wrwlb": {
                this.wrwlbF7(evt, formShowParameter);
                break;
            }
            case "swrwzl": {
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u6c34\u6c61\u67d3\u7269\u79cd\u7c7b", (String)"PollutionBaseDataBillPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]));
                formShowParameter.getListFilterParameter().setFilter(new QFilter("bizdef.number", "=", (Object)"SWRWZL"));
                break;
            }
            case "wrwpfljsff": {
                this.wrwpfljsffF7(formShowParameter, evt.getRow());
                break;
            }
            case "wrwmc": {
                this.wrwmcF7(evt, formShowParameter);
                break;
            }
            case "zszm": {
                this.zszmF7(evt, formShowParameter);
                break;
            }
            case "pwxkznum": {
                this.pwxkznumF7(formShowParameter);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        Integer rowIndex = changeSet[0].getRowIndex();
        switch (name) {
            case "org": {
                this.orgChanged(newValue);
                break;
            }
            case "startdate": 
            case "enddate": {
                this.dateChanged(name, (Date)newValue);
                break;
            }
            case "wrwlb": {
                this.wrwlbChanged(newValue, oldValue, changeSet[0].getRowIndex());
                break;
            }
            case "wrwmc": {
                this.wrwmcChanged();
                break;
            }
            case "swrwzl": {
                if (newValue == null) break;
                this.swrwzlChanged(newValue, oldValue, rowIndex);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        int rowIndex;
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("switchwrwlb".equals(callBackId)) {
            rowIndex = Integer.parseInt(messageBoxClosedEvent.getCustomVaule());
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.clearData();
                this.getModel().setValue("swrwzl", null, rowIndex);
                this.setDefaultValue(rowIndex);
            } else if (MessageBoxResult.Cancel.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getPageCache().put("cancelFlag", "Boolean.TRUE");
                this.getModel().setValue("wrwlb", (Object)messageBoxClosedEvent.getCustomVaule(), rowIndex);
                this.getPageCache().put("cancelFlag", "Boolean.FALSE");
            }
        }
        if ("switchswrwzl".equals(callBackId)) {
            rowIndex = Integer.parseInt(messageBoxClosedEvent.getCustomVaule());
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.clearData();
                this.setDefaultValue(rowIndex);
            } else if (MessageBoxResult.Cancel.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getPageCache().put("cancelFlag", "Boolean.TRUE");
                this.getModel().setValue("wrwlb", (Object)messageBoxClosedEvent.getCustomVaule(), rowIndex);
                this.getPageCache().put("cancelFlag", "Boolean.FALSE");
            }
        }
        if ("savecheckwrwlbandwrwjsff".equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)this.getView().getEntityId(), (DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)}, (OperateOption)OperateOption.create());
            if (result.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"PollutionBaseDataBillPlugin_1", (String)"taxc-tcret", (Object[])new Object[0]));
            } else {
                this.getView().showOperationResult(result);
            }
        }
    }

    private boolean isTaxAccount(Long orgid) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        return QueryServiceHelper.exists((String)"bastax_taxorg", (QFilter[])new QFilter[]{orgFilter});
    }

    private void pwxkznumF7(ListShowParameter formShowParameter) {
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6392\u6c61\u8bb8\u53ef\u8bc1\u7f16\u53f7", (String)"PollutionBaseDataBillPlugin_2", (String)"taxc-tcret", (Object[])new Object[0]));
        List qFilters = formShowParameter.getListFilterParameter().getQFilters();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Long orgid = org != null ? org.getLong("id") : 0L;
        Boolean hbsEnable = (Boolean)TaxcMainDataServiceHelper.isTaxcMainHjbhsEnableByOrgId((Long)orgid).getData();
        if (!hbsEnable.booleanValue()) {
            qFilters.add(new QFilter("id", "=", (Object)0L));
        } else {
            DynamicObjectCollection hbsEntity = PollutionBaseDataUtils.getHbsEntity(orgid);
            if (!CollectionUtils.isEmpty((Collection)hbsEntity)) {
                List ids = hbsEntity.stream().filter(s -> StringUtil.isNotBlank((CharSequence)s.getString("hjbhs_number"))).map(s -> s.getLong("id")).collect(Collectors.toList());
                qFilters.add(new QFilter("id", "in", ids));
            } else {
                qFilters.add(new QFilter("id", "=", (Object)0L));
            }
        }
    }

    private void zszmF7(BeforeF7SelectEvent evt, ListShowParameter formShowParameter) {
        DynamicObject wrwmcObj = (DynamicObject)this.getModel().getValue("wrwmc", evt.getRow());
        if (wrwmcObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6c61\u67d3\u7269\u540d\u79f0", (String)"PollutionBaseDataBillPlugin_3", (String)"taxc-tcret", (Object[])new Object[0]));
            evt.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        String wrwmcNumber = wrwmcObj.getString("number");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u5f81\u6536\u5b50\u76ee", (String)"PollutionBaseDataBillPlugin_4", (String)"taxc-tcret", (Object[])new Object[0]));
        ListFilterParameter listFilterParameter = formShowParameter.getListFilterParameter();
        listFilterParameter.setFilter(new QFilter("parent.number", "=", (Object)wrwmcNumber));
    }

    private void wrwmcF7(BeforeF7SelectEvent evt, ListShowParameter formShowParameter) {
        Object value = this.getModel().getValue("wrwlb");
        if (value == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6c61\u67d3\u7269\u7c7b\u522b", (String)"PollutionBaseDataBillPlugin_5", (String)"taxc-tcret", (Object[])new Object[0]));
            evt.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        String wrwlbNumber = ((DynamicObject)value).getString("number");
        Object swrwzl = this.getModel().getValue("swrwzl");
        if ("101".equals(wrwlbNumber) && swrwzl == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6c34\u6c61\u67d3\u7269\u79cd\u7c7b", (String)"PollutionBaseDataBillPlugin_6", (String)"taxc-tcret", (Object[])new Object[0]));
            evt.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6c61\u67d3\u7269\u540d\u79f0", (String)"PollutionBaseDataBillPlugin_7", (String)"taxc-tcret", (Object[])new Object[0]));
        ListFilterParameter listFilterParameter = formShowParameter.getListFilterParameter();
        List<QFilter> qFilters = this.appendFilter(listFilterParameter.getQFilters(), evt.getRow());
        TreeFilterParameter treeFilterParameter = formShowParameter.getTreeFilterParameter();
        treeFilterParameter.setQFilters(qFilters);
        qFilters.add(new QFilter("isleaf", "=", (Object)"1"));
    }

    private void wrwpfljsffF7(ListShowParameter formShowParameter, int row) {
        ListFilterParameter listFilterParameter = formShowParameter.getListFilterParameter();
        List qFilters = listFilterParameter.getQFilters();
        String wrwlbNum = this.getF7FieldNum("wrwlb", row);
        if ("103".equals(wrwlbNum)) {
            qFilters.add(new QFilter("number", "in", (Object)new String[]{"201", "202"}));
        }
        if ("304".equals(this.getF7FieldNum("swrwzl", row))) {
            qFilters.add(new QFilter("number", "in", (Object)new String[]{"205"}));
        }
        qFilters.add(new QFilter("number", "!=", (Object)"206"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6c61\u67d3\u7269\u6392\u653e\u91cf\u8ba1\u7b97\u65b9\u6cd5", (String)"PollutionBaseDataBillPlugin_8", (String)"taxc-tcret", (Object[])new Object[0]));
    }

    private void wrwlbF7(BeforeF7SelectEvent evt, ListShowParameter formShowParameter) {
        Object org = this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7", (String)"PollutionBaseDataBillPlugin_9", (String)"taxc-tcret", (Object[])new Object[0]));
            evt.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6c61\u67d3\u7269\u79cd\u7c7b", (String)"PollutionBaseDataBillPlugin_10", (String)"taxc-tcret", (Object[])new Object[0]));
    }

    private void swrwzlChanged(Object newValue, Object oldValue, Integer rowIndex) {
        boolean modifyExistBill;
        String cancelFlag = this.getPageCache().get("cancelFlag");
        boolean bl = modifyExistBill = !"Boolean.TRUE".equals(cancelFlag) && oldValue != null;
        if (modifyExistBill && !newValue.equals(oldValue)) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("switchswrwzl", (IFormPlugin)this);
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u5207\u6362\u6c34\u6c61\u67d3\u7269\u79cd\u7c7b\u4f1a\u6e05\u7a7a\u5df2\u5f55\u5165\u6570\u636e\uff0c\u8bf7\u95ee\u662f\u5426\u5207\u6362\uff1f", (String)"PollutionBaseDataBillPlugin_11", (String)"taxc-tcret", (Object[])new Object[0]);
            this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener, new HashMap(), rowIndex.toString());
        } else {
            this.setDefaultValue(rowIndex);
        }
    }

    private void wrwmcChanged() {
        this.getModel().setValue("zszm", null);
    }

    private void wrwlbChanged(Object newValue, Object oldValue, Integer rowIndex) {
        boolean modifyExistBill;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Object value = this.getModel().getValue("wrwlb");
        String number = value != null ? ((DynamicObject)value).getString("number") : "";
        Predicate<DynamicObject> predicate = s -> Arrays.stream(s.getString("hjbhs_pollutanttype").split(",")).collect(Collectors.toList()).contains(number);
        if (!PollutionBaseDataUtils.validHbsEntityBaseData(org.getLong("id"), predicate).booleanValue()) {
            this.getModel().setValue("wrwlb", null);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u79cd\u5361\u7247\u4e2d\u672a\u5305\u542b\u5f53\u524d\u9009\u62e9\u7684\u6c61\u67d3\u7269\u7c7b\u522b", (String)"PollutionBaseDataBillPlugin_12", (String)"taxc-tcret", (Object[])new Object[0]));
            return;
        }
        String cancelFlag = this.getPageCache().get("cancelFlag");
        boolean bl = modifyExistBill = !"Boolean.TRUE".equals(cancelFlag) && oldValue != null;
        if (modifyExistBill && !newValue.equals(oldValue)) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("switchwrwlb", (IFormPlugin)this);
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u5207\u6362\u6c61\u67d3\u7269\u7c7b\u522b\u4f1a\u6e05\u7a7a\u5df2\u5f55\u5165\u6570\u636e\uff0c\u8bf7\u95ee\u662f\u5426\u5207\u6362\uff1f", (String)"PollutionBaseDataBillPlugin_13", (String)"taxc-tcret", (Object[])new Object[0]);
            this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener, new HashMap(), rowIndex.toString());
        } else {
            this.setDefaultValue(rowIndex);
        }
    }

    private void dateChanged(String name, Date newValue) {
        Date enddate;
        Date startdate = "startdate".equals(name) ? newValue : (Date)this.getModel().getValue("startdate");
        Date date = enddate = "enddate".equals(name) ? newValue : (Date)this.getModel().getValue("enddate");
        if ("startdate".equals(name) && startdate != null && !startdate.equals(DateUtils.getFirstDateOfMonth((Date)startdate))) {
            this.getModel().setValue("startdate", (Object)DateUtils.getFirstDateOfMonth((Date)startdate));
            return;
        }
        if ("enddate".equals(name) && enddate != null && !enddate.equals(DateUtils.getLastDateOfMonth2((Date)enddate))) {
            this.getModel().setValue("enddate", (Object)DateUtils.getLastDateOfMonth2((Date)enddate));
            return;
        }
        DateCheckUtils.checkDate(false, startdate, enddate, this.getView());
    }

    private void orgChanged(Object newValue) {
        long orgId = newValue != null ? ((DynamicObject)newValue).getLong("id") : 0L;
        this.getModel().setValue("scjyszx", (Object)this.getScjyszx(orgId));
        this.getModel().setValue("pfksszgswjg", (Object)this.getPfksszgswjg(orgId));
    }

    private void setDefaultValue(Integer row) {
        String number = this.getF7FieldNum("wrwlb", row);
        if ("104".equals(number)) {
            this.getModel().setValue("wrwpfljsff", (Object)this.getDefaultValue("WRWPFLJSFF", "206"), row.intValue());
        }
        if ("103".equals(number)) {
            this.getModel().setValue("wrwmc", (Object)this.getDefaultValue("NOTMATCH", "408"), row.intValue());
        }
        if (!"101".equals(number)) {
            this.getModel().setValue("swrwzl", (Object)this.getDefaultValue("NOTMATCH", "408"), row.intValue());
        }
        if ("304".equals(this.getF7FieldNum("swrwzl", row))) {
            this.getModel().setValue("wrwpfljsff", (Object)this.getDefaultValue("WRWPFLJSFF", "205"), row.intValue());
        }
    }

    private String getF7FieldNum(String field, int row) {
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(field, row);
        return dynamicObject != null ? dynamicObject.getString("number") : "";
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection entryentity;
        if (args.getSource() instanceof Save && !CollectionUtils.isEmpty((Collection)(entryentity = this.getModel().getEntryEntity("entryentity"))) && entryentity.size() > 1) {
            HashSet wrwlbSet = Sets.newHashSet();
            HashSet wrwjsffSet = Sets.newHashSet();
            entryentity.forEach(s -> {
                if (s.getDynamicObject("wrwlb") != null) {
                    wrwlbSet.add(s.getDynamicObject("wrwlb").getString("number"));
                }
                if (s.getDynamicObject("wrwpfljsff") != null) {
                    wrwjsffSet.add(s.getDynamicObject("wrwpfljsff").getString("number"));
                }
            });
            if (wrwlbSet.size() > 1 || wrwjsffSet.size() > 1) {
                args.setCancel(true);
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("savecheckwrwlbandwrwjsff", (IFormPlugin)this);
                String msg = ResManager.loadKDString((String)"\u5f53\u524d\u6392\u6c61\u53e3\u4fe1\u606f\u201c\u6c61\u67d3\u7269\u7c7b\u522b\u201d\u6216\u201c\u6c61\u67d3\u7269\u6392\u653e\u91cf\u8ba1\u7b97\u65b9\u6cd5\u201d\u4e0d\u552f\u4e00\uff0c\u53ef\u80fd\u4e0e\u7a0e\u5c40\u767b\u8bb0\u8d44\u6599\u4e0d\u7b26\uff0c\u786e\u5b9a\u8981\u7ee7\u7eed\u4fdd\u5b58\u8be5\u8bb0\u5f55\u5417", (String)"PollutionBaseDataBillPlugin_14", (String)"taxc-tcret", (Object[])new Object[0]);
                this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener, new HashMap(), "");
            }
        }
    }

    private Long getDefaultValue(String parentNumebr, String number) {
        DynamicObjectCollection dynamicObjects = PollutionBaseDataUtils.getHbsEntryLists(parentNumebr, Lists.newArrayList((Object[])new String[]{number}));
        return !CollectionUtils.isEmpty((Collection)dynamicObjects) ? Long.valueOf(((DynamicObject)dynamicObjects.get(0)).getLong("entry_detail.id")) : null;
    }

    private List<QFilter> appendFilter(List<QFilter> qFilters, int row) {
        List<String> numbers = PollutionBaseDataUtils.getNumber(this.getF7FieldNum("wrwlb", row), this.getF7FieldNum("swrwzl", row));
        if (!CollectionUtils.isEmpty(numbers)) {
            QFilter filter = new QFilter("number", "in", numbers);
            qFilters.add(filter);
        }
        return qFilters;
    }

    private void clearData() {
        this.getModel().setValue("wrwmc", null);
        this.getModel().setValue("wrwpfljsff", null);
        this.getModel().setValue("zszm", null);
        this.getModel().setValue("mark", (Object)"");
        this.getModel().setValue("bzndz", (Object)0);
    }

    private String getScjyszx(Long orgid) {
        DynamicObject taxMain = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgid).getData();
        return taxMain != null ? taxMain.getString("actualaddress") : null;
    }

    private Long getPfksszgswjg(Long orgid) {
        DynamicObject taxMain = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgid).getData();
        return taxMain != null ? (taxMain.getDynamicObject("taxoffice") != null ? Long.valueOf(taxMain.getDynamicObject("taxoffice").getLong("id")) : null) : null;
    }
}

