/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.taxsource.tdzzs.listener;

import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.declare.handler.IDeclareHandler;
import kd.taxc.bdtaxr.common.declare.listener.IControlListener;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class XmListener
implements IControlListener {
    public static final String TDZZS_XM = "tdzzsxm";

    public boolean checkControlValue(IFormView view, IPageCache pageCache, IDataModel model) {
        String datatype = pageCache.get("datatype");
        if ("2".equals(datatype)) {
            return true;
        }
        String tdzzsxm = pageCache.get("taxsourceid");
        if (EmptyCheckUtils.isEmpty((Object)tdzzsxm)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9879\u76ee\u540d\u79f0", (String)"XmListener_0", (String)"taxc-tcret", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs args, IDeclareHandler handler, IFormView view, IPageCache pageCache, IDataModel model) {
        String name = args.getProperty().getName();
        if (TDZZS_XM.equals(name)) {
            Object newValue = args.getChangeSet()[0].getNewValue();
            if (model.getValue("skssqq") != null) {
                pageCache.put("code_change_skssqq", "true");
            }
            model.setValue("skssqq", null);
            if (model.getValue("skssqz") != null) {
                pageCache.put("code_change_skssqz", "true");
            }
            model.setValue("skssqz", null);
            if (null == newValue) {
                pageCache.remove("taxsourceid");
                pageCache.remove("skssqq");
                pageCache.remove("skssqz");
                return;
            }
            Long xmId = ((DynamicObject)newValue).getLong("id");
            pageCache.put("taxsourceid", String.valueOf(xmId));
            DynamicObject xm = BusinessDataServiceHelper.loadSingleFromCache((Object)xmId, (String)"tdm_tdzzs_clearing_unit");
            String taxlimit = xm.getString("paymentdeadline");
            Map skssqzMap = DateUtils.getPrePeriodByTaxLimit((Date)new Date(), (String)taxlimit);
            if (skssqzMap != null) {
                Date skssqz = (Date)model.getValue("skssqz");
                if (skssqz == null || skssqz.compareTo((Date)skssqzMap.get("endDate")) == 0) {
                    pageCache.put("code_change_skssqq", "true");
                }
                pageCache.put("code_change_skssqq", "true");
                model.setValue("skssqq", skssqzMap.get("startDate"));
                model.setValue("skssqz", skssqzMap.get("endDate"));
            }
        }
    }
}

