/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.zys.taxsource;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchMainDto;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.license.plugin.common.AbstractLicenseCheckFormPlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tcret.business.zys.ZysCollectEngine;
import kd.taxc.tcret.business.zys.ZysService;

public class ZysCollectFormPlugin
extends AbstractLicenseCheckFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit taxsource = (BasedataEdit)this.getControl("taxsource");
        taxsource.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxdeduction = (BasedataEdit)this.getControl("taxdeduction");
        taxdeduction.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxitem = (BasedataEdit)this.getControl("taxitem");
        taxitem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        String billstatus;
        DynamicObject sbb = (DynamicObject)this.getModel().getValue("sbbid");
        if (sbb != null && ("B".equals(billstatus = sbb.getString("billstatus")) || "C".equals(billstatus))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"entryentity"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            DynamicObject taxsource;
            DynamicObject taxoffice;
            long orgId = org.getLong("id");
            TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgId);
            if (result.isSuccess() && result.getData() != null) {
                DynamicObject taxMain = (DynamicObject)result.getData();
                this.getModel().setValue("taxoffice", taxMain.get("taxoffice"));
            }
            if ((taxoffice = (DynamicObject)this.getModel().getValue("taxoffice")) != null) {
                DynamicObjectCollection collection = ZysService.queryZysRegisterByTaxoffice(taxoffice.getLong("id"));
                this.getModel().setValue("taxsource", EmptyCheckUtils.isNotEmpty((Object)collection) ? Long.valueOf(((DynamicObject)collection.get(0)).getLong("id")) : null);
            }
            if ((taxsource = (DynamicObject)this.getModel().getValue("taxsource")) != null) {
                Date date = new Date();
                String taxlimit = taxsource.getString("taxperiod");
                this.setDate(taxsource, taxlimit, date);
                Date skssqq = (Date)this.getModel().getValue("skssqq");
                Date skssqz = (Date)this.getModel().getValue("skssqz");
                this.loadDetailData(org, taxsource, skssqq, skssqz, false);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("taxsource".equals(name)) {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            DynamicObject taxoffice = (DynamicObject)this.getModel().getValue("taxoffice");
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            if (taxoffice != null && org != null) {
                QFilter taxofficeQfilter = new QFilter("taxoffice", "=", (Object)taxoffice.getLong("id"));
                QFilter orgQfilter = new QFilter("org", "=", (Object)org.getLong("id"));
                qFilter.and(taxofficeQfilter).and(orgQfilter);
            } else {
                QFilter taxofficeQfilter = new QFilter("taxoffice", "=", (Object)0L);
                qFilter.and(taxofficeQfilter);
            }
            formShowParameter.getListFilterParameter().setFilter(qFilter);
        } else if ("taxdeduction".equals(name)) {
            Date skssqq = (Date)this.getModel().getValue("skssqq");
            Date skssqz = (Date)this.getModel().getValue("skssqz");
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter skssqqFilter = new QFilter("startdate", "<=", (Object)skssqq);
            QFilter skssqzFilter = new QFilter("enddate", ">=", (Object)skssqz).or(new QFilter("enddate", "=", null));
            formShowParameter.getListFilterParameter().setFilter(skssqqFilter.and(skssqzFilter));
        } else if ("taxitem".equals(name)) {
            DynamicObject taxsource = (DynamicObject)this.getModel().getValue("taxsource");
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (taxsource != null) {
                DynamicObjectCollection taxsourceCollection = taxsource.getDynamicObjectCollection("entryentity");
                List ids = taxsourceCollection.stream().map(a -> a.getLong("taxitem.id")).collect(Collectors.toList());
                formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", ids));
            } else {
                formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "=", (Object)0L));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("recal".equals(operateKey) || "refetch".equals(operateKey)) {
            this.check(args, "org", ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"ZysCollectFormPlugin_2", (String)"taxc-tcret", (Object[])new Object[0]));
            this.check(args, "taxoffice", ResManager.loadKDString((String)"\u7a0e\u6e90\u6240\u5c5e\u7a0e\u52a1\u673a\u5173\u4e3a\u7a7a\u3002", (String)"ZysCollectFormPlugin_3", (String)"taxc-tcret", (Object[])new Object[0]));
            this.check(args, "taxsource", ResManager.loadKDString((String)"\u7a0e\u6e90\u7f16\u53f7\u4e3a\u7a7a\u3002", (String)"ZysCollectFormPlugin_4", (String)"taxc-tcret", (Object[])new Object[0]));
            this.check(args, "skssqq", ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u4e3a\u7a7a\u3002", (String)"ZysCollectFormPlugin_5", (String)"taxc-tcret", (Object[])new Object[0]));
            this.check(args, "skssqz", ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u6b62\u4e3a\u7a7a\u3002", (String)"ZysCollectFormPlugin_6", (String)"taxc-tcret", (Object[])new Object[0]));
            if ("refetch".equals(operateKey)) {
                DynamicObjectCollection ruleCollection;
                this.check(args, "entryentity", ResManager.loadKDString((String)"\u201c\u7a0e\u6e90\u4fe1\u606f\u201d\u4e3a\u7a7a\uff0c\u91cd\u65b0\u53d6\u6570\u5931\u8d25\u3002", (String)"ZysCollectFormPlugin_7", (String)"taxc-tcret", (Object[])new Object[0]));
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                DynamicObject taxsource = (DynamicObject)this.getModel().getValue("taxsource");
                if (org != null && taxsource != null && CollectionUtils.isEmpty((Collection)(ruleCollection = ZysService.queryRule(org.getLong("id"), taxsource.getLong("id"), null)))) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u7a0e\u6e90\u672a\u914d\u7f6e\u53d6\u6570\u89c4\u5219\uff0c\u8bf7\u524d\u5f80\u201c\u8d22\u4ea7\u548c\u884c\u4e3a\u7a0e-\u57fa\u7840\u8bbe\u7f6e-\u8d44\u6e90\u7a0e\u9879\u76ee\u914d\u7f6e\u201d\u4e2d\u914d\u7f6e\u53d6\u6570\u89c4\u5219\u3002", (String)"ZysCollectFormPlugin_11", (String)"taxc-tcret", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            }
        }
    }

    public void check(BeforeDoOperationEventArgs args, String field, String msg) {
        Object object = this.getModel().getValue(field);
        if (object == null) {
            args.setCancel(true);
            this.getView().showTipNotification(msg);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if ("newentry".equals(afterDoOperationEventArgs.getOperateKey())) {
            EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
            int focusRow = entryentity.getEntryState().getFocusRow();
            this.getModel().setValue("datasource", (Object)"useradd", focusRow);
        } else if ("refetch".equals(afterDoOperationEventArgs.getOperateKey())) {
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            int[] rows = entryentity.stream().filter(e -> "auto".equals(e.getString("datasource"))).map(e -> e.getInt("seq")).mapToInt(i -> i - 1).toArray();
            this.getModel().deleteEntryRows("entryentity", rows);
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            DynamicObject taxsource = (DynamicObject)this.getModel().getValue("taxsource");
            Date skssqq = (Date)this.getModel().getValue("skssqq");
            Date skssqz = (Date)this.getModel().getValue("skssqz");
            this.loadDetailData(org, taxsource, skssqq, skssqz, true);
        } else if ("recal".equals(afterDoOperationEventArgs.getOperateKey())) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("recal", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"ZysCollectFormPlugin_8", (String)"taxc-tcret", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"ZysCollectFormPlugin_9", (String)"taxc-tcret", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.YesNo;
            String msg = ResManager.loadKDString((String)"\u91cd\u7f6e\u5c06\u6e05\u7a7a\u6240\u6709\u6570\u636e\uff0c\u5e76\u6309\u7167\u53d6\u6570\u89c4\u5219\u91cd\u65b0\u53d6\u6570\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ZysCollectFormPlugin_10", (String)"taxc-tcret", (Object[])new Object[0]);
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String key = messageBoxClosedEvent.getCallBackId();
        if ("recal".equals(key) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            DynamicObject taxsource = (DynamicObject)this.getModel().getValue("taxsource");
            Date skssqq = (Date)this.getModel().getValue("skssqq");
            Date skssqz = (Date)this.getModel().getValue("skssqz");
            this.loadDetailData(org, taxsource, skssqq, skssqz, false);
        }
    }

    private void loadDetailData(DynamicObject org, DynamicObject taxsource, Date skssqq, Date skssqz, boolean refetch) {
        if (org == null || taxsource == null || skssqq == null || skssqz == null) {
            return;
        }
        DynamicObjectCollection taxsourceCollection = taxsource.getDynamicObjectCollection("entryentity");
        if (taxsourceCollection.size() > 0) {
            List<Long> taxitemIds = taxsourceCollection.stream().map(a -> a.getLong("taxitem.id")).collect(Collectors.toList());
            DynamicObjectCollection ruleCollection = ZysService.queryRule(org.getLong("id"), taxsource.getLong("id"), taxitemIds);
            Map<String, List<DynamicObject>> ruleMap = ruleCollection.stream().collect(Collectors.groupingBy(a -> a.getString("taxitem") + "_" + a.getString("taxsubitem")));
            Map<Object, Object> calculateRuleAccessResult = new HashMap();
            if (EmptyCheckUtils.isNotEmpty((Object)ruleCollection)) {
                RuleFetchMainDto ruleFetchMainDto = ZysCollectEngine.runEngine(org.getLong("id"), skssqq, skssqz, taxsource.getLong("id"), taxitemIds);
                calculateRuleAccessResult = ruleFetchMainDto.getRuleFetchCellSummaryList().stream().collect(Collectors.toMap(cell -> cell.getRuleId() + "_" + cell.getReportItem(), cell -> cell.getAmount() == null ? BigDecimal.ZERO : cell.getAmount().setScale(2, RoundingMode.HALF_UP), (key1, key2) -> key2));
            }
            this.getModel().beginInit();
            if (!refetch) {
                this.getModel().deleteEntryData("entryentity");
            }
            for (DynamicObject dynamicObject : taxsourceCollection) {
                List<DynamicObject> ruleObjectList = ruleMap.get(dynamicObject.getString("taxitem.id") + "_" + dynamicObject.getString("taxsubitem"));
                if (CollectionUtils.isNotEmpty(ruleObjectList)) {
                    for (DynamicObject ruleObject : ruleObjectList) {
                        int rowIndex = this.getModel().createNewEntryRow("entryentity");
                        this.getModel().setValue("taxitem", dynamicObject.get("taxitem"), rowIndex);
                        this.getModel().setValue("taxsubitem", dynamicObject.get("taxsubitem"), rowIndex);
                        BigDecimal taxrate = dynamicObject.getBigDecimal("taxrate");
                        this.getModel().setValue("taxrate", (Object)taxrate, rowIndex);
                        this.getModel().setValue("unit", dynamicObject.get("unit"), rowIndex);
                        String levy = dynamicObject.getString("levy");
                        this.getModel().setValue("levy", (Object)levy, rowIndex);
                        this.getModel().setValue("bizname", ruleObject.get("name"), rowIndex);
                        this.getModel().setValue("ruleid", (Object)String.valueOf(ruleObject.get("id")), rowIndex);
                        this.getModel().setValue("datasource", (Object)"auto", rowIndex);
                        if (ruleObject.getDate("taxdeduction.startdate") != null && ZysService.isEffectiveDate(skssqq, skssqz, ruleObject.getDate("taxdeduction.startdate"), ruleObject.getDate("taxdeduction.enddate"))) {
                            this.getModel().setValue("taxdeduction", ruleObject.get("taxdeduction"), rowIndex);
                        }
                        BigDecimal xssl = calculateRuleAccessResult.getOrDefault(ruleObject.getString("id") + "_xssl", BigDecimal.ZERO);
                        BigDecimal gjsl = (BigDecimal)calculateRuleAccessResult.getOrDefault(ruleObject.getString("id") + "_gjsl", BigDecimal.ZERO);
                        BigDecimal xse = (BigDecimal)calculateRuleAccessResult.getOrDefault(ruleObject.getString("id") + "_xse", BigDecimal.ZERO);
                        BigDecimal yzf = (BigDecimal)calculateRuleAccessResult.getOrDefault(ruleObject.getString("id") + "_yzf", BigDecimal.ZERO);
                        BigDecimal gjje = (BigDecimal)calculateRuleAccessResult.getOrDefault(ruleObject.getString("id") + "_gjje", BigDecimal.ZERO);
                        this.getModel().setValue("xssl", (Object)xssl, rowIndex);
                        this.getModel().setValue("gjsl", (Object)gjsl, rowIndex);
                        this.getModel().setValue("xse", (Object)xse, rowIndex);
                        this.getModel().setValue("yzf", (Object)yzf, rowIndex);
                        this.getModel().setValue("gjje", (Object)gjje, rowIndex);
                        DynamicObject taxdeduction = (DynamicObject)this.getModel().getValue("taxdeduction", rowIndex);
                        if ("cjjz".equals(levy)) {
                            BigDecimal jsxse = xse.subtract(yzf).subtract(gjje);
                            this.getModel().setValue("jsxse", (Object)jsxse, rowIndex);
                            this.getModel().setValue("jsxssl", (Object)BigDecimal.ZERO, rowIndex);
                            this.getModel().setValue("ynse", (Object)BigDecimalUtil.multiplyObject((Object)jsxse, (Object)taxrate, (int)4), rowIndex);
                            if (taxdeduction != null && "1".equals(taxdeduction.getString("deductiontype"))) {
                                this.getModel().setValue("jmsxse", (Object)jsxse, rowIndex);
                                this.getModel().setValue("jmsxssl", (Object)BigDecimal.ZERO, rowIndex);
                                this.getModel().setValue("jmse", (Object)BigDecimalUtil.multiplyObject((Object)jsxse, (Object)taxrate, (int)4), rowIndex);
                            }
                        } else if ("cljz".equals(levy)) {
                            BigDecimal jsxssl = xssl.subtract(gjsl);
                            this.getModel().setValue("jsxse", (Object)BigDecimal.ZERO, rowIndex);
                            this.getModel().setValue("jsxssl", (Object)jsxssl, rowIndex);
                            this.getModel().setValue("ynse", (Object)BigDecimalUtil.multiplyObject((Object)jsxssl, (Object)taxrate, (int)4), rowIndex);
                            if (taxdeduction != null && "1".equals(taxdeduction.getString("deductiontype"))) {
                                this.getModel().setValue("jmsxse", (Object)BigDecimal.ZERO, rowIndex);
                                this.getModel().setValue("jmsxssl", (Object)jsxssl, rowIndex);
                                this.getModel().setValue("jmse", (Object)BigDecimalUtil.multiplyObject((Object)jsxssl, (Object)taxrate, (int)4), rowIndex);
                            }
                        }
                        BigDecimal ynse = (BigDecimal)this.getModel().getValue("ynse", rowIndex);
                        BigDecimal jmse = (BigDecimal)this.getModel().getValue("jmse", rowIndex);
                        BigDecimal yjse = (BigDecimal)this.getModel().getValue("yjse", rowIndex);
                        this.getModel().setValue("ybtse", (Object)ynse.subtract(jmse).subtract(yjse), rowIndex);
                    }
                    continue;
                }
                if (refetch) continue;
                int rowIndex = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("taxitem", dynamicObject.get("taxitem"), rowIndex);
                this.getModel().setValue("taxsubitem", dynamicObject.get("taxsubitem"), rowIndex);
                this.getModel().setValue("taxrate", dynamicObject.get("taxrate"), rowIndex);
                this.getModel().setValue("unit", dynamicObject.get("unit"), rowIndex);
                this.getModel().setValue("levy", dynamicObject.get("levy"), rowIndex);
                this.getModel().setValue("datasource", (Object)"useradd", rowIndex);
            }
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject taxsource = (DynamicObject)this.getModel().getValue("taxsource");
        if ("skssqq".equals(name) || "skssqz".equals(name)) {
            Date changedate = (Date)this.getModel().getValue(name);
            if (changedate == null) {
                return;
            }
            if (taxsource != null) {
                String taxlimit = taxsource.getString("taxperiod");
                boolean isReset = this.setDate(taxsource, taxlimit, changedate);
                if (!isReset) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u201c\u7a0e\u6e90\u7f16\u53f7\u201d\u7684\u6709\u6548\u671f\u8d77\u6b62\u4e0d\u5305\u542b\u6240\u9009\u7684\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u6b62\uff0c\u8bf7\u4fee\u6539\u201c\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u6b62\u201d\u65f6\u95f4\u3002", (String)"ZysCollectFormPlugin_1", (String)"taxc-tcret", (Object[])new Object[0]));
                    this.getModel().setValue("skssqq", null);
                    this.getModel().setValue("skssqz", null);
                }
                Date skssqq = (Date)this.getModel().getValue("skssqq");
                Date skssqz = (Date)this.getModel().getValue("skssqz");
                this.loadDetailData(org, taxsource, skssqq, skssqz, false);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u6e90\u7f16\u53f7\u201c\u3002", (String)"ZysCollectFormPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]));
            }
        } else if ("taxsource".equals(name)) {
            if (taxsource != null) {
                String taxlimit = taxsource.getString("taxperiod");
                Date date = new Date();
                this.setDate(taxsource, taxlimit, date);
                Date skssqq = (Date)this.getModel().getValue("skssqq");
                Date skssqz = (Date)this.getModel().getValue("skssqz");
                this.loadDetailData(org, taxsource, skssqq, skssqz, false);
            }
        } else if ("taxoffice".equals(name)) {
            this.getModel().setValue("taxsource", null);
        }
    }

    private boolean setDate(DynamicObject taxsource, String taxlimit, Date date) {
        if (taxsource != null && date != null) {
            Map period = DateUtils.getPeriodByTaxLimit((Date)date, (String)taxlimit);
            if ("count".equals(taxlimit)) {
                period.put("startDate", DateUtils.trunc((Date)date));
                period.put("endDate", DateUtils.trunc((Date)date));
            }
            if (EmptyCheckUtils.isNotEmpty((Object)period) && ZysService.isEffectiveDate((Date)period.get("startDate"), (Date)period.get("endDate"), taxsource.getDate("startDate"), taxsource.getDate("endDate"))) {
                this.getModel().setValue("skssqq", period.get("startDate"));
                this.getModel().setValue("skssqz", period.get("endDate"));
                return true;
            }
            return false;
        }
        return false;
    }
}

