/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.opplugin;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcret.formplugin.taxsource.hbs.PollutionBaseDataConstant;
import kd.taxc.tcret.formplugin.taxsource.hbs.PollutionBaseDataUtils;

public class PollutionBaseDataSaveValidator
extends AbstractValidator
implements PollutionBaseDataConstant {
    private static Log LOGGER = LogFactory.getLog(PollutionBaseDataSaveValidator.class);

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject currentObj = dataEntity.getDataEntity();
            DynamicObject org = currentObj.getDynamicObject("org");
            if (org != null && !TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).isSuccess()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"PollutionBaseDataSaveValidator_0", (String)"taxc-tcret", (Object[])new Object[0]));
                return;
            }
            this.locationValid(dataEntity);
            this.timeValid(dataEntity);
            this.pwxkzbhValid(dataEntity);
            DynamicObjectCollection entryentity = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
            for (DynamicObject object : entryentity) {
                this.hasBasicValid(object, dataEntity);
                this.swrlValid(object, dataEntity);
                this.wrwlbValid(object, dataEntity);
                this.jsffValid(object, dataEntity);
                this.zszmValid(object, dataEntity);
                this.zszmToWrwmcValid(object, dataEntity);
            }
            if (CollectionUtils.isEmpty((Collection)entryentity) || entryentity.size() <= 1 || entryentity.stream().filter(s -> s.getDynamicObject("wrwlb") != null && "103".equals(s.getDynamicObject("wrwlb").getString("number"))).count() <= 0L) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53 \u201c\u6c61\u67d3\u7269\u7c7b\u522b\u201d\u4e3a\u201c\u566a\u58f0\u201d\u65f6\uff0c\u4e0d\u80fd\u4e0e\u5176\u4ed6\u6c61\u67d3\u7269\u5171\u7528\u4e00\u4e2a\u6392\u6c61\u53e3\uff0c\u4e14\u4e00\u4e2a\u6392\u6c61\u53e3\u53ea\u80fd\u767b\u8bb0\u4e00\u6761\u201c\u566a\u58f0\u201d\u6c61\u67d3\u7269\u4fe1\u606f\u3002", (String)"PollutionBaseDataSaveValidator_1", (String)"taxc-tcret", (Object[])new Object[0]));
        }
    }

    private void zszmValid(DynamicObject currentObj, ExtendedDataEntity dataEntity) {
        String wrwmcNumber = this.getF7FieldNum(currentObj, "wrwmc");
        if ("101212301".equals(wrwmcNumber) && currentObj.getDynamicObject("zszm") == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u6c61\u67d3\u7269\u540d\u79f0\u201d\u4e3a\u201cPH\u503c\uff08\u6c34\uff09\u201d\u65f6\uff0c\u201c\u5f81\u6536\u5b50\u76ee\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PollutionBaseDataSaveValidator_2", (String)"taxc-tcret", (Object[])new Object[0]));
        }
    }

    private void zszmToWrwmcValid(DynamicObject currentObj, ExtendedDataEntity dataEntity) {
        DynamicObject zszmObj = currentObj.getDynamicObject("zszm");
        String wrwmcNumber = this.getF7FieldNum(currentObj, "wrwmc");
        if (zszmObj != null && !Objects.equals(wrwmcNumber, zszmObj.getString("parent.number"))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u6c61\u67d3\u7269\u540d\u79f0\u201d\u548c\u201c\u5f81\u6536\u5b50\u76ee\u201d\u7684\u5bf9\u5e94\u5173\u7cfb\u9519\u8bef\u3002", (String)"PollutionBaseDataSaveValidator_3", (String)"taxc-tcret", (Object[])new Object[0]));
        }
    }

    private void locationValid(ExtendedDataEntity dataEntity) {
        DynamicObject currentObj = dataEntity.getDataEntity();
        int jingdu = currentObj.getInt("jingdu");
        int jingdufen = currentObj.getInt("jingdufen");
        BigDecimal jingdumiao = currentObj.getBigDecimal("jingdumiao");
        int weidu = currentObj.getInt("weidu");
        int weidufen = currentObj.getInt("weidufen");
        BigDecimal weidumiao = currentObj.getBigDecimal("weidumiao");
        if (jingdu < 0 || jingdu > 180) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ecf\u5ea6-\u5ea6\u8bf7\u5f55\u5165[0-180]\u5185\u7684\u6574\u6570\u3002", (String)"PollutionBaseDataSaveValidator_4", (String)"taxc-tcret", (Object[])new Object[0]));
        }
        if (weidu < 0 || weidu > 90) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7eac\u5ea6-\u5ea6\u8bf7\u5f55\u5165[0-90]\u5185\u7684\u6574\u6570\u3002", (String)"PollutionBaseDataSaveValidator_5", (String)"taxc-tcret", (Object[])new Object[0]));
        }
        if (jingdufen < 0 || jingdufen > 60 || weidufen < 0 || weidufen > 60) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ecf\u5ea6-\u5206or\u7eac\u5ea6-\u5206\u8bf7\u5f55\u5165[0-60]\u5185\u7684\u6574\u6570\u3002", (String)"PollutionBaseDataSaveValidator_6", (String)"taxc-tcret", (Object[])new Object[0]));
        }
        boolean b1 = jingdumiao != null && (jingdumiao.doubleValue() < 0.0 || jingdumiao.doubleValue() > 60.0);
        boolean b2 = weidumiao != null && (weidumiao.doubleValue() < 0.0 || weidumiao.doubleValue() > 60.0);
        LOGGER.info(ResManager.loadKDString((String)"\u7ecf\u7eac\u5ea6\u6570\u636e\uff0cid:{},jingdumiao:{},weidumiao:{}", (String)"PollutionBaseDataSaveValidator_7", (String)"taxc-tcret", (Object[])new Object[0]), new Object[]{currentObj.get("id"), jingdumiao, weidumiao});
        if (b1 || b2) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ecf\u5ea6-\u79d2or\u7eac\u5ea6-\u79d2\u8bf7\u5f55\u5165[0.0-60.0]\u5185\u7684\u5c0f\u6570\uff0c\u4fdd\u75591\u4f4d\u5c0f\u6570\u3002", (String)"PollutionBaseDataSaveValidator_8", (String)"taxc-tcret", (Object[])new Object[0]));
        }
    }

    private void jsffValid(DynamicObject currentObj, ExtendedDataEntity dataEntity) {
        String wrwlbNumber = this.getF7FieldNum(currentObj, "wrwlb");
        String wrwpfljsffNumber = this.getF7FieldNum(currentObj, "wrwpfljsff");
        if ("206".equals(wrwpfljsffNumber) && !"104".equals(wrwlbNumber)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709104\u56fa\u4f53\u5e9f\u7269\u7684\u6c61\u67d3\u7269\u6392\u653e\u91cf\u8ba1\u7b97\u65b9\u6cd5\u7f16\u7801\u4e3a206\u3002", (String)"PollutionBaseDataSaveValidator_9", (String)"taxc-tcret", (Object[])new Object[0]));
        }
    }

    private void pwxkzbhValid(ExtendedDataEntity dataEntity) {
        DynamicObject currentObj = dataEntity.getDataEntity();
        DynamicObject org = currentObj.getDynamicObject("org");
        String pwxkznumNumber = this.getF7FieldNum(currentObj, "pwxkznum");
        if (StringUtil.isEmpty((CharSequence)pwxkznumNumber)) {
            return;
        }
        DynamicObjectCollection hbsEntity = PollutionBaseDataUtils.getHbsEntity(org.getLong("id"));
        if (CollectionUtils.isEmpty((Collection)hbsEntity) || hbsEntity.stream().noneMatch(s -> pwxkznumNumber.equals(s.getString("hjbhs_number")))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u7684\u7a0e\u79cd\u5361\u7247\u6ca1\u6709\u8be5\u6392\u6c61\u8bb8\u53ef\u8bc1\u7f16\u53f7\u3002", (String)"PollutionBaseDataSaveValidator_10", (String)"taxc-tcret", (Object[])new Object[0]));
        }
    }

    private void wrwlbValid(DynamicObject currentObj, ExtendedDataEntity dataEntity) {
        List<String> numbers;
        String swrwzlNumber = this.getF7FieldNum(currentObj, "swrwzl");
        String wrwlbNumber = this.getF7FieldNum(currentObj, "wrwlb");
        String wrwmcNumber = this.getF7FieldNum(currentObj, "wrwmc");
        String wrwpfljsffNumber = this.getF7FieldNum(currentObj, "wrwpfljsff");
        if ("101".equals(wrwlbNumber)) {
            numbers = PollutionBaseDataUtils.getNumber(wrwlbNumber, swrwzlNumber);
            if ("301".equals(swrwzlNumber) && !numbers.contains(wrwmcNumber)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u586b\u5217\u7684\u6c61\u67d3\u7269\u540d\u79f0\u4e0d\u5c5e\u4e8e\u7b2c\u4e00\u7c7b\u6c34\u6c61\u67d3\u7269\u3002", (String)"PollutionBaseDataSaveValidator_11", (String)"taxc-tcret", (Object[])new Object[0]));
            }
            if ("302".equals(swrwzlNumber) && !numbers.contains(wrwmcNumber)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u586b\u5217\u7684\u6c61\u67d3\u7269\u540d\u79f0\u4e0d\u5c5e\u4e8e\u7b2c\u4e8c\u7c7b\u6c34\u6c61\u67d3\u7269\u3002", (String)"PollutionBaseDataSaveValidator_12", (String)"taxc-tcret", (Object[])new Object[0]));
            }
            if ("303".equals(swrwzlNumber) && !numbers.contains(wrwmcNumber)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u586b\u5217\u7684\u6c61\u67d3\u7269\u540d\u79f0\u4e0d\u5c5e\u4e8ePH\u503c\u3001\u8272\u5ea6\u3001\u5927\u80a0\u83cc\u7fa4\u6570\u3001\u4f59\u6c2f\u91cf\u6c34\u6c61\u67d3\u7269\u3002", (String)"PollutionBaseDataSaveValidator_13", (String)"taxc-tcret", (Object[])new Object[0]));
            }
            if ("304".equals(swrwzlNumber) && !numbers.contains(wrwmcNumber)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u6c61\u67d3\u7269\u540d\u79f0\u4e0d\u5c5e\u4e8e\u79bd\u755c\u517b\u6b96\u4e1a\u3001\u5c0f\u578b\u4f01\u4e1a\u548c\u7b2c\u4e09\u4ea7\u4e1a\u3002", (String)"PollutionBaseDataSaveValidator_14", (String)"taxc-tcret", (Object[])new Object[0]));
            }
            if ("304".equals(swrwzlNumber) && !"205".equals(wrwpfljsffNumber)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u6c61\u67d3\u7269\u79cd\u7c7b\u4ec5\u9002\u7528\u62bd\u6837\u6d4b\u7b97\u8ba1\u7b97\u65b9\u6cd5\uff0c\u8bf7\u786e\u5b9a\u5f55\u5165\u4fe1\u606f\u3002", (String)"PollutionBaseDataSaveValidator_15", (String)"taxc-tcret", (Object[])new Object[0]));
            }
        }
        if ("102".equals(wrwlbNumber) && !(numbers = PollutionBaseDataUtils.getNumber(wrwlbNumber, "")).contains(wrwmcNumber)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u6c61\u67d3\u7269\u540d\u79f0\u4e0d\u5c5e\u4e8e\u5927\u6c14\u6c61\u67d3\u7269\u3002", (String)"PollutionBaseDataSaveValidator_16", (String)"taxc-tcret", (Object[])new Object[0]));
        }
        if ("103".equals(wrwlbNumber)) {
            if (!"408".equals(wrwmcNumber)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u566a\u58f0\u6c61\u67d3\u7269\u7684\u6c61\u67d3\u7269\u540d\u79f0\u7f16\u7801\u4e3a408\u3002", (String)"PollutionBaseDataSaveValidator_17", (String)"taxc-tcret", (Object[])new Object[0]));
            }
            if (!Lists.newArrayList((Object[])new String[]{"201", "202"}).contains(wrwpfljsffNumber)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u566a\u58f0\u4ec5\u9002\u7528\u3010\u81ea\u52a8\u76d1\u6d4b\u3011\u6216\u3010\u76d1\u6d4b\u673a\u6784\u76d1\u6d4b\u3011\uff0c\u8bf7\u786e\u5b9a\u5f55\u5165\u4fe1\u606f\u3002", (String)"PollutionBaseDataSaveValidator_18", (String)"taxc-tcret", (Object[])new Object[0]));
            }
        }
        if ("104".equals(wrwlbNumber)) {
            numbers = PollutionBaseDataUtils.getNumber(wrwlbNumber, "");
            if (!numbers.contains(wrwmcNumber)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u6c61\u67d3\u7269\u540d\u79f0\u4e0d\u5c5e\u4e8e\u56fa\u4f53\u5e9f\u7269\u3002", (String)"PollutionBaseDataSaveValidator_19", (String)"taxc-tcret", (Object[])new Object[0]));
            }
            if (!"206".equals(wrwpfljsffNumber)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u56fa\u4f53\u5e9f\u7269\u7684\u6c61\u67d3\u7269\u6392\u653e\u91cf\u8ba1\u7b97\u65b9\u6cd5\u7f16\u7801\u4e3a206\u3002", (String)"PollutionBaseDataSaveValidator_20", (String)"taxc-tcret", (Object[])new Object[0]));
            }
        }
        if ("408".equals(wrwmcNumber) && !"103".equals(wrwlbNumber)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u566a\u58f0\u6c61\u67d3\u7269\u7684\u6c61\u67d3\u7269\u540d\u79f0\u7f16\u7801\u4e3a408\u3002", (String)"PollutionBaseDataSaveValidator_21", (String)"taxc-tcret", (Object[])new Object[0]));
        }
    }

    private void swrlValid(DynamicObject currentObj, ExtendedDataEntity dataEntity) {
        String swrwzlNumber = this.getF7FieldNum(currentObj, "swrwzl");
        String wrwlbNumber = this.getF7FieldNum(currentObj, "wrwlb");
        if (!"101".equals(wrwlbNumber) && StringUtils.isEmpty((Object)wrwlbNumber)) {
            currentObj.set("wrwlb", (Object)1221067502579091456L);
        }
        if (!StringUtil.isEmpty((CharSequence)swrwzlNumber) && ("101".equals(wrwlbNumber) && !Lists.newArrayList((Object[])new String[]{"301", "302", "303", "304"}).contains(swrwzlNumber) || !"101".equals(wrwlbNumber) && !"408".equals(swrwzlNumber))) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u7684\u6c34\u6c61\u67d3\u7269\u79cd\u7c7b\u7f16\u7801\uff1a%s\u3002", (String)"PollutionBaseDataSaveValidator_22", (String)"taxc-tcret", (Object[])new Object[0]), swrwzlNumber));
        }
    }

    private String getF7FieldNum(DynamicObject currentObj, String field) {
        DynamicObject dynamicObject = currentObj.getDynamicObject(field);
        return dynamicObject != null ? dynamicObject.getString("number") : "";
    }

    private void hasBasicValid(DynamicObject currentObj, ExtendedDataEntity dataEntity) {
        String wrwlbNumber = this.getF7FieldNum(currentObj, "wrwlb");
        QFilter orgFilter = new QFilter("org.number", "=", (Object)this.getF7FieldNum(dataEntity.getDataEntity(), "org"));
        DynamicObject org = QueryServiceHelper.queryOne((String)"bastax_taxorg", (String)"org.id as id,org.number as number", (QFilter[])new QFilter[]{orgFilter});
        QFilter q3 = new QFilter("number", "in", (Object)Lists.newArrayList((Object[])new String[]{"WRWZL"}));
        QFilter q4 = new QFilter("entry_detail.subnumber", "=", (Object)wrwlbNumber);
        DynamicObject wrwlbObj = QueryServiceHelper.queryOne((String)"tpo_hbs_bizdef", (String)"entry_detail.id,entry_detail.subnumber,entry_detail.projectname", (QFilter[])new QFilter[]{q3, q4});
        if (Lists.newArrayList((Object[])new String[]{"101", "102", "103", "104"}).contains(wrwlbNumber) && wrwlbObj != null) {
            Predicate<DynamicObject> predicate = s -> Arrays.stream(s.getString("hjbhs_pollutanttype").split(",")).collect(Collectors.toList()).contains(wrwlbNumber);
            if (!PollutionBaseDataUtils.validHbsEntityBaseData(org.getLong("id"), predicate).booleanValue()) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7a0e\u79cd\u5361\u7247\u672a\u5305\u542b%s\u3002", (String)"PollutionBaseDataSaveValidator_23", (String)"taxc-tcret", (Object[])new Object[0]), wrwlbObj.getString("entry_detail.projectname")));
            }
        } else {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u7684\u6c61\u67d3\u7269\u7c7b\u522b\u7f16\u7801\uff1a%s\u3002", (String)"PollutionBaseDataSaveValidator_24", (String)"taxc-tcret", (Object[])new Object[0]), wrwlbNumber));
        }
    }

    private void timeValid(ExtendedDataEntity dataEntity) {
        int dayOfDate2;
        int dayOfDate1;
        DynamicObject currentObj = dataEntity.getDataEntity();
        Date startdate = currentObj.getDate("startdate");
        Date enddate = currentObj.getDate("enddate");
        if (startdate == null || enddate == null) {
            return;
        }
        int dayOfDate = DateUtils.getDayOfDate((Date)startdate);
        if (dayOfDate != 1) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u5fc5\u987b\u662f\u6708\u521d\u3002", (String)"PollutionBaseDataSaveValidator_25", (String)"taxc-tcret", (Object[])new Object[0]));
        }
        if ((dayOfDate1 = DateUtils.getDayOfDate((Date)DateUtils.getLastDateOfMonth((Date)enddate))) != (dayOfDate2 = DateUtils.getDayOfDate((Date)enddate))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u6b62\u5fc5\u987b\u662f\u6708\u672b\u3002", (String)"PollutionBaseDataSaveValidator_26", (String)"taxc-tcret", (Object[])new Object[0]));
        }
        if (startdate.after(enddate)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\u6e90\u6709\u6548\u671f\u6b62\u7684\u65f6\u95f4\u5e94\u665a\u4e8e\u7a0e\u6e90\u6709\u6548\u671f\u8d77\u7684\u65f6\u95f4\u3002", (String)"PollutionBaseDataSaveValidator_27", (String)"taxc-tcret", (Object[])new Object[0]));
        }
    }
}

