/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.opplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.tcret.common.enums.RuleTypeEnum;

public class RuleCollectTreeOp
extends AbstractOperationServicePlugIn {
    public static final String DISABLE = "disable";
    public static final String ENABLE = "enable";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("ruletype");
        e.getFieldKeys().add("group");
        e.getFieldKeys().add("rulepurpose");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        if (DISABLE.equals(operationKey) || ENABLE.equals(operationKey)) {
            DynamicObject[] dataEntities = e.getDataEntities();
            Map<String, List<DynamicObject>> groupIdToRuleMap = Stream.of(dataEntities).collect(Collectors.groupingBy(d -> d.getDynamicObject("group").getString("id")));
            for (Map.Entry<String, List<DynamicObject>> entry : groupIdToRuleMap.entrySet()) {
                String formId = RuleTypeEnum.getStrategyByGroupId(entry.getKey()).getFormId();
                if (!EmptyCheckUtils.isNotEmpty((Object)formId)) continue;
                List ruleIds = entry.getValue().stream().map(dataEntity -> dataEntity.getLong("id")).collect(Collectors.toList());
                DynamicObject[] ruleArray = BusinessDataServiceHelper.load((Object[])ruleIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)formId));
                ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(10);
                for (DynamicObject rule : ruleArray) {
                    rule.set(ENABLE, (Object)e.getDataEntities()[0].getString(ENABLE));
                    updateList.add(rule);
                }
                SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
            }
        }
    }
}

