/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.opplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.bean.BeanCopyUtils;
import kd.taxc.tcret.common.enums.RuleTypeEnum;

public class RuleDataSynOp
extends AbstractOperationServicePlugIn {
    public static final String TCRET_ALL_RULE_CONFIG = "tcret_all_rule_config";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("ruletype");
        e.getFieldKeys().add("group");
        e.getFieldKeys().add("rulepurpose");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        if ("disable".equals(operationKey) || "enable".equals(operationKey)) {
            DynamicObject[] dataEntities = e.getDataEntities();
            List ruleIds = Stream.of(dataEntities).map(dataEntity -> dataEntity.getLong("id")).collect(Collectors.toList());
            DynamicObject[] ruleArray = BusinessDataServiceHelper.load((Object[])ruleIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TCRET_ALL_RULE_CONFIG));
            ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(10);
            for (DynamicObject rule : ruleArray) {
                rule.set("enable", (Object)e.getDataEntities()[0].getString("enable"));
                updateList.add(rule);
            }
            SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
        }
        if ("save".equals(operationKey)) {
            DynamicObject dataEntity2 = e.getDataEntities()[0];
            Object pkValue = dataEntity2.getPkValue();
            String formId = e.getDataEntities()[0].getDataEntityType().getName();
            Long groupId = RuleTypeEnum.getGroupId(formId);
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)TCRET_ALL_RULE_CONFIG);
            BeanCopyUtils.copyDynamicObjectWithoutEntity((DynamicObject)e.getDataEntities()[0], (DynamicObject)dynamicObject);
            if (RuleTypeEnum.ZYS.getFormId().equals(formId)) {
                dynamicObject.set("taxitem", (Object)dataEntity2.getDynamicObject("taxitem").getLong("id"));
                dynamicObject.set("taxitemtype", (Object)"tpo_zys_taxitem_entry");
                dynamicObject.set("xtys", (Object)"0");
            }
            dynamicObject.set("group", (Object)groupId);
            if (QueryServiceHelper.exists((String)TCRET_ALL_RULE_CONFIG, (Object)pkValue)) {
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
                return;
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }
}

