/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.opplugin.compare.validate;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tcret.common.enums.CompareListEnum;

public class CreateProvisionValidator
extends AbstractValidator {
    private static final String ITP_PROVISTON_ITEM = "itp_proviston_item";

    public void validate() {
        List<Long> allProvistonItems = CompareListEnum.getAllProvistonItems();
        QFilter q1 = new QFilter("id", "in", allProvistonItems);
        QFilter q2 = new QFilter("enable", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection enableItems = QueryServiceHelper.query((String)ITP_PROVISTON_ITEM, (String)"taxtype", (QFilter[])new QFilter[]{q1, q2});
        List enableTaxTypes = enableItems.stream().map(d -> d.getLong("taxtype")).collect(Collectors.toList());
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject entity = dataEntity.getDataEntity();
            if (entity.getBoolean("generatebusinessdoc")) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u5e95\u7a3f\u5df2\u751f\u6210\u8ba1\u63d0\u5355", (String)"CreateProvisionValidator_0", (String)"taxc-tcret", (Object[])new Object[0]));
                continue;
            }
            if (!"C".equalsIgnoreCase(entity.getString("billstatus"))) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u5df2\u5ba1\u6838\u7684\u5e95\u7a3f\u751f\u6210\u8ba1\u63d0\u5355", (String)"CreateProvisionValidator_1", (String)"taxc-tcret", (Object[])new Object[0]));
                continue;
            }
            long taxtypeId = entity.getDynamicObject("taxtype").getLong("id");
            if (enableTaxTypes.contains(taxtypeId)) continue;
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8ba1\u63d0\u4e8b\u9879\u672a\u542f\u7528", (String)"CreateProvisionValidator_2", (String)"taxc-tcret", (Object[])new Object[0]));
        }
    }
}

