/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.opplugin.declarelist;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareMQSender;
import kd.taxc.bdtaxr.common.mq.DeclareMQType;
import kd.taxc.bdtaxr.common.taxdeclare.constant.TaxTypeEnum;
import kd.taxc.tcret.business.draft.DraftWriteBackService;
import org.apache.commons.collections.CollectionUtils;

public class DeclareListApplyOp
extends AbstractOperationServicePlugIn {
    private static final String TCRET_QUERY_REPORT = "tcret_query_report";
    private static final String SEPARATOR = System.getProperty("line.separator");

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operateKey = args.getOperationKey();
        if ("apply".equals(operateKey)) {
            StringBuilder message = new StringBuilder();
            DynamicObject[] dataEntities = args.getDataEntities();
            List<Object> pkIds = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            DynamicObject[] declares = BusinessDataServiceHelper.load((Object[])pkIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TCRET_QUERY_REPORT));
            if (declares != null && declares.length > 0) {
                ArrayList<DynamicObject> modifyDynamicObjects = new ArrayList<DynamicObject>();
                for (DynamicObject declare : declares) {
                    DynamicObject org = declare.getDynamicObject("org");
                    String billStatus = declare.getString("billstatus");
                    String billno = declare.getString("billno");
                    if (!"C".equals(billStatus)) {
                        message.append(String.format(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u7533\u62a5\u8868\u624d\u80fd\u63d0\u4ea4\u7533\u62a5: %1$s %2$s\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"DeclareListApplyOp_0", (String)"taxc-tcret", (Object[])new Object[0]), org.getString("name"), billno)).append(SEPARATOR);
                        continue;
                    }
                    if (!"editing".equals(declare.getString("declarestatus")) && !"declarefailed".equals(declare.getString("declarestatus"))) {
                        message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u72b6\u6001\u672a\u7533\u62a5\u6216\u7533\u62a5\u5931\u8d25\u72b6\u6001\u53ef\u786e\u8ba4\u7533\u62a5: %1$s %2$s\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"DeclareListApplyOp_1", (String)"taxc-tcret", (Object[])new Object[0]), org.getString("name"), billno)).append(SEPARATOR);
                        continue;
                    }
                    BigDecimal bqybtse = declare.getBigDecimal("bqybtse");
                    this.setPayStatus(bqybtse, declare, "tcret");
                    declare.set("declarestatus", (Object)"declared");
                    declare.set("modifytime", (Object)new Date());
                    declare.set("modifier", (Object)RequestContext.get().getUserId());
                    declare.set("declaretype", (Object)"0");
                    declare.set("sbrq", (Object)new Date());
                    declare.set("declarer", (Object)RequestContext.get().getUserId());
                    modifyDynamicObjects.add(declare);
                }
                String msg = message.toString();
                if (StringUtils.isNotBlank((CharSequence)message.toString())) {
                    this.operationResult.setSuccess(false);
                    this.operationResult.setMessage(msg);
                    this.operationResult.setShowMessage(false);
                    return;
                }
                if (!CollectionUtils.isEmpty(modifyDynamicObjects)) {
                    List ids = modifyDynamicObjects.stream().filter(d -> !"nopay".equals(d.getString("paystatus"))).map(a -> a.get("id")).collect(Collectors.toList());
                    DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DeferPayApplyService", (String)"manualDeclare", (Object[])new Object[]{ids});
                    SaveServiceHelper.save((DynamicObject[])modifyDynamicObjects.toArray(new DynamicObject[modifyDynamicObjects.size()]));
                    for (DynamicObject modifyob : modifyDynamicObjects) {
                        DeclareMQSender.sendMQ((DynamicObject)modifyob, (Date)DeclareListApplyOp.getPayDate(modifyob), (String)DeclareMQType.PAY.name(), (String)operateKey);
                    }
                    this.operationResult.setSuccess(true);
                }
                DraftWriteBackService.writeBackDeclareReportByField(pkIds, "declarestatus", "declared");
            }
        }
    }

    private static Date getPayDate(DynamicObject modifyob) {
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bdtaxr_pay_record", (String)"paydate", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)modifyob.getString("id"))});
        return null == obj ? null : obj.getDate("paydate");
    }

    private void setPayStatus(BigDecimal bqybtse, DynamicObject declare, String appId) {
        String type = declare.getString("type");
        String declareAppId = this.getAppId(type, appId);
        if ("tcvat".equals(declareAppId)) {
            DynamicObjectCollection entryentity = declare.getDynamicObjectCollection("entryentity");
            DynamicObject zzs = entryentity.stream().filter(e -> "1".equals(e.getString("taxtypes"))).findFirst().orElse(null);
            if (zzs != null && BigDecimal.ONE.compareTo(zzs.getBigDecimal("bqdybtse")) >= 0) {
                declare.set("paystatus", (Object)"nopay");
            }
        } else if ("tccit".equals(declareAppId) || "szys_a".equals(type) || "szys_b".equals(type)) {
            if (BigDecimal.ONE.compareTo(bqybtse) >= 0) {
                declare.set("paystatus", (Object)"nopay");
            }
        } else if ("tcret".equals(declareAppId)) {
            DynamicObjectCollection entryentity = declare.getDynamicObjectCollection("entryentity");
            Map<String, List<DynamicObject>> taxtypeMap = entryentity.stream().collect(Collectors.groupingBy(o -> o.getString("taxtype")));
            boolean allLessOne = true;
            for (List<DynamicObject> datums : taxtypeMap.values()) {
                BigDecimal ybse = datums.stream().map(o -> o.getBigDecimal("ybse")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                allLessOne = allLessOne && BigDecimal.ONE.compareTo(ybse) >= 0;
            }
            if (allLessOne) {
                declare.set("paystatus", (Object)"nopay");
            }
        } else if (BigDecimal.ZERO.compareTo(bqybtse) >= 0) {
            declare.set("paystatus", (Object)"nopay");
        }
    }

    private String getAppId(String declareType, String appId) {
        if ("tam".equals(appId) && (appId = Arrays.stream(TaxTypeEnum.values()).filter(e -> Arrays.asList(e.getTemplates()).contains(declareType) && !"tam".equals(e.getAppId()) && !"tsate".equals(e.getAppId())).map(TaxTypeEnum::getAppId).findFirst().orElse(appId)).contains("_")) {
            appId = appId.substring(0, appId.indexOf("_"));
        }
        return appId;
    }
}

