/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.opplugin.declarelist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import org.apache.commons.collections.CollectionUtils;

public class DeclareListUnpayOp
extends AbstractOperationServicePlugIn {
    private static final String SEPARATOR = System.getProperty("line.separator");

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operateKey = args.getOperationKey();
        if ("cancelpay".equals(operateKey)) {
            StringBuilder message = new StringBuilder();
            DynamicObject[] dataEntities = args.getDataEntities();
            List pkIds = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            DynamicObject[] declares = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)MetadataUtil.getAllSubFieldString((String)"tcvat_nsrxx"), (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
            if (declares != null && declares.length > 0) {
                ArrayList<DynamicObject> modifyDynamicObjects = new ArrayList<DynamicObject>();
                for (DynamicObject declare : declares) {
                    DynamicObject org = declare.getDynamicObject("org");
                    String payType = declare.getString("paytype");
                    String billno = declare.getString("billno");
                    String billStatus = declare.getString("billstatus");
                    if (!"C".equals(billStatus)) {
                        message.append(String.format(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u7533\u62a5\u8868\u624d\u80fd\u53d6\u6d88\u7f34\u6b3e: %1$s %2$s \u4e0d\u7b26\u5408\u6761\u4ef6", (String)"DeclareListUnpayOp_0", (String)"taxc-tcret", (Object[])new Object[0]), org.getString("name"), billno)).append(SEPARATOR);
                        continue;
                    }
                    if (!"paid".equals(declare.getString("paystatus"))) {
                        message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7f34\u6b3e\u72b6\u6001\u4e3a\u7f34\u6b3e\u6210\u529f\u7684\u6570\u636e\u53ef\u53d6\u6d88\u7f34\u6b3e: %1$s %2$s \u4e0d\u7b26\u5408\u6761\u4ef6", (String)"DeclareListUnpayOp_1", (String)"taxc-tcret", (Object[])new Object[0]), org.getString("name"), billno)).append(SEPARATOR);
                        continue;
                    }
                    if (!"0".equals(payType)) {
                        message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7f34\u6b3e\u65b9\u5f0f\u4e3a\u624b\u5de5\u7f34\u6b3e\u7684\u6570\u636e\u53ef\u53d6\u6d88\u7f34\u6b3e: %1$s %2$s \u4e0d\u7b26\u5408\u6761\u4ef6", (String)"DeclareListUnpayOp_2", (String)"taxc-tcret", (Object[])new Object[0]), org.getString("name"), billno)).append(SEPARATOR);
                        continue;
                    }
                    declare.set("paystatus", (Object)"unpaid");
                    declare.set("modifytime", (Object)new Date());
                    declare.set("modifier", (Object)RequestContext.get().getUserId());
                    declare.set("paytype", (Object)"");
                    declare.set("paydate", null);
                    declare.set("payer", (Object)0L);
                    modifyDynamicObjects.add(declare);
                }
                String msg = message.toString();
                if (StringUtils.isNotBlank((CharSequence)msg)) {
                    this.operationResult.setSuccess(false);
                    this.operationResult.setMessage(msg);
                    this.operationResult.setShowMessage(false);
                    return;
                }
                if (CollectionUtils.isNotEmpty(modifyDynamicObjects)) {
                    SaveServiceHelper.save((DynamicObject[])modifyDynamicObjects.toArray(new DynamicObject[modifyDynamicObjects.size()]));
                    List sbbIds = modifyDynamicObjects.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
                    DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DeferPayApplyService", (String)"cancelPay", (Object[])new Object[]{sbbIds});
                    this.operationResult.setSuccess(true);
                }
            }
        }
    }

    private static Date getPayDate(DynamicObject modifyob) {
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bdtaxr_pay_record", (String)"paydate", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)modifyob.getString("id"))});
        return null == obj ? null : obj.getDate("paydate");
    }
}

