/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.opplugin.taxsource.yhs.validate;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcret.business.taxsource.YhsTaxSourceServiceHelper;
import kd.taxc.tcret.common.utils.YhsUtils;

public class YhsTaxSourceSaveValidator
extends AbstractValidator {
    private static final String ORG = "org";
    private static final String TAXITEM = "taxitem";
    private static final String SUBTAXITEM = "subtaxitem";
    private static final String DECLARETYPE = "declaretype";
    private static final String DEDUCTIONCODE = "deductioncode";
    private static final String TAXATION = "taxation";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String CALCTAXAMOUNT = "calctaxamount";
    private static final String VOUCHERDATE = "voucherdate";

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            DynamicObject org = dynamicObject.getDynamicObject(ORG);
            if (!TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).isSuccess()) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"YhsTaxSourceSaveValidator_0", (String)"taxc-tcret", (Object[])new Object[0]));
                return;
            }
            String declaretype = dynamicObject.getString(DECLARETYPE);
            DynamicObject taxitem = dynamicObject.getDynamicObject(TAXITEM);
            DynamicObject subtaxitem = dynamicObject.getDynamicObject(SUBTAXITEM);
            String taxation = dynamicObject.getString(TAXATION);
            DynamicObject deductioncode = dynamicObject.getDynamicObject(DEDUCTIONCODE);
            BigDecimal calctaxamount = dynamicObject.getBigDecimal(CALCTAXAMOUNT);
            Date voucherdate = dynamicObject.getDate(VOUCHERDATE);
            Date skssqq = dynamicObject.getDate(SKSSQQ);
            Date skssqz = dynamicObject.getDate(SKSSQZ);
            if (StringUtil.equals((CharSequence)"aqsb", (CharSequence)declaretype)) {
                if (taxitem != null && skssqq != null && skssqz != null) {
                    boolean existTaxitem = YhsUtils.isExistTaxItem(taxitem, org, skssqq, skssqz);
                    if (!existTaxitem) {
                        String msg = String.format(ResManager.loadKDString((String)"\u5370\u82b1\u7a0e\u7a0e\u79cd\u5361\u7247\u4e2d\u4e0d\u5b58\u5728\u5f53\u524d\u5c5e\u671f\u751f\u6548\u7684%s\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u7a0e\u76ee\u7b49\u76f8\u5173\u4fe1\u606f\u3002", (String)"YhsTaxSourceSaveValidator_1", (String)"taxc-tcret", (Object[])new Object[0]), taxitem.getLocaleString("name").getLocaleValue());
                        this.addFatalErrorMessage(dataEntity, msg);
                        return;
                    }
                    DynamicObject checkUniqueness = YhsTaxSourceServiceHelper.isCheckUniqueness(taxitem, org, subtaxitem, skssqq, skssqz, taxation, deductioncode);
                    if (checkUniqueness != null && checkUniqueness.getLong("id") != dynamicObject.getLong("id")) {
                        String msg = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u76f8\u540c\u7a0e\u671f\u3001\u7a0e\u76ee\u3001\u5b50\u76ee\u3001\u5f81\u6536\u65b9\u5f0f\u548c\u51cf\u514d\u653f\u7b56\u53ea\u5141\u8bb8\u5b58\u5728\u4e00\u6761\u7a0e\u6e90\u6570\u636e\u3002", (String)"YhsTaxSourceSaveValidator_2", (String)"taxc-tcret", (Object[])new Object[0]), taxitem.getLocaleString("name").getLocaleValue());
                        this.addFatalErrorMessage(dataEntity, msg);
                        return;
                    }
                }
            } else if (StringUtil.equals((CharSequence)"acsb", (CharSequence)declaretype)) {
                if (!Objects.equals(DateUtils.format((Date)skssqq), DateUtils.format((Date)voucherdate))) {
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6309\u6b21\u7533\u62a5\u7684\u7a0e\u6e90\u6570\u636e\u7684\u5e94\u7a0e\u51ed\u8bc1\u4e66\u7acb\u65e5\u671f\u9700\u8981\u4e0e\u6240\u5c5e\u7a0e\u671f\u4fdd\u6301\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"YhsTaxSourceSaveValidator_3", (String)"taxc-tcret", (Object[])new Object[0]));
                    return;
                }
                if (calctaxamount.compareTo(BigDecimal.ZERO) <= 0) {
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6309\u6b21\u7533\u62a5\u65f6\uff0c\u8ba1\u7a0e\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0\uff0c\u8bf7\u4fee\u6539\u3002", (String)"YhsTaxSourceSaveValidator_4", (String)"taxc-tcret", (Object[])new Object[0]));
                    return;
                }
            }
            if (taxitem == null || skssqq == null || !taxitem.getString("number").equals("02001") || skssqq.compareTo(Objects.requireNonNull(YhsUtils.YHS_NEW_VERSION_DATE)) < 0 || subtaxitem != null) continue;
            String msg = ResManager.loadKDString((String)"\u4ea7\u6743\u8f6c\u79fb\u4e66\u636e\u7684\u5b50\u76ee\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5b50\u76ee\u201d\u3002", (String)"YhsTaxSourceSaveValidator_5", (String)"taxc-tcret", (Object[])new Object[0]);
            this.addFatalErrorMessage(dataEntity, msg);
            return;
        }
    }
}

