/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcwat.formplugin.declare;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.plugin.support.util.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.helper.YbnsrServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.formplugin.taxdeclare.AbstractDeclareReportPlugin;
import kd.taxc.tcret.common.utils.PbtDeclareUtil;
import kd.taxc.tcret.common.utils.SzyUtils;
import kd.taxc.tcret.common.utils.TaxSourceUtils;
import kd.taxc.tcwat.formplugin.declare.TcwatDeclareUtils;
import kd.taxc.tcwat.formplugin.declare.TcwatSourceEngine;

public class TcwatDeclarationEditPlugin
extends AbstractDeclareReportPlugin {
    private static final String CACHE_KEY_WATERSOURCEID = "watersourceid";
    private static final String CACHE_KEY_TAXSOURCEID = "taxsourceid";

    public TcwatDeclarationEditPlugin() {
        this.setControlListeners(TcwatDeclareUtils.getControlListeners());
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("bar_selectsbb".equals(key)) {
            this.selectSbb("click");
        } else if ("bar_viewsource".equals(key)) {
            this.viewSource();
        }
    }

    public void afterPropertyChanged(PropertyChangedArgs args, String changetype) {
        this.selectSbb(changetype);
    }

    private void selectSbb(String changetype) {
        if (this.isInvalidInput()) {
            return;
        }
        HashMap<String, String> customParams = new HashMap<String, String>();
        String orgid = this.getPageCache().get("orgid");
        String declaremonth = this.getPageCache().get("declaredate");
        String taxauthority = this.getPageCache().get("taxauthority");
        customParams.put("orgid", orgid);
        customParams.put("taxauthority", taxauthority);
        customParams.put("declaremonth", declaremonth);
        customParams.put("changetype", changetype);
        PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tcwat_selectsource", (IFormView)this.getView(), customParams, (IFormPlugin)this);
    }

    private void viewSource() {
        if (this.isInvalidInput()) {
            return;
        }
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("sbbid", this.getPageCache().get("sbbid"));
        customParams.put("operation", this.getPageCache().get("operation"));
        PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tcwat_view_source", (IFormView)this.getView(), customParams, (IFormPlugin)this);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if ("tcwat_selectsource".equals(evt.getActionId())) {
            ListSelectedRow listSelectedRow;
            Map returnData = (Map)evt.getReturnData();
            Object key = returnData.get("key");
            if (key == null) {
                Object changetype = returnData.get("changetype");
                if ("propertyChanged".equals(changetype)) {
                    this.getPageCache().remove("sbbid");
                }
            } else if ("btnok".equals(key) && (listSelectedRow = (ListSelectedRow)returnData.get("data")) != null) {
                String sbbbillstatus;
                DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)listSelectedRow.getPrimaryKeyValue(), (String)"tdm_water_resource");
                String taxsourceid = object.getDynamicObject("taxsource").getString("id");
                this.getPageCache().put(CACHE_KEY_WATERSOURCEID, object.getString("id"));
                this.getPageCache().put(CACHE_KEY_TAXSOURCEID, taxsourceid);
                this.getPageCache().put("businessno", object.getString("billno"));
                Date skssqq = object.getDate("skssqq");
                Date skssqz = object.getDate("skssqz");
                Long sbbid = object.getLong("sbbid");
                String sbbbillno = object.getString("sbbbillno");
                String operationStatus = "read";
                String sysbb = object.getDynamicObject("taxsource").getString("sysbb");
                if ("A".equals(sysbb)) {
                    this.getPageCache().put("templatetype", "szys_a");
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_viewsource"});
                } else {
                    this.getPageCache().put("templatetype", "szys_b");
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_viewsource"});
                }
                boolean refresh = false;
                if (sbbid == 0L) {
                    operationStatus = "edit";
                    sbbid = DeclareServiceHelper.generateSBBId((String)"tcwat_declare_query");
                    sbbbillno = DeclareServiceHelper.generateSBBNo((String)"tcwat_declare_query");
                }
                if (EmptyCheckUtils.isEmpty((Object)(sbbbillstatus = object.getString("sbbbillstatus"))) || "A".equals(sbbbillstatus)) {
                    refresh = true;
                    TcwatSourceEngine.execute(sbbid, object.getLong("id"));
                }
                this.getModel().setValue("declarenumber", (Object)sbbbillno);
                this.getPageCache().put("sbbid", String.valueOf(sbbid));
                this.getPageCache().put("sbbbillno", sbbbillno);
                this.getPageCache().put("skssqq", DateUtils.format((Date)skssqq));
                this.getPageCache().put("skssqz", DateUtils.format((Date)skssqz));
                this.showInnerPage(refresh, operationStatus);
            }
        }
    }

    public String getTemplateType() {
        String templateType = this.getPageCache().get("templatetype");
        if (StringUtils.isEmpty((Object)templateType)) {
            return "szys_a";
        }
        return templateType;
    }

    public boolean initModelValue(boolean orgChange, String orgId) {
        String taxauthority = PbtDeclareUtil.queryTaxOffice(orgId);
        this.getModel().setValue("taxauthority", (Object)taxauthority);
        this.getPageCache().put("taxauthority", taxauthority);
        Date date = new Date();
        this.getModel().setValue("declaredate", (Object)date);
        this.getPageCache().put("declaredate", DateUtils.format((Date)date));
        this.selectSbb("click");
        return false;
    }

    protected void setRequestModel(DeclareRequestModel requestModel) {
        requestModel.addBusinessValue(CACHE_KEY_TAXSOURCEID, this.getPageCache().get(CACHE_KEY_TAXSOURCEID));
        requestModel.addBusinessValue(CACHE_KEY_WATERSOURCEID, this.getPageCache().get(CACHE_KEY_WATERSOURCEID));
        String taxauthority = this.getPageCache().get("taxauthority");
        String declaredate = this.getPageCache().get("declaredate");
        if (EmptyCheckUtils.isNotEmpty((Object)taxauthority) && EmptyCheckUtils.isNotEmpty((Object)declaredate)) {
            HashMap<String, String> extendParams = new HashMap<String, String>();
            extendParams.put("taxauthority", taxauthority);
            extendParams.put("declaredate", declaredate);
            requestModel.setExtendParams(extendParams);
        }
    }

    protected void doInLoadFromHyperLinkClick(DynamicObject nsrxx) {
        String businessno = nsrxx.getString("businessno");
        DynamicObject waterResource = QueryServiceHelper.queryOne((String)"tdm_water_resource", (String)"id,taxsource.sysbb", (QFilter[])new QFilter[]{new QFilter("taxsource.number", "=", (Object)businessno)});
        if (waterResource != null) {
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)waterResource.get("id"), (String)"tdm_water_resource");
            String taxsourceid = object.getDynamicObject("taxsource").getString("id");
            this.getPageCache().put(CACHE_KEY_WATERSOURCEID, object.getString("id"));
            this.getPageCache().put(CACHE_KEY_TAXSOURCEID, taxsourceid);
            if (waterResource.getString("taxsource.sysbb").equals("A")) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_viewsource"});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_viewsource"});
            }
        }
    }

    protected void operationBill(String operationKey) {
        if ("save".equals(operationKey)) {
            String waterResourceId = this.getPageCache().get(CACHE_KEY_WATERSOURCEID);
            if (EmptyCheckUtils.isNotEmpty((Object)waterResourceId)) {
                String sbbid = this.getPageCache().get("sbbid");
                DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(waterResourceId), (String)"tdm_water_resource");
                DynamicObject ybnsr = YbnsrServiceHelper.queryYbnsrWithId((String)sbbid);
                if (ybnsr != null) {
                    object.set("sbbid", (Object)Long.parseLong(sbbid));
                    object.set("sbbbillno", (Object)ybnsr.getString("billno"));
                    object.set("declarestatus", (Object)ybnsr.getString("declarestatus"));
                    object.set("sbbbillstatus", (Object)ybnsr.getString("billstatus"));
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
                    SzyUtils.saveBills(Long.valueOf(sbbid));
                }
            }
        } else {
            String sbbid = this.getPageCache().get("sbbid");
            QFilter qFilter = new QFilter("sbbid", "=", (Object)Long.parseLong(sbbid));
            DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"tdm_water_resource", (String)"id,sbbbillstatus", (QFilter[])new QFilter[]{qFilter});
            if (object != null) {
                object.set("sbbbillstatus", (Object)TaxSourceUtils.KEY_BILLSTATUS_MAP.get(operationKey));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
            }
        }
    }

    protected DynamicObject queryNsrxx(String orgId, String templateType, String startdate, String enddate) {
        HashMap<String, String> extendsmap = new HashMap<String, String>();
        extendsmap.put("businessno", this.getPageCache().get("businessno"));
        return YbnsrService.queryYbnsr((String)orgId, (String)templateType, (String)startdate, (String)enddate, extendsmap);
    }
}

