/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcwat.formplugin.declare;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicListBasePlugin;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import org.apache.commons.lang3.StringUtils;

public class TcwatTemplateBHenandynmicPlugin
extends AbstractDynamicListBasePlugin {
    public List<Map<String, Object>> query(BussinessParamsVo bussinessParamsVo) {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>(16);
        String orgId = bussinessParamsVo.getOrgId();
        String taxauthority = (String)bussinessParamsVo.getExtendParams().get("taxauthority");
        String taxsourceid = (String)bussinessParamsVo.getExtendParams().get("taxsourceid");
        String watersourceid = (String)bussinessParamsVo.getExtendParams().get("watersourceid");
        Date skssqq = DateUtils.stringToDate((String)bussinessParamsVo.getExtendParams().get("skssqq").toString());
        Date skssqz = DateUtils.stringToDate((String)bussinessParamsVo.getExtendParams().get("skssqz").toString());
        if (StringUtils.isNotEmpty((CharSequence)watersourceid) && StringUtils.isNotEmpty((CharSequence)taxsourceid)) {
            QFilter q1 = new QFilter("org", "=", (Object)Long.valueOf(orgId));
            QFilter q2 = new QFilter("id", "=", (Object)Long.valueOf(watersourceid));
            QFilter q3 = new QFilter("skssqq", "=", (Object)skssqq);
            QFilter q4 = new QFilter("skssqz", "=", (Object)skssqz);
            DynamicObjectCollection taxresource = QueryServiceHelper.query((String)"tdm_water_source_dj", (String)"entryentity1.zszm,entryentity1.lossrate,entryentity1.taxamount", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(taxsourceid))});
            DynamicObjectCollection waterresource = QueryServiceHelper.query((String)"tdm_water_resource", (String)"entryentity.zszm,entryentity.zszm.projectname,entryentity.sqljqslb,entryentity.bqqslb", (QFilter[])new QFilter[]{q1, q2, q3, q4});
            for (DynamicObject object : waterresource) {
                HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
                resultMap.put(String.format("%1$s#%2$s", "tcwat_declare_a_tax", "zszm"), object.getString("entryentity.zszm.projectname"));
                resultMap.put(String.format("%1$s#%2$s", "tcwat_declare_a_tax", "ljqsfdl"), object.getBigDecimal("entryentity.sqljqslb"));
                resultMap.put(String.format("%1$s#%2$s", "tcwat_declare_a_tax", "bqqsl"), object.getBigDecimal("entryentity.bqqslb"));
                resultMap.put("tcwat_declare_a_tax#bqjsqsfdl", object.getBigDecimal("entryentity.bqqslb"));
                Optional<DynamicObject> taxresourcezszm = taxresource.stream().filter(o -> o.get("entryentity1.zszm").equals(object.get("entryentity.zszm"))).findFirst();
                if (taxresourcezszm.isPresent()) {
                    resultMap.put("tcwat_declare_a_tax#hlshl", taxresourcezszm.get().getBigDecimal("entryentity1.lossrate"));
                    resultMap.put("tcwat_declare_a_tax#bqsybzse", taxresourcezszm.get().getBigDecimal("entryentity1.taxamount"));
                }
                maps.add(resultMap);
            }
        }
        return maps;
    }
}

