/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.dao.draft;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.common.dto.draft.DraftDto;

public class DraftDao {
    public DynamicObject queryOneDraft(List<QFilter> filterList) {
        return QueryServiceHelper.queryOne((String)"tctb_draft_main", (String)"id,billno,billstatus,templatetype", (QFilter[])filterList.toArray(new QFilter[0]));
    }

    public DynamicObjectCollection querAllDraft(List<QFilter> filterList) {
        DynamicObjectCollection draftCollect = QueryServiceHelper.query((String)"tcvat_query_ybnsr", (String)"templatetype,startdate,enddate,accrualplan", (QFilter[])filterList.toArray(new QFilter[0]));
        return draftCollect;
    }

    public DynamicObjectCollection querAllSjjtDraft(DraftDto draftDto) {
        Long orgId = (Long)draftDto.getOrgId();
        Date startDate = (Date)draftDto.getStartDate();
        Date endDate = (Date)draftDto.getEndDate();
        String deadLine = TaxDeclareHelper.getDeadLine(draftDto.getDraftPurpose(), orgId.toString(), startDate, endDate);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter and = new QFilter("org", "=", (Object)orgId).and(new QFilter("templatetype", "in", Arrays.asList("draft_zzsybnsr_sjjt", "draft_zzsybnsr_yz_zjg_sjjt", "draft_zzsybnsr_yz_fzjg_Sjjt", "draft_zzsybnsr_sjjt", "draft_zzsxgmnsr_sjjt", "draft_zzsybnsr_ybhz_sjjt", "draft_zzsybnsr_hz_zjg_sjjt")));
        filterList.add(and);
        if ("aysb".equals(deadLine)) {
            QFilter season = new QFilter("skssqq", "=", (Object)DateUtils.getFirstDateOfSeason((Date)startDate)).and(new QFilter("skssqz", "=", (Object)DateUtils.trunc((Date)DateUtils.getLastDateOfSeason((Date)endDate))));
            QFilter month = new QFilter("skssqq", "=", (Object)startDate).and(new QFilter("skssqz", "=", (Object)endDate));
            filterList.add(month.or(season));
        } else {
            filterList.add(new QFilter("skssqq", ">=", (Object)startDate).and(new QFilter("skssqz", "<=", (Object)endDate)));
        }
        DynamicObjectCollection draftCollect = QueryServiceHelper.query((String)"tcvat_sjjt_draft_query", (String)"templatetype,skssqq,skssqz", (QFilter[])filterList.toArray(new QFilter[0]));
        return draftCollect;
    }

    public DynamicObjectCollection queryRunninSchTaskByJobId(String jobId) {
        return QueryServiceHelper.query((String)"sch_task", (String)"id", (QFilter[])new QFilter[]{new QFilter("job", "=", (Object)jobId), new QFilter("status", "=", (Object)"BEGIN")}, (String)"dispatchtime desc", (int)1);
    }
}

