/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.dynamicrow;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicListBasePlugin;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import org.apache.commons.collections.CollectionUtils;

public class TcvatDkdjpzFetchDataPlugin
extends AbstractDynamicListBasePlugin {
    private static Log logger = LogFactory.getLog(TcvatDkdjpzFetchDataPlugin.class);
    private static final ArrayList<String> FIELDS = Lists.newArrayList((Object[])new String[]{"taxpayernumber", "taxpayername", "taxoffice", "taxcode", "actualpayment"});
    private static final Long ZZS_TEMPLATEID = 1389922186361365504L;

    public List<Map<String, Object>> query(BussinessParamsVo bussinessParamsVo) {
        ArrayList<Map<String, Object>> maps;
        block13: {
            maps = new ArrayList<Map<String, Object>>(16);
            Map extendParams = bussinessParamsVo.getExtendParams();
            QFilter q1 = new QFilter("taxpayernumber", "=", extendParams.get("nsrsbh"));
            QFilter q2 = new QFilter("withholdingitems.taxcategory", "=", (Object)1);
            String startdate = (String)extendParams.get("startdate");
            String enddate = (String)extendParams.get("enddate");
            Long templateId = (Long)extendParams.get("templateId");
            QFilter q3 = new QFilter("period", "<=", (Object)DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)enddate)));
            QFilter q4 = new QFilter("period", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)startdate)));
            String taxpayertype = (String)extendParams.get("taxpayertype");
            logger.info("dkdjqd:taxpayertype" + taxpayertype + "orgid\uff1a" + extendParams.get("orgId") + "nsrsbh:" + extendParams.get("nsrsbh"));
            if ("zzsybnsr_ybhz".equals(taxpayertype) || "zzsybnsr_hz_zjg".equals(taxpayertype) || "zzsybnsr_yz_zjg".equals(taxpayertype)) {
                Object collect;
                QFilter orgIdFilter;
                DynamicObjectCollection query;
                DynamicObjectCollection tcvatYbhzPolicyConfirm;
                QFilter hzorgFilter = new QFilter("orgid", "=", (Object)Long.parseLong((String)extendParams.get("orgId")));
                QFilter startDateFilter = new QFilter("startdate", "=", (Object)DateUtils.stringToDate((String)startdate));
                QFilter endDateFilter = new QFilter("enddate", "=", (Object)DateUtils.stringToDate((String)enddate));
                QFilter sfnrhzFilter = null;
                if ("zzsybnsr_ybhz".equals(taxpayertype) || "zzsybnsr_hz_zjg".equals(taxpayertype)) {
                    sfnrhzFilter = new QFilter("entryentity.nrhzsb", "=", (Object)"1");
                }
                if (CollectionUtils.isNotEmpty((Collection)(tcvatYbhzPolicyConfirm = QueryServiceHelper.query((String)"tcvat_ybhz_policy_confirm", (String)"entryentity.suborg", (QFilter[])new QFilter[]{hzorgFilter, startDateFilter, endDateFilter, sfnrhzFilter}))) && CollectionUtils.isNotEmpty((Collection)(query = QueryServiceHelper.query((String)"bastax_taxorg", (String)"unifiedsocialcode", (QFilter[])new QFilter[]{orgIdFilter = new QFilter("org", "in", collect = tcvatYbhzPolicyConfirm.stream().map(s -> s.get("entryentity.suborg")).distinct().collect(Collectors.toList()))})))) {
                    q1 = new QFilter("taxpayernumber", "in", query.stream().map(s -> s.get("unifiedsocialcode")).collect(Collectors.toList()));
                }
            }
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tdm_withholding_tax", (String)"id,taxpayernumber,taxpayername,officetax as taxoffice,taxcode,withholdingitems.actualpayment as actualpayment,withholdingitems.itemname as itemname", (QFilter[])new QFilter[]{q1, q2, q3, q4}, (String)"taxpayernumber desc");
            logger.info("tdm_withholding_tax:" + dynamicObjects.size());
            if (!CollectionUtils.isNotEmpty((Collection)dynamicObjects)) break block13;
            if (ZZS_TEMPLATEID.equals(templateId)) {
                ArrayList zzs_fields = Lists.newArrayList((Object[])new String[]{"taxpayernumber", "taxpayername", "taxoffice", "dkdjxm", "taxcode", "actualpayment"});
                for (DynamicObject object : dynamicObjects) {
                    HashMap<String, String> resultMap = new HashMap<String, String>(16);
                    for (String field : zzs_fields) {
                        String key = String.format("%s#%s", "tdm_withholding_tax", field);
                        if ("dkdjxm".equals(field)) {
                            resultMap.put(key, object.getString("itemname"));
                            continue;
                        }
                        if ("taxoffice".equals(field)) {
                            DynamicObject taxorgan = QueryServiceHelper.queryOne((String)"bastax_taxorgan", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)object.getLong(field))});
                            if (null == taxorgan) continue;
                            resultMap.put(key, taxorgan.getString("name"));
                            continue;
                        }
                        resultMap.put(key, object.getString(field));
                    }
                    maps.add(resultMap);
                }
            } else {
                Map<Long, List<DynamicObject>> ids = dynamicObjects.stream().collect(Collectors.groupingBy(s -> s.getLong("id")));
                for (Map.Entry<Long, List<DynamicObject>> longListEntry : ids.entrySet()) {
                    List<DynamicObject> value = longListEntry.getValue();
                    DynamicObject object = value.get(0);
                    BigDecimal sum = value.stream().map(s -> s.getBigDecimal("actualpayment")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
                    for (String field : FIELDS) {
                        String key = String.format("%s#%s", "tdm_withholding_tax", field);
                        if ("actualpayment".equals(field)) {
                            resultMap.put(key, sum);
                            continue;
                        }
                        if ("taxoffice".equals(field)) {
                            DynamicObject taxorgan = QueryServiceHelper.queryOne((String)"bastax_taxorgan", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)object.getLong(field))});
                            if (null == taxorgan) continue;
                            resultMap.put(key, taxorgan.getString("name"));
                            continue;
                        }
                        resultMap.put(key, object.getString(field));
                    }
                    maps.add(resultMap);
                }
            }
        }
        return maps;
    }
}

