/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.dynamicrow.declare;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicCustomFormulaPlugin;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;

public class TcvatJmxmCheckFormulaDynamicCustomFormulaPlugin
extends AbstractDynamicCustomFormulaPlugin {
    private static final Log logger = LogFactory.getLog(TcvatJmxmCheckFormulaDynamicCustomFormulaPlugin.class);

    public Map<String, FormulaVo> query(List<DynamicRowModel> dynList) {
        HashMap<String, FormulaVo> formulaMap = new HashMap<String, FormulaVo>();
        if (!ObjectUtils.isEmpty(dynList)) {
            ArrayList<String> logs = new ArrayList<String>();
            for (DynamicRowModel dyn : dynList) {
                if (!"tcvat_ybnsr_jsxm#2".equals(dyn.getDynRowNo()) || dyn.getRowList() == null) continue;
                for (int k = 0; k < dyn.getRowList().size(); ++k) {
                    Map row = (Map)dyn.getRowList().get(k);
                    int seqno = k + 2;
                    String formula = this.buildDynamicFormula(seqno, dyn.getRowList().size() + 1);
                    for (Map.Entry entry : row.entrySet()) {
                        String cellFlag = ((String)entry.getKey()).replace(seqno + "#", "");
                        if (!"tcvat_ybnsr_jsxm#swsxdm".equals(cellFlag)) continue;
                        String[] split = cellFlag.split("#");
                        String prefixKey = split[0] + '#';
                        String suffixKey = '#' + split[1];
                        String formulaKey = prefixKey + seqno + suffixKey;
                        FormulaVo formulaVo = new FormulaVo();
                        formulaVo.setFormula(formula);
                        formulaVo.setFormulaKey(formulaKey);
                        formulaVo.setFormulaType("2");
                        formulaVo.setDatatype("number");
                        formulaVo.setTitle(ResManager.loadKDString((String)"\u300a\u51cf\u514d\u7a0e\u7533\u62a5\u660e\u7ec6\u8868\u300b\u51cf\u7a0e\u9879\u76ee\u5f02\u5e38", (String)"TcvatJmxmCheckFormulaDynamicCustomFormulaPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                        formulaVo.setContent(ResManager.loadKDString((String)"\u3010\u51cf\u7a0e\u6027\u8d28\u4ee3\u7801\u3011\u5217\u51fa\u73b0\u4e86\u91cd\u590d\u7684\u3010\u51cf\u7a0e\u4ee3\u7801\u3011\u6216\u8005\u3010\u7a7a\u767d\u884c\u3011", (String)"TcvatJmxmCheckFormulaDynamicCustomFormulaPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                        formulaMap.put(formulaKey, formulaVo);
                        logs.add("JsxmDynoRowCheckFormula===key:{" + formulaKey + "}===formula:{" + formula + "}");
                    }
                }
            }
            logger.info(((Object)logs).toString());
        }
        return formulaMap;
    }

    private String buildDynamicFormula(int seqno, int rowListSize) {
        StringBuilder checkFormul1 = new StringBuilder();
        StringBuilder checkFormul2 = new StringBuilder();
        checkFormul2.append("if(({Q[tcvat_ybnsr_jsxm#").append(seqno).append("#qcye]}!=0 ||{Q[tcvat_ybnsr_jsxm#").append(seqno).append("#bqfse]}!=0||{Q[tcvat_ybnsr_jsxm#").append(seqno).append("#bqydjse]}!=0||{Q[tcvat_ybnsr_jsxm#").append(seqno).append("#bqsjdjse]}!=0||{Q[tcvat_ybnsr_jsxm#").append(seqno).append("#qmye]}!=0)&&{Q[tcvat_ybnsr_jsxm#").append(seqno).append("#swsxdm]}==0,false,true)");
        if (seqno == rowListSize) {
            return checkFormul2.toString();
        }
        checkFormul1.append("if(");
        checkFormul1.append("{Q[tcvat_ybnsr_jsxm#").append(seqno).append("#swsxdm]}>0&&(");
        for (int i = seqno; i < rowListSize; ++i) {
            checkFormul1.append("{Q[tcvat_ybnsr_jsxm#").append(seqno).append("#swsxdm]} == {Q[tcvat_ybnsr_jsxm#").append(i + 1).append("#swsxdm]} || ");
        }
        checkFormul1.delete(checkFormul1.length() - 3, checkFormul1.length());
        checkFormul1.append(")");
        checkFormul1.append(", false,");
        checkFormul1.append((CharSequence)checkFormul2);
        checkFormul1.append(")");
        return checkFormul1.toString();
    }
}

