/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.dynamicrow.declare;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicListBasePlugin;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import kd.taxc.tcvat.business.dynamicrow.TcvatHenanDeclarePlugin;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;

public class TcvatJmxmFetchDataPlugin
extends AbstractDynamicListBasePlugin {
    private static final String TCVAT_YBNSR_JSXM = "tcvat_ybnsr_jsxm";
    private static final String SPLIT = "#";

    public List<Map<String, Object>> query(BussinessParamsVo bussinessParamsVo) {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>(16);
        Map extendParams = bussinessParamsVo.getExtendParams();
        String orgId = (String)extendParams.get("orgId");
        String startPeriod = (String)extendParams.get("startPeriod");
        String middlePeriod = (String)extendParams.get("middlePeriod");
        String endPeriod = (String)extendParams.get("endPeriod");
        String deadline = (String)extendParams.get("deadline");
        String taxpayertype = (String)extendParams.get("taxpayertype");
        Long templateId = (Long)extendParams.get("templateId");
        String preSbbid = (String)extendParams.get("presbbid");
        QFilter preJsxmFilter = new QFilter("sbbid", "=", (Object)preSbbid).and("swsxdm", "!=", (Object)0L);
        Map<String, BigDecimal> reportSwsxdm = this.queryPerJsxmReportSwsxdmMap(preJsxmFilter);
        Map<String, BigDecimal> draftswsxdm = this.queryCurrentTaxReductionDraftSwsxdmMap(extendParams, orgId, startPeriod, middlePeriod, endPeriod, deadline, taxpayertype);
        this.buildDynamicRowMap(maps, extendParams, templateId, reportSwsxdm, draftswsxdm);
        return maps;
    }

    public Map<String, BigDecimal> queryCurrentTaxReductionDraftSwsxdmMap(Map<String, Object> extendParams, String orgId, String startPeriod, String middlePeriod, String endPeriod, String deadline, String taxpayertype) {
        DraftMetaDataInfo taxReductionMetaData = DraftMetaDataDTO.getMetaDataByCustomParam(extendParams).getTaxReduction();
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        QFilter deadLineFilter = new QFilter("deadline", "=", (Object)deadline);
        QFilter taxPeriodFilter = new QFilter("startdate", ">=", (Object)DateUtils.stringToDate2((String)((String)extendParams.get("skssqq")))).and(new QFilter("enddate", "<=", (Object)DateUtils.stringToDate2((String)((String)extendParams.get("skssqz")))));
        if ("zzsybnsr".equals(taxpayertype) || "zzsxgmnsr".equals(taxpayertype)) {
            taxPeriodFilter = new QFilter("taxperiod", "in", Arrays.asList(startPeriod, middlePeriod, endPeriod));
        }
        QFilter taxPayerTypeFilter = new QFilter("taxpayertype", "in", (Object)taxpayertype);
        DynamicObjectCollection TaxReductionDraftListCollection = QueryServiceHelper.query((String)taxReductionMetaData.getAccountMetaDataName(), (String)"taxreductionid,currentamount", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter, deadLineFilter, taxPayerTypeFilter});
        return TaxReductionDraftListCollection.stream().collect(Collectors.groupingBy(k -> k.getString("taxreductionid"), Collectors.mapping(v -> v.getBigDecimal("currentamount"), Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
    }

    public Map<String, BigDecimal> queryPerJsxmReportSwsxdmMap(QFilter preJsxmFilter) {
        DynamicObjectCollection preJsxmReportCollection = QueryServiceHelper.query((String)TCVAT_YBNSR_JSXM, (String)"swsxdm as taxreductionid,qmye", (QFilter[])new QFilter[]{preJsxmFilter});
        return preJsxmReportCollection.stream().collect(Collectors.groupingBy(k -> k.getString("taxreductionid"), Collectors.mapping(v -> v.getBigDecimal("qmye"), Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
    }

    public void buildDynamicRowMap(ArrayList<Map<String, Object>> maps, Map<String, Object> extendParams, Long templateId, Map<String, BigDecimal> reportSwsxdm, Map<String, BigDecimal> draftswsxdm) {
        HashSet<String> taxReductionIdSet = new HashSet<String>(reportSwsxdm.size() + draftswsxdm.size());
        taxReductionIdSet.addAll(reportSwsxdm.keySet());
        taxReductionIdSet.addAll(draftswsxdm.keySet());
        for (String taxReductionId : taxReductionIdSet) {
            BigDecimal currentamount;
            if (null == draftswsxdm.get(taxReductionId) && null != reportSwsxdm.get(taxReductionId) && BigDecimal.ZERO.compareTo(reportSwsxdm.get(taxReductionId)) == 0) continue;
            HashMap<String, Object> result = new HashMap<String, Object>();
            BigDecimal sqqmye = null == reportSwsxdm.get(taxReductionId) ? BigDecimal.ZERO : reportSwsxdm.get(taxReductionId);
            sqqmye = this.getHeNanSqqmye(extendParams, templateId, taxReductionId, sqqmye);
            BigDecimal bigDecimal = currentamount = null == draftswsxdm.get(taxReductionId) ? BigDecimal.ZERO : draftswsxdm.get(taxReductionId);
            if (sqqmye.compareTo(BigDecimal.ZERO) == 0 && currentamount.compareTo(BigDecimal.ZERO) == 0) continue;
            result.put("tcvat_ybnsr_jsxm#swsxdm", taxReductionId);
            result.put("tcvat_ybnsr_jsxm#qcye", sqqmye);
            result.put("tcvat_ybnsr_jsxm#bqfse", currentamount);
            result.put("tcvat_ybnsr_jsxm#bqsjdjse", BigDecimal.ZERO);
            maps.add(result);
        }
    }

    public BigDecimal getHeNanSqqmye(Map<String, Object> extendParams, Long templateId, String taxReductionId, BigDecimal sqqmye) {
        if (templateId.compareTo(1636309081566231552L) == 0 && ("789806480307039232".equals(taxReductionId) || "789806484266464256".equals(taxReductionId) || "789806484274850816".equals(taxReductionId))) {
            extendParams.put("judgeHenanMc", taxReductionId);
            extendParams.put("sqqmye", sqqmye);
            return new TcvatHenanDeclarePlugin().query(extendParams);
        }
        return sqqmye;
    }
}

