/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.dynamicrow.precision;

import kd.taxc.tcvat.business.dynamicrow.precision.PrecisionHandler;
import kd.taxc.tcvat.business.dynamicrow.precision.handle.NcpDgHandle;
import kd.taxc.tcvat.business.dynamicrow.precision.handle.TaxRefundHandle;
import kd.taxc.tcvat.business.dynamicrow.precision.handle.TcvatHljnmHandle;
import kd.taxc.tcvat.business.dynamicrow.precision.handle.TcvatZjHandle;
import kd.taxc.tcvat.business.dynamicrow.precision.handle.TcvatZzsybnsrHNGXHandle;
import kd.taxc.tcvat.business.dynamicrow.precision.handle.TcvatZzsybnsrHandle;

public enum TemplateNumberEnum {
    VAT202206("VAT202206", "zzsybnsr", new TcvatZzsybnsrHandle()),
    VAT202206_A("VAT202206-A", "zzsybnsr", new TcvatZzsybnsrHandle()),
    VAT202206_HUNAN("VAT202206-HUNAN", "zzsybnsr", new TcvatZzsybnsrHNGXHandle()),
    VAT202206_HNGX("VAT202206-HNGX", "zzsybnsr", new TcvatZzsybnsrHNGXHandle()),
    VAT202206_B("VAT202206-B", "zzsybnsr", new TcvatHljnmHandle()),
    VAT202206_ZJ("VAT202206-ZJ", "zzsybnsr", new TcvatZjHandle()),
    NCP_HDKC_DG("NCP_HDKC_DG", "ncpdg", new NcpDgHandle()),
    TDSSQB("TDSSQB", "tcvat_taxrefund", new TaxRefundHandle());

    String number;
    String type;
    PrecisionHandler handle;

    private TemplateNumberEnum(String number, String type, PrecisionHandler handle) {
        this.number = number;
        this.type = type;
        this.handle = handle;
    }

    public static PrecisionHandler getPrecisionHandler(String number) {
        for (TemplateNumberEnum value : TemplateNumberEnum.values()) {
            if (!number.equalsIgnoreCase(value.getNumber())) continue;
            return value.getHandle();
        }
        return null;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public PrecisionHandler getHandle() {
        return this.handle;
    }

    public void setHandle(PrecisionHandler handle) {
        this.handle = handle;
    }
}

