/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.dynamicrow.precision.handle;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.tcvat.business.dynamicrow.precision.PrecisionHandler;

public class NcpDgHandle
implements PrecisionHandler {
    private static final String JLSGJSWJ = "12200000000";
    private static final String ZJSGJSWJ = "13300000000";
    private static final String AHSGJSWJ = "13400000000";
    private static final Set<String> SDHBSGJSWJ = Sets.newHashSet((Object[])new String[]{"13700000000", "11300000000"});
    private static final Set<String> keys624 = Sets.newHashSet((Object[])new String[]{"hyncpsldth#hy_actual_goods_sale_count", "hyncpsldth#hy_purch_sale_goods_count", "hyncpsldth#hy_self_product_sale_goods_count", "hyncpsldth#hy_accrued_input_tax_count", "hyncpsldth#hy_hyncp_count", "hyncpslhj#hy_actual_goods_sale_count", "hyncpslhj#hy_purch_sale_goods_count", "hyncpslhj#hy_self_product_sale_goods_count", "hyncpslhj#hy_accrued_input_tax_count", "hyncpslhj#hy_hyncp_count", "sjgdyhgdh#sjg_sl", "sjgdygdth#sjg_sl", "sjgbqxjgdh#sjg_sl", "sjgdehgdh#sjg_sl", "sjgdegdth#sjg_sl", "sjgqmhjgdh#sjg_sl", "gjzjxsdyggdh#gjzj_sl", "gjzjxsdygdth#gjzj_sl", "gjzjxsbqxjgdh#gjzj_sl", "gjzjxsdegdth#gjzj_sl", "gjzjxsgdh#gjzj_sl", "gjzjxsqmhjgdh#gjzj_sl", "jxsejsdgdth#jxse_dqxshwsl", "jxsejsdgxjgdh#jxse_dqxshwsl", "jxsedeggdh#jxse_dqxshwsl", "jxsejshjgdh#jxse_dqxshwsl"});
    private static final Set<String> keys64 = Sets.newHashSet((Object[])new String[]{"hyncpsldth#hy_approval_loss", "hyncpsldth#hy_declare_loss", "jxsejsdgdth#jxse_sbdh", "jxsedeggdh#jxse_sbdh"});
    private static final Set<String> zj_keys4 = Sets.newHashSet((Object[])new String[]{"hyncpsldth#hy_actual_goods_sale_count", "hyncpslhj#hy_actual_goods_sale_count", "hyncpsldth#hy_purch_sale_goods_count", "hyncpslhj#hy_purch_sale_goods_count", "hyncpsldth#hy_self_product_sale_goods_count", "hyncpslhj#hy_self_product_sale_goods_count", "hyncpsldth#hy_accrued_input_tax_count", "hyncpslhj#hy_accrued_input_tax_count", "hyncpsldth#hy_hyncp_count", "hyncpslhj#hy_hyncp_count", "sjgdyhgdh#sjg_sl", "sjgdygdth#sjg_sl", "sjgbqxjgdh#sjg_sl", "sjgdehgdh#sjg_sl", "sjgdegdth#sjg_sl", "sjgqmhjgdh#sjg_sl", "sjgdyhgdh#sjg_pjgmdj", "sjgdygdth#sjg_pjgmdj", "sjgbqxjgdh#sjg_pjgmdj", "sjgdehgdh#sjg_pjgmdj", "sjgdegdth#sjg_pjgmdj", "sjgqmhjgdh#sjg_pjgmdj", "gjzjxsdyggdh#gjzj_sl", "gjzjxsdygdth#gjzj_sl", "gjzjxsbqxjgdh#gjzj_sl", "gjzjxsdegdth#gjzj_sl", "gjzjxsgdh#gjzj_sl", "gjzjxsqmhjgdh#gjzj_sl", "gjzjxsdyggdh#gjzj_pjgmdj", "gjzjxsdygdth#gjzj_pjgmdj", "gjzjxsbqxjgdh#gjzj_pjgmdj", "gjzjxsdegdth#gjzj_pjgmdj", "gjzjxsgdh#gjzj_pjgmdj", "gjzjxsqmhjgdh#gjzj_pjgmdj", "jxsejsdgdth#jxse_pjgmdj", "jxsedeggdh#jxse_pjgmdj", "jxsejsdgdth#jxse_dqxshwsl", "jxsejsdgxjgdh#jxse_dqxshwsl", "jxsedeggdh#jxse_dqxshwsl", "jxsedeggdh#jxse_dqxshwsl"});
    private static final Set<String> ah_keys6 = Sets.newHashSet((Object[])new String[]{"hyncpsldth#hy_actual_goods_sale_count", "hyncpslhj#hy_actual_goods_sale_count", "hyncpsldth#hy_purch_sale_goods_count", "hyncpslhj#hy_purch_sale_goods_count", "hyncpsldth#hy_self_product_sale_goods_count", "hyncpslhj#hy_self_product_sale_goods_count", "hyncpsldth#hy_accrued_input_tax_count", "hyncpslhj#hy_accrued_input_tax_count", "hyncpsldth#hy_approval_loss", "hyncpsldth#hy_declare_loss", "hyncpsldth#hy_hyncp_count", "hyncpslhj#hy_hyncp_count", "sjgdyhgdh#sjg_sl", "sjgdygdth#sjg_sl", "sjgbqxjgdh#sjg_sl", "sjgdehgdh#sjg_sl", "sjgdegdth#sjg_sl", "sjgqmhjgdh#sjg_sl", "gjzjxsdyggdh#gjzj_sl", "gjzjxsdygdth#gjzj_sl", "gjzjxsbqxjgdh#gjzj_sl", "gjzjxsdegdth#gjzj_sl", "gjzjxsgdh#gjzj_sl", "gjzjxsqmhjgdh#gjzj_sl", "jxsejsdgdth#jxse_sbdh", "jxsedeggdh#jxse_sbdh", "jxsejsdgdth#jxse_dqxshwsl", "jxsejsdgxjgdh#jxse_dqxshwsl", "jxsedeggdh#jxse_dqxshwsl", "jxsejshjgdh#jxse_dqxshwsl"});
    private static final Set<String> sdhb_keys6 = Sets.newHashSet((Object[])new String[]{"hyncpsldth#hy_actual_goods_sale_count", "hyncpslhj#hy_actual_goods_sale_count", "hyncpsldth#hy_purch_sale_goods_count", "hyncpslhj#hy_purch_sale_goods_count", "hyncpsldth#hy_self_product_sale_goods_count", "hyncpslhj#hy_self_product_sale_goods_count", "hyncpsldth#hy_accrued_input_tax_count", "hyncpslhj#hy_accrued_input_tax_count", "hyncpsldth#hy_approval_loss", "hyncpsldth#hy_declare_loss", "hyncpsldth#hy_hyncp_count", "hyncpslhj#hy_hyncp_count", "sjgdyhgdh#sjg_sl", "sjgdygdth#sjg_sl", "sjgbqxjgdh#sjg_sl", "sjgdehgdh#sjg_sl", "sjgdegdth#sjg_sl", "sjgqmhjgdh#sjg_sl", "gjzjxsdegdth#gjzj_sl", "gjzjxsgdh#gjzj_sl", "gjzjxsqmhjgdh#gjzj_sl", "jxsejsdgdth#jxse_sbdh", "jxsedeggdh#jxse_sbdh", "jxsejsdgdth#jxse_dqxshwsl", "jxsejsdgxjgdh#jxse_dqxshwsl", "jxsedeggdh#jxse_dqxshwsl", "jxsejshjgdh#jxse_dqxshwsl"});

    @Override
    public Map<String, EntityField> handle(DeclareRequestModel requestModel) {
        HashMap<String, EntityField> result = new HashMap<String, EntityField>();
        Long orgId = requestModel.getOrgId();
        TaxResult main = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgId);
        if (Objects.isNull(main.getData())) {
            return result;
        }
        String taxOffice = ((DynamicObject)main.getData()).getString("taxoffice.number");
        String sjTaxOffice = ((DynamicObject)main.getData()).getString("taxoffice.parent.number");
        if (JLSGJSWJ.equals(taxOffice) || JLSGJSWJ.equals(sjTaxOffice)) {
            result.putAll(this.generateCustomEntity(keys64, "#0.000000"));
        } else if (ZJSGJSWJ.equals(taxOffice) || ZJSGJSWJ.equals(sjTaxOffice)) {
            result.putAll(this.generateCustomEntity(zj_keys4, "#0.0000"));
            result.putAll(this.generateCustomEntity(keys624, "#0.0000"));
        } else {
            result.putAll(this.generateCustomEntity(keys624, "#0.0000"));
        }
        if (AHSGJSWJ.equals(taxOffice) || AHSGJSWJ.equals(sjTaxOffice)) {
            result.putAll(this.generateCustomEntity(ah_keys6, "#0.000000"));
        }
        if (SDHBSGJSWJ.contains(taxOffice) || SDHBSGJSWJ.contains(sjTaxOffice)) {
            result.putAll(this.generateCustomEntity(sdhb_keys6, "#0.000000"));
        }
        return result;
    }

    private Map<String, EntityField> generateCustomEntity(Set<String> keys, String precision) {
        HashMap<String, EntityField> result = new HashMap<String, EntityField>(keys.size());
        for (String key : keys) {
            EntityField entityField = new EntityField();
            entityField.setFieldId(key);
            entityField.setFieldType("decimal");
            entityField.setComboItems(new ArrayList());
            entityField.setFormatStr(precision);
            result.put(key, entityField);
        }
        return result;
    }
}

