/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.dynamicrow.precision.handle;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.tcvat.business.dynamicrow.precision.PrecisionHandler;
import kd.taxc.tcvat.business.dynamicrow.precision.handle.CommonHandle;

public class TaxRefundHandle
implements PrecisionHandler {
    private static final String AHSGJSWJ = "13400000000";
    private static final String HBSGJSWJ = "14200000000";
    private static final String SZSGJSWJ = "14403000000";
    private static final Set<String> DEFOULT4 = Sets.newHashSet((Object[])new String[]{"jbxx#tdhyzzsxse", "jbxx#tdhytqqbxse", "ldtsjs#bqsqthdqmldtse", "ldtsjs#bqsqthdclldse", "ldtsjs#bqsqthdzlldse"});
    private static final Set<String> AHHB8 = Sets.newHashSet((Object[])new String[]{"jbxx#tdhyzb", "ldtsjs#jxgcbl"});
    private static final Set<String> NOAHHB4 = Sets.newHashSet((Object[])new String[]{"jbxx#tdhyzb"});
    private static final Set<String> NOAHHB6 = Sets.newHashSet((Object[])new String[]{"ldtsjs#jxgcbl"});
    private static final Set<String> SZ2 = Sets.newHashSet((Object[])new String[]{"ldtsjs#bqysbmdtsytse", "ldtsjs#qmldtse", "ldtsjs#startqmldtse", "ldtsjs#clldse", "ldtsjs#txfzzdzzse", "ldtsjs#hgjkzzszyjksse", "ldtsjs#wspzzmdzzsse", "ldtsjs#ydkdjxse"});
    private static final Set<String> NOSZ4 = Sets.newHashSet((Object[])new String[]{"ldtsjs#bqysbmdtsytse", "ldtsjs#qmldtse", "ldtsjs#startqmldtse", "ldtsjs#clldse", "ldtsjs#txfzzdzzse", "ldtsjs#hgjkzzszyjksse", "ldtsjs#wspzzmdzzsse", "ldtsjs#ydkdjxse"});

    @Override
    public Map<String, EntityField> handle(DeclareRequestModel requestModel) {
        HashMap<String, EntityField> result = new HashMap<String, EntityField>();
        Long orgId = requestModel.getOrgId();
        TaxResult main = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgId);
        if (Objects.isNull(main.getData())) {
            return result;
        }
        String taxOffice = ((DynamicObject)main.getData()).getString("taxoffice.number");
        String sjTaxOffice = ((DynamicObject)main.getData()).getString("taxoffice.parent.number");
        if (AHSGJSWJ.equals(taxOffice) || AHSGJSWJ.equals(sjTaxOffice) || HBSGJSWJ.equals(taxOffice) || HBSGJSWJ.equals(sjTaxOffice)) {
            result.putAll(CommonHandle.generateCustomEntity(AHHB8, "#0.00000000"));
            result.putAll(CommonHandle.generateCustomEntity(NOSZ4, "#0.0000"));
        } else if (SZSGJSWJ.equals(taxOffice) || SZSGJSWJ.equals(sjTaxOffice)) {
            result.putAll(CommonHandle.generateCustomEntity(SZ2, "#0.00"));
            result.putAll(CommonHandle.generateCustomEntity(NOAHHB4, "#0.0000"));
            result.putAll(CommonHandle.generateCustomEntity(NOAHHB6, "#0.000000"));
        } else {
            result.putAll(CommonHandle.generateCustomEntity(NOAHHB4, "#0.0000"));
            result.putAll(CommonHandle.generateCustomEntity(NOAHHB6, "#0.000000"));
            result.putAll(CommonHandle.generateCustomEntity(NOSZ4, "#0.0000"));
        }
        result.putAll(CommonHandle.generateCustomEntity(DEFOULT4, "#0.0000"));
        return result;
    }
}

