/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.dynamicrow.precision.handle;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.tcvat.business.dynamicrow.precision.PrecisionHandler;
import kd.taxc.tcvat.business.dynamicrow.precision.handle.CommonHandle;

public class TcvatZzsybnsrHandle
implements PrecisionHandler {
    private static final String JLSGJSWJ = "12200000000";
    private static final String JXSGJSWJ = "13600000000";
    private static final String AHSGJSWJ = "13400000000";
    private static final Set<String> SDHBSGJSWJ = Sets.newHashSet((Object[])new String[]{"13700000000", "11300000000"});
    private static final Set<String> keys624 = Sets.newHashSet((Object[])new String[]{"tcvat_ybnsr_trccfhdncp#1#qckcncpsl", "tcvat_ybnsr_trccfhdncp#2#qckcncpsl", "tcvat_ybnsr_trccfhdncp#1#dqgjncpsl", "tcvat_ybnsr_trccfhdncp#2#dqgjncpsl", "tcvat_ybnsr_trccfhdncp#1#dqxshwsl", "tcvat_ybnsr_trccfhdncp#2#dqxshwsl", "tcvat_ybnsr_gjncpzjxshd#2#dqxsncpsl", "tcvat_ybnsr_gjncpzjxshd#2#shsl", "tcvat_ybnsr_gjncpzjxshd#2#ncpgjsl", "tcvat_ybnsr_gjncpzjxshd#2#qckcncpsl", "tcvat_ybnsr_gjncpzjxshd#2#dqgjncpsl"});
    private static final Set<String> keys64 = Sets.newHashSet((Object[])new String[]{"tcvat_ybnsr_trccfhdncp#1#hddhsl", "tcvat_ybnsr_trccfhdncp#2#hddhsl"});
    private static final Set<String> key_JX6 = Sets.newHashSet((Object[])new String[]{"tcvat_ybnsr_trccfhdncp#2#hddhsl", "tcvat_ybnsr_trccfhdncp#2#qckcncpsl", "tcvat_ybnsr_trccfhdncp#2#dqgjncpsl", "tcvat_ybnsr_trccfhdncp#2#dqxshwsl", "tcvat_ybnsr_gjncpzjxshd#2#dqxsncpsl", "tcvat_ybnsr_trccfhdncp#1#hddhsl", "tcvat_ybnsr_trccfhdncp#1#qckcncpsl", "tcvat_ybnsr_trccfhdncp#1#dqgjncpsl", "tcvat_ybnsr_trccfhdncp#1#dqxshwsl"});
    private static final Set<String> key_AH6 = Sets.newHashSet((Object[])new String[]{"tcvat_ybnsr_trccfhdncp#2#hddhsl", "tcvat_ybnsr_trccfhdncp#1#hddhsl", "tcvat_ybnsr_trccfhdncp#2#qckcncpsl", "tcvat_ybnsr_trccfhdncp#1#qckcncpsl", "tcvat_ybnsr_trccfhdncp#2#dqgjncpsl", "tcvat_ybnsr_trccfhdncp#1#dqgjncpsl", "tcvat_ybnsr_trccfhdncp#2#dqxshwsl", "tcvat_ybnsr_trccfhdncp#1#dqxshwsl"});
    private static final Set<String> key_SDHB6 = Sets.newHashSet((Object[])new String[]{"tcvat_ybnsr_gjncpzjxshd#2#shl"});

    @Override
    public Map<String, EntityField> handle(DeclareRequestModel requestModel) {
        HashMap<String, EntityField> result = new HashMap<String, EntityField>();
        Long orgId = requestModel.getOrgId();
        String templateNumber = requestModel.getTemplateNumber();
        TaxResult main = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgId);
        if (Objects.isNull(main.getData())) {
            return result;
        }
        String taxOffice = ((DynamicObject)main.getData()).getString("taxoffice.number");
        String sjTaxOffice = ((DynamicObject)main.getData()).getString("taxoffice.parent.number");
        if (JLSGJSWJ.equals(taxOffice) || JLSGJSWJ.equals(sjTaxOffice)) {
            result.putAll(CommonHandle.generateCustomEntity(keys624, "#0.000000", 6));
            result.putAll(CommonHandle.generateCustomEntity(keys64, "#0.000000", 6));
        } else {
            result.putAll(CommonHandle.generateCustomEntity(keys624, "#0.0000", 4));
        }
        if ("VAT202206-A".equalsIgnoreCase(templateNumber) && (JXSGJSWJ.equals(taxOffice) || JXSGJSWJ.equals(sjTaxOffice))) {
            result.putAll(CommonHandle.generateCustomEntity(key_JX6, "#0.000000", 6));
        }
        if ("VAT202206-A".equalsIgnoreCase(templateNumber) && (AHSGJSWJ.equals(taxOffice) || AHSGJSWJ.equals(sjTaxOffice))) {
            result.putAll(CommonHandle.generateCustomEntity(key_AH6, "#0.000000", 6));
        }
        if ("VAT202206-A".equalsIgnoreCase(templateNumber) && (SDHBSGJSWJ.contains(taxOffice) || SDHBSGJSWJ.contains(sjTaxOffice))) {
            result.putAll(CommonHandle.generateCustomEntity(key_JX6, "#0.000000", 6));
            result.putAll(CommonHandle.generateCustomEntity(key_SDHB6, "#0.000000", 6));
        }
        return result;
    }
}

