/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.errorcode.TaxcErrorCode;
import kd.taxc.bdtaxr.common.helper.bos.perm.PermDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class OrgService {
    public static DynamicObject getDefaultOrg(IFormView getView, IPageCache getPageCache) {
        String id;
        Long orgId = RequestContext.get().getOrgId();
        HashMap map = new HashMap(16);
        TreeUtils.convertParam((String)"id", (Object)orgId, map);
        TreeUtils.convertParam((String)"status", (Object)"1", map);
        DynamicObjectCollection org = TreeUtils.queryOrgListByCondition(map);
        if (org == null || org.isEmpty()) {
            org = TreeUtils.queryOrgListByCondition((Map)TreeUtils.convertParam((String)"status", (Object)"1"));
        } else if ("0".equals(((DynamicObject)org.get(0)).getString("id")) && StringUtils.isNotBlank((CharSequence)(id = OrgCheckUtil.findTaxOrg((IFormView)getView, (IPageCache)getPageCache)))) {
            ((DynamicObject)org.get(0)).set("id", (Object)id);
        }
        return CollectionUtils.isEmpty((Collection)org) ? BusinessDataServiceHelper.newDynamicObject((String)"tctb_org_entity") : (DynamicObject)org.get(0);
    }

    public static List<Long> getAccountingOrg(List<Long> orgList) {
        QFilter idsFilter = new QFilter("id", "in", orgList).and("fisaccounting", "=", (Object)"1");
        DynamicObject[] bos_orgs = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,fisaccounting", (QFilter[])idsFilter.toArray());
        return Arrays.stream(bos_orgs).map(v -> v.getLong("id")).collect(Collectors.toList());
    }

    public static void addFilterByConditionBeforeF7Select(Object event, IFormView view, DynamicObject org) {
        if (BeforeF7SelectEvent.class.isAssignableFrom(event.getClass())) {
            BeforeF7SelectEvent beforeF7SelectEvent = (BeforeF7SelectEvent)event;
            if (Objects.isNull(org)) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\uff01", (String)"ProjectFormPlugin_9", (String)"taxc-tcvat", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            List orgList = TaxOrgTakeRelationServiceHelper.getTaxOrgByAccountingOrg((Long)org.getLong("id"), (Date)new Date());
            if (CollectionUtils.isNotEmpty((Collection)orgList)) {
                List<Long> taxOrgIds = OrgService.checkOrgPerm(view, orgList);
                if (CollectionUtils.isNotEmpty(taxOrgIds)) {
                    ListShowParameter parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    parameter.getListFilterParameter().setFilter(new QFilter("id", "in", taxOrgIds));
                } else if (orgList.size() > 1) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5408\u9002\u7684\u7a0e\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5efa\u7acb\u4e86\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\u6216\u8005\u7a0e\u52a1\u7ec4\u7ec7\u662f\u5426\u5f00\u542f\u4e86\u589e\u503c\u7a0e\u5361\u7247\u3002", (String)"ProjectFormPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(Boolean.TRUE.booleanValue());
                } else {
                    beforeF7SelectEvent.setCancel(Boolean.TRUE.booleanValue());
                }
            } else {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u4e1a\u52a1\u5355\u5143\u534f\u4f5c\u4e2d\u7ef4\u62a4\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u3002", (String)"ProjectFormPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(Boolean.TRUE.booleanValue());
            }
        }
    }

    public static List<Long> checkOrgPerm(IFormView view, List<Long> taxorgs) {
        Boolean flag = CollectionUtils.isNotEmpty(taxorgs) && taxorgs.size() == 1;
        ArrayList result = Lists.newArrayList();
        taxorgs.forEach(taxorg -> {
            Boolean license = LicenseCheckServiceHelper.check((Object)taxorg, null, (String)"tcvat");
            if (license.booleanValue() && flag.booleanValue()) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u6709\u8bb8\u53ef\u7684\u7a0e\u52a1\u7ec4\u7ec7", (String)"ProjectFormPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            TaxResult isTaxcMainOrg = TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)taxorg);
            Boolean isEnableOrApprove = (Boolean)isTaxcMainOrg.getData() == false;
            if (isEnableOrApprove.booleanValue() && flag.booleanValue()) {
                String msg = TaxcErrorCode.TAXC_STATUS_CODE.getCode().equals(isTaxcMainOrg.getCode()) ? ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u201c\u7a0e\u52a1\u7ec4\u7ec7\u72b6\u6001\u201d=\u201c\u53ef\u7528\u201d\u7684\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"ProjectFormPlugin_10", (String)"taxc-tcvat", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u7a0e\u52a1\u7ec4\u7ec7\u662f\u5426\u5ba1\u6838\u901a\u8fc7\u3002", (String)"ProjectFormPlugin_7", (String)"taxc-tcvat", (Object[])new Object[0]);
                view.showErrorNotification(msg);
                return;
            }
            boolean taxCategoryEnable = OrgCheckUtil.taxCategoryEnable((String)String.valueOf(taxorg), (IFormView)view, (String)"tcvat", (String)"zzs", (boolean)false);
            if (taxCategoryEnable && flag.booleanValue()) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u542f\u7528\u4e86\u589e\u503c\u7a0e\u5361\u7247\u7684\u7a0e\u52a1\u7ec4\u7ec7", (String)"ProjectFormPlugin_8", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            if (!(license.booleanValue() || isEnableOrApprove.booleanValue() || taxCategoryEnable)) {
                result.add(taxorg);
            }
        });
        return result;
    }

    public static List<Long> getAllPermOrgs(String appId, String entityId, String permItemId) {
        TaxResult permOrgs = PermDataServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)entityId, (String)permItemId);
        if (permOrgs.isSuccess() && !ObjectUtils.isEmpty((Object)permOrgs.getData())) {
            return (List)permOrgs.getData();
        }
        return new ArrayList<Long>();
    }
}

