/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IPageCache;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxclicense.TaxcLicenseCheckDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.draft.StatusUtils;
import kd.taxc.bdtaxr.common.taxdeclare.draft.org.OrgChangeRecordUtil;
import kd.taxc.bdtaxr.common.taxdeclare.dto.TaxableListDto;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.vo.EngineResponse;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import kd.taxc.tcvat.business.service.draft.TcvatDraftService;
import kd.taxc.tcvat.business.service.draft.strategy.TcvatStrategy;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.common.dto.draft.DraftDto;
import org.apache.commons.beanutils.BeanUtils;

public class TaxDeclareHelper {
    private static final Log LOGGER = LogFactory.getLog(TaxDeclareHelper.class);
    private static final Map<String, String> ENTERPRIESTYPEMAP = new HashMap<String, String>(3);

    public static TcvatEngineModel buildEngineModel(DraftDto draftDto, IPageCache pageCache) {
        Map<String, Object> cache = TaxDeclareHelper.getTemplateType("draft", ((Long)draftDto.getOrgId()).toString(), draftDto.getStartDateToString(), draftDto.getEndDateToString(), draftDto.getDraftPurpose());
        draftDto.setPrelevyrate((String)cache.get("prelevyrate"));
        TcvatStrategy strategy = TcvatDraftService.getStrategy(draftDto);
        TcvatEngineModel engineModel = (TcvatEngineModel)strategy.buildEngineModel(((Long)draftDto.getOrgId()).toString(), draftDto.getStartDateToString(), draftDto.getEndDateToString(), draftDto.getTaxPayerType(), pageCache, draftDto.getDraftPurpose());
        return engineModel;
    }

    public static TcvatEngineModel buildEngineModel(String orgId, String skssqq, String skssqz, String taxPayerType, IPageCache pageCache, String draftPurpose) {
        Map<String, Object> cache = TaxDeclareHelper.getTemplateType("draft", orgId, skssqq, skssqz, draftPurpose);
        TcvatStrategy strategy = TcvatDraftService.getStrategy(taxPayerType, (String)cache.get("prelevyrate"));
        TcvatEngineModel engineModel = (TcvatEngineModel)strategy.buildEngineModel(orgId, skssqq, skssqz, taxPayerType, pageCache, draftPurpose);
        return engineModel;
    }

    public static Map<String, Object> getTaxPayerType(String orgId, Date startDate, Date endDate) {
        HashMap<String, Object> cache = new HashMap<String, Object>(16);
        DynamicObject declarePlanObject = null;
        DynamicObject dynamicObject = null;
        if (StringUtils.isNotBlank((CharSequence)orgId) && startDate != null && endDate != null) {
            declarePlanObject = OrgUtils.getOrgDeclarePlan((Long)Long.parseLong(orgId), (Date)startDate, (Date)endDate);
            dynamicObject = OrgChangeRecordUtil.loadChangeRecord((String)orgId, (Date)endDate);
        }
        LOGGER.info("TaxDeclareHelper  getTaxPayerType declarePlanObject:{},dynamicObject:{},orgId:{}", new Object[]{SerializationUtils.toJsonString(declarePlanObject), SerializationUtils.toJsonString(dynamicObject), orgId});
        cache.put("deadLine", dynamicObject != null ? dynamicObject.getString("deadline") : null);
        String taxpayertype = dynamicObject != null ? "zzs" + dynamicObject.getString("taxpayertype") : "othertype";
        cache.put("taxpayertype", taxpayertype);
        if (null == declarePlanObject) {
            return cache;
        }
        if (!"zzsybnsr".equals(taxpayertype)) {
            cache.put("taxpayertype", "othertype");
            cache.put("taxpayertypemsg", String.format(ResManager.loadKDString((String)"\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\u6c47\u603b\u7f34\u7eb3\u589e\u503c\u7a0e\u6682\u672a\u5f00\u653e\uff0c\u656c\u8bf7\u671f\u5f85\u3002", (String)"TaxDeclareHelper_3", (String)"taxc-tcvat", (Object[])new Object[0]), ENTERPRIESTYPEMAP.get(declarePlanObject.getString("summaryorgtype"))));
            return cache;
        }
        DynamicObjectCollection orgrow = declarePlanObject.getDynamicObjectCollection("orgrow");
        LOGGER.info("TaxDeclareHelper  getTaxPayerType orgrow:{},orgId:{}", (Object)SerializationUtils.toJsonString((Object)orgrow), (Object)orgId);
        String declareType = null;
        String hzOrgName = "";
        String currentOrgName = "";
        for (DynamicObject object : orgrow) {
            String orgid = object.getDynamicObject("orgid").getString("id");
            if (orgId.equals(orgid)) {
                declareType = object.getString("declaration");
                currentOrgName = object.getString("orgname");
                cache.put("declareType", declareType);
            }
            if (!"2".equals(object.getString("declaration"))) continue;
            hzOrgName = object.getString("orgname");
            cache.put("hzOrgId", orgid);
        }
        cache.put("planid", declarePlanObject.getString("id"));
        if ("1".equals(declarePlanObject.getString("summaryorgtype"))) {
            if ("2".equals(declareType)) {
                cache.put("taxpayertype", "zzsybnsr_zjg");
                return cache;
            }
            if ("3".equals(declareType)) {
                cache.put("taxpayertype", "zzsybnsr_fzjg");
                return cache;
            }
        }
        if ("5".equals(declarePlanObject.getString("summaryorgtype"))) {
            if ("2".equals(declarePlanObject.getString("summaryway"))) {
                if ("2".equals(declareType)) {
                    cache.put("taxpayertype", "zzsybnsr_ybhz");
                    return cache;
                }
                if ("3".equals(declareType)) {
                    cache.put("taxpayertype", "zzsybnsr");
                    cache.put("taxpayertypemsg", String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u7a0e\u52a1\u7ec4\u7ec7\u5df2\u88ab\u3010%2$s\u3011\u7a0e\u52a1\u7ec4\u7ec7\u6c47\u603b\u7533\u62a5\uff0c\u6700\u7ec8\u7533\u62a5\u6570\u636e\u4ee5\u6c47\u603b\u7533\u62a5\u6570\u636e\u4e3a\u51c6", (String)"TaxDeclareHelper_4", (String)"taxc-tcvat", (Object[])new Object[0]), currentOrgName, hzOrgName));
                    return cache;
                }
            } else if ("1".equals(declarePlanObject.getString("summaryway"))) {
                cache.put("prelevyrate", declarePlanObject.getString("prelevyrate"));
                if ("2".equals(declareType)) {
                    cache.put("taxpayertype", "zzsybnsr_yz_zjg");
                    return cache;
                }
                if ("3".equals(declareType)) {
                    cache.put("taxpayertype", "zzsybnsr_yz_fzjg");
                    cache.put("taxpayertypemsg", String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u4e3a\u9884\u5f81\u6c47\u603b\u7533\u62a5\u7684\u5206\u652f\u673a\u6784\uff0c\u65e0\u9700\u751f\u6210\u5e95\u7a3f\uff0c\u53ef\u5728\u603b\u673a\u6784\u5e95\u7a3f\u4e2d\u67e5\u770b\u5206\u652f\u673a\u6784\u6570\u636e\u3002", (String)"TaxDeclareHelper_5", (String)"taxc-tcvat", (Object[])new Object[0]), currentOrgName));
                    return cache;
                }
            } else if ("3".equals(declarePlanObject.getString("summaryway"))) {
                cache.put("prelevyrate", declarePlanObject.getString("prelevyrate"));
                if ("2".equals(declareType)) {
                    cache.put("taxpayertype", "zzsybnsr_hz_zjg");
                    return cache;
                }
                if ("3".equals(declareType)) {
                    cache.put("taxpayertype", "zzsybnsr_hz_fzjg");
                    cache.put("taxpayertypemsg", String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u4e3a\u4ec5\u6c47\u603b\u4e0d\u5206\u914d\u4e0d\u9884\u5f81\u65b9\u5f0f\u4e0b\u7533\u62a5\u7684\u5206\u652f\u673a\u6784\uff0c\u65e0\u9700\u751f\u6210\u5e95\u7a3f\uff0c\u53ef\u5728\u603b\u673a\u6784\u5e95\u7a3f\u4e2d\u67e5\u770b\u5206\u652f\u673a\u6784\u6570\u636e\u3002", (String)"TaxDeclareHelper_6", (String)"taxc-tcvat", (Object[])new Object[0]), currentOrgName));
                    return cache;
                }
            }
            cache.put("taxpayertype", "othertype");
            return cache;
        }
        cache.put("taxpayertype", "othertype");
        cache.put("taxpayertypemsg", String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4f01\u4e1a\u589e\u503c\u7a0e\u6c47\u603b\u7533\u62a5\u6682\u672a\u5f00\u653e\uff0c\u656c\u8bf7\u671f\u5f85\u3002", (String)"TaxDeclareHelper_7", (String)"taxc-tcvat", (Object[])new Object[0]), ENTERPRIESTYPEMAP.get(declarePlanObject.getString("summaryorgtype"))));
        return cache;
    }

    public static Map<String, Object> getTemplateType(String type, String orgId, String startDate, String endDate) {
        return TaxDeclareHelper.getTemplateType(type, orgId, startDate, endDate, "nssb");
    }

    public static Map<String, Object> getTemplateType(String type, String orgId, String startDate, String endDate, String draftPurpose) {
        String templateType = "";
        Date skssqq = DateUtils.stringToDate((String)startDate);
        Date skssqz = DateUtils.stringToDate((String)endDate);
        Map<String, Object> cache = TaxDeclareHelper.checkBeforeGetTemplateType(orgId, skssqq, skssqz);
        LOGGER.info("TaxDeclareHelper getTemplateType cache:{},orgId:{}", cache, (Object)orgId);
        if (!cache.isEmpty()) {
            return cache;
        }
        cache = TaxDeclareHelper.getTaxPayerType(orgId, skssqq, skssqz);
        LOGGER.info("TaxDeclareHelper getTemplateType2 cache2:{},orgId:{}", cache, (Object)orgId);
        String taxpayertype = (String)cache.get("taxpayertype");
        if (null != taxpayertype && "draft".equals(type)) {
            templateType = "draft_" + taxpayertype;
            if ("sjjt".equals(draftPurpose)) {
                templateType = templateType + "_sjjt";
            }
        }
        boolean zerodeclare = false;
        if ("declare".equals(type)) {
            templateType = taxpayertype;
            DynamicObject declareMain = TaxDeclareHelper.getDeclareMain(orgId, startDate, endDate, templateType);
            LOGGER.info("TaxDeclareHelper getTemplateType4 declareMain:{},orgId:{}", (Object)SerializationUtils.toJsonString((Object)declareMain), (Object)orgId);
            if (null == declareMain) {
                declareMain = TaxDeclareHelper.getDeclareMain(orgId, startDate, endDate, "zzsybnsr");
                LOGGER.info("TaxDeclareHelper getTemplateType5 declareMain:{},orgId:{}", (Object)SerializationUtils.toJsonString((Object)declareMain), (Object)orgId);
            }
            if (null != declareMain) {
                zerodeclare = declareMain.getBoolean("zerodeclare");
            } else {
                zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)"tcvat", (String)"zerodeclare", (long)Long.parseLong(orgId));
                LOGGER.info("TaxDeclareHelper getTemplateType5 zerodeclare:{},orgId:{}", (Object)zerodeclare, (Object)orgId);
            }
            if (zerodeclare && !"zzsxgmnsr".equals(templateType)) {
                templateType = "zzsybnsr";
            }
        }
        DynamicObject object = OrgChangeRecordUtil.loadChangeRecord((String)orgId, (Date)skssqz);
        LOGGER.info("TaxDeclareHelper getTemplateType3 object:{},orgId:{}", (Object)SerializationUtils.toJsonString((Object)object), (Object)orgId);
        cache.put("zerodeclare", zerodeclare);
        cache.put("templatetype", templateType);
        cache.put("deadLine", object.getString("deadLine"));
        return cache;
    }

    public static Map<String, Object> checkBeforeGetTemplateType(String orgId, Date skssqq, Date skssqz) {
        HashMap<String, Object> cache = new HashMap<String, Object>();
        if (null == orgId) {
            cache.put("orgmsg", ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7", (String)"TaxDeclareHelper_8", (String)"taxc-tcvat", (Object[])new Object[0]));
            return cache;
        }
        DynamicObject object = OrgChangeRecordUtil.loadChangeRecord((String)orgId, (Date)skssqz);
        if (object == null) {
            cache.put("orgmsg", ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u57fa\u7840\u8d44\u6599\u7a0e\u52a1\u4fe1\u606f\u4e2d\u914d\u7f6e\u7a0e\u79cd\u4fe1\u606f", (String)"TaxDeclareHelper_9", (String)"taxc-tcvat", (Object[])new Object[0]));
            return cache;
        }
        if (!"1".equals(object.get("enable"))) {
            cache.put("orgmsg", ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u57fa\u7840\u8d44\u6599\u7a0e\u52a1\u4fe1\u606f\u4e2d\u542f\u7528\u589e\u503c\u7a0e\u4fe1\u606f", (String)"TaxDeclareHelper_10", (String)"taxc-tcvat", (Object[])new Object[0]));
            return cache;
        }
        TaxResult<DynamicObject> dynamicObjectTaxResult = PeriodService.queryTaxcMainByOrgId(orgId);
        if (Objects.isNull(dynamicObjectTaxResult.getData())) {
            cache.put("orgmsg", dynamicObjectTaxResult.getMessage());
            return cache;
        }
        return cache;
    }

    public static void initPeriod(IDataModel getModel, IPageCache getPageCache, String orgId, Map<String, Object> customParams, boolean orgChange) {
        Date endDate;
        Date startDate;
        if (Boolean.TRUE.equals(customParams.get("readonly"))) {
            startDate = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
            endDate = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        } else {
            Map<String, Date> map = PeriodService.getPreTaxPeriod((String)customParams.getOrDefault("draftpurpose", "nssb"), orgId, new Date());
            startDate = map.get("startDate");
            endDate = DateUtils.getLastDateOfMonth2((Date)map.get("endDate"));
        }
        getModel.beginInit();
        getModel.setValue("skssqq", (Object)startDate);
        getModel.setValue("skssqz", (Object)endDate);
        getModel.endInit();
        getModel.updateCache();
        getPageCache.put("skssqq", DateUtils.format((Date)startDate));
        getPageCache.put("skssqz", DateUtils.format((Date)endDate));
    }

    public static boolean validByTaxLimit(DraftDto draftDto) {
        Date startDate = (Date)draftDto.getStartDate();
        Date endDate = (Date)draftDto.getEndDate();
        if (startDate == null || endDate == null || startDate.after(endDate)) {
            return false;
        }
        String taxLimit = TaxDeclareHelper.getDeadLine(draftDto.getDraftPurpose(), String.valueOf(draftDto.getOrgId()), startDate, endDate);
        if (taxLimit == null) {
            return false;
        }
        if ("aysb".equals(taxLimit) && !DateUtils.formatMonth((Date)startDate).equals(DateUtils.formatMonth((Date)endDate))) {
            return false;
        }
        return !"ajsb".equals(taxLimit) || PeriodService.isValidSeasonalDates(startDate, endDate) && PeriodService.isSameSeason(startDate, endDate);
    }

    public static DynamicObject getDeclareMain(String orgid, String startDate, String endDate, Object type) {
        QFilter q1 = new QFilter("org", "=", (Object)Long.valueOf(orgid));
        QFilter q2 = new QFilter("skssqq", "=", (Object)DateUtils.stringToDate((String)startDate));
        QFilter q3 = new QFilter("skssqz", "=", (Object)DateUtils.stringToDate((String)endDate));
        QFilter q4 = new QFilter("type", "=", type);
        DynamicObject object = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"id,billstatus,billno,zerodeclare", (QFilter[])new QFilter[]{q1, q2, q3, q4});
        return object;
    }

    public static String verify(String orgId) {
        Map orgEnable = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgCheckService", (String)"orgEnable", (Object[])new Object[]{Long.valueOf(orgId), Boolean.TRUE});
        if (StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)orgEnable.get("code")), (CharSequence)"true")) {
            return (String)orgEnable.get("failInfo");
        }
        Map isTaxPayerAuth = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgCheckService", (String)"isTaxPayerAuth", (Object[])new Object[]{orgId, "tcvat_draft_page", Boolean.TRUE});
        if (StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)isTaxPayerAuth.get("code")), (CharSequence)"true")) {
            return (String)isTaxPayerAuth.get("failInfo");
        }
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainZzsByOrgId(Collections.singletonList(Long.parseLong(orgId)));
        if (!result.isSuccess()) {
            return result.getMessage();
        }
        if (EmptyCheckUtils.isEmpty((Object)result.getData()) || EmptyCheckUtils.isEmpty((Object)((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity"))) {
            return ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u7a0e\u52a1\u4fe1\u606f\u3002", (String)"TaxDeclareHelper_12", (String)"taxc-tcvat", (Object[])new Object[0]);
        }
        DynamicObjectCollection list = ((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity");
        DynamicObject dy = (DynamicObject)list.get(0);
        if (Objects.equals("0", dy.getString("enable"))) {
            return String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u589e\u503c\u7a0e\u7a0e\u79cd\u5c1a\u672a\u542f\u7528\u3002", (String)"TaxDeclareHelper_13", (String)"taxc-tcvat", (Object[])new Object[0]), ((DynamicObject)((List)result.getData()).get(0)).getString("taxorg.taxpayer"));
        }
        return null;
    }

    public static List<EngineResponse> doDraftVerify(Long org, Date declareDate, Date skssqq, Date skssqz, Boolean isCheckOrg, Boolean isCheckLicense, String draftPurpose) {
        boolean zerodeclare;
        boolean checkFirstMonthSeason;
        String verifyMsg;
        LicenseCheckResult result;
        ArrayList<EngineResponse> engineResponses = new ArrayList<EngineResponse>();
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        EngineResponse engineResponse = new EngineResponse(Boolean.FALSE, data, null, null);
        if (isCheckLicense.booleanValue() && !(result = LicenseCheckServiceHelper.checkTxftPerformGroup((String)"tcdrs")).getHasLicense().booleanValue()) {
            engineResponse.setMessage(result.getMsg());
            return Collections.singletonList(engineResponse);
        }
        String orgId = org.toString();
        if (isCheckOrg.booleanValue() && null != (verifyMsg = TaxDeclareHelper.verify(orgId))) {
            engineResponse.setMessage(verifyMsg);
            return Collections.singletonList(engineResponse);
        }
        if ("sjjt".equals(draftPurpose) && !(checkFirstMonthSeason = TaxDeclareHelper.checkFirstMonthSeason("sjjt", String.valueOf(org), declareDate))) {
            engineResponse.setMessage(ResManager.loadKDString((String)"\u8ba1\u63d0\u622a\u6b62\u671f\u4e0e\u8ba1\u63d0\u65b9\u6848\u7684\u8ba1\u63d0\u5468\u671f\u4e0d\u5339\u914d\uff0c\u8ba1\u63d0\u5931\u8d25", (String)"TaxDeclareHelper_14", (String)"taxc-tcvat", (Object[])new Object[0]));
            return Collections.singletonList(engineResponse);
        }
        Map<String, Date> initDateMap = PeriodService.getAccrualPreTaxPeriod(draftPurpose, orgId, declareDate);
        Date startDate = initDateMap.get("startDate");
        Date endDate = DateUtils.getLastDateOfMonth2((Date)initDateMap.get("endDate"));
        Map<String, Object> taxPayerTypeMap = TaxDeclareHelper.getTaxPayerType(orgId, startDate, endDate);
        String taxpayertype = (String)taxPayerTypeMap.get("taxpayertype");
        LOGGER.info("draftTaxPayerTypeMap" + SerializationUtils.toJsonString(taxPayerTypeMap));
        if ("sjjt".equals(draftPurpose)) {
            String cycle = PeriodService.getCycleByProvisionPlan(Collections.singletonList(Long.parseLong(orgId)), startDate, endDate);
            if (StringUtils.isBlank((CharSequence)cycle)) {
                engineResponse.setMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u65e0\u53ef\u7528\u8ba1\u63d0\u65b9\u6848\u3002", (String)"TaxDeclareHelper_15", (String)"taxc-tcvat", (Object[])new Object[0]));
                return Collections.singletonList(engineResponse);
            }
            if ("season".equals(cycle) && Arrays.asList("zzsybnsr_yz_zjg", "zzsybnsr_ybhz", "zzsybnsr_hz_zjg").contains(taxpayertype)) {
                engineResponse.setMessage(ResManager.loadKDString((String)"\u6c47\u603b\u8ba1\u63d0\u5e95\u7a3f\u6682\u4e0d\u652f\u6301\u6309\u5b63\u8ba1\u63d0", (String)"TaxDeclareHelper_16", (String)"taxc-tcvat", (Object[])new Object[0]));
                return Collections.singletonList(engineResponse);
            }
            if ("year".equals(cycle)) {
                engineResponse.setMessage(ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u8ba1\u63d0\u5e95\u7a3f\u6682\u4e0d\u652f\u6301\u6309\u5e74\u8ba1\u63d0", (String)"TaxDeclareHelper_17", (String)"taxc-tcvat", (Object[])new Object[0]));
                return Collections.singletonList(engineResponse);
            }
        }
        if (zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)"tcvat", (String)"zerodeclare", (long)org)) {
            String orgname = OrgUtils.getOrgNameById((String)orgId);
            if ("sjjt".equals(draftPurpose)) {
                engineResponse.setMessage(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u7ec4\u7ec7\uff0c\u4e0d\u652f\u6301\u7f16\u5236\u8ba1\u63d0\u5e95\u7a3f\u3002", (String)"TaxDeclareHelper_27", (String)"taxc-tcvat", (Object[])new Object[0]), orgname));
            } else {
                engineResponse.setMessage(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u7ec4\u7ec7\uff0c\u4e0d\u652f\u6301\u7f16\u5236\u7533\u62a5\u5e95\u7a3f\u3002", (String)"TaxDeclareHelper_18", (String)"taxc-tcvat", (Object[])new Object[0]), orgname));
            }
            return Collections.singletonList(engineResponse);
        }
        if (("zzsybnsr".equals(taxpayertype) || "zzsybnsr_yz_fzjg".equals(taxpayertype) || "zzsybnsr_hz_fzjg".equals(taxpayertype)) && null != taxPayerTypeMap.get("taxpayertypemsg")) {
            engineResponse.setMessage((String)taxPayerTypeMap.get("taxpayertypemsg"));
            return Collections.singletonList(engineResponse);
        }
        Map<String, Object> cache = TaxDeclareHelper.getTemplateType("draft", orgId, DateUtils.format((Date)startDate), DateUtils.format((Date)endDate), draftPurpose);
        LOGGER.info("draftCache" + SerializationUtils.toJsonString(cache));
        if (null != cache.get("orgmsg")) {
            engineResponse.setMessage((String)cache.get("orgmsg"));
            return Collections.singletonList(engineResponse);
        }
        data.put("skssqq", startDate);
        data.put("skssqz", endDate);
        data.put("org", org);
        data.put("templatetype", cache.get("templatetype"));
        data.put("taxpayertype", taxpayertype);
        engineResponse.setData(data);
        engineResponse.setSuccess(Boolean.TRUE);
        engineResponses.add(engineResponse);
        return engineResponses;
    }

    public static List<EngineResponse> doDeclareVerify(Long org, Date declareDate, Date skssqq, Date skssqz, Boolean isCheckOrg, Boolean zerodeclare) {
        Date endDate;
        Date startDate;
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        EngineResponse engineResponse = new EngineResponse(Boolean.FALSE, data, null, null);
        ArrayList<EngineResponse> engineResponses = new ArrayList<EngineResponse>();
        EngineResponse verifyRes = TaxDeclareHelper.verifyZeroDeclareLicenseOrg(zerodeclare, isCheckOrg, org.toString());
        if (!verifyRes.getSuccess().booleanValue()) {
            engineResponse.setMessage(verifyRes.getMessage());
            return Collections.singletonList(engineResponse);
        }
        if (null != declareDate) {
            Map<String, Date> initDateMap = PeriodService.preTaxPeriod(org.toString(), declareDate);
            startDate = initDateMap.get("startDate");
            endDate = initDateMap.get("endDate");
        } else {
            startDate = skssqq;
            endDate = skssqz;
            if (null == startDate || null == endDate) {
                engineResponse.setMessage(ResManager.loadKDString((String)"\u7533\u62a5\u5c5e\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxDeclareHelper_19", (String)"taxc-tcvat", (Object[])new Object[0]));
                return Collections.singletonList(engineResponse);
            }
        }
        data.put("skssqq", startDate);
        data.put("skssqz", endDate);
        data.put("org", org);
        Map<String, Object> taxPayerTypeMap = TaxDeclareHelper.getTaxPayerType(org.toString(), startDate, endDate);
        String taxpayertype = (String)taxPayerTypeMap.get("taxpayertype");
        LOGGER.info("DeclareTaxPayerTypeMap" + SerializationUtils.toJsonString(taxPayerTypeMap));
        EngineResponse verifyResult = TaxDeclareHelper.verifyDeclareTaxpayerType(taxPayerTypeMap, zerodeclare, org.toString(), startDate, endDate);
        if (!verifyResult.getSuccess().booleanValue()) {
            engineResponse.setMessage(verifyResult.getMessage());
            return Collections.singletonList(engineResponse);
        }
        if (zerodeclare.booleanValue() && !taxpayertype.equals("zzsxgmnsr")) {
            data.put("draftstatus", TaxableListDto.DRAFTSTATUS_WXBZ);
            engineResponse = TaxDeclareHelper.dealTemplateType(org.toString(), engineResponse, startDate, endDate, data, true);
            return Collections.singletonList(engineResponse);
        }
        if ("zzsybnsr_yz_zjg".equals(taxpayertype)) {
            DynamicObjectCollection collection = OrgUtils.queryOrgGroupDetailForCollectedOrg((String)"zzs", (String)org.toString(), (String)DateUtils.format((Date)startDate));
            ArrayList<String> zjgOrgid = new ArrayList<String>(10);
            for (DynamicObject planObj : collection) {
                if ("1".equals(planObj.getString("levelname")) && planObj.getBoolean("issuesbb")) {
                    zjgOrgid.add(planObj.getString("orgid"));
                    continue;
                }
                if (!"2".equals(planObj.getString("levelname")) || !planObj.getBoolean("issuesbb")) continue;
                EngineResponse addResponse = TaxDeclareHelper.addResponse(engineResponse, startDate, endDate, planObj.getString("orgid"));
                ((Map)addResponse.getData()).put("draftstatus", TaxableListDto.DRAFTSTATUS_WXBZ);
                engineResponses.add(addResponse);
            }
            for (String orgid : zjgOrgid) {
                engineResponses.add(TaxDeclareHelper.addResponse(engineResponse, startDate, endDate, orgid));
            }
        } else {
            engineResponse = TaxDeclareHelper.dealTemplateType(org.toString(), engineResponse, startDate, endDate, data, false);
            engineResponses.add(engineResponse);
        }
        return engineResponses;
    }

    private static EngineResponse addResponse(EngineResponse engineResponse, Date startDate, Date endDate, String orgid) {
        EngineResponse dest = new EngineResponse();
        TaxDeclareHelper.copyObject(engineResponse, dest);
        Map sData = (Map)dest.getData();
        sData.put("org", Long.valueOf(orgid));
        dest = TaxDeclareHelper.dealTemplateType(orgid, dest, startDate, endDate, sData, false);
        return dest;
    }

    private static void copyObject(EngineResponse engineResponse, EngineResponse dest) {
        try {
            BeanUtils.copyProperties((Object)dest, (Object)engineResponse);
        }
        catch (Exception e) {
            throw new RuntimeException("copyObject", e);
        }
    }

    private static EngineResponse dealTemplateType(String orgid, EngineResponse engineResponse, Date startDate, Date endDate, Map<String, Object> data, boolean zerodeclare) {
        Map<String, Object> cache = TaxDeclareHelper.getTemplateType("declare", orgid, DateUtils.format((Date)startDate), DateUtils.format((Date)endDate), "nssb");
        LOGGER.info("DeclareCache" + SerializationUtils.toJsonString(cache));
        if (null != cache.get("orgmsg")) {
            engineResponse.setMessage((String)cache.get("orgmsg"));
        } else {
            String templateType = (String)cache.get("templatetype");
            if (zerodeclare && !"zzsxgmnsr".equals(cache.get("templatetype"))) {
                templateType = "zzsybnsr";
            }
            data.put("templatetype", templateType);
            engineResponse.setSuccess(Boolean.TRUE);
        }
        return engineResponse;
    }

    public static String getDeadLine(String draftpurpose, String orgId, Date startDate, Date endDate) {
        if ("sjjt".equals(draftpurpose)) {
            String cycle = PeriodService.getCycleByProvisionPlan(Collections.singletonList(Long.parseLong(orgId)), startDate, endDate);
            return TaxDeclareHelper.convert2DeadLine(cycle);
        }
        DynamicObject dynamicObject = OrgChangeRecordUtil.loadChangeRecord((String)orgId, (Date)startDate, (Date)endDate);
        return dynamicObject != null ? dynamicObject.getString("deadLine") : null;
    }

    public static String convert2DeadLine(String taxLimit) {
        if ("month".equals(taxLimit)) {
            return "aysb";
        }
        if ("season".equals(taxLimit)) {
            return "ajsb";
        }
        return taxLimit;
    }

    public static DynamicObject getPolicyConfirm(String draftPurpose, String entityName, String templateType, String orgId, String startdate, String enddate) {
        QFilter q1 = new QFilter("orgid", "=", (Object)Long.parseLong(orgId));
        QFilter draftPurposeFilter = new QFilter("draftpurpose", "=", (Object)draftPurpose);
        Date lastMonthLastDay = DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)enddate, (String)"yyyy-MM"));
        Date lastMonthFirstDay = DateUtils.stringToDate((String)startdate, (String)"yyyy-MM");
        switch (templateType) {
            case "draft_zzsybnsr": 
            case "draft_zzsybnsr_sjjt": 
            case "draft_zzsxgmnsr": 
            case "draft_zzsxgmnsr_sjjt": {
                QFilter q2 = new QFilter("reportperiod", ">=", (Object)lastMonthFirstDay).and(new QFilter("reportperiod", "<=", (Object)lastMonthLastDay));
                return BusinessDataServiceHelper.loadSingle((String)entityName, (String)"id", (QFilter[])new QFilter[]{q1, q2, draftPurposeFilter});
            }
            case "draft_zzsybnsr_ybhz": 
            case "draft_zzsybnsr_ybhz_sjjt": 
            case "draft_zzsybnsr_yz_zjg_sjjt": 
            case "draft_zzsybnsr_yz_zjg": 
            case "draft_zzsybnsr_hz_zjg": 
            case "draft_zzsybnsr_hz_zjg_sjjt": {
                QFilter dateFilter = new QFilter("startdate", ">=", (Object)lastMonthFirstDay).and(new QFilter("enddate", "<=", (Object)lastMonthLastDay));
                return BusinessDataServiceHelper.loadSingle((String)entityName, (String)"id", (QFilter[])new QFilter[]{q1, dateFilter, draftPurposeFilter});
            }
        }
        return null;
    }

    public static void markDraftModified(String draftnumber, int isModified) {
        if (StringUtils.isBlank((CharSequence)draftnumber)) {
            return;
        }
        QFilter draftnumberFilter = new QFilter("billno", "=", (Object)draftnumber);
        DynamicObject draftMain = BusinessDataServiceHelper.loadSingle((String)TaxDeclareHelper.getDraftQueryPage(draftnumber), (String)"id,ismodified", (QFilter[])new QFilter[]{draftnumberFilter});
        if (draftMain == null) {
            return;
        }
        draftMain.set("ismodified", (Object)isModified);
        SaveServiceHelper.update((DynamicObject)draftMain);
    }

    public static String checkBillStatus(String orgId, String startDate, String endDate, String templateType, DynamicObject org, String draftPurpose) {
        QFilter draftPurposeFilter;
        QFilter templatetype;
        QFilter skssqqzFilter;
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        DynamicObject draft = QueryServiceHelper.queryOne((String)"tctb_draft_main", (String)"id,billno,billstatus", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter = new QFilter("startdate", "=", (Object)DateUtils.stringToDate((String)startDate)).and(new QFilter("enddate", "=", (Object)DateUtils.stringToDate((String)endDate))), templatetype = new QFilter("templatetype", "=", (Object)templateType), draftPurposeFilter = new QFilter("draftpurpose", "=", (Object)draftPurpose)});
        if (null != draft && !"A".equals(draft.getString("billstatus"))) {
            String orgName = null != org ? org.getString("name") : "";
            String statusName = ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"TaxDeclareHelper_23", (String)"taxc-tcvat", (Object[])new Object[0]);
            if ("C".equals(draft.getString("billstatus"))) {
                statusName = ResManager.loadKDString((String)"\u5ba1\u6838", (String)"TaxDeclareHelper_24", (String)"taxc-tcvat", (Object[])new Object[0]);
            }
            String taxlimitStr = DateUtils.getTaxLimitTips((Date)DateUtils.stringToDate((String)startDate), (Date)DateUtils.stringToDate((String)endDate));
            return String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u5c5e\u671f%3$s\u5df2%4$s\uff0c\u4e0d\u652f\u6301\u4fee\u6539\u3002", (String)"TaxDeclareHelper_25", (String)"taxc-tcvat", (Object[])new Object[0]), orgName, taxlimitStr, ResManager.loadKDString((String)"\u5e95\u7a3f", (String)"TaxDeclareHelper_26", (String)"taxc-tcvat", (Object[])new Object[0]), statusName);
        }
        return null;
    }

    public static String getTaxRegisterType(String orgId) {
        DynamicObject dynamicObject = PeriodService.loadTaxMain(orgId);
        return dynamicObject != null ? dynamicObject.getString("registertype.id") : null;
    }

    public static void updateDraftStatus(Map<String, Object> customParams) {
        String skssqq = (String)customParams.get("skssqq");
        String skssqz = (String)customParams.get("skssqz");
        String templatetype = (String)customParams.get("templatetype");
        String draftpurpose = (String)customParams.get("draftpurpose");
        String orgid = customParams.get("orgid").toString();
        StatusUtils.updateStatus((String)templatetype, (String)orgid, (String)skssqq, (String)skssqz, (String)"1", (String)draftpurpose);
    }

    public static DynamicObject getProvistonPlan() {
        QFilter filter = new QFilter("taxtype", "=", (Object)1L).and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject provistonPlan = QueryServiceHelper.queryOne((String)"itp_proviston_plan", (String)"cycle", (QFilter[])new QFilter[]{filter});
        return provistonPlan;
    }

    public static String getDraftQueryPage(String draftnumber) {
        return draftnumber.startsWith("VATACCURE") ? "tcvat_sjjt_draft_query" : "tcvat_query_ybnsr";
    }

    public static String getDraftQueryFileds(String draftnumber) {
        return draftnumber.startsWith("VATACCURE") ? "id,billstatus,org,templatetype,skssqq as startdate,skssqz as enddate" : "id,billstatus,org,templatetype,startdate,enddate";
    }

    public static EngineResponse verifyDeclareTaxpayerType(Map<String, Object> taxPayerTypeMap, boolean zerodeclare, String orgId, Date startDate, Date endDate) {
        DynamicObject declarePlanObject;
        DynamicObject currentOrgPlanData;
        EngineResponse engineResponse = new EngineResponse();
        engineResponse.setSuccess(Boolean.valueOf(false));
        String taxpayertype = (String)taxPayerTypeMap.get("taxpayertype");
        if (zerodeclare) {
            engineResponse.setSuccess(Boolean.valueOf(true));
            return engineResponse;
        }
        if (taxpayertype.equals("zzsybnsr") && null != taxPayerTypeMap.get("taxpayertypemsg")) {
            engineResponse.setMessage((String)taxPayerTypeMap.get("taxpayertypemsg"));
            return engineResponse;
        }
        if ("zzsybnsr_hz_fzjg".equals(taxpayertype)) {
            engineResponse.setMessage(ResManager.loadKDString((String)"\u5206\u652f\u673a\u6784\u4e0d\u751f\u6210\u7533\u62a5\u8868\u3002", (String)"TaxDeclareHelper_21", (String)"taxc-tcvat", (Object[])new Object[0]));
            return engineResponse;
        }
        if ("zzsybnsr_yz_fzjg".equals(taxpayertype) && !(currentOrgPlanData = (declarePlanObject = OrgUtils.getOrgDeclarePlan((Long)Long.valueOf(orgId), (Date)startDate, (Date)endDate)).getDynamicObjectCollection("orgrow").stream().filter(c -> c.getDynamicObject("orgid").getString("id").equals(orgId)).findFirst().get()).getBoolean("issuesbb")) {
            engineResponse.setMessage(ResManager.loadKDString((String)"\u6c47\u603b\u65b9\u6848\u3010\u51fa\u5177\u7533\u62a5\u8868\u3011\u672a\u5f00\u542f\u3002", (String)"TaxDeclareHelper_22", (String)"taxc-tcvat", (Object[])new Object[0]));
            return engineResponse;
        }
        engineResponse.setSuccess(Boolean.valueOf(true));
        return engineResponse;
    }

    public static EngineResponse verifyZeroDeclareLicenseOrg(boolean zerodeclare, boolean isCheckOrg, String orgId) {
        String verifyMsg;
        TaxResult result;
        EngineResponse engineResponse = new EngineResponse();
        engineResponse.setSuccess(Boolean.valueOf(false));
        if (!zerodeclare && (result = TaxcLicenseCheckDataServiceHelper.check((Long)Long.parseLong(String.valueOf(orgId)), (String)"tcvat")) != null && Boolean.TRUE.equals(result.getData())) {
            engineResponse.setMessage(result.getMessage());
            return engineResponse;
        }
        if (isCheckOrg && null != (verifyMsg = TaxDeclareHelper.verify(orgId))) {
            engineResponse.setMessage(verifyMsg);
            return engineResponse;
        }
        engineResponse.setSuccess(Boolean.valueOf(true));
        return engineResponse;
    }

    public static boolean checkLastMonthSeason(String orgId, Date accrualDate) {
        DynamicObjectCollection categoryentryentity;
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainZzsByOrgId(Collections.singletonList(Long.parseLong(orgId)));
        if (EmptyCheckUtils.isNotEmpty((Object)result.getData()) && EmptyCheckUtils.isNotEmpty((Object)(categoryentryentity = ((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity"))) && Objects.equals(((DynamicObject)categoryentryentity.get(0)).getString("deadline"), "ajsb")) {
            return DateUtils.seasonEndMonth.contains(String.valueOf(DateUtils.getMonthOfDate((Date)accrualDate)));
        }
        return true;
    }

    public static boolean checkLastMonthSeason(String draftpurpose, String orgId, Date accrualDate) {
        if ("sjjt".equals(draftpurpose)) {
            String cycle = PeriodService.getCycleByProvisionPlan(Collections.singletonList(Long.parseLong(orgId)), accrualDate, accrualDate);
            if ("season".equals(cycle)) {
                return DateUtils.seasonEndMonth.contains(String.valueOf(DateUtils.getMonthOfDate((Date)accrualDate)));
            }
        } else {
            return TaxDeclareHelper.checkLastMonthSeason(orgId, accrualDate);
        }
        return true;
    }

    public static boolean checkFirstMonthSeason(String draftpurpose, String orgId, Date accrualDate) {
        String cycle;
        if ("sjjt".equals(draftpurpose) && "season".equals(cycle = PeriodService.getCycleByProvisionPlan(Collections.singletonList(Long.parseLong(orgId)), accrualDate, accrualDate))) {
            return DateUtils.seasonStartMonth.contains(String.valueOf(DateUtils.getMonthOfDate((Date)accrualDate)));
        }
        return true;
    }

    public static String getXgmTemplateType(String deadLine, String draftpurpose) {
        String templateType = "ajsb".equals(deadLine) ? ("sjjt".equals(draftpurpose) ? "zzsaccount_sjjt" : "zzsaccount") : ("sjjt".equals(draftpurpose) ? "zzsaccountmonth_sjjt" : "zzsaccountmonth");
        return templateType;
    }

    public static String getOrgLimit(Long orgId) {
        Optional<String> first;
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainZzsByOrgId(Collections.singletonList(orgId));
        if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData()) && (first = ((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity").stream().map(d -> d.getString("deadline")).findFirst()).isPresent()) {
            return first.get();
        }
        return null;
    }

    public static String getPreTaxLimitType(String taxlimt) {
        return "ajsb".equals(taxlimt) ? "season" : "month";
    }

    static {
        ENTERPRIESTYPEMAP.put("2", ResManager.loadKDString((String)"\u94c1\u8def\u8fd0\u8f93\u4f01\u4e1a", (String)"TaxDeclareHelper_0", (String)"taxc-tcvat", (Object[])new Object[0]));
        ENTERPRIESTYPEMAP.put("3", ResManager.loadKDString((String)"\u90ae\u653f\u4f01\u4e1a", (String)"TaxDeclareHelper_1", (String)"taxc-tcvat", (Object[])new Object[0]));
        ENTERPRIESTYPEMAP.put("4", ResManager.loadKDString((String)"\u7535\u4fe1\u4f01\u4e1a", (String)"TaxDeclareHelper_2", (String)"taxc-tcvat", (Object[])new Object[0]));
    }
}

