/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.account;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.common.constant.SelectTabConstant;

public class AccountSelectFormService {
    private static final String BTN_FASTSETTING = "btnfastsetting";
    private static final String BTN_FASTSETTING_AP = "vectorap";

    public static void setVisibleForFastSetting(IFormView getView, String tabKey) {
        Map customParams = getView.getFormShowParameter().getCustomParams();
        Object from = customParams.get("from");
        boolean readonly = (Boolean)customParams.get("readonly");
        if (readonly) {
            getView.setVisible(Boolean.FALSE, new String[]{BTN_FASTSETTING, BTN_FASTSETTING_AP});
            return;
        }
        if (from != null) {
            getView.setVisible(Boolean.FALSE, new String[]{BTN_FASTSETTING, BTN_FASTSETTING_AP});
            return;
        }
        if ("ybhz_income".equals(tabKey) || "income".equals(tabKey) || "rollout".equals(tabKey) || "diff".equals(tabKey) || "taxreduction".equals(tabKey) || "fzprepay".equals(tabKey) || "waitdeduction".equals(tabKey) || "perpre".equals(tabKey)) {
            getView.setVisible(Boolean.TRUE, new String[]{BTN_FASTSETTING, BTN_FASTSETTING_AP});
        } else {
            getView.setVisible(Boolean.FALSE, new String[]{BTN_FASTSETTING, BTN_FASTSETTING_AP});
        }
    }

    public static void showPage(String type, IFormView getView, IPageCache pageCache, String tabKey) {
        Map<String, String> selectPageTypeMap = SelectTabConstant.getBranchPluginTab().get(type);
        String targetPage = selectPageTypeMap.get(tabKey);
        AccountSelectFormService.showFormInnerTabPage(type, getView, pageCache, targetPage, tabKey);
    }

    public static void showPopPage(String type, IFormView getView, IPageCache pageCache, String tabKey) {
        Map<String, String> selectPageTypeMap = SelectTabConstant.getBranchPluginTab().get(type);
        String targetPage = selectPageTypeMap.get(tabKey);
        AccountSelectFormService.showFormInnerTabPage(type, getView, pageCache, targetPage, "record".equals(tabKey) ? tabKey : "detail");
    }

    private static void showFormInnerTabPage(String type, IFormView getView, IPageCache pageCache, String pageName, String tbName) {
        String flag = "loadtb-" + tbName;
        String id = pageCache.get(flag);
        if (id == null) {
            FormShowParameter parameter = new FormShowParameter();
            String pageId = parameter.getPageId();
            parameter.setFormId(pageName);
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey(tbName);
            FormShowParameter upStepParameter = getView.getFormShowParameter();
            parameter.setCustomParam("orgid", upStepParameter.getCustomParam("orgid"));
            parameter.setCustomParam("readonly", upStepParameter.getCustomParam("readonly"));
            parameter.setCustomParam("status", upStepParameter.getCustomParam("status"));
            parameter.setCustomParam("billstatus", upStepParameter.getCustomParam("billstatus"));
            parameter.setCustomParam("deadLine", upStepParameter.getCustomParam("deadLine"));
            String skssqq = (String)upStepParameter.getCustomParam("skssqq");
            parameter.setCustomParam("skssqq", (Object)skssqq);
            String skssqz = (String)upStepParameter.getCustomParam("skssqz");
            parameter.setCustomParam("skssqz", (Object)skssqz);
            parameter.setCustomParam("draftpurpose", upStepParameter.getCustomParam("draftpurpose"));
            parameter.setCustomParam("taxpayertype", upStepParameter.getCustomParam("taxPayerType"));
            parameter.setCustomParam("accountorg", upStepParameter.getCustomParam("accountorg"));
            parameter.setCustomParam("businessdimension", upStepParameter.getCustomParam("businessdimension"));
            if ("AccountSelectFormPlugin".equals(type) || "BranchAccountSelectFormPlugin".equals(type) || "HzAccountSelectFormPlugin".equals(type) || "SmallScaleAccountSelectFormPlugin".equals(type)) {
                QFilter filterList;
                DynamicObject object;
                parameter.setCustomParam("declaremap", upStepParameter.getCustomParam("declaremap"));
                if (null == upStepParameter.getCustomParam("draftnumber") && null != (object = QueryServiceHelper.queryOne((String)"tcvat_query_ybnsr", (String)"billno", (QFilter[])new QFilter[]{filterList = new QFilter("org", "=", (Object)Long.valueOf((String)upStepParameter.getCustomParam("orgid"))).and(new QFilter("startdate", "<=", (Object)DateUtils.stringToDate((String)skssqq))).and(new QFilter("enddate", ">=", (Object)DateUtils.stringToDate((String)skssqq))).and(new QFilter("templatetype", "=", (Object)("draft_" + upStepParameter.getCustomParam("taxPayerType"))))}))) {
                    upStepParameter.getCustomParams().put("draftnumber", object.getString("billno"));
                }
                parameter.setCustomParam("draftnumber", upStepParameter.getCustomParam("draftnumber"));
                parameter.setCustomParam("drafttype", (Object)pageName);
                parameter.setCustomParam("taxperiod", upStepParameter.getCustomParam("taxperiod"));
                parameter.setCustomParam("startDate", upStepParameter.getCustomParam("skssqq"));
                parameter.setCustomParam("endDate", upStepParameter.getCustomParam("skssqz"));
            } else if ("EditSelectFormPlugin".equals(type) || "Hz_EditSelectFormPlugin".equals(type) || "Small_EditSelectFormPlugin".equals(type) || "Yjskb_EditSelectFormPlugin".equals(type)) {
                parameter.setCustomParams(upStepParameter.getCustomParams());
            } else {
                parameter.setCustomParam("taxperiod", upStepParameter.getCustomParam("taxperiod"));
                parameter.setCustomParam("startDate", upStepParameter.getCustomParam("skssqq"));
                parameter.setCustomParam("endDate", upStepParameter.getCustomParam("skssqz"));
            }
            getView.showForm(parameter);
            pageCache.put(flag, pageId);
        } else {
            if (!("EditSelectFormPlugin".equals(type) || "Hz_EditSelectFormPlugin".equals(type) || "Small_EditSelectFormPlugin".equals(type) || "Yjskb_EditSelectFormPlugin".equals(type))) {
                getView.getView(id).invokeOperation("refresh");
            }
            getView.sendFormAction(getView.getView(id));
        }
    }

    public DynamicObject queryPolicyConfirm(Map<String, Object> customParams, DraftMetaDataDTO metaDataDTO) {
        return this.queryPolicyConfirm((String)customParams.get("orgid"), (String)customParams.get("skssqq"), (String)customParams.get("skssqz"), metaDataDTO.getDraftPurpose(), "zzsybnsr", metaDataDTO.getPolicyConfirm().getAccountMetaDataName());
    }

    public DynamicObject queryPolicyConfirm(String orgId, String skssqq, String skssqz, String draftPurpose, String taxplayeraptitude, String policyConfirmMetaName) {
        QFilter orgidFilter = new QFilter("orgid", "=", (Object)Long.parseLong(orgId));
        Date lastMonthLastDay = DateUtils.stringToDate((String)skssqz);
        Date lastMonthFirstDay = DateUtils.stringToDate((String)skssqq);
        QFilter reportPeriodFilter = new QFilter("reportperiod", ">=", (Object)lastMonthFirstDay).and(new QFilter("reportperiod", "<=", (Object)lastMonthLastDay));
        QFilter taxPayerTypeFilter = new QFilter("taxplayeraptitude", "=", (Object)taxplayeraptitude);
        QFilter draftPurposeFilter = new QFilter("draftpurpose", "=", (Object)draftPurpose);
        return BusinessDataServiceHelper.loadSingle((String)policyConfirmMetaName, (String)MetadataUtil.getAllFieldToQuery((String)policyConfirmMetaName), (QFilter[])new QFilter[]{orgidFilter, reportPeriodFilter, taxPayerTypeFilter, draftPurposeFilter});
    }

    public boolean isVisibleDeductTab(JSONArray deduct) {
        if (null == deduct) {
            return false;
        }
        return deduct.stream().filter(o -> ((JSONObject)o).getJSONObject("deducttype").getString("number").startsWith("VAT_JXDK_DDK_")).count() > 0L;
    }

    public String adapt(Map<String, Object> customParams) {
        String fieldName = (String)customParams.get("fieldName");
        Object deductiontype = customParams.get("deductiontype");
        return deductiontype == null ? fieldName : fieldName.concat(deductiontype.toString());
    }
}

