/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.account;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.taxc.tcvat.business.service.account.SaveFetchRuleExtensionService;
import kd.taxc.tcvat.business.service.draft.DeductionRolloutService;
import kd.taxc.tcvat.business.service.engine.impl.service.JzjtJxseEngineService;
import kd.taxc.tcvat.common.constant.DraftConstant;

public class AccountingDetailFormService
implements SaveFetchRuleExtensionService {
    private static final String INCOME_DETAIL_ENTITY = "tcvat_accdetail_income";
    private static final String WAIT_DEDUCTION_DETAIL_ENTITY = "tcvat_wait_deduction_det";
    private DeductionRolloutService deductionRolloutService = new DeductionRolloutService();

    public String buildQueryParam(Map<String, Object> customParams, QFilter qFilter, String selectFields) {
        if (Objects.equals(INCOME_DETAIL_ENTITY, customParams.get("entry"))) {
            qFilter.and("type", "=", customParams.get("type"));
            selectFields = "skssqq,table,amountfield,datatype,datadirection,fetchamount,amount,filtercondition,absolute,taxrate,taxamount,exrate,conditionjson,differenceinvoice";
        }
        if ("tcvat_income_invoice".equals(customParams.get("entry"))) {
            qFilter.and("type", "=", customParams.get("type"));
            selectFields = "taxperiod,table,amountfield,datatype,datadirection,fetchamount,invoiceamount,filtercondition,absolute,taxrate,taxamount,conditionjson,differenceinvoice";
        }
        if (Objects.equals("tcvat_hz_accdetail_diff", customParams.get("entry"))) {
            selectFields = "startdate as skssqq,table,amountfield,datatype,datadirection,fetchamount,amount,filtercondition,absolute,conditionjson";
        }
        if (Objects.equals(WAIT_DEDUCTION_DETAIL_ENTITY, customParams.get("entry"))) {
            String fieldName = String.valueOf(customParams.get("fieldName"));
            if ("count".equals(fieldName)) {
                qFilter.and("type", "=", (Object)"count");
            } else if ("amount".equals(fieldName)) {
                qFilter.and("type", "=", (Object)"amount");
            } else if ("taxamount".equals(fieldName)) {
                qFilter.and("type", "=", (Object)"taxamount");
            }
        }
        if (Objects.equals("tcvat_accdetail_diff", customParams.get("entry")) && customParams.get("fieldName") != null) {
            qFilter.and("type", "=", customParams.get("fieldName"));
        }
        return selectFields;
    }

    @Override
    public void addRollOutRecord(String tzsm0, String tzsm1, Object oldRuleTzsm, Object oldManualTzsm, Map<String, Object> customParams, List<DynamicObject> saveList, Map<String, Object> modelParam) {
        DeductionRolloutService.addRollOutRecord(tzsm0, tzsm1, oldRuleTzsm, oldManualTzsm, customParams, saveList, modelParam);
    }

    @Override
    public void updateFiled(DynamicObject draftObj, String fieldName, Object adjustsumamount, String updateDraft) {
        if ((DraftConstant.YBNSR_JZJT_JXSE_SUMMARY.equals(updateDraft) || DraftConstant.YBNSR_JZJT_JXSE_SUMMARY_SJJT.equals(updateDraft)) && "inputtax".equals(fieldName)) {
            new JzjtJxseEngineService().calcJzjtjxTax(draftObj, (BigDecimal)adjustsumamount);
        }
        DeductionRolloutService.updateFiled(draftObj, fieldName, adjustsumamount, updateDraft);
    }

    @Override
    public void afterSave(Map<String, Object> params) {
        if ("tcvat_income_list".equals(params.get("drafttype")) && "zzsybnsr".equals(params.get("taxPayerType"))) {
            this.deductionRolloutService.updateRollOutDate(params);
            DeductionRolloutService.updateJzjtJxseDraft(params);
            DeductionRolloutService.updateAddDeductionDraft(params);
        }
        if ("tcvat_jzjt_jxse_list".equals(params.get("drafttype")) && "zzsybnsr".equals(params.get("taxPayerType"))) {
            DeductionRolloutService.updateAddDeductionDraft(params);
        }
    }
}

