/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.account;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.common.dto.draft.DraftDto;

public class DeductionService {
    public static final List<String> DOWN_DEDUCTION = Arrays.asList("VAT_JXDK_BQDK_11", "VAT_JXDK_BQDK_15", "VAT_JXDK_BQDK_16", "VAT_JXDK_BQDK_17", "VAT_JXDK_BQDK_18");

    public static Object getCellName(String fieldName, String suffix) {
        String name;
        switch (name = fieldName.replace(suffix, "")) {
            case "count": {
                return ResManager.loadKDString((String)"\u4efd\u6570", (String)"DeductionService_0", (String)"taxc-tcvat", (Object[])new Object[0]);
            }
            case "amount": {
                return ResManager.loadKDString((String)"\u91d1\u989d", (String)"DeductionService_1", (String)"taxc-tcvat", (Object[])new Object[0]);
            }
            case "taxamount": {
                return ResManager.loadKDString((String)"\u7a0e\u989d", (String)"DeductionService_2", (String)"taxc-tcvat", (Object[])new Object[0]);
            }
            case "inputtaxamount": {
                return ResManager.loadKDString((String)"\u5373\u5f81\u5373\u9000\u8fdb\u9879\u7a0e\u989d", (String)"DeductionService_3", (String)"taxc-tcvat", (Object[])new Object[0]);
            }
        }
        return "";
    }

    public static Object getDescription(String deductiontype) {
        switch (deductiontype) {
            case "1": {
                return ResManager.loadKDString((String)"\u672c\u671f\u8ba4\u8bc1\u76f8\u7b26\u7684\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968", (String)"DeductionService_4", (String)"taxc-tcvat", (Object[])new Object[0]);
            }
            case "2": {
                return ResManager.loadKDString((String)"\u672c\u671f\u8ba4\u8bc1\u76f8\u7b26\u7684\u901a\u884c\u8d39\u53d1\u7968", (String)"DeductionService_5", (String)"taxc-tcvat", (Object[])new Object[0]);
            }
            case "3": {
                return ResManager.loadKDString((String)"\u6d77\u5173\u8fdb\u53e3\u589e\u503c\u7a0e\u4e13\u7528\u7f34\u6b3e\u4e66", (String)"DeductionService_6", (String)"taxc-tcvat", (Object[])new Object[0]);
            }
            case "21": {
                return ResManager.loadKDString((String)"\u6d77\u5173\u8fdb\u53e3\u589e\u503c\u7a0e\u4e13\u7528\u7f34\u6b3e\u4e66", (String)"DeductionService_6", (String)"taxc-tcvat", (Object[])new Object[0]);
            }
            case "4": {
                return ResManager.loadKDString((String)"\u519c\u4ea7\u54c1\u6536\u8d2d\u53d1\u7968\u6216\u8005\u9500\u552e\u53d1\u7968", (String)"DeductionService_7", (String)"taxc-tcvat", (Object[])new Object[0]);
            }
            case "5": {
                return ResManager.loadKDString((String)"\u4ee3\u6263\u4ee3\u7f34\u7a0e\u6536\u7f34\u6b3e\u51ed\u8bc1", (String)"DeductionService_8", (String)"taxc-tcvat", (Object[])new Object[0]);
            }
            case "6": {
                return ResManager.loadKDString((String)"\u52a0\u8ba1\u6263\u9664\u519c\u4ea7\u54c1\u8fdb\u9879\u7a0e\u989d", (String)"DeductionService_9", (String)"taxc-tcvat", (Object[])new Object[0]);
            }
            case "7": {
                return ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u670d\u52a1\u6263\u7a0e\u51ed\u8bc1", (String)"DeductionService_10", (String)"taxc-tcvat", (Object[])new Object[0]);
            }
            case "8": {
                return ResManager.loadKDString((String)"\u5176\u4ed6", (String)"DeductionService_11", (String)"taxc-tcvat", (Object[])new Object[0]);
            }
            case "9": {
                return ResManager.loadKDString((String)"\u672c\u671f\u8ba4\u8bc1\u76f8\u7b26\u7684\u673a\u52a8\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968", (String)"DeductionService_12", (String)"taxc-tcvat", (Object[])new Object[0]);
            }
            case "VAT_JXDK_BQDK_11": {
                return ResManager.loadKDString((String)"\u672c\u671f\u7528\u4e8e\u8d2d\u5efa\u4e0d\u52a8\u4ea7\u7684\u6263\u7a0e\u51ed\u8bc1", (String)"DeductionService_13", (String)"taxc-tcvat", (Object[])new Object[0]);
            }
            case "VAT_JXDK_BQDK_15": {
                return ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u670d\u52a1\u6263\u7a0e\u51ed\u8bc1_\u589e\u503c\u7a0e\uff08\u7535\u5b50\uff09\u666e\u901a\u53d1\u7968", (String)"DeductionService_18", (String)"taxc-tcvat", (Object[])new Object[0]);
            }
            case "VAT_JXDK_BQDK_16": {
                return ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u670d\u52a1\u6263\u7a0e\u51ed\u8bc1_\u6ce8\u660e\u65c5\u5ba2\u8eab\u4efd\u4fe1\u606f\u7684\u822a\u7a7a\u8fd0\u8f93\u7535\u5b50\u5ba2\u7968\u884c\u7a0b\u5355", (String)"DeductionService_19", (String)"taxc-tcvat", (Object[])new Object[0]);
            }
            case "VAT_JXDK_BQDK_17": {
                return ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u670d\u52a1\u6263\u7a0e\u51ed\u8bc1_\u94c1\u8def\u65c5\u5ba2\u8fd0\u8f93\u7968\u636e", (String)"DeductionService_20", (String)"taxc-tcvat", (Object[])new Object[0]);
            }
            case "VAT_JXDK_BQDK_18": {
                return ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u670d\u52a1\u6263\u7a0e\u51ed\u8bc1_\u6ce8\u660e\u65c5\u5ba2\u8eab\u4efd\u4fe1\u606f\u7684\u516c\u8def\u3001\u6c34\u8def\u5176\u4ed6\u5ba2\u7968", (String)"DeductionService_21", (String)"taxc-tcvat", (Object[])new Object[0]);
            }
        }
        return "";
    }

    public boolean check(Map<String, Object> customParams, String fieldName, BigDecimal jzjtAmount, BigDecimal taxAmount) {
        if (!fieldName.equals(customParams.get("fieldName"))) {
            return false;
        }
        return this.jzjtAmountCompareToTaxAmount(jzjtAmount, taxAmount);
    }

    public BigDecimal queryUpdateDraft(Map<String, Object> customParams, String taxamount) {
        String updateDraft = (String)customParams.get("updateDraft");
        DynamicObject draftObj = BusinessDataServiceHelper.loadSingle((Object)customParams.get("id"), (String)updateDraft);
        return draftObj.getBigDecimal(taxamount);
    }

    private boolean jzjtAmountCompareToTaxAmount(BigDecimal jzjtAmount, BigDecimal taxamount) {
        return jzjtAmount.compareTo(taxamount) > 0;
    }

    public Map<String, Object> createPageShowParams(Map<String, Object> customParamMap, DynamicObject selectedRow, String fieldName, String entryKey) {
        String suffix = entryKey.replace("entryentity", "");
        DraftMetaDataDTO deductionMetaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParamMap);
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("draftpurpose", customParamMap.get("draftpurpose"));
        customParams.put("updateDraft", deductionMetaData.getDeduction().getAccountMetaDataName());
        customParams.put("orgid", customParamMap.get("orgid"));
        customParams.put("id", customParamMap.get("id"));
        customParams.put("taxpayertype", customParamMap.get("taxpayertype"));
        customParams.put("fieldName", fieldName);
        customParams.put("cellName", DeductionService.getCellName(fieldName, suffix));
        String deductiontype = selectedRow.getString("deductiontype" + suffix);
        customParams.put("amount", customParamMap.get("amount"));
        customParams.put("draftnumber", customParamMap.get("draftnumber"));
        customParams.put("drafttype", customParamMap.get("drafttype"));
        customParams.put("billstatus", customParamMap.get("billstatus"));
        customParams.put("taxaccountserialno", selectedRow.getString("serialno" + suffix));
        customParams.put("entry", deductionMetaData.getDeduction().getDetailMetaDataNameMap().get(DraftConstant.YBNSR_DEDUCTION_DETAIL_BILL));
        customParams.put("type", fieldName);
        customParams.put("customCaption", ResManager.loadKDString((String)"\u8fdb\u9879\u62b5\u6263\u660e\u7ec6\u5217\u8868", (String)"DeductionService_14", (String)"taxc-tcvat", (Object[])new Object[0]));
        if (DOWN_DEDUCTION.contains(deductiontype)) {
            customParams.put("id", customParamMap.get("id1"));
            customParams.put("entry", deductionMetaData.getWaitDeduction().getDetailMetaDataNameMap().get(DraftConstant.PAGE_WAIT_DEDUCTION_DETAIL));
            customParams.put("fieldName", fieldName.replace("1", ""));
            customParams.put("type", fieldName.replace("1", ""));
            customParams.put("taxaccountserialno", selectedRow.getString("serialno1"));
            customParams.put("customCaption", String.format(ResManager.loadKDString((String)"%s\u62b5\u6263\u660e\u7ec6\u5217\u8868", (String)"DeductionService_22", (String)"taxc-tcvat", (Object[])new Object[0]), DeductionService.getDescription(deductiontype)));
            customParams.put("updateDraft", deductionMetaData.getWaitDeduction().getAccountMetaDataName());
            customParams.put("description", DeductionService.getDescription(deductiontype));
        } else {
            customParams.put("description", selectedRow.getString("description"));
        }
        return customParams;
    }

    public DynamicObjectCollection queryYbnsrDeductionDraftData(DraftDto draftDto) {
        ArrayList filter = Lists.newArrayList();
        String metaname = this.getQueryConditin(draftDto, filter);
        return QueryServiceHelper.query((String)metaname, (String)"id,serialno,deductiontype,count,amount,taxamount,org,taxperiod,inputtaxamount", (QFilter[])filter.toArray(new QFilter[0]), (String)"taxperiod,deductiontype");
    }

    public DynamicObject[] loadYbnsrDeductionDraftData(DraftDto draftDto) {
        ArrayList filter = Lists.newArrayList();
        String metaname = this.getQueryConditin(draftDto, filter);
        return BusinessDataServiceHelper.load((String)metaname, (String)"id,serialno,deductiontype,count,amount,taxamount,org,taxperiod,inputtaxamount", (QFilter[])filter.toArray(new QFilter[0]), (String)"taxperiod,deductiontype");
    }

    private String getQueryConditin(DraftDto draftDto, List<QFilter> filters) {
        QFilter orgFilter = new QFilter("org", "=", draftDto.getOrgId());
        QFilter taxPeriodFilter = new QFilter("taxperiod", "in", PeriodService.getPeriodList((Date)draftDto.getStartDate(), (Date)draftDto.getEndDate()));
        QFilter pidFilter = new QFilter("pid", "=", (Object)0L);
        String deadLine = TaxDeclareHelper.getDeadLine(draftDto.getDraftPurpose(), ((Long)draftDto.getOrgId()).toString(), (Date)draftDto.getStartDate(), (Date)draftDto.getEndDate());
        QFilter deadLineFilter = new QFilter("deadline", "=", (Object)deadLine);
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("draftpurpose", draftDto.getDraftPurpose());
        customParams.put("taxpayertype", draftDto.getTaxPayerType());
        DraftMetaDataInfo deductionMetaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParams).getDeduction();
        filters.addAll(Lists.newArrayList((Object[])new QFilter[]{orgFilter, taxPeriodFilter, pidFilter, deadLineFilter}));
        return deductionMetaData.getAccountMetaDataName();
    }

    public DynamicObjectCollection queryHzDeductionDraftData(DraftDto draftDto, String selectFields, String orderBy) {
        QFilter orgFilter = new QFilter("org", "=", draftDto.getOrgId());
        QFilter taxPeriodFilter = new QFilter("startdate", ">=", draftDto.getStartDate()).and(new QFilter("enddate", "<=", draftDto.getEndDate()));
        QFilter taxpayertypeFilter = new QFilter("taxpayertype", "=", (Object)draftDto.getTaxPayerType());
        QFilter pidFilter = new QFilter("pid", "=", (Object)0L);
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("draftpurpose", draftDto.getDraftPurpose());
        customParams.put("taxpayertype", draftDto.getTaxPayerType());
        DraftMetaDataDTO metaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParams);
        DraftMetaDataInfo deduction = metaData.getDeduction();
        return QueryServiceHelper.query((String)deduction.getAccountMetaDataName(), (String)selectFields, (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter, pidFilter, taxpayertypeFilter}, (String)orderBy);
    }

    public String validateChange(DynamicObject dataEntity, String propertyName, BigDecimal inputtaxamount, BigDecimal taxamount) {
        BigDecimal changeValue = dataEntity.getBigDecimal(propertyName);
        if (changeValue.compareTo(BigDecimal.ZERO) < 0) {
            return ResManager.loadKDString((String)"\u91d1\u989d\u4e0d\u53ef\u4ee5\u4e3a\u8d1f\u6570\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002", (String)"DeductionService_16", (String)"taxc-tcvat", (Object[])new Object[0]);
        }
        if (("inputtaxamount".equals(propertyName) || "taxamount".equals(propertyName)) && inputtaxamount.compareTo(taxamount) > 0) {
            return ResManager.loadKDString((String)"\u5373\u5f81\u5373\u9000\u8fdb\u9879\u7a0e\u989d\u5e94\u5f53\u5c0f\u4e8e\u6216\u7b49\u4e8e\u7a0e\u989d\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002", (String)"DeductionService_17", (String)"taxc-tcvat", (Object[])new Object[0]);
        }
        return null;
    }
}

