/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.account;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.assist.AssistService;
import kd.taxc.bdtaxr.common.onekeygenerate.EngineHandler;
import kd.taxc.bdtaxr.common.onekeygenerate.EngineHandlerFactory;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.TaxBaseDataUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;

public class PolicyConfirmService {
    private static Log LOGGER = LogFactory.getLog(PolicyConfirmService.class);
    private static final String ORGID_KEY = "orgid";
    public static final String ASSIST_DEDUCTION_RATE_CODE = "0001_01";
    private static final String DEDUCTION_RATE = "deductionrate";
    private static final String BQSFSYJZZC = "bqsfsyjzzc";
    private static final int FIRSTHALFYEAR = 6;
    private static final Set<String> QYSDSNB = Sets.newHashSet((Object[])new String[]{"qysdsnb", "qysdsnb_fzjg", "qysds_hdzs_nb"});

    public static ArrayList<ComboItem> setDeductionRateSelectValue(String draftpurpose, Map<String, Object> customParams, IFormView getView, IDataModel getModel, IPageCache getPageCache, QFilter preDateFilter) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u9002\u7528", (String)"PolicyConfirmService_0", (String)"taxc-tcvat", (Object[])new Object[0])), "N"));
        BillShowParameter formShowParameter = (BillShowParameter)getView.getFormShowParameter();
        String orgId = (String)formShowParameter.getCustomParam(ORGID_KEY);
        String startDate = (String)customParams.get("skssqq");
        String endDate = (String)customParams.get("skssqz");
        List deductionRateList = AssistService.queryAssistParams((String)ASSIST_DEDUCTION_RATE_CODE, (String)orgId, (String)startDate, (String)endDate);
        for (String deductionRate : deductionRateList) {
            double rate = Double.parseDouble(deductionRate) * 100.0;
            items.add(new ComboItem(new LocaleString((int)rate + "%"), (int)rate + "%"));
        }
        if (formShowParameter.getPkId() == null || formShowParameter.getPkId().equals(0)) {
            PolicyConfirmService.setRateDefaultValue(draftpurpose, customParams, orgId, getModel, getPageCache, preDateFilter);
        }
        return items;
    }

    public static void setRateDefaultValue(String draftpurpose, Map<String, Object> customParams, String orgId, IDataModel getModel, IPageCache getPageCache, QFilter preDateFilter) {
        QFilter q1 = new QFilter(ORGID_KEY, "=", (Object)Long.parseLong(orgId));
        QFilter q2 = new QFilter("draftpurpose", "=", (Object)draftpurpose);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)String.valueOf(customParams.get("page")), (String)DEDUCTION_RATE, (QFilter[])new QFilter[]{q1, preDateFilter, q2});
        if (dynamicObject == null) {
            return;
        }
        String deductionRate = dynamicObject.getString(DEDUCTION_RATE);
        getPageCache.put(DEDUCTION_RATE, deductionRate);
        getModel.setValue(DEDUCTION_RATE, (Object)deductionRate);
    }

    public static String queryBqsfsyjzzcDefaultValue(String draftpurpose, String entityName, long orgId, String startDate, String endDate, QFilter preDateFilter) {
        Date start = DateUtils.stringToDate((String)startDate);
        String reliefPolicyType = TaxBaseDataUtils.getReliefPolicyType((Long)orgId, (Date)start, (Date)DateUtils.stringToDate((String)endDate), (boolean)false);
        String bqsfsyjzzc = null;
        if ("gtgsh".equalsIgnoreCase(reliefPolicyType)) {
            bqsfsyjzzc = "1";
        } else {
            int monthOfDate = DateUtils.getMonthOfDate((Date)start);
            Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)start);
            DynamicObject xxwl = null;
            DynamicObjectCollection sbb = monthOfDate <= 6 ? PolicyConfirmService.querySbbid(DateUtils.addYear((Date)firstDateOfYear, (int)-2), orgId) : PolicyConfirmService.querySbbid(DateUtils.addYear((Date)firstDateOfYear, (int)-1), orgId);
            if (CollectionUtils.isNotEmpty((Collection)sbb)) {
                Long sbbId = ((DynamicObject)sbb.get(0)).getLong("id");
                xxwl = PolicyConfirmService.queryQysdsWlqy(sbbId);
                if (!Objects.isNull(xxwl)) {
                    bqsfsyjzzc = xxwl.getString("xxwlqy");
                }
                LOGGER.info("\u6839\u636e\u7533\u62a5\u8868id{}\u67e5\u8be2\u51fa109\u5c0f\u578b\u5fae\u5229\u4f01\u4e1a\u7684\u6570\u636e\u4e3a{}", (Object)sbbId, (Object)xxwl);
            }
            if (CollectionUtils.isEmpty((Collection)sbb) || Objects.isNull(xxwl)) {
                QFilter q2;
                if (Objects.equals(monthOfDate, 7)) {
                    return bqsfsyjzzc;
                }
                QFilter orgFilter = new QFilter(ORGID_KEY, "=", (Object)orgId);
                DynamicObject dgObject = QueryServiceHelper.queryOne((String)entityName, (String)BQSFSYJZZC, (QFilter[])new QFilter[]{orgFilter, preDateFilter, q2 = new QFilter("draftpurpose", "=", (Object)draftpurpose)});
                if (dgObject != null) {
                    bqsfsyjzzc = dgObject.getString(BQSFSYJZZC);
                }
            }
        }
        return bqsfsyjzzc;
    }

    public static DynamicObject queryQysdsWlqy(Long sbbId) {
        QFilter filter = new QFilter("sbbid", "=", (Object)String.valueOf(sbbId));
        return QueryServiceHelper.queryOne((String)"tccit_qysds_a000000", (String)"xxwlqy", (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObjectCollection querySbbid(Date skssqq, Long orgId) {
        QFilter filter = new QFilter("org", "=", (Object)orgId).and("skssqq", "=", (Object)skssqq).and("type", "in", QYSDSNB).and("declarestatus", "=", (Object)"declared");
        return QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id,sbbid", (QFilter[])new QFilter[]{filter});
    }

    public static void controlEdit(Map<String, Object> customParams, IFormView getView) {
        boolean readonly = (Boolean)customParams.get("readonly");
        if (readonly) {
            IFormView view = getView;
            view.setEnable(Boolean.FALSE, new String[]{"isapplicableplus", "applicablediffer", DEDUCTION_RATE, "entryentity"});
        }
    }

    public static void resetDraftData(Map<String, Object> customParams) {
        TaxDeclareHelper.updateDraftStatus(customParams);
        String orgid = (String)customParams.get(ORGID_KEY);
        String startdate = (String)customParams.get("skssqq");
        String enddate = (String)customParams.get("skssqz");
        String taxPayerType = (String)customParams.get("taxPayerType");
        String draftpurpose = (String)customParams.get("draftpurpose");
        TcvatEngineModel engineModel = TaxDeclareHelper.buildEngineModel(orgid, startdate, enddate, taxPayerType, null, draftpurpose);
        PolicyConfirmService.deleteDraftData(engineModel);
    }

    public static void deleteDraftData(TcvatEngineModel engineModel) {
        EngineHandler handler = EngineHandlerFactory.createHandler((String)engineModel.getDeclareType());
        handler.getEngineList().stream().filter(e -> !e.getClass().getName().contains("PolicyEngine")).forEach(e -> e.deleteData((EngineModel)engineModel));
    }
}

